<?php if( ! isset( $_SESSION ) ) session_start();
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - Yal Gestor de Archivos
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 */
	
	//** Definiciones Globales */
	define( "YEDS", DIRECTORY_SEPARATOR);
	define( "YEROOT", dirname( dirname( dirname( dirname( dirname(__FILE__) ) ) ) ) );
	define( "YEBASEDIR", ( ( isset( $_GET['basedir'] ) ) ? '/' . trim( $_GET['basedir'], '/' ) : '' ) );
	define( "YEPATH", realpath( YEROOT . YEBASEDIR ) );
	
	//** funcion para abrir carpetas en el panel de navegacion  */
		function abrir_carpeta_nav( $dir_actual = '', $localdir = NULL ){
			// creo path real de directorio root
			$dir_actual	= realpath( YEPATH . '/' . $dir_actual );	
			$eldir 		= abrirdir( $dir_actual ); 
			$carpetas	= '';
				
				if ( $eldir ) {
					
					while ( $recurso = readdir($eldir) ){
						/* si encuentra '.' o '..' no lo listo */
						if( $recurso == '.' || $recurso == '..')
						{
							continue;
						}
						
						/* creo ruta de carpeta */
						$ldir	= ( $localdir != NULL ) ? $localdir . '/' . $recurso : $recurso;
						$realdir= realpath( $dir_actual .  '/' . $recurso );
						
						/* Listo si son carpetas */
						$iD = md5( $realdir );
						
						if( is_dir( $realdir ) ){ 
							$carpetas .= '<li style="width:100%" title="' . $recurso . '">
									<i class="yga-tab"></i>
									<span id="mm_' . $iD . '" class="fa fa-plus-square-o" onClick="yGestorArchivos.expandir_contraer( \'' . $recurso . '\', \'' . $ldir . '\', \'' . $iD . '\' )"></span> 
									<a href="javascript:;" onClick="yGestorArchivos.abrir_explorar_archivo( \'' . $recurso . '\', \'' . $ldir . '\', \'' . $iD . '\' )">
										<i id="mmc_' . $iD . '" class="ico-yga-carpeta"></i> ' . $recurso . '
									</a>
									<div id="cCarp_' . $iD . '" class="yga-tab"></div>
								</li>' ."\n";
						}
					}
					//print $realdir;
					closedir($eldir);
					return $carpetas;
				}
				
				return false;
				
		}
	
	//** funcion para abrir directorio */
		function abrirdir( $dir ){
				 return ( is_dir( $dir ) ) ? opendir( $dir ) : false;
		}
		
	/* Funcion para convertir bytes a MB  */
		function convBytes2Mb( $bytes = 0, $decimales = 1 ){
			//if( $fichero == NULL ) return false;
			
			//$bytes = filesize( $fichero );
			
			if( $bytes > 1024 && $bytes < 1048576 )
				return number_format( ( $bytes / 1024 ), $decimales ) . ' kb';
				
			if( $bytes > 1048576 && $bytes < 1073741824 )
				return number_format( ( $bytes / 1048576 ), $decimales ) . ' MB';
				
			if( $bytes > 1073741824 && $bytes < 109951163e12  )
				return number_format( ( $bytes / 1073741824 ), $decimales ) . ' GB';
				
			return number_format( $bytes ) . ' bytes';
			
		}
		
		function convKb2MB( $size = 0 ){
			 //$size = filesize($path);
			$units = array( 'B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
			$power = $size > 0 ? floor(log($size, 1024)) : 0;
			return number_format($size / pow(1024, $power), 2) . ' ' . $units[$power];
		}
		
	/* Funcion para obtener diferencia de días
	 * entre dos fechas 
	 */
	function comparar_fechas($fecha_comparacion, $fecha_actual)
		{
			$primera = date('Y-m-d',strtotime($fecha_comparacion) );
			$segunda = date('Y-m-d',strtotime($fecha_actual) );
			
			$primera = date( "d/m/Y", strtotime( $primera ) );
			$segunda = date( "d/m/Y", strtotime( $segunda ) );
			
			$valoresPrimera = explode ("/", $primera); 
			$valoresSegunda = explode ("/", $segunda); 
			
			$diaPrimera    = $valoresPrimera[0]; 
			$mesPrimera  = $valoresPrimera[1]; 
			$anyoPrimera   = $valoresPrimera[2];
			
			$diaSegunda   = $valoresSegunda[0];
			$mesSegunda = $valoresSegunda[1]; 
			$anyoSegunda  = $valoresSegunda[2];
			
			$diasPrimeraJuliano = gregoriantojd($mesPrimera, $diaPrimera, $anyoPrimera);  
			$diasSegundaJuliano = gregoriantojd($mesSegunda, $diaSegunda, $anyoSegunda); 
			
			if(!checkdate($mesPrimera, $diaPrimera, $anyoPrimera)){
				// "La fecha ".$primera." no es v&aacute;lida";
				return 0;
			}elseif(!checkdate($mesSegunda, $diaSegunda, $anyoSegunda)){
				// "La fecha ".$segunda." no es v&aacute;lida";
				return 0;
			}else{
				return  $diasPrimeraJuliano - $diasSegundaJuliano;
			}
	}
	
	/* 
		funcion para comprimir archivos:
		$nombre_zip	= "ruta-y-nombre-del-nuevo.zip";
		$zip		= new ZipArchive();
		
		$zip->open( $nombre_zip, ZIPARCHIVE::CREATE);
		comprimir( "directorio/a/comprimir", "", $zip );
		$zip->close();
	*/
	function comprimir_dir( $ubicacion, $carpeta, $zip ){ 
		$dir = realpath( YEPATH . YEDS . $ubicacion );
		//$zip->addDir($carpeta);
		$directorio = opendir( $dir ); 
		while ( $archivo = readdir( $directorio ) ) {
			if( !is_dir( "$dir/$archivo" ) ){
				$zip->addFile( $dir . '/' . $archivo, "$carpeta/$archivo" ); 
            }else{
				if( $archivo != "." && $archivo != ".." ){
					$nuevaUbicacion = $ubicacion . "/". $archivo."/";
					comprimir_dir($nuevaUbicacion, $carpeta.$archivo."/", $zip);
				} 
			} 
		}
		closedir($directorio);
		//return $zip;
	}
	
	/* funcion para crear ID de Archivo */
		function idarchivo( $nombre ){
			 $caracteres_nulos = array( ' ', ',', '.', '-', '@', "á", "é", "í", "ó", "ú" );
			 return ( !empty( $nombre ) ) ? str_replace( $caracteres_nulos, '', $nombre ) : false;
		}
		 
	//Crear nuevos directorios completos
		function rcopiar( $source, $target ) {
			if ( is_dir( $source ) ) {
				@mkdir( $target );
				$d = dir( $source );
				while ( FALSE !== ( $entry = $d->read() ) ) {
					if ( $entry == '.' || $entry == '..' ) {
						continue;
					}
					$Entry = $source . '/' . $entry; 
					if ( is_dir( $Entry ) ) {
						full_copy( $Entry, $target . '/' . $entry );
						continue;
					}
					copy( $Entry, $target . '/' . $entry );
				}
				
				$d->close();
				
				return true;
			}else {
				return copy( $source, $target );
			}
		}
		
	/*
	 * Funcion para eliminar directorio
	 */
	function eliminarDir( $dir ) { 
			$files = array_diff( scandir($dir), array('.','..') ); 
			foreach ($files as $file) {
				( is_dir( "$dir/$file" ) ) ? eliminarDir( "$dir/$file" ) : unlink( "$dir/$file" ); 
			}
			return rmdir( $dir );
	}
	
	//** funcion para abrir contenido de carpeta */
	function explorar_carpeta( $dir_actual = '', $localdir = NULL, $vista = 'detalles' ){
				
				$dir_actual	= realpath( YEPATH . '/' . $dir_actual );
				
				$eldir = abrirdir( $dir_actual );
				
				$carpetas	= 'No hay elementos';
				$ficheros	= 'No hay elementos';
				$insertarImg= '';
				
				//** Verifico si activo opciones de insertar imagen */
				$insImg	= ( isset( $_GET['insImg'] ) ) ? $_GET['insImg'] : 'no';
				if( $insImg != NULL && $insImg == 'si' ){
					$funcjs			= ( isset( $_GET['func_js'] ) ) ? $_GET['func_js'] : '';
					$selector		= ( isset( $_GET['selector'] ) ) ? $_GET['selector'] : '';
					$insertarImg = '<div class="cBtnIns"><button onClick="window.parent.' . $funcjs . '(\'' . $selector . '\',yGestorArchivos.oSel())">Insertar imagen</button></div>';
				}
				
				if ( $eldir ) {
					// vista iconos
					if( $vista == 'iconos' ){
						//cargo archivos
						$j = 0;
						while ( $recurso = readdir($eldir) ){
							/* si encuentra '.' o '..' no lo listo */
							if( $recurso == '.' || $recurso == '..')
							{
								continue;
							}
							
							/* creo ruta de carpeta ej. /mi_ruta | /mi_ruta/imagen1.jpg */
							//$ldir	= trim( $localdir, '/' ) . '/' . $recurso;
							//$realdir= realpath( $dir . '/' . $recurso );
							$ldir	= ( $localdir != NULL ) ? $localdir . '/' . $recurso : $recurso;
							$ldir	= trim( $ldir, '/' );
							$realdir= realpath( $dir_actual .  '/' . $recurso );
							//print '<br>' . $ldir;
							/* Listo si son carpetas */
							//print $ldir;
							if( is_dir( $realdir ) ){ 
								if( $carpetas	== 'No hay elementos' ) $carpetas	= '';
								// cargo carpetas
								$carpetas .= '<div class="item w20" onDblClick="yGestorArchivos.explorar_archivo( \'' . $recurso . '\', \'' . $ldir . '\' )" title="' . $recurso . ' (' . convBytes2Mb( peso_dir( $realdir ) ) . ')">
										<input type="checkbox" id="chka_' . $j++ . '" name="chka" value="' . $ldir . '" onClick="habilitar_acc()">
										<div class="ic-icono"><i class="ico-yga-carpeta"></i></div>
										<div class="ic-nombre">' . YE::resumirTexto( $recurso, 15 ) . '</div>
									</div>' ."\n";
							/* Listo los ficheros */
							}else{
								$mime	= rmime( $recurso );
								if( $ficheros	== 'No hay elementos' ) $ficheros	= '';
								if ($mime=="jpg" or $mime=="jpeg" or $mime=="png" or $mime=="gif" or $mime=="bmp")
								{
									
									// cargo imagenes
									$ficheros .= '<div class="item w20" title="'. $recurso . ' (' . peso_fichero( $realdir ) . ')">
										<input type="checkbox" id="chka_' . $j . '" name="chka" value="' . $ldir . '" onClick="habilitar_acc()">
										<label for="chka_' . $j . '">
											<div class="ic-icono"><img src="' . YE::base_sitio() . trim( YEBASEDIR, '/' ) .'/'. $ldir . '"></div>
											<div class="ic-nombre">' . YE::resumirTexto( $recurso, 15 ) . '</div>
										</label>
									</div>' ."\n";
									$j++;
								}else{
								
									$ficheros .= '<div class="item w20" title="' . $recurso . ' (' . peso_fichero( $realdir ) . ')">
											<input type="checkbox" id="chka_' . $j . '" name="chka" value="' . $ldir . '" onClick="habilitar_acc()">
											<label for="chka_' . $j . '">
												<div class="ic-icono"><i class="mime-yga-' . $mime . '"></i></div>
												<div class="ic-nombre">' . YE::resumirTexto( $recurso, 15 ) . '</div>
											</label>
										</div>' ."\n";
									$j++;
								}
							}
						}
						
						closedir($eldir);
						return '<div class="contenedor-panel-r">' . $insertarImg . '
							<div class="vista-iconos">
									<div class="subti">Carpetas</div>
									<div class="ventana">' . $carpetas . '</div>
									<div class="subti">Archivos</div>
									<div class="ventana">' . $ficheros . '</div>
							</div>
						</div>';
						
					// vista detalles
					}else{
						//cargo archivos
						$j = 0;
						
						$carpetas .= '<li style="display:flex" class="cabecera">
						<div class="i-nombre">Nombre</div>
						<div class="i-peso">Tamaño</div>
						<div class="i-modificacion">Fecha modificación</div>
						<div class="i-tipo">Tipo</div>
						<div class="i-permiso">Permiso</div>
					</li>';
					
						while ( $recurso = readdir($eldir) ){
							/* si encuentra '.' o '..' no lo listo */
							if( $recurso == '.' || $recurso == '..')
							{
								continue;
							}
							/* creo ruta de carpeta */
							$ldir = $location . $recurso ;
							/* Listo si son carpetas */
							if( is_dir( $dir . '/' . $recurso ) ){
								$carpetas .= '<li style="display:flex" onDblClick="yGestorArchivos.explorar_archivo( \'' . $recurso . '\', \'' . trim( $ldir, '/' ) . '\' )">
										<div class="i-nombre"> 
											<input type="checkbox" id="chka_' . $j++ . '" name="chka" value="' . $location . $recurso . '" onClick="habiltar_acc()"> <i class="ico-yga-carpeta"></i> ' . YE::resumirTexto( $recurso, 15 ) . '
										</div>
										<div class="i-peso">
											' . convBytes2Mb( peso_dir( $dir . '/' . $recurso ) ) . '
										</div>
										<div class="i-modificacion">
											' . ultima_modificacion( $dir . '/' . $recurso ) . '
										</div>
										<div class="i-tipo">
											' . mime_content_type( $dir . '/' . $recurso ) . '
										</div>
										<div class="i-permiso">
											' . fileperms( $dir . '/' . $recurso ) . '
										</div>
									</li>' ."\n";
							}else{
								$mime	= rmime( $recurso );
								$ficheros .= '<li style="display:flex">
										 
										<div class="i-nombre">
											<input type="checkbox" id="chka_' . $j++ . '" name="chka" value="' . $location . $recurso . '" onClick="habiltar_acc()"> <i class="mime-yga-' . $mime . '"></i> ' . YE::resumirTexto( $recurso, 15 ) . '
										</div>
										<div class="i-peso">
											' . peso_fichero( $dir . '/' . $recurso ) . '
										</div>
										<div class="i-modificacion">
											' . ultima_modificacion( $dir . '/' . $recurso ) . '
										</div>
										<div class="i-tipo">
											' . mime_content_type( $dir . '/' . $recurso ) . '
										</div>
										<div class="i-permiso">
											' . fileperms( $dir . '/' . $recurso ) . '
										</div>
									</li>' ."\n";
							}
						}
						
						closedir($eldir);
						return '<div class="contenedor-panel-r"><ul>' . $carpetas . $ficheros . '</ul></div>';
					}
					
				}
				
				return false;
				
	}
	
	function YGA_SALT(){
		$psw = rand( 100000, 999999999 );
		$_SESSION['salt'] = ( isset( $_SESSION['salt'] ) ) ? $_SESSION['salt'] : md5( $psw);
		return $_SESSION['salt'];
	}
	
	// obtengo valor de sesion: $CGF['yga']['session']
	// creo la contraseña:
	$_SESSION['hash'] = ( isset( $_SESSION['yga_session'] ) ) ? ygaPassword::hash( $_SESSION['yga_session'] ) : false;
	
	class ygaPassword {
		/*const SALT = 'EstoEsUnSalt';
		public static function hash($password) {
			return hash('sha512', self::SALT . $password);
		}
		public static function verify($password, $hash) {
			return ($hash == self::hash($password));
		}*/
		public static function hash($password) {
			YGA_SALT();
			return hash('sha512', $_SESSION['salt'] . $password);
		}
		
		public static function verify($password, $hash) {
			return ($hash == self::hash($password));
		}
	}
	
	
	/*
	 * Path de archivo
	 * $zipPath = '/path/a/archivo.zip';
	 *
	 * Path de destino
	 * $destPath = '/destino/dir/';
	 *
	 * Extraer archivo comprimido
	 * ygaZip::extraer( $zipPath, $destPath );
	 *
	 * if($extract){
	 *	echo $GLOBALS['status']['success'];
	 * }else{
	 *	echo $GLOBALS['status']['error'];
	 * }
	 */
	class yeZip {
		
			function comprimir_dir( $ubicacion, $carpeta, $zip ){ 
				$dir = $ubicacion;
				//$zip->addDir($carpeta);
				$directorio = opendir( $dir ); 
				while ( $archivo = readdir( $directorio ) ) {
					if( !is_dir( "$dir/$archivo" ) ){
						$zip->addFile( $dir . '/' . $archivo, "$carpeta/$archivo" ); 
					}else{
						if( $archivo != "." && $archivo != ".." ){
							$nuevaUbicacion = $ubicacion . "/" . $archivo . "/";
							comprimir_dir($nuevaUbicacion, $carpeta.$archivo."/", $zip);
						} 
					} 
				}
				closedir($directorio);
				//return $zip;
			} 
			
			/**
			 * Comprueba la extensión del archivo y llama a las funciones de extracción adecuada.
			 * Checks file extension and calls suitable extractor functions.
			 *
			 * @param $archive
			 * @param $destination
			 */
			public static function extraer( $archive, $destination ){
				$ext = pathinfo( $archive, PATHINFO_EXTENSION );
				switch ($ext){
					case 'zip':
						$res = self::extraerZip($archive, $destination);
						break;
					case 'gz':
		
						$res = self::extraerGzip($archive, $destination);
						break;
					case 'rar':
		
						$res = self::extraerRar($archive, $destination);
						break;
				}
		
				return $res;
			}
			
			/**
			 * Descomprime/extrae un archivo zip usando ZipArchive.
			 * Decompress/extract a zip archive using ZipArchive.
			 *
			 * @param $archive
			 * @param $destination
			 */
			public static function extraerZip($archive, $destination){
				// Comprueba si el servidor web admite la descompresión.
				if(!class_exists('ZipArchive')){
					$GLOBALS['status'] = array('error' => 'Your PHP version does not support unzip functionality.');
					return false;
				}
			
				$zip = new ZipArchive;
			
				// Comprueba si el archivo es legible.
				if($zip->open($archive) === TRUE){
					// Comprueba si el destino se puede escribir.
					if(is_writeable($destination . '/')){
						$zip->extractTo($destination);
						$zip->close();
						$GLOBALS['status'] = array('success' => 'Files unzipped successfully');
						return true;
					}else{
						$GLOBALS['status'] = array('error' => 'Directory not writeable by webserver.');
						return false;
					}
				}else{
					$GLOBALS['status'] = array('error' => 'Cannot read .zip archive.');
					return false;
				}
			}
			
			/**
			 * Descomprimir un archivo .gz
			 * Decompress a .gz File.
			 *
			 * @param $archive
			 * @param $destination
			 */
			public static function extraerGzip($archive, $destination){
				// Check if zlib is enabled
				if(!function_exists('gzopen')){
					$GLOBALS['status'] = array('error' => 'Error: Your PHP has no zlib support enabled.');
					return false;
				}
			
				$filename = pathinfo($archive, PATHINFO_FILENAME);
				$gzipped = gzopen($archive, "rb");
		
				$file = fopen($filename, "w");
			
				while ($string = gzread($gzipped, 4096)) {
					fwrite($file, $string, strlen($string));
				}
				gzclose($gzipped);
		
				fclose($file);
			
				// Comprueba si se extrajo el archivo.
				if( file_exists($destination.'/'.$filename) ){
					$GLOBALS['status'] = array('success' => 'File unzipped successfully.');
					return true;
				}else{
					$GLOBALS['status'] = array('error' => 'Error unzipping file.');
					return false;
				}
			}
			
			/**
			 * Decompress/extract a Rar archive using RarArchive.
			 *
			 * @param $archive
			 * @param $destination
		
			 */
			public static function extraerRar( $archive, $destination ){
				// Check if webserver supports unzipping.
				if(!class_exists('RarArchive')){
					$GLOBALS['status'] = array('error' => 'Your PHP version does not support .rar archive functionality.');
					return false;
				}
				// Check if archive is readable.
				if($rar = RarArchive::open($archive)){
		
					// Check if destination is writable
					if ( is_writeable( $destination . '/' ) ) {
						$entries = $rar->getEntries();
						foreach ($entries as $entry) {
							$entry->extract($destination);
						}
						$rar->close();
						$GLOBALS['status'] = array('success' => 'File extracted successfully.');
						return true;
					}else{
						$GLOBALS['status'] = array('error' => 'Directory not writeable by webserver.');
						return false;
					}
				}else{
					$GLOBALS['status'] = array('error' => 'Cannot read .rar archive.');
					return false;
				}
			}
		
	}
	
	class YE{
		/* base_sitio : string
		 * Obtener la base del sitio Weby+
		 */
		public static function base_sitio(){
				$base = rtrim(dirname(dirname(dirname(dirname(dirname($_SERVER['SCRIPT_NAME']))))), '/\\');
				$base = $base . '/';
				return $base;
			}
		
		/* url_sitioweb : string
		 * Funcion para obtener URL de sitio weby+
		 */
		public static function url_sitioweb(){
			$Protocolo = strtolower( substr($_SERVER['SERVER_PROTOCOL'], 0, 4) ) . '://';
			return $Protocolo . $_SERVER['HTTP_HOST'] .  Base_SitioWeby();
		}
		
		/**
		 * sesion_hash - iniciar sesion en ye
		 * @param string    $user    Usuario
		 */
		public static function sesion_hash( $user ){
			// obtengo sesion de usuario
			$user = ( !empty( $user ) ) ? strtolower( $user ) : 'root';
			// verifico creencial de usuario
			if( self::usuario() != $user ){
				return false;
			}else{
				self::Sesion( 'usr_' . $user, $user );
				self::sHash( $user );
			}
			return false;
		}
		
		/**
		 * resumirTexto - Sacar un resumen de un texto 
		 * @param string    $cadena            Cadena donde se saracará el resumen
		 * @param int       $num_caracteres    Numero de caracteres que se mostrará como resumen
		 * @param bool      $sacarTags         true para limpiar la cadena de etiquetas html
		 */
		public static function resumirTexto( $cadena, $num_caracteres = 55, $sacarTags=false ){
			$puntos = '';
			if( strlen( $cadena ) >= $num_caracteres) {
					$puntos = '...';
			}
			if( $sacarTags ){
				$cadena = strip_tags( $cadena );
			}
			//$cadena .= ' ';
			$cadena = substr( $cadena, 0,  $num_caracteres );
			//$cadena = substr( $cadena, 0, strrpos( $cadena,' ') );
			return  $cadena.$puntos;
		}
		
		/**
		 * sHash - Crea sesion hash de YE
		 */
		private static function sHash( $cadena = NULL ){
			//** creo sesion hash */
			if( !empty( $cadena ) ){
				return self::Sesion( "clave_hash" . $cadena, md5( $cadena . $_SERVER['REMOTE_ADDR'] ) );
			}
			//** leo hash */
			return self::Sesion( 'clave_hash' . self::usuario() );
		}
		
		
		
		/**
		 * Sesion - Crea sesión del sistema yExplorador
		 */
		private static function Sesion( $clave, $valor = NULL ){
			$user_agent	= $_SERVER['HTTP_USER_AGENT'];
			$ip			= $_SERVER['REMOTE_ADDR'];
			//** ubicación donde se guardarán las sesiones */
			//$sess_uri	= __DIR__ . '/.s/.sess' . md5( $ip . $user_agent . self::usuario() );
			$sess_uri	= __DIR__ . YEDS . '.s' . YEDS . '.sess2938749dh73s9qw837h';
			if( !empty( $valor ) ){
				if( file_exists( $sess_uri ) ) {
					$json = file_get_contents( $sess_uri );
					$json = json_decode( $json, true );
				}
				
				$json[$clave]	= $valor;
				$json			= json_encode( $json );
				
				file_put_contents( $sess_uri, $json );
				return $valor;
			}
			
			if( file_exists( $sess_uri ) ) {
				$json = file_get_contents( $sess_uri );
				$json = json_decode( $json );
						
				return ( isset( $json->$clave ) ) ? $json->$clave : NULL;
			}
			
			return false;
		}
		
		/**
		 * ySesionDestruir() : bool
		 * Elimina sesión propia del sistema
		 */
		public static function SesionDestruir(){
			$user_agent	= $_SERVER['HTTP_USER_AGENT'];
			$ip			= $_SERVER['REMOTE_ADDR'];
			//** ubicación donde se guardarán las sesiones */
			$sess_uri	= self::$ySesion_uri . '.sess' . md5( $ip . $user_agent );
			
			if( file_exists( $sess_uri ) ) {
				return unlink( $sess_uri );
			}
			
			return false;
		}
		
		/**
		 * veriSess - bolean
		 */
		public static function veriSess(){
			$user	= self::Sesion( 'usr_' . self::usuario() );
			$ohash	= ( !empty( self::sHash() ) ) ? self::sHash() : rand(1000,9999999);
			$osesion= ( !empty( $user ) ) ? md5( $user . $_SERVER['REMOTE_ADDR'] ) : 'root';
			//print $osesion .' ======= ' . $ohash . self::usuario();
			if( $osesion == $ohash ){
					return true;
			}
			
			return false;
		}
		
		/**
		 * usuario() : string
		 * Retorna usuario
		 */
		public static function usuario(){
			if( ! isset( $_SESSION ) ) session_start();
			return ( isset( $_SESSION['yps_us'] ) ) ? $_SESSION['yps_us'] : NULL;
		}
		
	}
	 
?>