<?php
	/*
	 *
	 * 2003 - 2016 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 *
	 */
	
	/* Autorizo acceso */
		defined('WY_INI_WEBY') or die( 'No dispones de acceso' );
	
	class plug{
		public $archivo_conf		= false;
		public $gestor_idioma		= false;
		public $nombre;
		public $titulo;
		public $descripcion;
		
		public $a_tabla			= array();
		public $consulta_tabla	= "ORDER BY id DESC";
		
		public $JS_funcion	= array();
		public $JS_b_nuevo	= false;
		public $JS_b_salir	= false;
		
		
		/*
		 * función para cargar componente al sistema
		 */
		function cargar(){
			// ** Compruebo si el componente dispone de acceso
			if( wyp_n_privilegios_usr( 'mnu_usr', 'usuario' ) != 1 ) { 
				echo wyp_mensaje( "Acceso Restringido: No tiene acceso a esta área.", "Error" );
				return false;
			}
			
			echo '<div class="">';
			echo $this->obtener_titulo_seccion();
			echo $this->obtener_descripcion();
			echo '<hr style="border:none;border-bottom:1px solid #ccc;"></div><div class="com-caja-cuerpo">';
			if( $this->archivo_conf ){
				if( file_exists( YPATH . YDS . 'wy_incluye/wy_ext/' . $this->nombre . '/wy_' . $this->nombre . '.php' ) ){
					include_once( YPATH . YDS . 'wy_incluye/wy_ext/' . $this->nombre . '/wy_' . $this->nombre . '.php' );
				}
			}
			echo '</div>';
			
			echo '<script type="text/javascript">';
				if( $this->JS_b_nuevo ) echo 'var bNuevo = document.querySelector("button[name=b_nuevo]"); bNuevo.onclick = function(){ Ir_a(\'' . plug_ir_a( 'this', 'agregar' ) . '\'); }; ';
				if( $this->JS_b_salir ) echo 'var bCerrar = document.querySelector("button[name=b_cerrar]"); bCerrar.onclick = function(){ Ir_a(\'' . ( isset( $_GET['acc'] ) ? plug_ir_a( 'this' ) : './' ) . '\'); }; ';
				
				
				
			echo '</script>';
		}
		
		/*
		 * Leo configuración del componente
		 */
		public function leer_conf(){
			global $ypanel;
			
			// ** creo la ruta de configuración del componente
				$url_json = YPATH . YDS . 'wy_incluye/wy_ext/' . $this->nombre . '/plug.conf';
				
			// ** Verifico si existe el archivo de configuración
				if( file_exists( $url_json ) ){
					// ** leo la configuración en JSON
					$data	= file_get_contents( $url_json );
					$conf	= json_decode( $data );
					
					// ** evaluo si se usará gestor de idiomas o no
					$this->gestor_idioma	= ( isset( $conf->gestor_idioma ) && $conf->gestor_idioma == 1 ) ? true : false;
					$this->titulo			= ( isset( $conf->nombre ) ) ? $conf->nombre : $this->nombre;
					$this->descripcion		= ( isset( $conf->descripcion ) ) ? $conf->descripcion : '';
					
					if( $this->gestor_idioma ){ // ** ejecuto gestor de idiomas
						$this->titulo = ( strlen( $this->titulo ) > 3 ) ? explode( '|', $this->titulo ) : $this->titulo;
						$this->descripcion = ( strlen( $this->descripcion ) > 3 ) ? explode( '|', $this->descripcion ) : $this->descripcion;
						
						$ypanel->titulo_barra_titulo = ( is_array( $this->titulo ) ) ? 'PLUG::' . plug_lng( $this->titulo[0], $this->titulo[1] ) : $this->titulo;
						$this->descripcion = ( is_array( $this->descripcion ) ) ? plug_lng( $this->descripcion[0], $this->descripcion[1] ) : $this->descripcion;
					}else{ // ** No ejecuto gestor de idiomas
						$ypanel->titulo_barra_titulo = $this->titulo;
					}
					
					// ** confirmo existencia de archivo de configuración
					$this->archivo_conf = true;
					
					return true;
				}
				
				return false;
			
		}
		
		public function obtener_js(){
			foreach( $this->JS_funcion as $jsk => $jsv ){
					echo "\n\n" . $this->JS_funcion[ $jsk ] . "\n\n";
			}
		}
		
		/*
		 * Obtengo el titulo
		 * de la sección del 
		 * componente
		 */
		public function obtener_titulo_seccion(){
			global $ypanel;
			return '<div class="titulo">' . $ypanel->obtener_titulo() . '</div>';
		}
		
		/*
		 * Obtengo la descripcion
		 * del componente
		 */
		public function obtener_descripcion(){
			if( !empty( $this->descripcion ) ) return '<div class="descripcion">' . $this->descripcion . '</div>';
			return false;
		}
		
		
	}
	
	$plug = new plug();
	
	/* ********** ********** ********** ********** ********** */
	
	/*
	 * Nombre del Componente
	 */
	$plug->nombre = ( isset( $_GET['extension'] ) ) ? $_GET['extension'] : 'ninguno';
	
	/*
	 * función para crear botones
	 */
	function plug_boton( $tipo_boton, $valor = '', $id = NULL, $funcion = NULL ){
		global $plug;
		
		$js = ( function_exists( $funcion ) ) ? $funcion( $id ) : $funcion;
		
		if( $funcion != NULL ){
			$boton_nom = 'btn_' . $id;
			$plug->JS_funcion[$id] = 'var ' . $boton_nom . ' = document.querySelector("#' . $id . '"); ' . "\n" .
									$boton_nom . '.onclick = function(){ ' . $js . ' }; ';
		}
		
		$onClick = ( function_exists( $funcion ) ) ? $funcion( $id ) : $funcion;
			
			if( !empty( $tipo_boton ) ){
				switch( $tipo_boton ){
					case 'nuevo':
						$plug->JS_b_nuevo = true;
						return '<button name="b_nuevo" class="b-nuevo"><span class="fa fa-plus"></span> ' . wyp_etiqueta( 'e_btn_nuevo', 'Nuevo' ) . '</button>';
					 	break;
					
					case 'agregar-nuevo':
						$valor = ( !empty( $valor ) ) ? $valor : wyp_etiqueta( 'e_btn_agregar_nuevo', 'Agregar nuevo' );
						return '<button id="' . $id . '" class="b-azul"><span class="fa fa-plus"></span> ' . $valor . '</button>';
					 	break;
						
					case 'actualizar':
						$valor = ( !empty( $valor ) ) ? $valor : wyp_etiqueta( 'e_btn_actualizar', 'Actualizar datos' );
						return '<button id="' . $id . '" class="b-verde"><span class="fa fa-check-circle"></span> ' . $valor . '</button> ';
					 	
						break;
						
					case 'guardar':
						$valor = ( !empty( $valor ) ) ? $valor : wyp_etiqueta( 'e_btn_guardar', 'Guardar datos' );
						return '<button id="' . $id . '" class="b-azul"><span class="fa fa-check"></span> ' . $valor . '</button> ';
					 	
						break;
						
					case 'guardar-clasico':
						$valor = ( !empty( $valor ) ) ? $valor : wyp_etiqueta( 'e_btn_guardar', 'Guardar datos' );
						return '<button id="' . $id . '"><span class="fa fa-check"></span> ' . $valor . '</button> ';
					 	
						break;
						
					case 'salir':
						$plug->JS_b_salir = true;
						return '<button name="b_cerrar"><span class="fa fa-close"></span> ' . ( isset( $_GET['acc'] ) ? wyp_etiqueta( 'e_btn_cerrar', 'Cerrar' ) : wyp_etiqueta( 'e_btn_salir', 'Salir' ) ) . '</button>';
						break;
					
					case 'clasico-azul':
						return '<button type="button" id="' . $id . '" class="b-azul">' . $valor . '</button>';
						break;
					
					case 'clasico-verde':
						return '<button id="' . $id . '" class="b-verde">' . $valor . '</button>';
						break;
						
					default:
					 	return '<button id="' . $id . '"><span class="fa fa-plus"></span> ' . $valor . '</button>';
				}
			}
			return false;
	}
	
	function plug_captcha( $id_captcha = 'plug_captcha', $longitud = 8 ){
		$captcha = '';
		$pattern = '1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWYZ';
		$max = strlen( $pattern ) - 1;
		for( $i = 0; $i < $longitud; $i++ ) $captcha .= $pattern{ mt_rand( 0, $max ) };
		return $_SESSION[ $id_captcha ] = $captcha;
	}
	
	function plug_base(){
		global $plug;
		return Base_SitioWeby() . 'wy_incluye/wy_ext/' . $plug->nombre . '/';
	}
	
	/*
	 * Funcion para crear hipervinculos
	 */
	function plug_enlace( $href, $cadena, $atributos = NULL ){
		global $_WY_HTML;
		return $_WY_HTML::link( $href, $cadena, $atributos );
	}
	
	/*
	 * Funcion para abrir seccion
	 */
	function plug_ir_a( $secc, $accPost = NULL, $idPost = 0 ){
		if( !empty( $secc ) ){
			$seccPost	= ( $secc == 'this' ) ? 'secc=' . $_GET['secc'] . '&extension=' . $_GET['extension'] : 'secc=' . $secc;
			$accPost	= ( $accPost != NULL ) ? '&acc=' . $accPost : NULL;
			$idPost		= ( $idPost > 0 ) ? '&post=' . $idPost : NULL;
			
			return $_SERVER['PHP_SELF'] . '?' . $seccPost . $idPost . $accPost;
		}
		return false;
	}
	
	/*
	 * funcion para agregar funciones JS
	 */
	function plug_js( $funcion_nombre, $funcion_js ){
		global $plug;
		if( !empty( $funcion_js ) ){
			$js_nombre = 'jsy_' . $funcion_nombre . '()';
			$funcion_javascript = ( $funcion_nombre == 'linea' ) ? $funcion_js : 'function ' . $js_nombre . ' { ' . $funcion_js . ' }';
			$funcion_nombre		= ( $funcion_nombre == 'linea' ) ? $funcion_nombre . rand(10,999) : $funcion_nombre;
			$plug->JS_funcion[ $funcion_nombre ] = $funcion_javascript;
			return $js_nombre;
		}
		return false;
	}
	
	/*
	 * Mostrar etiqueta por idioma
	 */
	function plug_lng( $etiqueta, $por_defecto = '', $asociativo = false ){
		global $plug;
		
		if( empty( $etiqueta ) ) return $por_defecto;
		
		$lng = ( isset( $_SESSION['wyp_us'] ) ) ? wyp_us_lng( $_SESSION['wyp_us'] ) : 'es';
		
		$url_json = YPATH . YDS . 'wy_incluye' . YDS . 'wy_ext' . YDS . $plug->nombre . '/lng/' . $lng . '.lng';
		if( file_exists( $url_json ) ){
			$data	= file_get_contents( $url_json );
			$data	= json_decode( $data, $asociativo );
			if( $asociativo == false ){
				$etiqueta = ( isset( $data->$etiqueta ) ) ?  $data->$etiqueta : $por_defecto;
			}else{
				$etiqueta = ( isset( $data[$etiqueta] ) ) ?  $data[$etiqueta] : $por_defecto;
			}
			
			return $etiqueta;
		}
		return $por_defecto;
	}
	
	/*
	 * Obtener datos POST
	 */
	function plug_obt_post( $tabla, $campo, $valor_defecto = '' ){
		if( isset( $_GET['post'] ) ) return utf8_encode( WYSQL::obt1Reg( $tabla, "id='" . $_GET['post'] . "'", $campo ) );
		return $valor_defecto;
	}
	
	/*
	 * Registrar datos POST
	 */
	function plug_reg_post( $tabla, $campo, $valor = NULL, $idPost = 0 ){
		if( $idPost > 0 ) { 
			if( $valor != NULL ) return WYSQL::modificar_reg( $tabla, "id='" . $idPost . "'", "$campo='$valor'");
		}else{
			if( $valor != NULL ) return WYSQL::insertar_reg( $tabla, $campo, "'$valor'");
		}		
		return false;
	}
		
	/*
	 * Comprobar si estoy en una accion
	 */
	function plug_es_accion( $accion = NULL ){
		if( $accion == NULL || empty( $accion ) ) return (isset( $_GET['acc'] )) ? true : false;
		
		if( isset( $_GET['acc'] ) ){
			return ( $_GET['acc'] == $accion ) ? true : false; 
		}
	}
	
	/*
	 * Funcion para mostrar resultados
	 * de campos de una tabla
	 */	
	function plug_tabla_iniciar( $nombre_tabla ){
		global $plug;
		if( !empty( $nombre_tabla ) ){
			$plug->a_tabla[$nombre_tabla] = array();
			return $nombre_tabla;
		}
		$nombre_tabla = rand(10,99999);
		return $plug->a_tabla[$nombre_tabla] = array();
	}
	
	function plug_tabla_campo( $nombre_tabla, $nombre_campo, $etiqueta_campo, $func_valor_campo = NULL ){
		global $plug;
		if( !empty( $nombre_tabla ) ){
			$plug->a_tabla[$nombre_tabla]['campo'][$nombre_campo] = $nombre_campo;
			$plug->a_tabla[$nombre_tabla]['campo_valor'][$nombre_campo] = $func_valor_campo;
			$plug->a_tabla[$nombre_tabla]['etiqueta'][$etiqueta_campo] = $etiqueta_campo;
		}
	}
	
	function plug_tabla_consulta( $consulta ){
		global $plug;
		if( !empty( $consulta ) ) {
			$plug->consulta_tabla = $consulta;
		}
		return false;
	}
	
	function plug_tabla_ejecutar( $nombre_tabla ){
		global $plug;
		if( !empty( $nombre_tabla ) ){
			//print_r( $com->a_tabla[$nombre_tabla] );
			$tabla = '<table class="" cellspacing="0"><thead><tr>';				
				foreach( $plug->a_tabla[$nombre_tabla]['etiqueta'] as $k => $v){
					$tabla .= '<th class="">' . $plug->a_tabla[$nombre_tabla]['etiqueta'][$k] . '</th>';
				}
			$tabla .= '</tr></thead><tbody>';
		
			$tr_COLOR		= array("tr-bg-f5","");
			$tr_CONTADOR		= 0;
		
			$q = query( "SELECT * FROM " . WYCFG_DBPREFIJO . $nombre_tabla . " " . $plug->consulta_tabla );						  
			while($r = query_array($q)){
				$tr_CONTADOR++;
												
				$tabla .= '<tr id="' . $nombre_tabla . '-' . $r['id'] . '" class="' . $tr_COLOR[$tr_CONTADOR % 2] . '">'; 					foreach( $plug->a_tabla[$nombre_tabla]['campo'] as $kc => $vc ){
						$tabla .= '<td class="">';
							if( $plug->a_tabla[$nombre_tabla]['campo_valor'][$kc] != NULL ) 
								$tabla .= $plug->a_tabla[$nombre_tabla]['campo_valor'][$kc]( utf8_encode( $r[ $plug->a_tabla[$nombre_tabla]['campo'][$kc] ] ),$r['id'] );
							else
								$tabla .= utf8_encode( $r[ $plug->a_tabla[$nombre_tabla]['campo'][$kc] ] );
						$tabla .= '</td>';
					}
				$tabla .= '</tr>';
			}
			$tabla .= '</tbody></table>';
			
			echo $tabla;
		}
	}
	
	
	/*
	 * verifico si existe configuración
	 * del componentes. Si existe cargo
	 * el componente al sistema
	 */
	$plug->leer_conf();
	
?>