<?php
	
	/*
	
		100 Continue
		101 Switching Protocols
		102 Processing
		200 OK
		201 Created
		202 Accepted
		203 Non-Authoritative Information
		204 No Content
		205 Reset Content
		206 Partial Content
		207 Multi-Status
		226 IM Used
		300 Multiple Choices
		301 Moved Permanently
		302 Found
		303 See Other
		304 Not Modified
		305 Use Proxy
		306 Switch Proxy
		307 Temporary Redirect
		400 Bad Request
		401 Unauthorized
		402 Payment Required
		403 Forbidden
		404 Not Found
		405 Method Not Allowed
		406 Not Acceptable
		407 Proxy Authentication Required
		408 Request Timeout
		409 Conflict
		410 Gone
		411 Length Required
		412 Precondition Failed
		413 Request Entity Too Large
		414 Request-URI Too Long
		415 Unsupported Media Type
		416 Requested Range Not Satisfiable
		417 Expectation Failed
		418 I'm a teapot
		422 Unprocessable Entity
		423 Locked
		424 Failed Dependency
		425 Unordered Collection
		426 Upgrade Required
		449 Retry With
		500 Internal Server Error
		501 Not Implemented
		502 Bad Gateway
		503 Service Unavailable
		504 Gateway Timeout
		505 HTTP Version Not Supported
		506 Variant Also Negotiates
		507 Insufficient Storage
		509 Bandwidth Limit Exceeded
		510 Not Extended
	
	*/
	
	
	define( "ePATH", dirname( dirname( dirname( __FILE__ ) ) ) );
	define( "eDS", DIRECTORY_SEPARATOR );
	
	if( !isset( $Cfg['Server']['path'] ) ) require_once( ePATH . eDS . 'wy_configuracion.php' );
	
class HTTPErrorDocument{
	private static $title = array( 100 => 'Continue',
							101 => 'Switching Protocols',
							102 => 'Processing',
							200 => 'OK',
							201 => 'Created',
							202 => 'Accepted',
							203 => 'Non-Authoritative Information',
							204 => 'No Content',
							205 => 'Reset Content',
							206 => 'Partial Content',
							207 => 'Multi-Status',
							226 => 'IM Used',
							300 => 'Multiple Choices',
							301 => 'Moved Permanently',
							302 => 'Found',
							303 => 'See Other',
							304 => 'Not Modified',
							305 => 'Use Proxy',
							306 => 'Switch Proxy',
							307 => 'Temporary Redirect',
							400 => 'Bad Request',
							401 => 'Unauthorized',
							402 => 'Payment Required',
							403 => 'Forbidden',
							404 => 'Not Found',
							405 => 'Method Not Allowed',
							406 => 'Not Acceptable',
							407 => 'Proxy Authentication Required',
							408 => 'Request Timeout',
							409 => 'Conflict',
							410 => 'Gone',
							411 => 'Length Required',
							412 => 'Precondition Failed',
							413 => 'Request Entity Too Large',
							414 => 'Request-URI Too Long',
							415 => 'Unsupported Media Type',
							416 => 'Requested Range Not Satisfiable',
							417 => 'Expectation Failed',
							418 => 'I&lsquo;m a teapot',
							422 => 'Unprocessable Entity',
							423 => 'Locked',
							424 => 'Failed Dependency',
							425 => 'Unordered Collection',
							426 => 'Upgrade Required',
							449 => 'Retry With',
							500 => 'Internal Server Error',
							501 => 'Not Implemented',
							502 => 'Bad Gateway',
							503 => 'Service Unavailable',
							504 => 'Gateway Timeout',
							505 => 'HTTP Version Not Supported',
							506 => 'Variant Also Negotiates',
							507 => 'Insufficient Storage',
							509 => 'Bandwidth Limit Exceeded',
							510 => 'Not Extended',
							8000 => 'Bienvenido',
							8002 => 'Pagina en Mantenimiento',
							8003 => 'Pagina en construcci&oacute;n');
							
		private static $ico = array(100 => 'Continue',
							101 => 'Switching Protocols',
							102 => 'Processing',
							200 => 'fa fa-check-circle',
							201 => 'Created',
							202 => 'Accepted',
							203 => 'fa fa-user-times',
							204 => 'No Content',
							205 => 'Reset Content',
							206 => 'Partial Content',
							207 => 'Multi-Status',
							226 => 'IM Used',
							300 => 'Multiple Choices',
							301 => 'Moved Permanently',
							302 => 'Found',
							303 => 'See Other',
							304 => 'fa fa-user-times',
							305 => 'Use Proxy',
							306 => 'Switch Proxy',
							307 => 'Temporary Redirect',
							400 => 'fa fa-user-times',
							401 => 'fa fa-user-times',
							402 => 'Payment Required',
							403 => 'fa fa-user-times',
							404 => 'fa fa-hand-paper-o',
							405 => 'fa fa-user-times',
							406 => 'fa fa-user-times',
							407 => 'Proxy Authentication Required',
							408 => 'Request Timeout',
							409 => 'Conflict',
							410 => 'Gone',
							411 => 'Length Required',
							412 => 'Precondition Failed',
							413 => 'Request Entity Too Large',
							414 => 'Request-URI Too Long',
							415 => 'Unsupported Media Type',
							416 => 'Requested Range Not Satisfiable',
							417 => 'Expectation Failed',
							418 => 'I&lsquo;m a teapot',
							422 => 'Unprocessable Entity',
							423 => 'Locked',
							424 => 'Failed Dependency',
							425 => 'Unordered Collection',
							426 => 'Upgrade Required',
							449 => 'Retry With',
							500 => 'Internal Server Error',
							501 => 'Not Implemented',
							502 => 'Bad Gateway',
							503 => 'Service Unavailable',
							504 => 'Gateway Timeout',
							505 => 'fa fa-user-times',
							506 => 'Variant Also Negotiates',
							507 => 'Insufficient Storage',
							509 => 'Bandwidth Limit Exceeded',
							510 => 'fa fa-user-times',
							8000 => 'Bienvenido',
									8002 => 'fa fa-cogs',
									8003 => 'fa fa-puzzle-piece');
		
		/**
		 * incluir_tpl - Incluir platillas html
		 * @param string    $tpl_uri    Ruta de platilla
		 */
		private static function incluir_tpl( $tpl_uri )
		{
			if( file_exists( $tpl_uri ) ){
				$tpl = file_get_contents( $tpl_uri );
				return $tpl;
			}
			return false;
		}
		
		/**
		 * Verificar estado de pagina WebyPlus
		 */
		public static function estado(){
			/* Verifico estado de Sitio Weby+ */
			switch( YP_ESTADO_WEBY ){
				case 2: // En mantenimiento
					echo self::tlpError( 8002 ); exit();
					
					break;
				case 3: // En construccion
					echo self::tlpError( 8003 ); exit();
					
					break;
				default:
					return true;
			}
		}
		 
		/**
		 * tlpError - Carga plantilla errorDocument
		 * @param int    $error   Numero de error
		 */
		public static function tlpError( $error = 404 ){
			
			
			$tpl		= self::parse( self::incluir_tpl( 'error/include/header.tpl' ), $error );
			$tBody		= self::parse( self::incluir_tpl( 'error/include/body.tpl' ), $error );
			
			$tpl_body	= ePATH . eDS . 'error/HTTP_' . $error . '.tpl';
			if( file_exists( $tpl_body ) && ( filesize( $tpl_body ) > 300 ) ){
				$tBody = self::parse( self::incluir_tpl( $tpl_body ), $error );
			}
			
			$tpl	.= $tBody . self::incluir_tpl( 'error/include/footer.tpl' );
			
			return $tpl;
		}
		
		/**
		 * parse - Analizar gramaticalmente
		 * @param string    $cadena    Cadena que se analizará
		 * @param int       $error     Numero de error
		 */
		public static function parse( $cadena, $error ){
			global $Cfg;
			$title		= ( isset( $Cfg['Weby']['titulo'] ) && strlen( $Cfg['Weby']['titulo'] ) > 5 ) ? $Cfg['Weby']['titulo'] : self::$title[$error];
			$h2			= ( isset( self::$title[$error] ) )? strtolower( self::$title[$error] ) : "no se encontr&oacute; en este servidor";
			$variables	= array( "{title}", "{h1}", "{REQUEST_URI}", "{ico}", "{h2}" );
			$parsear	= array( $title, self::$title[$error], $_SERVER['REQUEST_URI'], self::$ico[$error], $h2 );
			
			return str_replace( $variables, $parsear, $cadena );
		}
}
	
?>