<?php
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * Carga el entorno del sitio Weby+
	 *
	 */
	
	/* Autorizo acceso */
		defined('YMS') or die( 'No dispones de acceso' );
	
	//$YMS['warning_handler']	= '';
	
	//* funcion para establecer error al usuario */
		function msg_error( $msg, $icon = '', $class = '' ){
			return yMSError::setMsgError( $msg, $icon, $class );
		}
		
	//* funcion para obtener error que se mostrará al usuario */
		function _error( $html = true ){
			return yMSError::getMsgError();
		}
		
	class yMSError {
		
		public static $msg_html;
		public static $msg;
		public static $pathLogErr;
		public static $pathNotificaciones;
		
		/* notificasiones - funcion para notificar alertas 
		 * @param str    $acc    e = escribir / l = leer
		 */
		public static function notificaciones( $acc = 'l', $notlinea = '' ){
			$acc	= strtolower( $acc );
			$data	= array();
			$index	= 0;
			$fecha	= date('Y-m-d H:i:s');
			
			if( file_exists( self::$pathNotificaciones ) ){
				$dat	= file_get_contents( self::$pathNotificaciones ); 
				$data	= json_decode( $dat, true );
				$index	= ( count( $data ) + 1 );
			}
			
			if( $acc == 'l' ) {
				for($i=0; $i < count( $data ); $i++){
					$data[$i]['leido'] = 1;
				}
				$dat2 = json_encode( $data );
				file_put_contents(self::$pathNotificaciones, $dat2);
				return $data;
			}
				
			if( $acc == 'e' ) {
				$data[$index]['fecha']		= $fecha;
				$data[$index]['descripcion']= $notlinea;
				$data[$index]['leido']		= 0;
				$dat2 = json_encode( $data );
				file_put_contents(self::$pathNotificaciones, $dat2);
			}
		}
		
		public static function notificaciones_noleidas(){
			$data	= array();
			
			if( file_exists( self::$pathNotificaciones ) ){
				$dat	= file_get_contents( self::$pathNotificaciones ); 
				$data	= json_decode( $dat, true );
				
				$c = 0;
				for($i=0; $i < count( $data ); $i++){
					if( $data[$i]['leido'] == 0 ){
						$c++;
					}
				}
				
				return $c;
			}
		}
		
		/* funcion para establecer error */
		public static function setMsgError( $msg, $icon = '', $class = '' ){
			$class	= 'alert ' . $class;
			$icon	= 'fa ' . $icon;
			$html	= '<div class="' . $class . '" role="alert"><i class="' . $icon . '"></i> ' . $msg . '</div>';
			self::$msg_html	= self::$msg_html . $html;
			self::$msg		= self::$msg . $msg . '<br/>';
			
			return $html;
		}
		
		/* funcion para obtener error */
		public static function getMsgError( $html = true ){
			return ( $html === true ) ? self::$msg_html : self::$msg;
		}
		
	}
	
	// función de gestión de errores
	function yLogErr( $errno, $errstr, $errfile, $errline, $errcontext )
	{
		//$descripcion	= "Error: [".$errno."] ".$errstr." ".$errfile." ".$errline." " . json_encode($errcontext);
		$descripcion	= "Error: [".$errno."] ".$errstr." ".$errfile." ".$errline." ";
		if (!(error_reporting() & $errno)) {
			// Este código de error no está incluido en error_reporting
			error_log( $descripcion . " \n\r", 3, yMSError::$pathLogErr);
			return;
		}
		
		error_log( $descripcion . " \n\r", 3, yMSError::$pathLogErr);
		///yMSError::notificaciones( 'e', "Error: [".$errno."] ".$errstr );
	
		/*switch ($errno) {
			case E_USER_ERROR:
				echo "<b>ERROR</b> [$errno] $errstr<br />\n";
				echo "  Error fatal en la línea $errline en el archivo $errfile";
				echo ", PHP " . PHP_VERSION . " (" . PHP_OS . ")<br />\n";
				echo "Abortando...<br />\n";
				exit(1);
				break;
		
			case E_USER_WARNING:
				echo "<b>Mi WARNING</b> [$errno] $errstr<br />\n";
				break;
		
			case E_USER_NOTICE:
				echo "<b>Mi NOTICE</b> [$errno] $errstr<br />\n";
				break;
		
			default:
				echo "Tipo de error desconocido: [$errno] $errstr<br />\n";
				break;
		}
	
		/* No ejecutar el gestor de errores interno de PHP */
		return true;
	}

	// función para probar el manejo de errores
	function scale_by_log($vect, $scale)
	{
		if (!is_numeric($scale) || $scale <= 0) {
			trigger_error("log(x) para x <= 0 no está definido, usó: scale = $scale", E_USER_ERROR);
		}
	
		if (!is_array($vect)) {
			trigger_error("Vector de entrada incorrecto, se esperaba una matriz de valores", E_USER_WARNING);
			return NULL;
		}
	
		$temp = array();
		foreach($vect as $pos => $valor) {
			if (!is_numeric($valor)) {
				trigger_error("El valor en la posición $pos no es un número, usando 0 (cero)", E_USER_NOTICE);
				$valor = 0;
			}
			$temp[$pos] = log($scale) * $valor;
		}
	
		return $temp;
	}
?>