<?php 
	/*
	 *
	 * 2003 - 2024 @ Yal Publicidad
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 */
	
	/* Autorizo acceso */
	defined('YPANEL_INI') or define('YPANEL_INI', true);
	// paquete del sistema web
	defined("YPATH") or define( "YPATH", dirname(__DIR__) );
	//** -- separador */
	defined('YDS') or define( "YDS", DIRECTORY_SEPARATOR );
	// directorios
	defined('__DIR_YPANEL__') or define("__DIR_YPANEL__", __DIR__);
	define("__DIR_BIN__", "NOP");
	// versiones soportadas
	define("VERSION_NUCLEO", "3.3.0");
	define("VERSION_PHP_MIN", "7.0");
	define("VERSION_MYSQL_MIN", "60000");
	// detalles de yPanel
	define("APP_NOMBRE", "yPanel Web");
	define("APP_DESCRIPCION", "Sistema CMS yPanel de Yal Publicidad");
	define("APP_MODIFICACION", "2024-05-17 18:30:45");
	define("APP_WEB", "https://ypanel.yalpublicidad.com");
	define("APP_SOPORTE", "ypanel@yalpublicidad.com");
	define("APP_URL_ACTUALIZACION", "http://ypanel.yalpublicidad.com/xml/actualizador.json");
	define("APP_IDIOMA", "ES");
	define("APP_NOMBRE_ORIGINAL", "yPanel");
	define('APP_URL_ERRORLOG', "http://ypanel.yalpublicidad.com/xml/prcsserrsis.php");
	define('APP_EXPLORER', 'editor/yexplorador/lib/mod.func.php');
	// datos del sistema web
    define('SIS_URL_ERRORLOG', "http://webyplus.com/xml/prcsserrsis.php");
	define('SIS_BIN', dirname(__DIR__) . YDS . "wy_lib" . YDS . "wy_cargar.php"); //__DIR_YPANEL__ . YDS . "bin" . YDS . "y_cargarsis.php";
	define('SIS_DIR_EXT', dirname(__DIR__) . YDS . 'wy_incluye' . YDS . 'wy_ext');
    define('SIS_IDATA', "NOP");
    // datos adicionales del sistema web ej. define("NOMRE","VALOR");
    define('WY_INI_WEBY',true);
	
	//** -- Cargo el sistema BIN principal que trabajará con yPanel. Solo es compatible con YBIN */ 
	if ( __DIR_BIN__ !== 'NOP' ) { 
		include_once(__DIR_BIN__);
	}else{
		include_once(SIS_BIN); 
	}
	defined( "YMS" ) or die('Módulo Y es necesario para que yPanel pueda funcionar correctamente.');
	
	//** -- Cargo el sistema yData.y */ 
	if ( SIS_IDATA !== 'NOP' ) { paquete_idata(_DIR_IDATA); }
	// defino el nombre personalizado de tabla login de sistema web que trabajara con yPanel
	loginTabla(WY_DBPREFIJO . 'usuarios');

	// metodo para importar librerias
    function importar($ruta=NULL, $ext=NULL){
		yPanelSis::importar($ruta,$ext);
	}

    class yPanelSis{

        /* importar - importa ficheros al sistema 
         * importar( string $ruta = NULL, string $ext = NULL) : mixed
         * 
         * Parametros
		 * ruta - Ruta del paquete a importar
         * ext  - Extensión de archivo que se importará, si no se define por defecto será PHP 
		*/
		public static function importar($ruta=NULL, $ext=NULL){
			if(empty($ruta)) return false;
			// determino extension
			$ext	= (empty($ext)) ? '.php' : '.' . $ext;
			// extraigo partes de la ruta
			$rutar	= explode('.', $ruta);
			// creo nombre de fichero
			$nomfi	= end($rutar) . $ext;
			// creo ruta de camino
			switch($rutar[0]){
				case 'sisx':
					$rutar[0] = YPATH;
					break;
				default:
					$rutar[0] = __DIR_YPANEL__;
			}
			// compongo ruta
			$rutax	= '';
			for($i=0;$i<(count($rutar)-1);$i++){
				$rutax .= $rutar[$i] . YDS;
			}
			///$rutax	= trim($rutax,YDS);
			$rutax	= trim($rutax);
			$path	= $rutax . $nomfi;
			// cargo fichero / leo ruta de archivo
			if(is_file($path)){
				include_once($path);
			}
			return;
		}
    }
	
?>