<?php 
	/*
	 *
	 * 2003 - 2024 @ Yal Publicidad
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 * 
	 * @ypanel.ypanel
	 *
	 */
	
	/* Autorizo acceso */
	defined('YPANEL_INI') or die( 'No dispones de acceso' );
	// ** -- compruebo si existe el archivo de configuracion */
    if(!file_exists('__DataSis__.php')){ 
		die('No se encontro el archivo de configuración. Este archivo es necesario ara el arranque de yPanel'); 
	}
	//** -- cargo libreria principales */
	include_once("__DataSis__.php");
	//** -- Verifico version de PHP Y MySQL */
	if ( version_compare( phpversion(), VERSION_PHP_MIN, 'lt' ) || mysqli_get_client_version() < VERSION_MYSQL_MIN ) {
		// Si no cumple con requerimientos imprimo mensaje
		die('ERROR: Se necesita una version PHP o MySQL superior a la que tiene instalada.');
		exit();
	}


	class yPanel{		
		/** 
		 * en_sesion() : bool
		 * funcion para verificar inicio de sesion 
		 */
		public static function en_sesion(){
			if(!class_exists("yMSISess")){
				die('¡IMPORTANTE! No se encontró el módulo YBIN necesario para ejecutar inicio de sesión.');
			}
			
			if(loginEnSesion()){
				return true;
			}
			return false;
		}
		
		/**
		 * login() : string
		 */
		public static function login(){
			$login	= __DIR_YPANEL__ . YDS . 'paneles' . YDS . 'login' . YDS . 'tpl_login.php';
			if( file_exists( $login ) ){
				include_once( $login );
				return;
			}
			header('HTTP/1.0 404 not found');
			return false;
		}
		
		/**
		 * no_cache() : void
		 */
		public static function no_cache(){
			// max-age=0 : max-age=10800, pre-check=10800 => 180 minutos es el valor predeterminado de session.cache_expire
			//header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
			header("Cache-Control: no-store, no-cache, must-revalidate, max-age=10800");
			header("Cache-Control: post-check=0, pre-check=10800", false);
			header("Pragma: no-cache");
		}
		
	}
	
?>