<?php
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - yPanel
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * funciones principales de modulo
	 */
	
	/* Autorizo acceso */
		defined('YPANEL_INI') or die( 'No dispones de acceso' );
	
	/** 
	  * funcion para mostrar estado 
	  * de sitio webyplus */
	function input_estado(){
		
		$shtml = '<select id="estado" name="estado">';
		$shtml .= '<option value="1" ';
		$shtml .= ( YP_ESTADO_WEBY == 1 ) ? 'selected' : '';
		$shtml .= '>Activada</option>';
		$shtml .= '<option value="2" ';
		$shtml .= ( YP_ESTADO_WEBY == 2 ) ? 'selected' : '';
		$shtml .= '>En mantenimiento</option>';
		$shtml .= '<option value="3" ';
		$shtml .= ( YP_ESTADO_WEBY == 3 ) ? 'selected' : '';
		$shtml .= '>En construcción</option></select>';
		
		return $shtml;
	}
	
	/** 
	  * funcion mail_ssl
	  * de sitio webyplus */
	function input_ssl(){		
		$shtml = '<input type="checkbox" id="mail_ssl" name="mail_ssl" value="1" ';
		$shtml .= ( WY_MAILSSL == false ) ? '' : 'checked';
		$shtml .= ' > SSL';
		
		return $shtml;
	}
	
	//** Listar zona horaria UTC */
	function utc( $gmtpag = NULL ){
		$utc		= _DIR_PAQUETE . YDS . '.ypanel/utc.y';
		
		if( file_exists( $utc ) ){
				$gmt	= file_get_contents( $utc );
				$gmt 	= json_decode( $gmt );
				
				$shtml = '<select id="gmt" name="gmt">';
				foreach ($gmt as $clave => $valor){
					$valor	= explode( '|', $valor );
					$value	= isset( $valor[1] ) ? $valor[1] : NULL;
					$text	= isset( $valor[0] ) ? $valor[0] : NULL;
					
					$shtml .= '<option value="' . $value . '"';
					if( $value == $gmtpag )  $shtml .= ' selected';
					$shtml .= '>' . $text . '</option>';
				}
				$shtml .= '</select>';
			
				return $shtml;
		}else{
				die( 'No hay modulo UTC disponible' );
		}
	}
	
?>	

		<form method="post" action="<?php echo com_base() ?>prcss.php">
			
			
			<div class="m-t-35 m-b-35" align="right">
				<hr>
				<?php echo com_boton( 'cancelar' ). com_boton( 'guardar', NULL, true ); ?>
			</div>
			
			<div class="row m-b-5">
				<div class="col-md-3">
					<label for="IdWeby">Id Weby+</label>
				</div>
				<div class="col-md-9">
					<input type="text" class="w-full" id="IdWeby" name="IdWeby" value="<?php echo WEBYPLUS_ID ?>" autocomplete="off">
				</div>
			</div>
			<div class="row m-b-25">
				<div class="col-md-3">
					<label for="CodActivacion"><?php echo etiqueta( 'e_form_input_codigo_activacion', 'Código de Activación' ) ?></label>
				</div>
				<div class="col-md-9">
					<input type="text" class="w-full" id="CodActivacion" name="CodActivacion" value="<?php echo WEBYPLUS_ID_ACTIVACION ?>" readonly>
				</div>
			</div>
								
			<ul class="Tabs" data-min="0" data-max="2">
					<li class="hTab" id="hTab-0" onclick="aTab(this)">Configuración del Sitio</li>
					<li class="hTab" id="hTab-1" onclick="aTab(this)">SMTP</li>
			
					<li class="bTab">
						<div id="bTab-0">
							<fieldset>
								<legend></legend>
								
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="estado"><?php echo etiqueta( 'e_form_input_estado_webyplus', 'Estado Sitio Weby+' ) ?></label>
									</div>
									<div class="col-md-9">
										<?php echo input_estado() ?>
									</div>
								</div>
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="gmt"><?php echo etiqueta( 'e_form_input_zona_horaria', 'Zona horaria' ) ?></label>
									</div>
									<div class="col-md-9">
										<?php echo utc( GMT ) ?>
									</div>
								</div>
									
								<h4 class="m-b-15 m-t-15"><?php echo etiqueta( 'e_subtitulo_1', 'Configuración &lt;head&gt; de sitio Weby+' ) ?></h4>
								
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="charset">Charset <span class="requerido">*</span></label>
									</div>
									<div class="col-md-9">
										<input type="text" id="charset" name="charset" placeholder="Ej. utf-8" value="<?php echo WY_CHARSET ?>" >
									</div>
								</div>
								
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="title"><?php echo etiqueta( 'e_form_input_titulo', 'Título de sitio web' ) ?></label>
									</div>
									<div class="col-md-9">
										<input type="text" class="w-full" id="title" name="title" placeholder="Titulo de sitio Weby+" value="<?php echo WY_TITLE ?>" >
									</div>
								</div>
								
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="description"><?php echo etiqueta( 'e_form_input_descripcion', 'Descripción' ) ?></label>
									</div>
									<div class="col-md-9">
										<textarea class="w-full" rows="5" name="description"><?php echo WY_DESCRIPTION ?></textarea>
									</div>
								</div>
								
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="keywords"><?php echo etiqueta( 'e_form_input_palabras_claves', 'Palabras claves' ) ?></label>
									</div>
									<div class="col-md-9">
										<textarea class="w-full" name="keywords"><?php echo WY_KEYWORDS ?></textarea>
									</div>
								</div>
									
								<h4 class="m-b-15 m-t-15"><?php echo etiqueta( 'e_subtitulo_2', 'Datos de Contacto del sitio Weby+' ) ?></h4>
									
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="organizacion"><?php echo etiqueta( 'e_form_input_organizacion', 'Organización' ) ?></label>
									</div>
									<div class="col-md-9">
										<input type="text" id="organizacion" name="organizacion" placeholder="Nombe de la empresa u organización" value="<?php echo WY_ORGANIZACION ?>" >
									</div>
								</div>
								
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="direccion"><?php echo etiqueta( 'e_form_input_direccion', 'Dirección' ) ?></label>
									</div>
									<div class="col-md-9">
										<input type="text" class="w-full" id="direccion" name="direccion" placeholder="Dirección de la empresa u organización" value="<?php echo WY_DIRECCION ?>" >
									</div>
								</div>
								
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="telefonos"><?php echo etiqueta( 'e_form_input_telefonos', 'Teléfonos' ) ?></label>
									</div>
									<div class="col-md-9">
										<textarea class="w-full" name="telefonos" placeholder="ej. +51 888 888 888, +51 999 999 999"><?php echo WY_TELEFONOS ?></textarea>
									</div>
								</div>
								
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="correos"><?php echo etiqueta( 'e_form_input_email', 'Correos Electrónicos' ) ?></label>
									</div>
									<div class="col-md-9">
										<textarea class="w-full" name="correos" placeholder="ej. usuario1@dominio.com, usuario2@dominio.com"><?php echo WY_EMAILS ?></textarea>
									</div>
								</div>
								
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="mapa"><?php echo etiqueta( 'e_form_input_mapa', 'URL Mapa de Ubicación' ) ?></label>
									</div>
									<div class="col-md-9">
										<textarea class="w-full" name="mapa" placeholder="ej. <embed></embed>"><?php echo WY_MAPA ?></textarea>
									</div>
								</div>
									
							</fieldset>
						</div>
						
						<div id="bTab-1">
							<fieldset>
								<legend></legend>
									
								<h4 class="m-b-15 m-t-15"><?php echo etiqueta( 'e_subtitulo_3', 'Información de Servidor' ) ?></h4>
									
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="mail_servidor"><?php echo etiqueta( 'e_form_input_servidor_mail', 'Servidor' ) ?></label>
									</div>
									<div class="col-md-9">
										<input type="text" class="w-full" id="mail_servidor" name="mail_servidor" placeholder="Servidor SMTP" value="<?php echo WY_MAILHOST ?>">
									</div>
								</div>
									
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="mail_usuario"><?php echo etiqueta( 'e_form_input_usuario_mail', 'Usuario' ) ?></label>
									</div>
									<div class="col-md-9">
										<input type="text" class="w-full" id="mail_usuario" name="mail_usuario" placeholder="Usuario SMTP" value="<?php echo WY_MAILUSER ?>" >
									</div>
								</div>
								
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="mail_pass"><?php echo etiqueta( 'e_form_input_password_mail', 'Contraseña' ) ?></label>
									</div>
									<div class="col-md-9">
										<input type="password" id="mail_pass" name="mail_pass" placeholder="Contraseña SMTP" value="<?php echo WY_MAILPASS ?>" >
									</div>
								</div>
								
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="mail_puerto"><?php echo etiqueta( 'e_form_input_puerto_mail', 'Puerto' ) ?></label>
									</div>
									<div class="col-md-9">
										<input type="text" id="mail_puerto" name="mail_puerto" placeholder="Por defecto 587" value="<?php echo WY_MAILPORT ?>" >
									</div>
								</div>
									
								<div class="row m-b-5">
									<div class="col-md-3">
										<label for="mail_ssl"><?php echo etiqueta( 'e_form_input_ssl_mail', 'Usar SSL' ) ?></label>
									</div>
									<div class="col-md-9">
										<?php echo input_ssl() ?>
									</div>
								</div>
									
							</fieldset>
						</div>
					</li>
				</ul>
				
			</form>
			
			<script> 
				setTimeout("obt_CA()",3000); 
				aTab(document.getElementById("hTab-0")); 
				
				$_("#cancelar").onclick = function(){ history.go(-1); }
				
			</script>