<?php

	//** -- separador */
	defined('YDS') or define( "YDS", DIRECTORY_SEPARATOR );
	defined('_DIR_PAQUETE') or define("_DIR_PAQUETE", __DIR__);

    // ** -- compruebo si existe el archivo de configuracion */
    if(!file_exists(_DIR_PAQUETE . YDS . 'cfg.php')){ 
		die('No se encontro el archivo de configuración. Este archivo es necesario ara el arranque de yPanel'); 
	}
	include_once(_DIR_PAQUETE . YDS . 'cfg.php');			// archivo de configuracion
	 // Si $yp es array Creará definiciones basadas en las variables de cfg
	 if(is_array($yp)){
		$nomClave = 'NULO';
		foreach($yp as $c => $v){
            foreach($v as $nc => $nv){
				$nomTmp = $c.'_'.$nc;
				defined($nomTmp) or define($nomTmp,$nv);
			}
		}
	}

	//** -- Verifico version de PHP Y MySQL */
	if ( version_compare( phpversion(), VERSION_PHP, 'lt' ) || mysqli_get_client_version() < VERSION_MYSQL ) {
		// Si no cumple con requerimientos imprimo mensaje
		die('ERROR: Se necesita una version PHP o MySQL superior a la que tiene instalada.');
		exit();
	}
	//** -- Cargo el sistema web principal que trabajará con yPanel */ 
	if ( SIS_SWEBP !== 'NOP' ) { include_once(SIS_SWEBP); }
	// ** -- compruebo si están cargadas las librerías 'YBIN' */
	if ( SIS_BIN !== 'NOP' ) { include_once(SIS_BIN); }		// cargo sistema BIN Requerido
	defined( "YMS" ) or die('Módulo Y es necesario para que yPanel pueda funcionar correctamente.');
	//** -- Cargo el sistema yData.y */ 
	if ( _DIR_IDATA !== 'NOP' ) { paquete_idata(_DIR_IDATA); }
	/*if(function_exists('idata') && is_object(idata())){
			$iDataVars	= get_object_vars(idata());
			foreach($iDataVars as $c => $v){
				$iNomTmp = 'IDATA_'.strtoupper($c);
				defined($iNomTmp) or define($iNomTmp,$v);
			}
	}*/

	/** -- Cargo clase yPänel */
	include_once(_DIR_PAQUETE . YDS . 'lib' . YDS . 'ypanel.php');	// archivo de metodos y propiedades
   
    // metodo para importar librerias
    function importar($ruta=NULL, $ext=NULL){
		yPanelSis::importar($ruta,$ext);
	}

    class yPanelSis{

        /* importar - importa ficheros al sistema 
         * importar( string $ruta = NULL, string $ext = NULL) : mixed
         * 
         * Parametros
		 * ruta - Ruta del paquete a importar
         * ext  - Extensión de archivo que se importará, si no se define por defecto será PHP 
		*/
		public static function importar($ruta=NULL, $ext=NULL){
			if(empty($ruta)) return false;
			// determino extension
			$ext	= (empty($ext)) ? '.php' : '.' . $ext;
			// extraigo partes de la ruta
			$rutar	= explode('.', $ruta);
			// creo nombre de fichero
			$nomfi	= end($rutar) . $ext;
			// creo ruta de camino
			switch($rutar[0]){
				case 'sisx':
					$rutar[0] = _DIR_PAQUETE_WEB;
					break;
				default:
					$rutar[0] = _DIR_PAQUETE;
			}
			// compongo ruta
			$rutax	= '';
			for($i=0;$i<(count($rutar)-1);$i++){
				$rutax .= $rutar[$i] . YDS;
			}
			///$rutax	= trim($rutax,YDS);
			$rutax	= trim($rutax);
			$path	= $rutax . $nomfi;
			// cargo fichero / leo ruta de archivo
			if(is_file($path)){
				include_once($path);
			}
			return;
		}
    }
?>