<?php
	/*
	 *
	 * 2003 - 2022 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * Este módulo lee y carga el sistema Weby+
	 *
	 */
	
	//* defino autorizacion de acceso al sistema web
	defined('WY_INI_WEBY') or define( "WY_INI_WEBY", true );
	//* defino autorizacion de acceso al sistema del panel
	defined('YPANEL_INI') or define("YPANEL_INI", true);
	//* defino ruta del path
	defined('YPATH') or define( "YPATH", __DIR__ );
	defined('YDS') or define( "YDS", DIRECTORY_SEPARATOR );
	
	/* Compruebo si el archivo de configuracion del sistema existe */
		if ( !file_exists( YPATH . YDS . 'wy_configuracion.php' ) || ( filesize( YPATH . YDS . 'wy_configuracion.php' ) < 10 ) ) {			
			if( file_exists( YPATH . YDS . 'instalar' . YDS . 'index.php' ) ) {
				header( 'Location: instalar/index.php' );
				exit();
			} else {
				echo '<center><strong>Error 1:</strong> La configuraci&oacute;n e instalaci&oacute;n del sistema no pueden ser cargado.</center>';
				exit();
			}		
		}
	
	//* Denegamos el acceso a plantilla en caso no existiera o esté en estado de mantenimiento */
		require_once( YPATH . YDS . 'error/include/HTTP_ErrorDocument.php' );
		HTTPErrorDocument::estado();
	
	//* Cargo la configuración del sistema */
		require_once( YPATH . YDS . 'wy_lib' . YDS . 'wy_cargar.php' );
		
	
	//* Verifico version de PHP Y MySQL
		if( !$PHP_VERSION || !$MySQL_VERSION ){
			// Si no cumple con requerimientos imprimo mensaje
			echo wy_error();
			exit();
		}
		
/* ---------------------------------------- *\
	Despues de verificar requimientos
	Inicio sistema WebyPlus(R)
\* ---------------------------------------- */
	
	//* Verifico que la licencia WebyPlus esté activa
		if( !IdWebyPlus( WEBYPLUS_ID, 'C' ) )
		{
			HTTPErrorDocument::tlpError( 8003 );
			exit;
		}
	
	/* Incluyo modulo de funciones personalizadas */
		if( file_exists( EntornoWeby::temaPath() . YDS . 'wy_mod_sitioweby.php' ) )
		{
				require_once( EntornoWeby::temaPath() . YDS . 'wy_mod_sitioweby.php' );
		}
	 
?>