<?php
	/*
	 *
	 * WebyPlus (c) 2003 - 2023 Yal Publicidad
	 * Este módulo es requerido para cargar todo el sistema WebyPlus.
	 * Es nesario incluirlo en modulos, clases o extensiones externas
	 * anexadas al sistema WebyPlus
	 *
	 */
	
	/* Autorizo acceso */
		defined('WY_INI_WEBY') or die( 'No dispones de acceso' );

	// ** -- defino ruta del path
	defined('YPATH') or define( "YPATH", dirname(__DIR__) );
	// ** -- control de errores
	error_reporting( E_CORE_ERROR | E_CORE_WARNING | E_COMPILE_ERROR | E_ERROR | E_WARNING | E_PARSE | E_USER_ERROR | E_USER_WARNING | E_RECOVERABLE_ERROR );
	// ** -- Cargo Configuracion de sistema */
		require_once( YPATH . YDS . 'wy_configuracion.php' );
	// ** -- Cargo librerias y variables de sistema MS */
		require_once( YPATH . YDS . 'bin' . YDS . 'y_cargarsis.php' );
	// ** -- cargo ruta de iData.y
		paquete_idata(YPATH);
	//
		yActualizar::$servidor_uri	= 'http://www.webyplus.com/xml/actualizador.json';
		yActualizar::$version_actual= idata( 'version_nucleo' );
		
	//* Deficiones de configuracion
		require_once( 'bin' . YDS . 'wy_cfg.php' );		
		
	//* funcion para almacenar error 
	function wy_msgError( $msg, $icon = NULL, $class = NULL ){
		msg_error( $msg, $icon, $class );
	}
	//* funcion para mostrar error
	function wy_error( $html = false ){
		if( $html )
			return yMSError::$msg_html;
		else
			return y_error();
	}
	
	// ** -- variables para version PHP y MySQL
	// comprobando requerimientos minimos de PHP y MySQL */
	$PHP_VERSION	= true;
	$MySQL_VERSION	= true;
		// Compruebo vesion de PHP
				if ( version_compare( phpversion(), idata( 'version_php' ), 'lt' ) ) {
						$PHP_VERSION = false;
						wy_msgError( '<b>Notice</b>: PHP ' . idata( 'version_php' ) . ' es requirido como m&iacute;nimo. Tu version actual instalada es PHP ' . phpversion() . '. ' );
				}
		// Compruebo version de MySQL
				if( mysqli_get_client_version() < idata( 'version_mysql' ) ){
						$MySQL_VERSION = false;
						wy_msgError( '<b>Notice</b>: MySQL ' + idata( 'version_mysql' ) + '+ es requirido como m&iacute;nimo. Tu version actual es ' . mysqli_get_client_version() . '. ' );
				}
		
	// ** -- Cargo la configuración del sistema WebyPlus */
		require_once( 'bin' . YDS . 'wy_funciones.php' );	
	// require_once( 'bin/wy_html.php' );
		require_once( 'bin' . YDS . 'wy_sql.php' );
	// Cargo modulo de sitio Weby+ */		
		require_once('bin' . YDS . 'wy_mod_sitioweby.php');
	// defino prefijo de tabla del sistema webyplus
	_mysql_est_prefijo_sisx(WY_DBPREFIJO); 
		
class EntornoWeby{
	/*
	 * Obtener ruta de tema del sistema weby+ 
	 * temaPath() : string
	 */
	public static function temaPath( $base = false ){
		$tmpPath	= ( $base ) ? 'wy_incluye/wy_tmp/' : YPATH . YDS . 'wy_incluye/wy_tmp/';
			
		$sql		= _mysql_query( "SELECT * FROM " . WY_DBPREFIJO . "plantillas WHERE sel='1'" );
		if($sql){
			while( $row = _mysql_fetch_array( $sql ) ){
				$tmpPath = ( $base ) ? 'sitio' . YDS . $row['plantilla'] : YPATH . YDS . 'sitio' . YDS . $row['plantilla'];
			}
		}
			
		return $tmpPath;
	}
	
	/*
	 * Obtener pagina de inicio del tema sistema weby+ 
	 */
	public static function index()
	{
			global $wy, $wy_func;
			// Header charset=UTF-8
			header('Content-Type: text/html; charset=UTF-8');
			$tmpIndex	= self::temaPath() . '/index.php';
			
			if( file_exists( $tmpIndex ) ){
				if( !isset( $_SESSION ) ) session_start();
				require_once( $tmpIndex );
			}else{ header('HTTP/1.0 404 not found'); return false; }
			
			//return $tmpIndex;
	}
}

?>