<?php
	/*
	 *
	 * yMS (c) 2003 - 2022 Yal Publicidad
	 * Sistema: Macrodígital Software - de Yal Publicidad
	 *
	 */
	
	define( "YMS", true );
	
	//* Procesador de errores
	include_once( 'y_error.php' );

	//* definiciones de sistema
	include_once( 'y_def.php' );
	
	//Definimos el tratamiento de errores no controlados
	/*set_error_handler( function()
	{
		throw new Exception( "<b>Error de conexión:</b> " );
	});*/
	
	class Y{
		
		public static $ruta_paquete;
		public static $bibliotecas	= array( "@lib" => "lib" );
		
		public static function importar( string $path ){
			if( empty( $path ) ) return false;
			
			$camino			= '';
			$ruta_paquete	= ( self::$ruta_paquete != NULL ) ? self::$ruta_paquete : dirname( dirname(__FILE__) );
			
			$path	= explode( '.', $path );
			
			if( is_array( $path ) ){
				for( $i = 0; $i < count( $path); $i++ ){
					$camino .= '/' . $path[$i];
				}
				include_once( $camino . '.php' );
			}
			
			include_once( $path[0] . '.php' );
		}
	}
	
	function idata($nombre=NULL){
		// si $nombre no esta definido, devuelvo todo el array
		if(empty($nombre)){ return MSiData::obt(); }
		// obtengo un valor especifico
		return MSiData::obtener($nombre);
	}

	function paquete_idata($rPaquete=NULL,$assoc=false){
		return MSiData::paquete_idata($rPaquete,$assoc);
	}

	/* ----------------------------------- *\
			Clase iData
	\* ----------------------------------- */
	class MSiData {
		
		public $terminos			= '';
		public static $camino_ydata = '';
		public static $camino_tyc	= '';
		
		private static $r_iData;		// ruta del paquete iData.y
		private static $a_iData;		// datos iData.y
		private static $rutaPaquete;	// ruta del paquete del sistema web
		private static $rutaPanel;		// ruta del panel
		
		/* obtener - obtiene un valor almacenado en iData.y
		 * obtener(string $dato ) : mixed
		 * Parametros
		 * $dato - campo del cual se quiere obtener el valor
		 * ----
		 * funcion para cargar yData.y
		 * {"version_nucleo":"1.9.15","version_php":"5.6.0","version_mysql":"50000","app_nombre":"WebyPlus","idioma":"en"}
		 */
		public static function obtener( $dato ){
			if( !empty(self::$a_iData) ){
				if(is_object(self::$a_iData)){
					return self::$a_iData->$dato;
				}
				if(is_array(self::$a_iData)){
					return self::$a_iData[$dato];
				}
			}
			return false;
			/*if( file_exists( self::$camino_ydata . '/iData.y' ) ){
				$iData	= file_get_contents( self::$camino_ydata . '/iData.y' );
				$iData = json_decode( $iData );
				return isset( $iData->$dato ) ? $iData->$dato : false;
			}else{
				die( '<b>Alerta!</b> MsiData archivo de sistema, no existe.' );
			}*/
		}
		
		public static function tyc(){
			if( file_exists( self::$camino_ydata . 'tyc/tyc.' . LNG::$idioma ) ){
				$iData	= file_get_contents( self::$camino_ydata . 'tyc/tyc.' . LNG::$idioma );
				return ( strlen( $iData ) > 55 ) ? $iData : false;
			}else{
				die( '<b>Alerta!</b> MsiData archivo de sistema, no existe.' );
			}
		}
		
		/*
		 * funcion para obtener info yData.y
		 * {"version_nucleo":"1.9.15","version_php":"5.6.0","version_mysql":"50000","app_nombre":"WebyPlus","idioma":"en"}
		 */
		public static function obt(){
			try{
				if( is_object(self::$a_iData) ){
					return self::$a_iData;
				}
			}catch( Exception $e ){
				$e->getMessage();
			}
		}
		
		/* paquete() : Cargo ruta del paquete sistema web ej. Webyplus 
		 * @param  str  $rPaquete    ruta del paquete
		*/
		public static function paquete($rPaquete=NULL){
			if(empty($rPaquete)) return false;
			self::$rutaPaquete = $rPaquete;
		}
		
		/* paquete_idata - Cargo ruta de la informacion iData.y ej. Webyplus 
		 * paquete_idata(string $rPaquete=NULL, ?bol $assoc=false) : string
		 * Parametros
		 * $rPaquete - ruta del paquete
		 * $assoc    - si es true devuelve resultados como array, si false devuelve resultados como objetos
		*/
		public static function paquete_idata($rPaquete=NULL,$assoc=false){
			$r_iData = $rPaquete . '/iData.y';
			if( file_exists( $r_iData ) ){
				self::$camino_ydata = $rPaquete;
				$iData	= file_get_contents( $r_iData );
				self::$a_iData = json_decode( $iData, $assoc );
				return self::$a_iData;
			}
			return $r_iData;
		}
		
		/* paquete_panel() : Cargo ruta del paquete del panel ej. yPanel 
		 * @param  str  $rPaquete    ruta del paquete
		*/
		public static function paquete_panel($rPaquete=NULL){
			if(empty($rPaquete)) return false;
			self::$rutaPanel = $rPaquete;
		}
	}
	
	
	//** funciones de sistema */
	require_once( 'y_funciones.php' );
	//** funciones de sesion */
	require_once( 'y_sessus.php' );
	//** funciones con IP */
	require_once( 'y_ip.php' );
	// ** funciones con fecha
	require_once('y_fecha.php');
	//** funciones MySQLi */
	require_once( 'y_mysql.php' );
	//** funciones de sesion */
	require_once( 'y_sess.php' );
	//** funciones captcha */
	require_once( 'y_captcha.php' );
	//** funciones html globales */
	require_once( 'y_html.php' );
	//** funciones de idioma */
	require_once( 'y_lng.php' );
	//** funciones de actualizacion */
	require_once( 'y_actualizador.php' );
	//** analizador de sistema
	require_once( 'y_anaMSsis.php' );
	//** cargo funciones de facturacion y divisas
	include_once( 'y_fac.php' );
	// ** cargo funciones e-comerce
	include_once( 'y_ec.php' );
	//** cargo funciones de correo
	include_once( 'y_correo.php' );
	

?>