<?php
	
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * @lib.y_actualizador
	 *
	 * Sistema de actualizacion WebyPlus.
	 *
	 */
	 
	
	/* Autorizo acceso */
		defined('YMS') or die( 'No dispones de acceso' );
	
	
	/**
	 * $url = url_exists( "http://ejemplo.com/una-url-a-comprobar" );
	 */
	function url_exists( $url = NULL ) {
		return url_existe( $url );
	}
	
	
	
	
	//** funcion para buscar actualizacion */
	function buscar_actualizacion( $link_actualizar = NULL )
	{
		return yActualizar::buscar_nueva_version( $link_actualizar );
	}
	
	//** funcion para descargar App */
	function descargarApp()
	{
		$appXML = file_get_contents( YPATH . YDS . '/xml/app-webyplus.xml' );
		$App = simplexml_load_string( $appXML );
		return $App->aplicacion;
	}
	
	
class yActualizar{
	
	public static $servidor_uri;
	public static $version_actual;
	
	private static $version_nueva;
	
	
	/**
	 * buscar_nueva_version() : string
	 * Busca nuevas versiones de la aplicacion
	 */
	public static function buscar_nueva_version( $link_actualizar = NULL )
	{
		$nom_app	= ( isset( self::servDatos()->nombre ) ) ? self::servDatos()->nombre : 'App';
		$version_n	= ( isset( self::servDatos()->version ) ) ? self::servDatos()->version : 0.0;
		$version	= str_replace( '.', '', $version_n );
		$version_a	= str_replace( '.', '', self::$version_actual );
		
		$lnkActualizarApp = ( $link_actualizar != NULL ) ? '<a href="' . $link_actualizar . '" title="Descargar actualización">Descargar ahora</a>' : '';
		
			if( $version > $version_a ){
				return '<div style="background:#d4eaf7;padding:10px 25px;border-radius:5px;border:#b4e4ee 1px solid; font-size:small;color:#2a6682;margin-bottom:10px;">&iexcl;Ya está disponible la versión ' . $nom_app . ' ' . $version_n . '! ' . $lnkActualizarApp . '</div>';
			}else{
				return '<div style="font-size:small;color:#999;margin-bottom:10px;">Tu versión ' . $nom_app . ' está actualizada.</div>';
			}
	}
	
	/**
	 * conectar_servidor() : string
	 * Conecta con servidor de la aplicacion
	 */
	private static function conectar_servidor(){
		if (function_exists('curl_init')) {
			
			$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, self::$servidor_uri);
            	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);				
				curl_setopt($ch, CURLOPT_FAILONERROR, true);
				curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); 
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		
			$res = curl_exec ($ch);
			
			if ( !($res) ) {
					$errno = curl_errno($ch);
					$errstr = curl_error($ch);
					curl_close($ch);
					//throw new Exception("cURL error: [$errno] $errstr");
					return die("cURL error: [$errno] $errstr");
			}
		
			curl_close($ch);
			
			return $res;
		}
		return '{"version":"0","url_descarga":"#"}';
	}
	
	/*
	 * servDatos() : string
	 * Obtiene datos del modulo de actualizacion
	 */
	public static function servDatos()
	{
		$datos	= json_decode( self::conectar_servidor() );
		return $datos;
	}
	
}
	



/*function buscar_actualizaciones()
	{
		if( url_exists( WYCFG_App_ActualizadorXML ) ){
			$actualizacionesXML = file_get_contents( WYCFG_App_ActualizadorXML );
			$Actualizar = simplexml_load_string( $actualizacionesXML );
			return $Actualizar->actualizar;
		}
		return false;
	}
	
	/*
	 * Buscar si hay acrualizaciones disponibles
	 */
	/*function actualizarApp( $RetornoMsj = false )
	{
		if( buscar_actualizaciones() ){
			//buscar_actualizaciones()->downloads->downloadurl
			$lnkActualizarApp = '<a href="' . post_link( 'actualizar' ) . '" title="Descargar actualización">Descargar ahora</a>';
			
			if( buscar_actualizaciones()->version > WYCFG_App_Version )
				return ( $RetornoMsj != false ) ? wyp_mensaje( '&iexcl;Ya está disponible la versión Weby+ ' . buscar_actualizaciones()->version . '! ' . $lnkActualizarApp, "Atento" ) : true;
		}
		
		// Si no hay actualizaciones de aplicación retorno valor falso
		return false;
	}*/
	
	
?>