<?php
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - yPanel
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * formulario de modulo
	 */
	
	/* Autorizo acceso */
		defined('YPANEL_INI') or die( 'No dispones de acceso' );
	
	/**
	  * Listar idiomas instalados en el sistema
	  */
	function idiomas_instalados( $usuario = NULL ){
		$idiomas		= _DIR_PAQUETE . YDS . '.ypanel' . YDS . 'datos' . YDS . 'lng' . YDS . '__datos';
		
		$json			= file_get_contents( $idiomas ); 
		$idiomas		= json_decode($json, true); 
		
		$idioma_us		= yPanel::cuenta_usuario( 'lenguaje', $usuario );
		$idiomas_list	= '';
		
		foreach( $idiomas as $k => $v ){
			$idiomas_list .= '<option value="' . $k . '"';
			if( $idioma_us == $k )  $idiomas_list .= ' selected';
			$idiomas_list .= '> ' . $v . '</li>';
		}
		
		return $idiomas_list;
	}
	
	function nivel_lista( $nivel_u = NULL ){
			$html	= '';
			//** obtengo nivel de usuario
			//$nivel_usuario	= strtolower( yPanel::cuenta_usuario( 'nivel' ) );
			$nivel_usuario	= strtolower( $nivel_u );
			//** obtengo array de acceso por niveles
			$niveles		= yPanel::niveles(); 
			
			foreach( $niveles as $n => $r ){
				$html	.= '<option value="' . $n . '"';
				$html	.= ( $n === $nivel_usuario ) ? ' selected' : '';
				$html	.= '>' . $r->nombre . '</option>';
			}
			
			return $html;
	}
	
	function reglas_u( $usuario = NULL, $nivel_u = NULL ){
			$html	= '<div class="row">';
			$modulos= array();
			//** obtengo privilegio de usuario
			$privilegios		= yPanel::privilegio_usuario( $usuario, $nivel_u );
			$privilegios		= json_decode( $privilegios, true );
			
			foreach( $privilegios as $n => $r ){
					$html .= '<div class="col-sm-4 m-b-25"><div class="m-b-10"><strong>' . $n . '</strong></div>';
					$html .= '<table class="table">';
					foreach( $r as $c => $v ){
						$html	.= '<tr>';
						$html	.= '<td><input type="checkbox" name="modulo_'. $n .'_' . $c . '" value="1"';
						$html	.= ( $v === 1 || $v == '1' ) ? ' checked' : '';
						$html	.= '><input type="hidden" name="mod_'. $n .'_' . $c . '" value="0"></td><td>' . $c . '</td>';
						$html	.= '</tr>';
					}
					$html .= '</table></div>';
			}
			$html	.= '</div>';
			return $html;
	}
	
	//** Listar zona horaria UTC */
	function utc( $usuario = NULL ){
		$utc		= _DIR_PAQUETE . YDS . '.ypanel' . YDS . 'utc.y';
		
		$json		= file_get_contents( $utc ); 
		$utc		= json_decode($json, true); 
		
		$utc_us		= yPanel::cuenta_usuario( 'utc_id', $usuario );
		$utc_list	= '';
		
		foreach( $utc as $k => $v ){
			$txt		= explode( '|', $v );
			$utc_list	.= '<option value="' . $k . '|' . $txt[1] . '"';
			if( $utc_us == $k )  $utc_list .= ' selected';
			$utc_list	.= '> ' . $txt[0] . '</option>';
		}
		
		return $utc_list;
	}
?>	
	
	<div class="m-t-30 m-b-20"><?php echo com_boton( 'nuevo', etiqueta( 'b_agregar_usuario', 'Agregar usuario' ) ); ?></div>
	<table class="table">
		<thead>
			<tr>
				<th>ID</th>
				<th><?php echo etiqueta( 'th_usuario', 'Usuario / Nivel' ) ?></th>
				<th><?php echo etiqueta( 'th_nombre', 'Nombre' ) ?></th>
				<th><?php echo etiqueta( 'th_habilitado', 'Habilitado' ) ?></th>
				<th>&nbsp;</th>
			</tr>
		</thead>
		<tbody>
			<?php
				$qis = _mysql_query( "SELECT * FROM " . MYSQL_PREFIJO_SISX . "usuarios ORDER BY nombre_usuario ASC " );
				while( $ris = _mysql_fetch_array( $qis ) ){
					
					$disable	= ( $ris['usuario'] == yPanel::usuario() ) ? true : false;
					$habilitado	= ( $ris['bloqueado'] == true ) ? 1 : 0;
					
					echo '<tr>
								<td>' . $ris['id'] . '</td>
								<td><i class="fa fa-user"></i> <strong>' . $ris['usuario'] . '</strong> (' . $ris['nivel'] . ')</td>
								<td>' . utf8_encode( $ris['nombre_usuario'] ) . '</td>
								<td>' . com_btnToggle( 'habilitado', $ris['id'], $habilitado, $disable ) . '</td>
								<td>
									<a href="' . post_link( 'usuarios', $ris['id'], 'acc=editar' ) . '" class="ico16" title="' . etiqueta( 'e_ver_usuario', 'Editar usuario' ) . '"><i class="fa fa-edit fs-18"></i></a>';
									
									if( $disable != true ){
										echo '<a href="javascript:;" onClick="usrCSess(\'' . $ris['id'] . '\')" class="ico16" title="' . etiqueta( 'e_cerrar_sesion', 'Cerrar Sesión' ) . '"><i class="fa fa-sign-out fs-18"></i></a>
									<a href="javascript:;" onClick="usrElim(\'' . $ris['id'] . '\');" class="ico16" title="' . etiqueta( 'e_eliminar_usr', 'Eliminar usuario' ) . '"><i class="fa fa-trash fs-18"></i></a>';
									}
								
					echo '		</td>
							</tr>';
				}
			?>
		</tbody>
	</table>
	
	<script>
			$_("#nuevo").onclick = function(){ location.href='<?php echo post_link( 'usuarios', NULL, "acc=agregar" ); ?>'; }
			
			$_("#habilitado").onclick = function(){ 
				$h = ( this.checked ) ? 1 : 0;
				MsjBox.mostrar('<?php echo etiqueta( 'msj_espere', 'espere...' ) ?>');
				$y.ajax({
						url: '<?php echo com_base() ?>prcss.php',
						metodo: 'POST',
						data: 'acc=usr-habilitar&post=' + this.value + '&h=' + $h,
						contenidoTipo: 'application/x-www-form-urlencoded',
						suceso: function(respuesta){ 
									if( respuesta == 1 ){
										 MsjBox.mostrar('<?php echo etiqueta( "msj_secambio_correctamente", 'Se cambió el estado correctamente' ) ?>');
									}
						}
				}); 
			}
			
			usrElim = function(id){
				MsjBox.mostrar('<?php echo etiqueta( 'msj_eliminando', 'Eliminando' ) ?>...');
				$y.ajax({
						url: '<?php echo com_base() ?>prcss.php',
						metodo: 'POST',
						data: 'acc=usr-eliminar&post=' + id,
						contenidoTipo: 'application/x-www-form-urlencoded',
						suceso: function(respuesta){ 
									if( respuesta == 1 ){
										 MsjBox.mostrar('El usuario se eliminó correctamente');
										 setTimeout("location.reload();",800);
									}
						}
				});
			}
			
			usrCSess = function(id){
				MsjBox.mostrar('<?php echo etiqueta( 'msj_espere', 'espere...' ) ?>...');
				$y.ajax({
						url: '<?php echo com_base() ?>prcss.php',
						metodo: 'POST',
						data: 'acc=usr-csess&post=' + id,
						contenidoTipo: 'application/x-www-form-urlencoded',
						suceso: function(respuesta){ 
									if( respuesta == 1 ){
										 MsjBox.mostrar('Se cerró la sesión correctamente');
										 setTimeout("location.reload();",800);
									}
						}
				});
			}
			
	</script>