<?php

	/* Cancelacion ScotiaBank PI3286939
	 *
	 * 2003 - 2023 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * @lib.yp_funciones
	 *
	 * Sesiones del sitio web Weby+
	 *
	 */
	 
	 /* Autorizo acceso */
		defined('YPANEL_INI') or die( 'No dispones de acceso' );
	
	/** REVISAR
	 * base_sitioWeby() : string
	 * Obtener la base del sitio Weby+
	 */
	function base_sitioWeby(){
			$base = rtrim(dirname(dirname($_SERVER['SCRIPT_NAME'])), '/\\');
			$base = $base . '/';
			return $base;
	}
	
	/**
	 * post_link - Obtiene la ventana del panel y la extension 
	 */
	function post_link( $seccPost = 'entradas', $idPost = 0, $qStr = NULL ){
		$extension	= '';
		$panel		= 'panel=';
		$panelext	= explode('|', $seccPost);
		// si recibo qstring lo cargo
		if ( !empty($qStr) ) $qStr = '&' . $qStr;
		// si recio post lo cargo
		$idPost		= ( $idPost > 0 ) ? '&post=' . $idPost: '';
		// si es extension compongo URL
		if( $panelext[0] == 'extension' ){ 
			$extStr		= (empty($panelext[1])) ? $_GET['extension'] : $panelext[1];
			$extension	= $extStr . $idPost . $qStr;
			$qryStr	= yPanel::link_ir_panel('extension', $extension);
		}else{
			$qryStr	= yPanel::link_ir_panel($seccPost . $idPost . $qStr);
		}
		return($qryStr);
		//$qryStr	= $_SERVER['PHP_SELF'] . '?panel=' . $panel . $extension;
	}
	
class yPanel{
		public $agregar_contenido		= array();
		public $agregar_contenido_num	= 0;
		
		public $titulo_barra_titulo		= 'Panel ';
		
		public static $idata_usr;
		public static $priv_uri;
		public static $password;
		public static $sisWebyPlus_uri;
		
		private static $captcha;
		private static $css_uri			= array();
		private static $js_uri			= array();
		private static $title;
		private static $token_sess;
		
		// REVISAR
		public function agregar_contenido( $seccion, $contenido ){
			if( !empty( $contenido ) ){
				return $this->agregar_contenido[$seccion][$this->agregar_contenido_num] = $contenido;
				$this->agregar_contenido_num++;
			}
			
			return false;
		}
		
		/* base_tpl - obtiene la ase html del sitio yPanel
		 * base_tpl() : string
		 */
		public static function base_tpl(){
			return self::dir_tema( true );
		}
		
		/**
		 * carga complementos propios de yPanel
		 */
		public static function cargar_modulo( $modulo = NULL ){
			//** verifico si el modulo existe
			if( !isset( self::paneles( $modulo )->nombre ) ) return '<h2>Acceso No Disponible.</h2><p>Error 404: El módulo solicitado, no se encontró.</p>';
			//** si el módulo existe cargo variables */
			$yhtml		= '';
			//** cargo nombre base de modulo
			$panel		= $modulo;
			//** cargo array de datos
			$modulo		= self::paneles( $modulo );
			//** obtengo nombre de modulo
			$nombre		= $modulo->nombre;
			//** obtengo descripcion de modulo
			$descrip	= $modulo->descripcion;
			//** obtengo ubicacion de directorio de modulo
			$mod_uri	= _DIR_PAQUETE . YDS . $modulo->dir;
			$mod_app	= $mod_uri . $panel . '.php';
			//** obtengo ubicacion de formulario
			$mod_frm	= $mod_uri . 'frm.php';
			//** obtengo valor get
			//$_getAcc	= ( isset( $_GET['acc'] ) ) ? $_GET['acc'] : false;
			//** coloco title de modulo en el head
			self::title_html( etiqueta( 'h_' . $panel, $nombre ) );
			
			//** Imprimimo HTML */
			//** si el usuario posee privilegios muestro contenido de modulo
			if( self::privilegio( $panel, $modulo->nivel ) )
			{
				//** creo el encabezado del modulo
				$yhtml	.= '<div class="row">
					<div class="col-lg-12">
						<div class="card">
							<div class="card-body">
									<h4 class="m-b-15">' . etiqueta( 'h_' . $panel, $nombre ) . '</h4>
									<p class="fs-small">' . etiqueta( 'p_' . $panel, $descrip ) . '</p>';
				$cModApp= '';
				$cModFrm= '';
				//** si php principal de modulo existe, lo cargo en variable
				if( file_exists( $mod_app ) ){
					ob_start(); # apertura de bufer
					include_once( $mod_app );
					$cModApp = ob_get_contents();
					ob_end_clean(); # cierre de bufer
					
					//** si existe acciones: $_getAcc del modulo cargo php 'frm' en variable
					if( file_exists( $mod_frm ) ){
						ob_start(); # apertura de bufer
						include_once( $mod_frm );
						$cModFrm = ob_get_contents();
						ob_end_clean(); # cierre de bufer
					}
					
					if( isset( $_GET['acc'] ) ){
						$yhtml .= (empty($cModFrm)) ? $cModApp:$cModFrm;
					}else{
						//muestro datos de pantalla de inicio
						if( com::obt_pantalla_inicio() !== false ){
							$yhtml .= com::obt_pantalla_inicio();	
						}else{
							$yhtml .= $cModApp;
						}
					}
				}
				
				
				$yhtml	.= '</div>
						</div>
					</div>
				</div>';
					
			}else{
				return '<h2>No dispones de privilegios para acceder.</h2><p>Ponte en contacto con tu administrador de servicio, para solicitar privilegios.</p>';
			}
			
			
			return $yhtml;
			
		}
		
		/**
		 * cargar_panel_principal() : string
		 */
		private static function cargar_panel_principal(){
			$html	= '';
					
			if( self::privilegio( 'actualizar', 'administrar' ) )
			{
				$html .= '<script> obt_CA() </script>';
				if( self::data('cron_buscar_actualizacion') == 1 ) $html .= '<div id="actualizaciones_disponibles"><script> ecajax(\'stSist\',\'#actualizaciones_disponibles\',\'a=buscar_actualizaciones\'); </script></div>';
			}
			
			if( self::privilegio( 'acceso_us', 'superadmin' ) )
			{
				$html	.= '<div class="row">
					<div class="col-lg-12">
						<div class="card">
							<div class="card-body">
								<h4 class="box-title"><i class="fa fa-history"></i> ' . etiqueta( 'h_histsess', 'Historial de Inicio de Sesiones' ) . '</h4>
							</div>
							<div class="card-body">
								<table class="table">
									<thead>
										<tr>
											<th class="">' . etiqueta( 'th_usrnivel', 'Usuarios / Nivel' ) . '</td>
											<th class="">' . etiqueta( 'th_iniciosesion', 'Inicio de sesión' ) . '</td>
											<th>&nbsp;</th>
										</tr>
									</thead>
									<tbody>';
				
				$hay_us = false;	
				$qis = _mysql_query( "SELECT * FROM " . MYSQL_PREFIJO_SISX . "usuarios ORDER BY ultimo_acceso DESC LIMIT 0,3" );
				while( $ris = _mysql_fetch_array( $qis ) ){
					$html	.= '	<tr>
										<td class="text-left"><i class="fa fa-user"></i> <strong>' . $ris['usuario'] . '</strong> (' . $ris['nivel'] . ')</td>
										<td class="">' . $ris['ultimo_acceso'] . '</td>
										<td>
											<a href="' . post_link( 'usuarios', $ris['id'], 'acc=editar' ) . '" class="ico16"><i class="fa fa-eye"></i></a>
										</td>
									</tr>';
					$hay_us = true;
				}
				
				$hay_us = ( $hay_us == true ) ? '<p align="right"><a href="' . post_link( 'histsess' ) . '"><i class="fa fa-long-arrow-right"></i>' . etiqueta( 'l_histsess', 'Ver todos los registros' ) . '</a></p>': NULL;
				
				$html	.= '</tbody></table>' . $hay_us . '
							</div>
						</div>
					</div>
				</div>';
			}
			
			//** Ultimo inicio de sesion
			$html	.= '<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-body">
							<table class="table">
									<tbody>
										<tr>
											<td class=""><strong>' . etiqueta( 'e_ultAccs', 'Mi último inicio de sesión' ) . '</strong></td>
											<td align="right"><i class="fa fa-calendar"></i> ' . fecha( _mysql_obtener_reg( MYSQL_PREFIJO_SISX . "usuarios", "id='" . self::id_usuario() . "'", "ultimo_acceso" ), 'D, j M \\d\e Y h:i a', 'es_ES', self::cuenta_usuario( 'utc' ) ) . '</td>
										</tr>
									</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>';
			//** Ultimas publicaciones
			$html	.= '<div class="row">
				<div class="col-lg-6">
					<div class="card">
						<div class="card-body">
							<h4 class="box-title"><i class="fa fa-pencil-square-o"></i> ' . etiqueta( 'h_ultpost', 'Últimas publicaciones' ) . '</h4>				
							<table class="table">
									<thead>
										<tr>
											<th class="text-left">' . etiqueta( 'th_entradas', 'Entradas' ) . '</td>
											<th class="">' . etiqueta( 'th_modificado', 'Modificado' ) . '</td>
										</tr>
									</thead>
									<tbody>';
				
				$qp = _mysql_query( "SELECT *, DATE_FORMAT(`modificado`,'%Y/%m/%d %H:%i:%s') AS m_fecha FROM " . MYSQL_PREFIJO_SISX . "contenido ORDER BY m_fecha DESC LIMIT 0,5" );
				while( $rp = _mysql_fetch_array( $qp ) ){
					$html	.= '	<tr>
										<td class=""><a href="' . post_link( 'entradas', $rp['id'], 'acc=editar' ) .'">' . resumirTexto( utf8_encode( $rp['titulo'] ), 40, true ) . '</a></td>
										<td>' . fecha( $rp['modificado'], 'D j M Y', 'es_ES', self::cuenta_usuario( 'utc' ) ) . '</td>
									</tr>';
				}
				
				$html	.= '</tbody></table></div>
					</div>
				</div>
				
				<div class="col-lg-6">
					<div class="card">
						<div class="card-body">
							<h4 class="box-title"><i class="fa fa-newspaper-o"></i> ' . etiqueta( 'h_ultnoticias', 'Últimas noticias' ) . '</h4>
						</div>
					</div>
				</div>
			</div>';
						
			//** Informacion del sistema
			$html	.= '<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-body">
							<h4 class="box-title"><i class="fa fa-info-circle"></i> ' . etiqueta( 'h_info_sistema', 'Información de Sistema' ) . '</h4>
						</div>
						
						<div class="row">
							<!-- Informacion de host -->
							<div class="col-sm-6">
								<div class="card-body">
									<h4 class="box-title"><i class="fa fa-server"></i> Host</h4>
									<table class="table">
										<tbody>
											<tr>
												<td class="">O.S.</td>
												<td class="">' . OS() . '</td>
											</tr>
											<tr>
												<td>Server Software</td>
												<td>' . $_SERVER['SERVER_SOFTWARE'] . '</td>
											</tr>
											<tr>
												<td>Version PHP</td>
												<td>' . phpversion() . '</td>
											</tr>
											<tr>
												<td>Version MySQL</td>
												<td>' . mysqli_get_client_version() . '</td>
											</tr>
										</tbody>
									</table>
								</div>
							</div>
							<!-- Informacion de WebyPlus -->
							<div class="col-sm-6">
								<div class="card-body">
									<h4 class="box-title"><i class="fa fa-soundcloud"></i> WebyPlus</h4>
									<table class="table">
										<tbody>
											<tr>
												<td class="">' . etiqueta( 'e_dirInst', 'Ruta de instalación' ) . '</td>
												<td class="">' . _DIR_PAQUETE_WEB . '</td>
											</tr>
											<tr>
												<td>' . etiqueta( 'e_espusado', 'Espacio usado' ) . '</td>
												<td><span id="tamDir">Obteniendo medida...<script> ecajax(\'stSist\',\'#tamDir\',\'a=tamanoDir\'); </script></span></td>
											</tr>
										</tbody>
									</table>
								</div>
							</div>
						</div>
						
					</div>
				</div>
			</div>';
						
			return $html;
		}
		
		/**
		 * crear_sesion - Crea session de yPanel
		 * @param string    $usuario
		 */
		private static function crear_sesion( $usuario = NULL, $id = 0 ){
			if( !empty($usuario) ){
				
				$ipUs	= $_SERVER['REMOTE_ADDR'];
				$id		= $_SESSION['yps_us_id']	= $id;
				$usuario= $_SESSION['yps_us']		= $usuario;
				
				$token	= encriptar($usuario, $ipUs);
				$nom_sess	= md5(  encriptar($usuario, $id) );
				$_SESSION['ypssessUs'.$nom_sess] = $token;
				// -- * Guardo el key
				return _mysql_query("UPDATE " . MYSQL_PREFIJO_SISX . "usuarios SET tokens='" . $token . "', ultimo_acceso='" . date( 'Y-m-d H:i:s' ) . "', ipusr='$ipUs' WHERE usuario='$usuario'");
			}
			return false;
		}
		
		/**
		 * contenido - Obtiene array de los datos de cuenta
		 * @param string    $usuarios
		 */
		public static function contenido( $tipo = 'link', $item = NULL, $texto = NULL, $m = 0 ){
			
			$ic		= array( "ayuda"=>"fa fa-support", "backup"=>"fa fa-download", "alertas"=>"fa fa-bell", "cerrar_sesion"=>"fa fa-power-off", "configuracion"=>"fa fa-cogs", "idioma"=>"fa fa-language", "usuarios"=>"fa fa-users" );
			$ic		= ( isset( $ic[$item] ) ) ? $ic[$item] : '';
			$n		= array( "alertas"=>"administrar", "backup"=>"administrar", "idioma"=>"ver", "usuarios"=>"administrar" );
			$n		= ( isset( $n[$item] ) ) ? $n[$item] : 'superadmin';
			$link	= '';
			switch( $tipo ){
				case 'boton_cerrar_sesion':
						return '<a href="paneles/login/login.php?sess=logout" title="' . etiqueta( 'l_cerrar_sesion', 'Cerrar Sesión' ) . '"><i class="fa fa-power-off"></i></a>';
					break;
				case 'boton_ver_alertas':
						if( self::privilegio( 'alertas', 'administrar' ) )
						{	
							return '<a href="' . post_link( 'alertas' ) . '"><i class="fa fa-bell"></i>0</a>';
						}
					break;
				case 'boton_ver_sitio':
						return '<a href="' . base_sitioWeby() . '" target="_blank">
									<i class="fa fa-globe"></i> 
									<span class="dis-movil-none">' . etiqueta( 'l_ver_sitio', 'Ver Sitio' ) . '</span>
								</a>';
					break;
				case 'link_ayuda':
						return '//www.webyplus.com/documentacion';
					break;
				case 'logo':
						return 'images/logo-yPanel.png';
					break;
				case 'link':
					if( self::privilegio( $item, $n ) )
					{
						
						$icono	= '<i class="' . $ic . '"></i> ';
						$texto	= '<span>' . etiqueta( 'l_' . $item, $texto ) . '</span>';
						$t		= $icono . $texto;
						$link	= '<a href="' . post_link( $item ) . '">';
						if( $m == 1 ) $t = $icono;
						if( $m == 2 ) $t = $texto;
						$link	.= $t . '</a>';
						//$cnt['header']['link']['backup']			= '<a href="' . post_link( 'backup' ) . '"><i class="fa fa-download"></i> <span>' . etiqueta( 'l_backup', 'Backup' ) . '</span></a>';
					}
					return $link;
					break;
				case 'panel_nav_estructura':
					$panel_nav_estructura	='<ul>
						<li class="menu-title">' . etiqueta( 'e_paneles', 'Estructura Sitio Weby+' ) . '</li>
						<li class="menu-item">' . self::mnuNav( 'entradas' ) . '</li>
						<li class="menu-item">' . self::mnuNav( 'secciones' ) . '</li>
						<li class="menu-item">' . self::mnuNav( 'categorias' ) . '</li>
						<li class="menu-item">' . self::mnuNav( 'menu' ) . '</li>
						<li class="menu-item">' . self::mnuNav( 'linksociales' ) . '</li>
						<li class="menu-item">' . self::mnuNav( 'multimedia' ) . '</li>
					</ul>';
					
					return $panel_nav_estructura;
					
					break;
					
				case 'panel_nav_apariencia':
					$panel_nav_apariencia	='<ul>
						<li class="menu-title">' . etiqueta( 'e_temas_webymas', 'Apariencia Sitio Weby+' ) . '</li>
						<li class="menu-item">' . self::mnuNav( 'mistemas' ) . '</li>
						<li class="menu-item">' . self::mnuNav( 'tienda' ) . '</li>
					</ul>';
					
					return $panel_nav_apariencia;
					
					break;
					
				case 'panel_nav_extension':
					$panel_nav_apariencia	='<ul>
						<li class="menu-title">' . etiqueta( 'e_plugin', 'Extensiones' ) . '</li>
						<li class="menu-item">' . self::mnuNav( 'extensiones' ) . '</li>
						<li class="menu-item menu-item-title">Instaladas</li>' . 
						self::extensiones() . 
						self::extensiones_obsoletas();
					
					$panel_nav_apariencia	.= '</ul>';
					
					return $panel_nav_apariencia;
					
					break;
					
				case 'panel_nav_ajustes':
					$panel_nav_ajustes	='<ul>
						<li class="menu-title">' . etiqueta( 'e_ajustes', 'Ajustes' ) . '</li>
						<li class="menu-item">' . self::mnuNav( 'ajustes' ) . '</li>
						<li class="menu-item">' . self::mnuNav( 'actualizar_sistema' ) . '</li>
					</ul>';
					
					return $panel_nav_ajustes;
					
					break;
					
				case 'panel_principal':
					$panel_principal	= '<div id="consola_msj"></div>';
					
					//** cargo panel principal del sistema
					if( isset( $_GET['panel'] ) ){
						$panel_principal .= self::cargar_modulo( $_GET['panel'] );
					}else{
						$panel_principal .= self::cargar_panel_principal();
					}
						
						return $panel_principal;
					break;
			}
		}
		
		/**
		 * cuenta_usuario - Devuelve preferencias de usuario
		 * @param string    $valor
		 */
		public static function cuenta_usuario( $valor = NULL, $usuario = NULL ){
			$cuentas_usuarios	= _DIR_PAQUETE . YDS . '.ypanel/datos/cuentas_usuarios';
			$usuario			= ( $usuario !== NULL ) ? $usuario : self::usuario();
			if( file_exists( $cuentas_usuarios ) ) {
				$data	= file_get_contents( $cuentas_usuarios );
				$data	= json_decode( $data );
				return ( isset( $data->$usuario->$valor ) ) ? $data->$usuario->$valor : NULL;
			}
			
			return NULL;
		}
		
		
		/**
		 * data - Obtiene datos de configuración de yPanel
		 * @param string    $valor
		 * @param bool      $assoc
		 */
		public static function data( $valor, $assoc = false ){
			$data_uri	= _DIR_PAQUETE . YDS . '.ypanel' . YDS . 'Data.y';
			if( file_exists( $data_uri ) ){
				$json	= file_get_contents( $data_uri );
				$json	= json_decode( $json, $assoc );
				
				if( $assoc ){
					return ( isset( $json[$valor] ) ) ? $json[$valor] : false;
				}else{
					return ( isset( $json->$valor ) ) ? $json->$valor : false;
				}
			}
			
			return false;
		}
		
		/**
		 * eliminar_sesion() : bool
		 * Elimina sesión de usuario
		 */
		public static function eliminar_sesion(){
			session_destroy();
			setcookie('wyp_us', '', time() - 1000);
			return y_sesion_destruir();
		}
		
		/** 
		 * en_sesion() : bool
		 * funcion para verificar inicio de sesion 
		 */
		public static function en_sesion(){
			if( !isset( $_SESSION ) ) session_start();
			
			$usuario= $_SESSION['yps_us'];
			$id		= $_SESSION['yps_us_id'];
			$token	= _mysql_obtener_reg( MYSQL_PREFIJO_SISX . "usuarios", "usuario='$usuario'", "tokens" );
			//** registro sesion */
			$nom_sess	= md5( encriptar( $usuario, $id ) );
			$sess		= $_SESSION['ypssessUs'.$nom_sess]; //y_sesion( $nom_sess );
			return ( $token === $sess ) ? true : false;
		}
		
		/*
		 * funcion para enviar reportes de errores de yPanel al servidor
		 */
		public static function envErrServer( $url = NULL ){
			if( $url != NULL && self::data('cron_enviar_error') == 1 ){
				//Ruta lote de errores
				$pathData_y	= '.ypanel/DataLogErr.y';
				if( file_exists( $pathData_y ) ){
					$dat	= file_get_contents( $pathData_y ); 
					//$data	= json_decode( $dat, true );
					//envio registro de errores
					$os			= OS() . '-' . $_SERVER['HTTP_USER_AGENT'] . '-' . $_SERVER['REMOTE_ADDR'];
					$urlData_y	= $url . '?os=' . base64_encode($os) . '&err=' . base64_encode($dat);
					$eErr		= file_get_contents( $urlData_y );
					sleep(3);
					unlink($pathData_y);
				}
			}
		}
		
		
		/*
		 * Conecto todas las extensiones registradas
		 */
		public static function extensiones(){
			$ext	= '';
			$tabla	= MYSQL_PREFIJO_SISX . 'extensiones';
			$q = _mysql_query( "SELECT * FROM "  . $tabla . " WHERE miapp!='' AND publicado = '1' ORDER BY nombre ASC" );
			while( $r = _mysql_fetch_array( $q ) ){
				$ext .= '<li class="menu-item"><a class="aplug" href="' . self::link_ir_panel( 'extension', $r['miapp'] ) . '"><i class="fa fa-hard-of-hearing"></i> ' . utf8_encode($r['mnu_texto']) . '</a></li>';
			}
			
			return ( empty( $ext ) ) ? '<li class="menu-item fs-12">No tienes extensiones instaladas</li>' : $ext;
		}
		
		/*
		 * Conecto todas las extensiones OBSOLETAS registradas
		 */
		public static function extensiones_obsoletas(){
			$q = _mysql_query( "SELECT * FROM " . MYSQL_PREFIJO_SISX . "extensiones WHERE  miapp='' AND publicado = '1' ORDER BY extension ASC" );
			$ext = '';
			while( $r = _mysql_fetch_array( $q ) ){
				$ext .= '<li class="menu-item"><a class="aplug-o" href="' . self::link_ir_panel( 'plugin_extension', $r['extension'] ) . '"><i class="fa fa-plug"></i> ' . utf8_encode($r['extension']) . '</a></li>';
			}
			return ( empty( $ext ) ) ? '<li class="menu-item fs-12">No tienes extensiones obsoletas instaladas</li>' : $ext;
		}
		
		/* head_html - crea head html del sitio yPanel
		 * head_html() : string 
		 */
		public static function head_html(){
			
			//* creo metas			
			html_meta( 'name="author" content="' . idata('nombre_original') . '"' );
			
			$charset= ( idata('charset') != NULL ) ? idata('charset') : 'utf-8';
			$head	= html_charset( $charset );
			$head	.= "\t" . '<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" />' . "\n";
			$head	.= "\t" . '<base href="' . html_base() .'">' . "\n";
			$title	= ( !empty( self::$title ) ) ? trim( strip_tags( self::$title ) ) : idata('nombre_original');
			$head	.= "\t" . '<title>' . $title . ' - yPanel</title>' . "\n";
			$head	.= html_obtMeta();

			$head .= "\n\t" . '<link rel="stylesheet" href="css/bootstrap.min.css">' . "\n" .
					 "\t" . '<link rel="stylesheet" href="css/toggle-button.css">' . "\n" .
					 "\t" . '<link rel="stylesheet" href="css/styles.css">' . "\n" .
					 "\t" . '<link rel="stylesheet" href="fonts/font-awesome-4.7.0/css/font-awesome.min.css">' . "\n" .
					 "\t" . '<link rel="stylesheet" href="css/fontawesome-all.min.css" type="text/css" />' .
					 "\t" . '<script type="text/javascript" src="js/jsy-scriptv2.js"></script>' . "\n" .
					 "\t" . '<meta name="generator" content="yPanel - Yal Publicidad" />' . "\n" .
					 "\t" . '<link rel="icon" href="images/favicons/favicon.png" type="image/x-icon">' . "\n" .
					 "\t" . '<link rel="shortcut icon" href="images/favicons/favicon.png" type="image/x-icon"/>' . "\n";
			
			$head .= self::obt_css();
			$head .= self::obt_js();
			
			$head	.= "\n\t" . '<script type=\'text/javascript\'>
		eform = function(e){
			$_(\'#consola_msj\').innerHTML = \'\';
			$y.ajax({
						url: e.action,
						metodo: e.method,
						data: $y.serialize(e),
						contenidoTipo: \'application/x-www-form-urlencoded\',
						suceso: function(respuesta){ $_(\'#consola_msj\').innerHTML = respuesta; window.scrollTo( 0, 0 ); }
			});			
			//return false;
		}
		
		eformData = function(e){
			$_(\'#consola_msj\').innerHTML = \'\';
			var Data = new FormData(e);
			$y.formData({
						url: e.action,
						data: Data,
						suceso: function(respuesta){ $_(\'#consola_msj\').innerHTML = respuesta; window.scrollTo( 0, 0 ); }
			});			
			return false;
		}
		
		eformDat2 = function(e,func){
			$_(\'#consola_msj\').innerHTML = \'\';
			var Data = new FormData(e);
			$y.formData({
						url: e.action,
						data: Data,
						suceso: function(respuesta){ func(respuesta); }
			});			
			return false;
		}
		
		mConsola = function(m){
			//$_(\'#consola_msj\').innerHTML = \'\';
			$_(\'#consola_msj\').innerHTML = \'<div class="alert alert-\' + m.alerta + \'">\' + m.texto + \'</div>\'; window.scrollTo( 0, 0 );
			
		}
		
		efacc = function(acc){
			uri = \'' . self::obtUriQuery('acc=') . '\' + acc;
			if(acc==\'cerrar\'){
				history.go(-1);
			}else if(acc==\'salir\'){
				location.href = \'?miypanel\';
			}else{
				location.href = uri;
			}
		}
		
		ecajax = function(u,s,q){
			$y.ajax({
						url: u + \'.php\',
						metodo: \'POST\',
						data: q,
						contenidoTipo: \'application/x-www-form-urlencoded\',
						suceso: function(respuesta){ $_(s).innerHTML = respuesta; }
			});			
			return false;
		}
		
		function obt_CA(){
				var CA = $_(\'#consola_msj\'); CA.innerHTML=\'Verificando activación...\';
				$y.ajax({
					url: \'stSist.php\',
					metodo: \'POST\',
					data: \'a=CA\',
					contenidoTipo: \'application/x-www-form-urlencoded\',
					suceso: function(respuesta){
									if( respuesta == 403 || respuesta == 404 ){
											alert( respuesta );
									} if( respuesta == 0){
											CA.innerHTML=\'' . msg_error( etiqueta( 'licencia_no', 'Tu Id de licencia Webyplus es incorrecto, para reestablecer el acceso a tu sitio web ' ) . '<a href="' . IdWebyPlusRecuperar() . '" target="_blank">pulsa aquí</a>.', NULL, 'alert-danger' ) . '\';
									} if( respuesta == 1){
											CA.innerHTML=\'' . msg_error( etiqueta( 'licencia_ok', 'Tu Id de licencia Webyplus está validado.' ), 'fa-check-circle', 'alert-success' ) . '\';
									}
							}
				});
			}
	</script>';
			
			return $head;
		}
		
		/**
		 * id_usuario() : int
		 * Retorna el id de usuario
		 */
		public static function id_usuario(){
			return ( isset( $_SESSION['yps_us_id'] ) ) ? $_SESSION['yps_us_id'] : 0;
		}
		
		/* index - retorna el html completo del panel principal yPanel
		 * index() : string
		 * Obtener pagina de inicio del tema yPanel
		 */
		public static function index()
		{
			// Header charset=UTF-8
				header('Content-Type: text/html; charset=UTF-8');
			//obtengo contenido HTML de tema yPanel
				$tmpIndex	= self::dir_tema() . YDS . 'index.php';
			//** Si la plantilla existe la muestro
				if( file_exists( $tmpIndex ) ){
					//** Almaceno plantilla en variable
					ob_start(); # apertura de bufer
					include_once( $tmpIndex );
					$tmpIndex = ob_get_contents();
					ob_end_clean(); # cierre de bufer
					
					//** creo contenido HTML de plantilla
					$html		= "<!DOCTYPE HTML>\n<html>\n<head>\n\t";
					$html		.= yPanel::head_html();
					$html		.= "\n</head>\n<body>" . $tmpIndex;
					$html		.= "\n</body>\n</html>";
					print $html;
				}else{ 
					header("HTTP/1.0 404 Not Found"); return false; //header('HTTP/1.0 500 Internal Server Error'); 
				}
				//return $tmpIndex;
		}
		
		/**
		 * incluir_css - Almacena ficheros CSS que se incluiran en el archivo HTML
		 */
		public static function incluir_css( $camino_css = NULL ){
			self::$css_uri[] = $camino_css;
		}
		
		/**
		 * incluir_css - Almacena ficheros CSS que se incluiran en el archivo HTML
		 */
		public static function incluir_js( $camino_js = NULL ){
			self::$js_uri[] = $camino_js;
		}
		
		/**
		 * yp_sess - iniciar sesion en yPanel
		 * @param string    $user    Usuario
		 * @param string    $pass    Password
		 */
		public static function isess( $user, $pass, $recordarme = false ){
			
			$user = ( $user != NULL ) ? trim( strtolower( $user ) ) : 'root';
			$pass = ( $pass != NULL ) ? $pass : '/==';
			
			if( self::data( 'version_demo' ) == 1 ){
				if( $user == self::data( 'user_demo' ) ){
					if( self::data( 'user_demo' ) == $pass ){
						$ksess= 'YP' . date('YmdHis') . 'K';
						$pass = encriptar( 'admin1234', $ksess );
						$cnt_json = '{"nombre_cuenta":"' . $_SERVER['SERVER_NAME'] . '","pass":"' . $pass . '","ksess":"' . $ksess . '","privilegios":"root","tema":"ypclasico","ypanel":1,"ywha":1}';
						guardar_json( YPATHROOT . YDS . 'local/ypanel/usr/.root', $cnt_json );
					}
					return false;
				}
				return false;
			}
			
			$pass	= md5( encriptar( $pass, $user ) );
			$q = _mysql_query( "SELECT id,usuario,password FROM " . MYSQL_PREFIJO_SISX . "usuarios WHERE usuario='$user'" );
			$r = _mysql_fetch_array( $q );
			
			if( $r['usuario'] != $user ){
				return 'u_invalido';
			}elseif( $r['password'] != $pass ) {
				return 'p_invalido';
			}else{
				// -- Evaluo si creo cookies
				if( $recordarme ) {
						setcookie('yp_us', $user, time() + 60 * 60 * 24 * 30);
						setcookie('yp_ps', $pass, time() + 60 * 60 * 24 * 30);
				}
				self::crear_sesion( $user, $r['id'] );
							
				return true;
			}
			return false;
		}
		
		/**
		 * 
		 */
		public static function mnuNav( $modulo = NULL, $texto_opcional = NULL, $get = '' ){
			$html		= '';
			$paneles	= _DIR_PAQUETE . YDS . '.ypanel' . YDS . 'paneles.y';
			if( file_exists( $paneles ) ) { 
				$dat	= file_get_contents( $paneles ); 
				$data	= json_decode( $dat );
				// si el modulo es diferente a nulo y existe, muestro enlace
				if( $modulo != NULL && isset( $data->modulos->$modulo ) ){
					$texto	= ( $texto_opcional != NULL ) ? $texto_opcional : etiqueta( $data->modulos->$modulo->menu_txt_lng, $data->modulos->$modulo->menu_txt );
					$texto	= ( $texto_opcional == 'no' ) ? '' : $texto;
					$get	= ( !empty( $get ) ) ? '&' . $get : '';
					
					if( self::privilegio( $modulo, $data->modulos->$modulo->nivel ) )
					{
						$html	= '<a href="index.php?panel=' . $modulo . $get . '"><i class="' . $data->modulos->$modulo->mnu_ic_html . '"></i> <span>' . $texto . '</span></a>';
					}
					
					return $html;
				}
				// si no existe el modulo, cago todo el array como guía del programador
				return $dat;
			}
			return false;
		}
		
		/**
		 * niveles() : String
		 */
		public static function niveles( $asociativo = false ){
			$niveles	= _DIR_PAQUETE . YDS . '.ypanel/niveles';
			if( file_exists( $niveles ) ) {
				$data	= file_get_contents( $niveles );
				$data	= json_decode( $data, $asociativo );
				return $data;
			}
			return false;
		}
		
		/**
		 * no_cache() : void
		 */
		public static function no_cache(){
			// max-age=0 : max-age=10800, pre-check=10800 => 180 minutos es el valor predeterminado de session.cache_expire
			//header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
			header("Cache-Control: no-store, no-cache, must-revalidate, max-age=10800");
			header("Cache-Control: post-check=0, pre-check=10800", false);
			header("Pragma: no-cache");
		}
		
		/**
		 * leerSisWebyPlus - Carga y almacena ruta de sistema WebyPlus
		 * @param string    $camino_sis_wy
		 */
		public static function leerSisWebyPlus( $camino_sis_wy = NULL ){
			if( file_exists( $camino_sis_wy ) ){
				self::$sisWebyPlus_uri = $camino_sis_wy;
				require_once( self::$sisWebyPlus_uri );	
				return;
			}
			return false;
		}
	
		/* link_ir_panel() : link para ir a un post
		 * @param  int       $idPost    Id del post que se quiere ir
		 * @param  string    $qStr      Query get que se pasará por el link post
		 */
		public static function link_ir_panel($panel = NULL, $extension = NULL){
			if( $extension != NULL ) $extension = '&extension=' . $extension;

			$qryStr	= 'index.php?panel=' . $panel . $extension;
			return($qryStr);
		}
	
		/* link_ir_post() : link para ir a un post
		 * @param  int       $idPost    Id del post que se quiere ir
		 * @param  string    $qStr      Query get que se pasará por el link post
		 */
		public static function link_ir_post($idPost = 0, $qStr = NULL){
			if( $qStr != NULL ) $qStr = '&' . $qStr;
			if( $idPost != NULL ) $idPost = 'post=' . $idPost;

			$qryStr	= self::obtUriQuery($idPost.$qStr);
			return($qryStr);
		}
		
		/**
		 * login() : string
		 */
		public static function login(){
			$login	= _DIR_PAQUETE . YDS . 'paneles' . YDS . 'login' . YDS . 'tpl_login.php';
			if( file_exists( $login ) ){
				include_once( $login );
				return;
			}
			header('HTTP/1.0 500 Internal Server Error');
			return false;
		}
		
		/**
		 * obt_css : string
		 */
		private static function obt_css(){
			$css	= self::$css_uri;
			$css_a	= '';
			for( $i = 0; $i < count( $css ); $i++ ){
				$css_a .= "\n\t" . '<link rel="stylesheet" href="' . $css[$i] . '" />';
			}
			
			return $css_a;
		}
		
		/**
		 * 
		 */
		private static function obt_js(){
			$js	= self::$js_uri;
			$js_a	= '';
			for( $i = 0; $i < count( $js ); $i++ ){
				$js_a .= "\n\t" . '<script type="text/javascript" src="' . $js[$i] . '"></script>';
			}
			
			return $js_a;
		}
	
		/**
		 * obtUriQuery() : string
		 * Retorna el query_string de URL
		 */
		public static function obtUriQuery($qs = NULL){
			// index.php?panel=extension&extension=yseCarreras&post=1&acc=editar
			$uri			= $_SERVER['QUERY_STRING'];
			$uri			= explode("&",$uri);
			$uri_dat2		= array();
			for($i=0; $i<(count($uri)); $i++){
				$q = explode("=",$uri[$i]);
				$uri_dat2[$q[0]] = $q[1];
			}
			
			// elimino duplicados
			$uri_qs			= explode("&",$qs);
			for($j=0; $j<(count($uri_qs)); $j++){
				$q1 = explode("=",$uri_qs[$j]);
				if(isset($uri_dat2[$q1[0]])) unset($uri_dat2[$q1[0]]);
			}
			
			$uri_a			= array_unique($uri_dat2); //$uri_dat2;
			$uri_a['panel']	= (isset($uri_a['panel'])) ? $_GET['panel'] : NULL;
			$uri_a['extension']= (isset($uri_a['extension'])) ? $_GET['extension'] : NULL;
			$uri_a['post']	= (isset($uri_a['post'])) ? $_GET['post'] : NULL;
			$uri_a['acc']	= (isset($uri_a['acc'])) ? $_GET['acc'] : NULL;
			$qryStr			= $_SERVER['PHP_SELF'] . '?';
			foreach($uri_a as $k => $v){
				$qryStr .= (!empty($v)) ? $k . '=' . $v . '&' : NULL;
			}
			return (empty($qs)) ? trim($qryStr,'&') : $qryStr . $qs;
		}
		
		/**
		 * 
		 */
		public static function paneles( $modulo = NULL ){
			$paneles	= _DIR_PAQUETE . YDS . '.ypanel' . YDS . 'paneles.y';
			if( file_exists( $paneles ) ) { 
				$data	= file_get_contents( $paneles ); 
				$data	= json_decode( $data );
				return ( isset( $data->modulos->$modulo ) ) ? $data->modulos->$modulo : false;
			}
			return false;
		}
		
		/**
		 * privilegios - Obtener acceso de privilegio de usuario
		 * @param string    $panel
		 * @param string    $item
		 */
		public static function privilegio( $panel = NULL, $item = NULL ){
			//** obtengo nivel de usuario
			$nivel_usuario	= strtolower( self::cuenta_usuario( 'nivel' ) );
			//** obtengo array de acceso por niveles
			$niveles		= self::niveles(); 
			//** obtengo privilegios globales de usuarios
			$niveles		= $niveles->$nivel_usuario->privilegios;
			//** obtengo nivel de privilegio que posee el usuario
			$permiso		= ( isset( $niveles->$item ) ) ? $niveles->$item : false;
			//** obtengo ruta de acceso a privilegios personalizado de usuario
			$priv_usuario	= _DIR_PAQUETE . YDS . '.ypanel' . YDS . 'datos' . YDS . 'priv' . YDS . self::usuario();
			//** obtengo privilegio personalizado de usuario
			if( file_exists( $priv_usuario ) ) {
				$data	= file_get_contents( $priv_usuario );
				$data	= json_decode( $data);
				return ( isset( $data->$panel->$item ) ) ? $data->$panel->$item : $permiso;
			}
			return $permiso;
		}
		
		/**
		 * privilegio_usuario - obtiene privilegios de usuario
		 * @param string    $usuario
		 * @param string    $nivel_u
		 */
		public static function privilegio_usuario( $usuario = NULL, $nivel_u = NULL ){
			$html	= '';
			$modulos= array();
			//** obtengo nivel de usuario
			$nivel_usuario		= strtolower( $nivel_u );
			//** obtengo array de acceso por niveles
			$privilegios_base	= self::niveles()->$nivel_usuario->privilegios;
			//** obtengo todos los paneles activos 
			//** junto al nivel de privelegios que le corresponde
			$paneles_uri		= _DIR_PAQUETE . YDS . '.ypanel/paneles.y';
			$paneles			= json_decode( file_get_contents( $paneles_uri ) );
			foreach( $paneles->modulos as $n => $r ){
				$modulos[$n]=$privilegios_base;
			}
			//** obtengo todas las extensiones activas 
			//** junto al nivel de privelegios que le corresponde
			$extensiones_uri	= _DIR_PAQUETE . YDS . '.ypanel/extensiones.y';
			$extensiones		= json_decode( file_get_contents( $extensiones_uri ) );
			foreach( $extensiones as $n1 => $r1 ){
				$modulos[$n1]=$privilegios_base;
			}
			//** creo JSON de paneles con sus respectivos privilegios
			$paneles	= json_encode( $modulos );
			//** convierto nuevamente a array()
			$modulos	= json_decode( $paneles, true );
			//** obtengo acceso a privilegios personalizado de usuario
			$priv_usuario	= _DIR_PAQUETE . YDS . '.ypanel/datos/priv/' . $usuario;
			//** obtengo privilegio personalizado de usuario
			if( file_exists( $priv_usuario ) ) {
				$data	= file_get_contents( $priv_usuario );
				$data	= json_decode( $data, true );
				foreach( $data as $m => $p ){
					$modulos[$m] = $p;
				}
			}			
			//** creo JSON de paneles con sus respectivos privilegios
			$paneles = json_encode( $modulos );
			$html				.= $paneles;
			
			return $html;
		}
		
		/* temaPath - muestra la ruta del tema que utilizará yPanel
		 * temaPath( ?bol $base = false ) : string 
		 * Parametros
		 * $base	- Cuando es true devolverá la ruta base del paquete para web, 
		 * cuando es false devolverá la ruta real completa donde está alojado el tema.
		 */
		public static function dir_tema( $base = false ){
			$tema		= self::data( 'tema' );
			$tmpPath	= ( $base ) ? 'tpl/' . $tema : _DIR_PAQUETE . YDS . 'tpl' . YDS . $tema;
				
			return $tmpPath;
		}
		
		/**
		 * title - almacena titulo que se mostrará en sitio WebyPlus
		 * @param string    $title
		 */
		public static function title_html( $title = NULL )
		{	
			// title personalizado
			if( !empty( $title ) ){
				self::$title = $title;
				return;
			}
			return NULL; 
		}
		
		/**
		 * usuario() : string
		 * Retorna usuario
		 */
		public static function usuario(){
			if( ! isset( $_SESSION ) ) session_start();
			return ( isset( $_SESSION['yps_us'] ) ) ? $_SESSION['yps_us'] : NULL;
		}
		
		/**
		 * usuario() : string
		 * Retorna usuario
		 */
		public static function usuario_id(){
			//session_start();
			return ( isset( $_SESSION['yps_us_id'] ) ) ? $_SESSION['yps_us_id'] : NULL;
		}
		
		
		
		
		
		
		
		
		
		/*public function obtener_contenido( $seccion ){
			if( !empty( $seccion ) ){
				$items = '';
				if( count( $this->agregar_contenido[$seccion] ) > 0 ){
					for( $i = 0; $i <= count( $this->agregar_contenido[$seccion] ); $i++ ){
						$items .= $this->agregar_contenido[$seccion][$i];
					}
				}
				return $items;
			}
			
			return false;
		}
		
		public function obtener_titulo(){
			return $this->titulo_barra_titulo;
		}*/
}
	
	
?>