<?php
	
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - YMS::intalacion
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 */
	 
	  /* Autorizo acceso */
		defined( 'MSai' ) or die( '<h2>No dispones de acceso<h2>' );
	
	define("YPATH",dirname(dirname(dirname(__FILE__))));
	define("YDS",DIRECTORY_SEPARATOR);
	
	/* ----------------------------------- *\
			Variables Globales YGE
	\* ----------------------------------- */
		$YGE_msg_error		= NULL;
		$YGE_version		= '2.1';
		$YGE_titulo_h1		= 'Macrodígital Software - Asistente de Instalación';
		$YGE_lnk_btn_1		= NULL;
		$YGE_lnk_btn_2		= NULL;
		$YGE_onclick_1		= NULL;
		$YGE_onclick_2		= NULL;
		$YGE_html			= '<!doctype html><html>';
		$YGE_btn_1			= NULL;
		$YGE_btn_2			= NULL;
		$YGE['msg_error']	= '';
		$YGE['warning_handler']	= '';
		
		$es_paso			= ( isset( $_GET['paso'] ) ) ? true : false;
	
		//* Variables de version */
			//define( 'YGE_VERSION', '1.3.0' );
			//define( 'PHP_VERSION', phpversion() );
			//define( 'PHP_VERSION_MIN', '5.6.0' );
			//define( 'MySQL_VERSION_MIN', '50000' );
		
		$PHP_VERSION	= true;
		$MySQL_VERSION	= true;
		$SOPORTE_CURL	= true;
		$SOPORTE_FGC	= true;
	
	/* ----------------------------------- *\
			Clase idioma
	\* ----------------------------------- */
	class LNG {
		
		public static $idioma;
		
		/*
		 * Funcion para cargar idioma
		 */
		public static function etiqueta( $lbl ){
			if( file_exists( '.as/lng/' . self::$idioma . '.lng' ) ){
				$datos_idioma	= file_get_contents( '.as/lng/' . self::$idioma . '.lng' );
				$idioma = json_decode( $datos_idioma );
				return ( isset( $idioma->$lbl ) ) ? $idioma->$lbl : '{' . $lbl . '}';
			}else{
				die( 'No hay modulo de idioma disponible' );
			}
		}
		
		/*
		 * Funcion para cargar idioma
		 */
		public static function guardar( $lng ){
			//self::$idioma = $lng;
				$l	= file_get_contents( '../iData.y' );
				$l = json_decode( $l );
				$l->idioma = $lng;
				$fh = fopen('../iData.y', 'w') or die("<b>Alerta!</b> MsiData archivo de sistema, no existe.");
				fwrite( $fh, json_encode( $l ) );
				fclose( $fh );
		}
	}
	
		/* Establecer idioma */
			$lng = ( MSiData::obtener('idioma') != NULL ) ? MSiData::obtener('idioma') : 'es';
			$lng = LNG::$idioma = ( isset( $_GET['lng'] ) ) ? $_GET['lng'] : $lng;
			if( isset( $_GET['lng'] ) ) LNG::guardar( $lng );
	
	/* ----------------------------------- *\
			Clase iData
	\* ----------------------------------- */
	class MSiData {
		
		public $terminos = '';
		/*
		 * Funcion para cargar idioma
		 * {"version_nucleo":"1.9.15","version_php":"5.6.0","version_mysql":"50000","app_nombre":"WebyPlus","idioma":"en"}
		 */
		public static function obtener( $dato ){
			if( file_exists( '../iData.y' ) ){
				$iData	= file_get_contents( '../iData.y' );
				$iData = json_decode( $iData );
				return isset( $iData->$dato ) ? $iData->$dato : false;
			}else{
				die( '<b>Alerta!</b> MsiData archivo de sistema, no existe.' );
			}
		}
		
		public static function tyc(){
			if( file_exists( '.as/tyc/tyc.' . LNG::$idioma ) ){
				$iData	= file_get_contents( '.as/tyc/tyc.' . LNG::$idioma );
				return ( strlen( $iData ) > 55 ) ? $iData : false;
			}else{
				die( '<b>Alerta!</b> MsiData archivo de sistema, no existe.' );
			}
		}
	}
	
	
	/* ----------------------------------- *\
			Clase Actualizar
	\* ----------------------------------- */
	class ms_actualizar{
		
		//public static $servidor_uri;
		//public static $version_actual;
		
		//private static $version_nueva;
		
		
		//** funcion para descargar App */
		public static function descargarApp()
		{
			$appXML = obtener_contenido_remoto( YPATH . YDS . '/xml/app-webyplus.xml' );
			$App = simplexml_load_string( $appXML );
			return $App->aplicacion;
		}
		
		/**
		 * conectar_servidor() : string
		 * Conecta con servidor de la aplicacion
		 */
		private static function conectar_servidor(){
			$res = obtener_contenido_remoto( MSiData::obtener( 'api_actualizacion' ) );
			if( $res != false ){
				return $res;
			}
			return '{"version":"0","url_descarga":"#"}';
		}
		
		/*
		 * servDatos() : string
		 * Obtiene datos del modulo de actualizacion
		 */
		public static function servDatos()
		{
			$datos	= json_decode( self::conectar_servidor() );
			return $datos;
		}
		
	}
	
	/* ----------------------------------- *\
			Funciones Globales YGE
	\* ----------------------------------- */
		//* funcion curl */
		function curl( $url, $timeout = 10 ) {
			$ch = curl_init();
			curl_setopt ($ch, CURLOPT_URL, $url);
			curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
			$file_contents = curl_exec($ch);
			curl_close($ch);
			return ( $file_contents ) ? $file_contents : false;
		}
		
		//* Funcion para lanzar mensaje al usuario */
		function msg_error( $msg, $icon = '', $class = '' ){
			global $YGE;
			$YGE['msg_error'] = '<div class="' . $class . '" role="alert"><i class="' . $icon . '"></i> ' . $msg . '</div>';
		}
		
		//* funcion para obtener contenido remoto */
		function obtener_contenido_remoto( $archivo ){
			if( function_exists('curl_init') ){
				return curl( $archivo );
			}
			// -- Si no existe cUrl, utilizo file_get_contents()
			if( function_exists( 'file_get_contents' ) ){
				return file_get_contents( $archivo );
			}
			return false;
		}
		
		//* Funcion para detectar el sistema operativo */
		function OS(){
			if ( strtoupper(substr(PHP_OS, 0, 3)) === 'WIN' )
				return 'Windows';
				
			if ( strtoupper(substr(PHP_OS, 0, 3)) === 'LIN' )
				return 'Linux';
				
			return PHP_OS;
		}
		
		//* funcion warning_handler */ 
		function warning_handler($errno = 0, $errstr = NULL ) { 
			// do something
		}
		
		//* funcion para guardar archivos */
		function salvarArchivo( $ruta, $contenido = '' ){
			
			if( empty( $contenido ) ) return false;
			
					$file = fopen( $ruta, "w");
								fwrite( $file, $contenido . PHP_EOL );
					fclose($file);
					
					return true;
		}
	
	/*
	 * Funcion para obtener informacion del sistema
	 */
	function WY_IS( $info = 'OS' ){
		switch( $info ) {
			case 'OS':
				return OS();
				
				break;
			case 'MYSQL_VER':
				return mysqli_get_client_version(); //mysqli_get_server_info( WYSQL::$SQLConn );
				
				break;
			case 'PHP_VER':
				return phpversion();
				
				break;
			case 'TAM_DISC':
				return Bytes2Mb( TamanoDir( YPATH ) );
				
				break;
			case 'WEBY_VER':
				//return WYCFG_App_Version;
				
				break;
			case 'SAFE_MODE':
				if (ini_get("safe_mode")){
					return "Activado";
				}
				return "Desactivado";
				
				
				break;
			case 'OPEN_BASEDIR':
				return ini_get("open_basedir");
				
				break;
			case 'GETMYUID':
				return getmyuid();
				
				break;
			case 'GETMYGID':
				return getmygid();
				
				break;
			default:
				return 'NULO';
		}
	}
	
	/* ----------------------------------- *\
			INICIO ARRANQUE DE SISTEMA
	\* ----------------------------------- */
		//* compruebo si el archivo de configuracion del sistema existe  */
			if ( !file_exists( '../wy_configuracion.php' ) || ( filesize( '../wy_configuracion.php' ) < 10 ) ) {
				//* Si no existe instalacion se inicia el setup
				$YGE_instalacion	= false;
			}else{
				$YGE_instalacion	= true;
			}
			
		//* comprobando requerimientos minimos de PHP y MySQL */
			// Compruebo vesion de PHP
				if ( version_compare( phpversion(), MSiData::obtener( 'version_php' ), 'lt' ) ) {
						$PHP_VERSION = false;
						$YGE_msg_error = 'PHP ' . MSiData::obtener( 'version_php' ) . ' es requirido como m&iacute;nimo. Tu version actual instalada es PHP ' . phpversion() . '. ';
				}
			// Compruebo version de MySQL
				if( mysqli_get_client_version() < MSiData::obtener( 'version_mysql' ) ){
						$MySQL_VERSION = false;
						$YGE_msg_error .= 'MySQL ' + MSiData::obtener( 'version_mysql' ) + '+ es requirido como m&iacute;nimo. Tu version actual es ' . mysqli_get_client_version() . '. ';
				}
			// compruebo soporte CURL
				if( ! function_exists('curl_init') ){
						$SOPORTE_CURL = false;
						$YGE_msg_error .= 'CURL no soportado';
				}
			// compruebo soporte file_get_contents()
				if( ! function_exists( 'file_get_contents' ) ){
						$SOPORTE_FGC = false;
						$YGE_msg_error .= 'file_get_contents no soportado';
				}
		
		
		//* Condicional de inicio de sesion */
		if( $YGE_instalacion == false )
		{
			// si existe intalacion muestro mensaje
				msg_error( LNG::etiqueta( 'msg_siconfig' ) . '<a href="../instalar/index.php">click aquí</a>', $icon = 'fa fa-info-circle', $class = 'alert alert-danger text-center' );
			
			$YGE_titulo_h1 = LNG::etiqueta( 'subti_0' );
			
			$YGE_html			= '<br>';
			// Boton
			$YGE_lnk_btn_1		= '../';
			$YGE_btn_1			= LNG::etiqueta( 'boton_regresarsis' );
		}
		else
		{
			// verificando conexion MySQL
			if( $es_paso && $_GET['paso'] == 4 )
			{
				// -- si las versiones son compatibles, continuo con instalacion
				if( $SOPORTE_FGC || $SOPORTE_CURL )
				{
					if( file_exists( '.as/bin/pi4.php' ) ){
						include_once( '.as/bin/pi4.php' );
					}
				}else{
					// Si no cumple con requerimientos primarios lanzo mensajes
						msg_error( '<strong>Verificación de requisitos del sistema fallida</strong><br>Su sistema no cumple con ' . $YGE_msg_error, $icon = 'fa fa-exclamation-circle', $class = 'alert alert-danger text-center' );
						
						$YGE_html .= 'Aborde los problemas enumerados anteriormente y luego haga clic en el botón a continuación para volver a verificar los requisitos y continuar.';
						
						$YGE_lnk_btn_1		= 'actualizar.php?paso=2';
						$YGE_btn_1			= 'Comprobar nuevamente';
				}
			
			// Configuracion de Sistema YGE
			}elseif( $es_paso && $_GET['paso'] == 3 ){
				if( $SOPORTE_FGC || $SOPORTE_CURL )
				{	
					if( file_exists( '.as/bin/pi3.php' ) ){
						include_once( '.as/bin/pi3.php' );
					}					
				}else{
					// Si no cumple con requerimientos primarios lanzo mensajes
						msg_error( '<strong>Verificación de requisitos del sistema fallida</strong><br>Su sistema no cumple con ' . $YGE_msg_error, $icon = 'fa fa-exclamation-circle', $class = 'alert alert-danger text-center' );
						
						$YGE_html .= 'Aborde los problemas enumerados anteriormente y luego haga clic en el botón a continuación para volver a verificar los requisitos y continuar.';
						
						$YGE_lnk_btn_1		= 'actualizar.php?paso=2';
						$YGE_btn_1			= 'Comprobar nuevamente';
				}
										
			// Requirimientos
			}elseif( $es_paso && $_GET['paso'] == 2 ){
				
				$YGE_titulo_h1 = LNG::etiqueta( 'subti_2' );
				
				// busco nueva version disponible
				$nom_app		= ( isset( ms_actualizar::servDatos()->nombre ) ) ? ms_actualizar::servDatos()->nombre : 'App';
				$url_descarga	= ( isset( ms_actualizar::servDatos()->url_descarga ) ) ? ms_actualizar::servDatos()->url_descarga : 'https://www.webyplus.com';
				$version_n		= ( isset( ms_actualizar::servDatos()->version ) ) ? ms_actualizar::servDatos()->version : 0.0;
				$version	= str_replace( '.', '', $version_n );
				$version_a	= str_replace( '.', '', MSiData::obtener( 'version_nucleo' ) );
				
				// Verifico curl / fgc
				if( $SOPORTE_CURL || $SOPORTE_FGC ){
					// Si hay nueva version inicio paso de instalacion
					if( $version > $version_a ) {
						msg_error( LNG::etiqueta( 'msg_req_ok' ), $icon = 'fa fa-check-circle', $class = 'alert alert-success text-center' );
							
						$YGE_lnk_btn_1		= 'actualizar.php?paso=3';
						$YGE_btn_1			= LNG::etiqueta( 'boton_iniinstal' );
							
						// creo cuerpo de paso 1
						$YGE_html .= '<div class="btn help-icon alert-info">Versión disponible ' . $nom_app . ' v' . $version_n . '</div>';
						$YGE_html .= '
						<p>Sistema operativo ' . OS() . ' detectado:</p>
						<table class="table table-striped requirements">
							<tr>
								<th>' . LNG::etiqueta( 'thead_requerimiento' ) . '</th>
								<th>' . LNG::etiqueta( 'thead_estado' ) . '</th>
							</tr>';
							
						$YGE_html .= '<tr><td>' . LNG::etiqueta( 'lbl_req_curl' ) . '</td><td>';
						$YGE_html .= ( $SOPORTE_CURL )? '<span class="btn help-icon alert-success">Habilitado</span>' : '<span class="btn help-icon alert-danger">Desactivado</span>';
						$YGE_html .= '</td></tr>';
						
						$YGE_html .= '<tr><td>' . LNG::etiqueta( 'lbl_req_filegetcontentsremoto' ) . '</td><td>';
						$YGE_html .= ( $SOPORTE_FGC ) ? '<span class="btn help-icon alert-success">Habilitado</span>' : '<span class="btn help-icon alert-warning">Desactivado</span>';
						$YGE_html .= '</td></tr>';
							
						$YGE_html .= '</table>';
					}else{
						$YGE_html .= '<div class="btn help-icon alert-success">Tu versión ' . $nom_app . ' está actualizada. v' . MSiData::obtener( 'version_nucleo' ) . '</div>';
						
						$YGE_lnk_btn_1		= './';
						$YGE_btn_1			= 'Salir';
					}
					
				}else{
						// Si no cumple con requerimientos primarios lanzo mensajes
						msg_error( LNG::etiqueta( 'msg_req_no' ) . $YGE_msg_error, $icon = 'fa fa-exclamation-circle', $class = 'alert alert-danger text-center' );
						
						$YGE_html .= LNG::etiqueta( 'lbl_req_abordeproblemas' );
						
						$YGE_lnk_btn_1		= 'actualizar.php?paso=2';
						$YGE_btn_1			= 'Comprobar nuevamente';
				}
				
				
			// Licencia de Uso	
			}else{
				// Si el usuario no acepta el contrato, lanzo mensaje
				if( isset( $_GET['disagree'] ) && $_GET['disagree'] == 1 ) msg_error( 'No puede continuar con la instalación a menos que acepte el Acuerdo de licencia', $icon = 'fa fa-exclamation-circle', $class = 'alert alert-danger text-center' );
				// Creo titilo H1
				$YGE_titulo_h1 = LNG::etiqueta( 'subti_1' );
				// creo acuerdo de licencia
				$YGE_html .= '
				<p>' . LNG::etiqueta( 'prompts_1' ) . '</p>
				
				<p align="center">
						<textarea class="form-control" style="font-family: Tahoma, sans-serif; font-size: 12px; color: #666666;" rows="25" readonly>' . MSiData::tyc() . '</textarea>
				</p>';
				
				$YGE_lnk_btn_1		= 'actualizar.php?paso=2';
				$YGE_lnk_btn_2		= 'actualizar.php?disagree=1';
				
				$YGE_btn_1			= LNG::etiqueta( 'boton_deacuerdo' );
				$YGE_btn_2			= LNG::etiqueta( 'boton_nodeacuerdo' );
				
			}
		}
		
		
	/* ----------------------------------- *\
				imprimo HTML
	\* ----------------------------------- */
			// imprimo HEAD y BODY
			$YGE_html = '<head>
			<meta charset="utf-8">
			<title>' . LNG::etiqueta( 'title' ) . '</title>
			<link href="../css/instalador.css" rel="stylesheet">
			<link href="../css/fontawesome-all.min.css" rel="stylesheet">
		</head>
		<body>
			<div class="wrapper">
				<div class="version">V' . MSiData::obtener( 'version_nucleo' ) . '</div>
				<div style="margin:30px;">
						<a href="https://productos.macrodigitalsoftware.com/?np=yge-cliente" target="_blank"><img src="../images/logo_wy.png" alt="YGE - Panel de Cliente" border="0" style="max-height:100px" /></a>
				</div>
				<h1>' . $YGE_titulo_h1 . '</h1>' . $YGE['msg_error'] . $YGE_html ;
			
			// imprimo botones incluido pie de pagina
			$YGE_html .= '<p align="center">';
			
			if( $YGE_btn_1 != NULL ) $YGE_html .= '<a href="' . $YGE_lnk_btn_1 .'" onClick="' . $YGE_onclick_1 . '" class="btn btn-success btn-lg" id="btnEulaAgree">' . $YGE_btn_1 . '</a> ';
			
			if( $YGE_btn_2 != NULL ) $YGE_html .= '<a href="' . $YGE_lnk_btn_2 .'" onClick="' . $YGE_onclick_2 . '" class="btn btn-default btn-lg" id="btnEulaDisagree">' . $YGE_btn_2 . '</a>';
			
			$YGE_html .= '	</p>
				
				<br>
				<br>
	
				<div align="center"><small>Copyright ' . MSiData::obtener( 'app_nombre' ) . ' &copy; YalPublicidad.Com 2003-' . date('Y') . '<br>
					<a href="https://www.yalpublicidad.com/" target="_blank">www.yalpublicidad.com</a></small>
				</div>
			</div>
			<br><br>
			<div align="center"><a href="index.php?' . $_SERVER['QUERY_STRING'] . '&lng=es">Español</a> &bull; <a href="index.php?' . $_SERVER['QUERY_STRING'] . '&lng=en">English</a></div></body></html>';
		
		echo $YGE_html;
	
?>
