<?php

	/*
	 *
	 * 2003 - 2023 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * @bin.wy_html
	 *
	 * Modulo de funciones HTML del sitio WebyPlus.
	 *
	 */
	

	/* Autorizo acceso */
		defined('WY_INI_WEBY') or die( 'No dispones de acceso' );
	

	/* CLASE HTML */
	class WYHTML {

		public static $_WY_BASE;
		public $_WY_OBT_SECCION		= array();
		public $_wy_obtContenido	= array();

		/* BASE_HTML
		 * Obtener Base html
		 * ej. /sitio/misitio/
		 */
		public static function BASE_HTML(){
			$base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\'); //$_SERVER['HTTP_HOST'] dirname($_SERVER['PHP_SELF'])
			$base = $base . '/';
			return $base;
		}

		/* _CopyRight
		 * Obtener el CopyRight del sitio Weby+ 
		 */
		public function _CopyRight( $Organizacion = NULL ){
			$HTML =   '		<div class="copy">' . "\n" .
					  '					<span>&copy;&nbsp;</span>' . "\n" .
					  '					<span id="copyright-year">' . date('Y') . '</span><span>&nbsp;' . $Organizacion . '.&nbsp;</span>' . "\n" .
					  '					<span>Todos los derechos reservados.</span>' . "\n" .

					  '                 <span>&nbsp;&bull;&nbsp;</span>' . "\n" .

					  '                 <span>Designed by <a class="wm" href="' . App_Organizacion_web . '" target="_blank">' . App_Organizacion . '</a>, with technology <a class="wmt" href="' . App_web . '" target="_blank">' . App_NombreOriginal . '</a></span>

					  		</div>';

							

			return $HTML;

		}

		/* HEAD_HTML

		 * Obtener el encabezado de la pagina Weby+

		 */

		public function head_html($charset = NULL, $metas=NULL){

			$HTML = ($charset!=NULL) ? self::Meta_Charset($charset) : self::Meta_Charset();
			$HTML .= '<base href="' . self::BASE_HTML() .'">' . "\n";
			$HTML .= self::Titulo();

			if($metas!=NULL) $HTML .= self::MetaTag($metas);

			$HTML .= self::Meta_Author();
			$HTML .= "\t" . '<link rel="stylesheet" href="css/styles.css">' . "\n" .
					 "\t" . '<script type="text/javascript" src="js/jsy_scriptv2.js"></script>' . "\n" .
					 "\t" . '<script type="text/javascript" src="js/jsy-script.js"></script>' . "\n" .
					 "\t" . '<meta name="generator" content="' . App_Organizacion . '" />' . "\n" .
					 "\t" . '<link rel="icon" href="images/favicon.png" type="image/x-icon">' . "\n" .
					 "\t" . '<link rel="shortcut icon" href="images/favicon.png" type="image/x-icon"/>';		  
			return $HTML;
		}

		/* link
		 * Crear links dinamicos
		 */
		public static function link( $href, $cadena, $atributos = NULL, $target = 0 )
		{
			if (is_array( $atributos )) {
				$atributos = explode( '\n', $atributos );
			}

			$target = ( $target > 0 ) ? ' target="_blank" ' : '';

			return '<a href="' . $href . '" ' . $atributos . $target . '>' . $cadena . '</a>';

		}

		

		public static $Var_MnuIndex = 1;

		/* _MNU
		 * Obtener el menu _TOP, _LEFT, _RIGHT, _BOTTOM 
		 */

		public function menu( $indice=0, $objetivo = NULL, $class=NULL, $limite=5, $padre = 0 )
		{
			// Defino objetivo
				if( $objetivo != NULL ) $objetivo = "posicion='$objetivo' and";

			/* Leo slug */
					$Slug		= self::Slug();

					if( !empty($Slug) ) $Slug_partes= explode('/',$Slug);

					if( !empty( $Slug_partes ) ){
						/* Busco coinciencias */
						$Slug = $Slug_partes[0];						
					}else{
						$Slug = 1;
					}

			$limite		= ( $limite != 0 ) ? "LIMIT 0,$limite" : "";
			$_HTML_MENU	= '<ul ' . $class . '>' . "\n";

			$Q = _mysql_query( "SELECT * FROM " . WY_DBPREFIJO . "menu WHERE $objetivo padre = '$padre' ORDER BY orden ASC $limite" );
			while( $row = _mysql_fetch_array( $Q ) ){
				if( $row['tipo'] == 'contenido' && $row['publicado'] == 1 ){

					$_HTML_MENU .= '<li><a href="';

					if($row['slug']!=NULL){
						$_HTML_MENU .= $row['slug'];
					}else{						
						if($row['link']!=NULL)
							$_HTML_MENU .= $row['link'];
						else
							$_HTML_MENU .= './';
					}		

					$_HTML_MENU .= '" class="';			

					if( $row['id'] == $Slug || $row['slug'] == $Slug || $row['link'] == $Slug ) $_HTML_MENU .= 'activo';

					$_HTML_MENU .= '">' . utf8_encode($row['nombre']) . '</a>';
					
					/* Creo sub menu si existe */
						if( _mysql_existe( WY_DBPREFIJO."menu", "padre", "padre='" . $row['id'] . "'" ) ) $_HTML_MENU .= $this->menu( 0, NULL, '', 0, $row['id'] );

					/* *** */
					$_HTML_MENU .= '</li>' . "\n";
				}
			}	

			$_HTML_MENU .= '</ul>' . "\n";

				return $_HTML_MENU;
		}

		

		/* Meta_Charset 
		 * Define el atributo Charset del <head>
		 */
		private static function Meta_Charset( $charset = 'utf-8' ){

			$HTML = '<meta charset="' . $charset . '">' . "\n";

			return $HTML;

		}

		/* Meta_Autor
		 * define el atributo name=Autor del <head>
		 */
		private static function Meta_Author( $autor = ''){
			$autor		= ( $autor != '' ) ? $autor : App_Organizacion;
			$meta_autor	= "\t" . '<meta name="author" content="' . $autor . '" />' . "\n";
			return $meta_autor;
		}

		/* MetaTags
		 * Define los metas del <head> 
		 */
		public static function MetaTag( $name = '' ){
			$meta = '';
			if( $name != ''  )
			{
				$name = explode('|',$name);
				$meta = "\n";

				for($i=0;$i<count($name);$i++){
					$valor = explode(':', $name[$i]);
					$meta .= '	<meta name="' . $valor[0] . '" content="' . $valor[1] . '" />' . "\n";
				}

			}
			return $meta;
		}

		/*
		 * Extraer el slug del sitio Weby+
		 * ej.	www.misitioweby.com/zapatos/mujer/botas
		 *		Llamar: Slug();
		 *		Retorna: zapatos/mujer/botas
		 */
		public static function Slug(){
			$Base		= preg_replace('/^(\/)/','',self::BASE_HTML());
			$Base_Slug	= preg_replace('/^(\/)/','',$_SERVER['REQUEST_URI']);
			$Slug		= str_replace( $Base, '', $Base_Slug );

			if( !empty($Slug) ) return $Slug;
			
			return false;
		}

		

		/* Slug_Contenido
		 * Se genera el slug del contenido
		 */
		public static function Slug_Contenido( $id )
		{
			$q = _mysql_query( "SELECT * FROM ".WY_DBPREFIJO."contenido WHERE id=$id" );
			 $r = _mysql_fetch_array( $q );
			 
			 $slug_seccion	= ( $r['seccionid'] > 0 ) ? self::Slug_Seccion( $r['seccionid'] ) . '/' : NULL;
			 $slug_por_id	= ( $id > 0 ) ? 'index.php?id=' . $id : NULL;
			 $slug			= ( $r['slug'] != NULL ) ? $slug_seccion . $r['slug'] : $slug_por_id;
			 
			 return $slug;
			 
			/* $slug = NULL;
			 $slug1 = WYSQL::obt1Reg( "contenido", "id=$id", "slug" );
			 $idSec = WYSQL::obt1Reg( "contenido", "id=$id", "seccionid" );
			 $slug2 = self::Slug_Seccion( $idSec );

			 if( $slug1 != NULL )
			 {
				 $slug = ( $slug2 != NULL ) ? $slug2 . '/' . $slug1 : $slug1;
			 }else{
				 if( $id > 0 ) $slug = 'index.php?id=' . $id;
			 }

			 return $slug;*/
		}

		 

		/* Slug_Seccion
		 * Se genera el slug del contenido
		 */
		 public static function Slug_Seccion( $idSec )
		 {
			$q = _mysql_query( "SELECT*FROM ".WY_DBPREFIJO."secciones  WHERE id='$idSec'" );
			 $r = _mysql_fetch_array( $q );
			 
			 $slug_padre	= ( $r['padre'] > 0 ) ? self::Slug_Seccion( $r['padre'] ) . '/' : NULL;
			 $slug			= ( $r['slug'] != NULL ) ? $slug_padre . $r['slug'] : NULL;
			 
			 return $slug;
			 
			/* $slug = NULL;
			 $slug1 = WYSQL::obt1Reg( "secciones", "id=$idSec", "slug" );
			 $slug2 = NULL;
			 $slug1_id = WYSQL::obt1Reg( "secciones", "id=$idSec", "id" );
			 $slug1_padre = WYSQL::obt1Reg( "secciones", "id=$idSec", "padre" );

			 if( $slug1 != NULL )
			 {
				 $slug = $slug1;

				 if( $slug1_padre > 0 ) $slug2 = self::Slug_Seccion( $slug1_padre );

				 if( $slug2 != NULL ) $slug = $slug2 . '/' . $slug;
			 }else{
				 if( $slug1_id > 0 ) $slug = $slug1_id;
			 }
			 return $slug;*/
		 }

		

		/* Title 
		 * Define la etiqueta <title> del <head>
		 */
		private static function Title( $titulo = '' ) {
			$HTML = '<title>' . $titulo . '</title>' . "\n";
			return $HTML;
		}

		/* Titulo
		 * Define el texto del titulo de la etiqueta <title>
		 */
		public function Titulo()
		{	
			/* Leo slug */
					$Slug		= self::Slug(); 
					if( !empty($Slug) ) $Slug_partes= explode('/',$Slug);

					if( !empty( $Slug_partes ) ){
						/* Busco coinciencias */
						$Slug		= end( $Slug_partes );
						$SlugContent= _mysql_existe( "contenido", "slug", "slug='$Slug'" );
						$SlugSec	= _mysql_existe( "secciones", "slug", "slug='$Slug'" );

						if( !empty( $SlugContent ) && $SlugContent ) {
							return utf8_encode( self::Title( _mysql_obtener_reg( "contenido", "slug='$Slug'", "titulo" ) ) );
						}

						if( !empty($SlugSec) && $SlugSec ) {
							return utf8_encode( self::Title( _mysql_obtener_reg( "secciones", "slug='$Slug'", "nombre" ) ) );
						}
					}

			/* Compruebo si se usa slug o variables */
				if( isset( $_GET['id'] ) ) return utf8_encode( self::Title( _mysql_obtener_reg( 'contenido', 'id=' . $_GET['id'], 'titulo' ) ) );
				if( isset( $_GET['iSec'] ) ) return utf8_encode( self::Title( _mysql_obtener_reg( 'secciones', 'id=' . $_GET['iSec'], 'nombre' ) ) );
				return ( WY_TITLE != '' ) ? self::Title( WY_TITLE ) : self::Title( App_NombreOriginal );
		}

		 

	 }

	 

	 $_WY_HTML = new WYHTML();

	 

?>