<?php

	/*
	 *
	 * 2003 - 2023 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * Modulo de funciones propias de WebyPlus
	 */
	 
	 /* Autorizo acceso */
		defined('WY_INI_WEBY') or die( 'No dispones de acceso' );
	
	
	/** Obtengo el nombre server_name de Weby+ */
	function IdWebySN(){
    	$protocolos = array('http://', 'https://', 'ftp://', 'www.');
    	$sn = explode( '/', str_replace( $protocolos, '', $_SERVER['SERVER_NAME'] ) );
    	return $sn[0];
	}
	
	/** Obtengo el Id Weby+ */
	function IdWebyPlus( $Idwp = NULL, $accion = 'L')
	{
		global $wy_func;
		
		$SERVER_NAME	= WY_SERVERNAME;
		///$SERVER_NAME	= IdWebySN();
		$IdCadena		=  WEBYPLUS_ID_ACTIVACION . '://' . YPATH;
		$Id = encriptar( $IdCadena, $SERVER_NAME );
		// ** C = Comparar
		if( $accion == 'C' ) return ( $Idwp == $Id ) ? true : false;
		
		return $Id;
	}
	
	function IdWebyPlusRecuperar()
	{
		$SN		= url_codificar( WY_SERVERNAME );
		///$SN		= url_codificar( IdWebySN() );
		$SA		= url_codificar( $_SERVER['SERVER_ADDR'] );
		$YP		= url_codificar( YPATH );
		$CA		= md5( WEBYPLUS_ID_ACTIVACION );
		$URI	= App_web . '/'; //'//localhost/webyplus/';
		$USR	= url_codificar( WY_MAILUSER );
		$e_Idwpr= $URI . "p_Idwpr.php?sn=$SN&sa=$SA&yp=$YP&ca=$CA&usr=$USR";
		
		return $e_Idwpr;
		
	}
	
	/*
	 *  Funcion saludo de bienvenida
	 */
	function saludo_bienvenida( $cadena = NULL ){
		//$hoy = getdate(); 
		//$hora=$hoy["hours"];
		$hora = gmdate( 'H', obt_GMT( GMT ) ); 
		if ($hora<6) { 
			echo( "Hoy has madrugado mucho " . $cadena ); 
		}elseif($hora<12){ 
			echo( "Buenos días " . $cadena ); 
		}elseif($hora<=18){ 
			echo( "Buenas Tardes " . $cadena ); 
		}else{ echo( "Buenas Noches " . $cadena ); } 
	}
	
	/*
	 * Funcion para obtener informacion del sistema
	 */
	function WY_IS( $info = 'OS' ){
		switch( $info ) {
			case 'OS':
				return OS();
				
				break;
			case 'MYSQL_VER':
				return mysqli_get_server_info( ySQL::$SQLConn );
				
				break;
			case 'PHP_VER':
				return phpversion();
				
				break;
			case 'TAM_DISC':
				return Bytes2Mb( TamanoDir( YPATH ) );
				
				break;
			case 'WEBY_VER':
				return App_Version;
				
				break;
			case 'SAFE_MODE':
				if (ini_get("safe_mode")){
					return "Activado";
				}
				return "Desactivado";
				
				
				break;
			case 'OPEN_BASEDIR':
				return ini_get("open_basedir");
				
				break;
			case 'GETMYUID':
				return getmyuid();
				
				break;
			case 'GETMYGID':
				return getmygid();
				
				break;
			default:
				return 'NULO';
		}
	}
?>