<?php
	/*
	 *
	 * YGA (c) 2003 - 2020 Yal Publicidad
	 * Yal Gestor de Archivos
	 *
	 */
	
	/* llamada a YE */
	include_once( 'lib/mod.func.php' );
		
	if ( YE::veriSess() ) {
		
		$mdir	= ( isset( $_GET['dir'] ) ) ? $_GET['dir'] : '/';
			 
?>
<html>
<head>
	<title>Cargar Archivo</title>
	<link rel="stylesheet" href="fonts/font-awesome-4.7.0/css/font-awesome.min.css">
	<style>
		body{ background:#E8EDF0; }
		
		a{ text-decoration:none; color:#236f9e; }
		
		#yedrop{ width: 790px; max-width:100%; margin: 20px auto; }
		
		.yga-drag-drop{ 
					background: #fff;
					position:relative; 
					margin: 15px 0px;
					padding: 15px;
					border:1px #0081d5 dashed; 
					border-radius:3px; 
					color: #000;
					text-align:center;
			}
			.yga-drag-drop h3{ color:#4a5058; font-size:24px; }
			
		
		#drop-area {
			border: 2px dashed #ccc;
			border-radius: 20px;
			width: 670px; max-width:100%;
			margin: 50px auto;
			padding: 20px;
			background:#ffffff;
			text-align:center;
		}
		#drop-area.highlight {
		  border-color: purple;
		}
		p {
		  margin-top: 0;
		}
		.my-form {
		  margin-bottom: 10px;
		}
		#gallery {
		  margin-top: 10px;
		}
		#gallery img {
		  width: 150px;
		  margin-bottom: 10px;
		  margin-right: 10px;
		  vertical-align: middle;
		}
		.button {
		  display: inline-block;
		  padding: 10px;
		  background: #ccc;
		  cursor: pointer;
		  border-radius: 5px;
		  border: 1px solid #ccc;
		}
		.button:hover {
		  background: #ddd;
		}
		#fileElem {
		  display: none;
		}
		
		progress {
			display:inline-block;
			width:190px;
			height:20px;
			padding:15px 0 0 0;
			margin:0;
			background:none;
			border:0;
			border-radius: 15px;
			text-align: left;
			position:relative;
			font-family: Arial, Helvetica, sans-serif;
			font-size: 0.8em;
		}
		progress::-webkit-progress-bar {
			height:11px;
			width:150px;
			margin:0 auto;
			background-color: #eee;
			border-radius: 15px;
			box-shadow:0px 0px 6px #999 inset;
		}
		progress::-webkit-progress-value {
			display:inline-block;
			float:left;
			height:11px;
			margin:0px -10px 0 0;
			background: #2299dd;
			border-radius: 15px;
			box-shadow:0px 0px 6px #777 inset;
		}
		progress:after {
			margin:-26px 0 0 -7px;
			padding:0;
			display:inline-block;
			float:left;
			content: attr(value) '%';
		}

	</style>
</head>
<body>

	<div id="yedrop">
		<h2>Cargar archivos en &quot;<?php echo $mdir; ?>&quot;</h2>
		<div><i class="fa fa-upload"></i> Tamaño maximo para cargar: <?php echo ini_get('upload_max_filesize'); ?></div>
	</div>
	
		<div id="drop-area">
			<form class="my-form">
				<h3>Arrastrar y soltar archivo</h3>
						<p>O si lo prefiere</p>
				<input type="file" id="fileElem" name="files" multiple accept="image/*" onchange="handleFiles(this.files)">
				<label class="button" for="fileElem">Select some files</label>
			</form>
			<progress id="progress-bar" max=100 value=0></progress>
		</div>
	<!-- log de resultados -->
	<div id="yedrop" align="center"><div id="gallery" /></div><div id="files" /></div></div>
	<!-- boton regresar -->
	<div id="yedrop" align="center"><a href="javascript:;" onClick="regresar()"><i class="fa fa-long-arrow-left"></i> Volver a explorador</a></div>

	<script>
		// ************************ Drag and drop ***************** //
		dropArea = document.getElementById("drop-area");
		
		// Prevent default drag behaviors
		["dragenter", "dragover", "dragleave", "drop"].forEach((eventName) => {
		  dropArea.addEventListener(eventName, preventDefaults, false);
		  document.body.addEventListener(eventName, preventDefaults, false);
		});
		
		// Highlight drop area when item is dragged over it
		["dragenter", "dragover"].forEach((eventName) => {
		  dropArea.addEventListener(eventName, highlight, false);
		});
		["dragleave", "drop"].forEach((eventName) => {
		  dropArea.addEventListener(eventName, unhighlight, false);
		});
		
		// Handle dropped files
		dropArea.addEventListener("drop", handleDrop, false);
		
		function preventDefaults(e) {
		  e.preventDefault();
		  e.stopPropagation();
		}
		
		function highlight(e) {
		  dropArea.classList.add("highlight");
		}
		
		function unhighlight(e) {
		  dropArea.classList.remove("active");
		}
		
		function handleDrop(e) {
		  var dt = e.dataTransfer;
		  var files = dt.files;
		
		  handleFiles(files);
		}
		
		let uploadProgress = [];
		let progressBar = document.getElementById("progress-bar");
		
		function initializeProgress(numFiles) {
		  progressBar.value = 0;
		  uploadProgress = [];
		
		  for (let i = numFiles; i > 0; i--) {
			uploadProgress.push(0);
		  }
		}
		
		function updateProgress(fileNumber, percent) {
		  uploadProgress[fileNumber] = percent;
		  let total =
			uploadProgress.reduce((tot, curr) => tot + curr, 0) / uploadProgress.length;
		  console.debug("update", fileNumber, percent, total);
		  progressBar.value = total;
		}
		
		function handleFiles(files) {
		  files = [...files];
		  initializeProgress(files.length);
		  files.forEach(uploadFile);
		  files.forEach(previewFile);
		}
		
		function previewFile(file) {
		  var reader = new FileReader();
		  reader.readAsDataURL(file);
		  reader.onloadend = function () {
				var img = document.createElement("img");
				var div = document.createElement("div");
				//verifico si es imagen o fichero
				mime = base64MimeType(reader.result);
				if( mime == 'image/png' || mime == 'image/jpeg' || mime == 'image/bmp' || mime == null ){
					img.src = reader.result;
					document.getElementById("gallery").appendChild(img);
				}else{
					div.innerHTML = '<i class="fa fa-check-circle"></i> subio ' + mime;
					document.getElementById("files").appendChild(div);
				}
		  };
		}
		
		function uploadFile(file, i) {
		  var url = "lib/ye.php?a=subir";
		  var xhr = new XMLHttpRequest();
		  var formData = new FormData();
		  xhr.open("POST", url, true);
		  xhr.setRequestHeader("X-Requested-With", "XMLHttpRequest");
		
		  // Update progress (can be used to show progress indicator)
		  xhr.upload.addEventListener("progress", function (e) {
			updateProgress(i, (e.loaded * 100.0) / e.total || 100);
		  });
		
		  xhr.addEventListener("readystatechange", function (e) {
			if (xhr.readyState == 4 && xhr.status == 200) {
			  updateProgress(i, 100); // <- Add this
			} else if (xhr.readyState == 4 && xhr.status != 200) {
			  // Error. Inform the user
			}
		  });
		
		  formData.append("upload_preset", "<?php echo $mdir; ?>");
		  formData.append("file", file);
		  xhr.send(formData);
		}
		
		function regresar(){
			window.opener.yGestorArchivos.explorar_archivo( '', window.opener.$barra.value );
			window.close();
		}
		
		function base64MimeType(encoded) {
			var result = null;
			
			if (typeof encoded !== 'string') { return result; }
			var mime = encoded.match(/data:([a-zA-Z0-9]+\/[a-zA-Z0-9-.+]+).*,.*/);
			if (mime && mime.length) {
				result = mime[1];
			}
			return result;
		}

	</script>


</body>
</html>
<?php
	}
?>