<?php
	/*
	 *
	 * yPanel (c) 2003 - 2019 Yal Publicidad
	 * Sistema yPanel - yWHA
	 *
	 */
	
	/* Autorizo acceso */
		defined('yPIni_yPanel') or die( '<h2>No dispones de acceso<h2>' );
	
	class yPanel {
		
		public static function usuario(){
			return YPSESS::usuario();
		}
		
		public static function document_root(){
			$eUnidades = array('C:','D:','E:','F:','G:','H:','I:','J:','K:','L:','M:','N:','O:');
			$docRoot = $_SERVER['DOCUMENT_ROOT'];
			$docRoot = str_replace($eUnidades, '', $docRoot );
			return $docRoot;
		}
		
		/* obtener email de cuenta */
		public static function email_cuenta(){
			$yp_uri = YPATHROOT . YDS . 'local/ypanel/usr/.' . YPSESS::usuario();
			if( $yp_uri != YPATHROOT . YDS . 'local/ypanel/usr/.' && file_exists( $yp_uri ) ){
				$json = file_get_contents( $yp_uri );
				$json = json_decode($json);
				
				return isset( $json->email_contacto ) ? $json->email_contacto : '';
			}
			return false;
		}
		
		/* modificar el email de la cuenta */
		public static function email_cuenta_cambiar( $email = '' ){
			$email_uri = YPATHROOT . YDS . 'local/ypanel/usr/.' . YPSESS::usuario();
			if( $email_uri != YPATHROOT . YDS . 'local/ypanel/usr/.' && file_exists( $email_uri ) ){
				// -- Leo los datos
						$json = file_get_contents( $email_uri ); 
						$data = json_decode($json, true); 
					
				// -- Modifico el pass y ksess
						$data['email_contacto'] = $email;
						
				// -- Guardo las modificciones
						$json = json_encode($data); 
						file_put_contents($email_uri, $json);
					
				return true;
			}
			
			return false;
		}
		
		/* Extraer nombre de DB yPanel */
		public static function extr_nom_db( $db_nombre ){
			if(! empty( $db_nombre ) ){
				$dbn = explode( '_', $db_nombre );
				return ( isset( $dbn[1] ) ) ? $dbn[1] : NULL;
			}
			return false;
		}
		
		public static function informacion_producto(){
			$yp_uri = YPATHROOT . YDS . 'local/ypanel/.instalacion';
			if( file_exists( $yp_uri ) ){
				$json = file_get_contents( $yp_uri );
				$json = json_decode($json);
				
				return $json->producto;
			}
			return 'yPanel Servidor - SO Windows';
		}
		
		public static function ip_server(){
			$ip = $_SERVER['SERVER_ADDR'];
			return $ip;
		}
		
		public static function nombre_cuenta(){
			global $YP_USR_CONFIG;
			return _yp( $YP_USR_CONFIG, 'DNS' );
		}
		
		public static function obt_subfijo_dbmysql( $n = 8 ){
			$sf_dbsql = substr( YPSESS::usuario(), 0, 8 );
			$sf_dbsql = $sf_dbsql . '_';
			return $sf_dbsql;
		}
		
		public static function os_server(){
			if ( strtoupper(substr(PHP_OS, 0, 3)) === 'WIN' )
				return 'Windows';
				
			if ( strtoupper(substr(PHP_OS, 0, 3)) === 'LIN' )
				return 'Linux';
				
			return PHP_OS;	
		}
		
		/* Obtener contaseña de usuario activo */
		public static function password(){
			return YPSESS::pass();
		}
		
		public static function password_modificar( $nPass, $vPass ){
			return YPSESS::pass_cambiar( $nPass, $vPass );	
		}
		
		public static function php_version(){
			return phpversion();
		}
		
		public static function sis_server_local(){
			$os = $_SERVER['SERVER_SOFTWARE'];
			return $os;	
		}
		
		/* calcular uso de banda ancha */
		public static function uso_banda_ancha( $homedir, $limite = 0 ){
			$limite = ( $limite == 0 || $limite == 'unlimited' || $limite == NULL ) ? '&infin;' : calSizeDisco( $limite );
			// -- /ypanel/logs/access-log/ymodas.com-access.log
			$accessLogs	= YPATHROOT . YDS . 'logs' . YDS . 'access-log' . YDS . yPanel::nombre_cuenta() . '-access.log' ;
			$homedir	= $homedir . YDS . 'logs';
			$homedir1	= $homedir . YDS . yPanel::nombre_cuenta() . '-' . date( 'M' ) . '-' . date( 'Y' ) . '.log';
			$uso_disco = 0;
			
			if( file_exists( $accessLogs ) ){
				copy( $accessLogs, $homedir1 );
				$uso_disco = sizeDir( $homedir );
			}
			
			return bytes2Mb( $uso_disco ) . ' / ' . $limite;
		}
		
		/* calcular uso de disco */
		public static function uso_disco( $homedir, $limite = 0 ){
			$limite = ( $limite == 0 || $limite == 'unlimited' ) ? '&infin;' : calSizeDisco( $limite );
			//$homeDirPath = YPATHROOT . YDS . 'home' . YDS . $usuario;
			$homeDirPath = $homedir;
			$uso_disco = 0;
			
			if( file_exists( $homeDirPath ) ){
				$uso_disco = sizeDir( $homeDirPath );
			}
			
			return bytes2Mb( $uso_disco ) . ' / ' . $limite;
		}
		
		public static function version(){
			$yp_uri = YPATHROOT . YDS . 'local/ypanel/.instalacion';
			if( file_exists( $yp_uri ) ){
				$json = file_get_contents( $yp_uri );
				$json = json_decode($json);
				
				return $json->version;
			}
			return '20.0.0';
		}
		
		
		
	}
	
	$yPanel = new yPanel();
	
?>