	
	function $_(selector){
		return document.querySelector(selector);
	}
	
	
/*
	
	Table of Contents
	-----------------
	Configuration
	
	Functions
	- getPageScroll()
	- getPageSize()
	- pause()
	- getKey()
	- listenKey()
	- showLightbox()
	- hideLightbox()
	- initLightbox()
	- addLoadEvent()
	
	Function Calls
	- addLoadEvent(initLightbox)

*/



//
// Configuration
//

// If you would like to use a custom loading image or close button reference them in the next two lines.
var loadingImage = 'loading.gif';		
var closeButton = 'close.gif';		

wyLightbox = {
	ImagenPreCarga: '',
	TextoPreCarga: 'Cargando'
}




//
// getPageScroll()
// Returns array with x,y page scroll values.
// Core code from - quirksmode.org
//
function getPageScroll(){

	var yScroll;

	if (self.pageYOffset) {
		yScroll = self.pageYOffset;
	} else if (document.documentElement && document.documentElement.scrollTop){	 // Explorer 6 Strict
		yScroll = document.documentElement.scrollTop;
	} else if (document.body) {// all other Explorers
		yScroll = document.body.scrollTop;
	}

	arrayPageScroll = new Array('',yScroll) 
	return arrayPageScroll;
}



//
// getPageSize()
// Returns array with page width, height and window width, height
// Core code from - quirksmode.org
// Edit for Firefox by pHaez
//
function getPageSize(){
	
	var xScroll, yScroll;
	
	if (window.innerHeight && window.scrollMaxY) {	
		xScroll = document.body.scrollWidth;
		yScroll = window.innerHeight + window.scrollMaxY;
	} else if (document.body.scrollHeight > document.body.offsetHeight){ // all but Explorer Mac
		xScroll = document.body.scrollWidth;
		yScroll = document.body.scrollHeight;
	} else { // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
		xScroll = document.body.offsetWidth;
		yScroll = document.body.offsetHeight;
	}
	
	var windowWidth, windowHeight;
	if (self.innerHeight) {	// all except Explorer
		windowWidth = self.innerWidth;
		windowHeight = self.innerHeight;
	} else if (document.documentElement && document.documentElement.clientHeight) { // Explorer 6 Strict Mode
		windowWidth = document.documentElement.clientWidth;
		windowHeight = document.documentElement.clientHeight;
	} else if (document.body) { // other Explorers
		windowWidth = document.body.clientWidth;
		windowHeight = document.body.clientHeight;
	}	
	
	// for small pages with total height less then height of the viewport
	if(yScroll < windowHeight){
		pageHeight = windowHeight;
	} else { 
		pageHeight = yScroll;
	}

	// for small pages with total width less then width of the viewport
	if(xScroll < windowWidth){	
		pageWidth = windowWidth;
	} else {
		pageWidth = xScroll;
	}


	arrayPageSize = new Array(pageWidth,pageHeight,windowWidth,windowHeight) 
	return arrayPageSize;
}


//
// pause(numberMillis)
// Pauses code execution for specified time. Uses busy code, not good.
// Code from http://www.faqts.com/knowledge_base/view.phtml/aid/1602
//
function pause(numberMillis) {
	var now = new Date();
	var exitTime = now.getTime() + numberMillis;
	while (true) {
		now = new Date();
		if (now.getTime() > exitTime)
			return;
	}
}

//
// getKey(key)
// Gets keycode. If 'x' is pressed then it hides the lightbox.
//

function getKey(e){
	if (e == null) { // ie
		keycode = event.keyCode;
	} else { // mozilla
		keycode = e.which;
	}
	key = String.fromCharCode(keycode).toLowerCase();
	
	if(key == 'x'){ hideLightbox(); }
}


//
// listenKey()
//
function listenKey () {	document.onkeypress = getKey; }
	

//
// showLightbox()
// Preloads images. Pleaces new image in lightbox then centers and displays.
//
function showLightbox(objLink)
{
	// prep objects
	var objOverlay = document.getElementById('overlay');
	var objLightbox = document.getElementById('lightbox');
	var objCaption = document.getElementById('lightboxCaption');
	var objImage = document.getElementById('lightboxImage');
	var objLoadingImage = document.getElementById('loadingImage');
	var objLightboxDetails = document.getElementById('lightboxDetails');

	
	var arrayPageSize = getPageSize();
	var arrayPageScroll = getPageScroll();

	// center loadingImage if it exists
	if (objLoadingImage) {
		objLoadingImage.style.top = (arrayPageScroll[1] + ((arrayPageSize[3] - 35 - objLoadingImage.height) / 2) + 'px');
		objLoadingImage.style.left = (((arrayPageSize[0] - 20 - objLoadingImage.width) / 2) + 'px');
		objLoadingImage.style.display = 'block';
	}

	// set height of Overlay to take up whole page and show
	objOverlay.style.height = (arrayPageSize[1] + 'px');
	objOverlay.style.display = 'block';

	// preload image
	imgPreload = new Image();

	imgPreload.onload=function(){
		objImage.src = objLink.href;

		// center lightbox and make sure that the top and left values are not negative
		// and the image placed outside the viewport
		var lightboxTop = arrayPageScroll[1] + ((arrayPageSize[3] - 35 - imgPreload.height) / 2);
		var lightboxLeft = ((arrayPageSize[0] - 20 - imgPreload.width) / 2);
		
		objLightbox.style.top = (lightboxTop < 0) ? "0px" : lightboxTop + "px";
		objLightbox.style.left = (lightboxLeft < 0) ? "0px" : lightboxLeft + "px";


		objLightboxDetails.style.width = imgPreload.width + 'px';
		
		if(objLink.getAttribute('title')){
			objCaption.style.display = 'block';
			//objCaption.style.width = imgPreload.width + 'px';
			objCaption.innerHTML = objLink.getAttribute('title');
		} else {
			objCaption.style.display = 'none';
		}
		
		// A small pause between the image loading and displaying is required with IE,
		// this prevents the previous image displaying for a short burst causing flicker.
		if (navigator.appVersion.indexOf("MSIE")!=-1){
			pause(250);
		} 

		if (objLoadingImage) {	objLoadingImage.style.display = 'none'; }

		// Hide select boxes as they will 'peek' through the image in IE
		selects = document.getElementsByTagName("select");
        for (i = 0; i != selects.length; i++) {
                selects[i].style.visibility = "hidden";
        }

	
		objLightbox.style.display = 'block';

		// After image is loaded, update the overlay height as the new image might have
		// increased the overall page height.
		arrayPageSize = getPageSize();
		objOverlay.style.height = (arrayPageSize[1] + 'px');
		
		// Check for 'x' keypress
		listenKey();

		return false;
	}

	imgPreload.src = objLink.href;
	
}





//
// hideLightbox()
//
function hideLightbox()
{
	// get objects
	objOverlay = document.getElementById('overlay');
	objLightbox = document.getElementById('lightbox');

	// hide lightbox and overlay
	objOverlay.style.display = 'none';
	objLightbox.style.display = 'none';

	// make select boxes visible
	selects = document.getElementsByTagName("select");
    for (i = 0; i != selects.length; i++) {
		selects[i].style.visibility = "visible";
	}

	// disable keypress listener
	document.onkeypress = '';
}


	
	/*
	 * Imagen precarga
	 */
	function ImagenPrecarga(src){
		// Precarga y crea la imagen del cargador
		var imgPreloader = new Image();
		
		// Si se encuentra la imagen del cargador, crear un enlace para ocultar la caja de luz y crear loadingimage
		imgPreloader.onload=function(){
	
			/*var objLoadingImageLink = document.createElement("a");
			objLoadingImageLink.setAttribute('href','#');
			objLoadingImageLink.onclick = function () {hideLightbox(); return false;}
			Overlay.appendChild(objLoadingImageLink);*/
			
			var objLoadingImage = document.createElement("img");
				objLoadingImage.src = src;
				objLoadingImage.setAttribute('id','loadingImage');
				objLoadingImage.style.position = 'absolute';
				objLoadingImage.style.zIndex = '150';
				$_('overlay').appendChild(objLoadingImage);
	
			imgPreloader.onload=function(){};	//	Limpio onLoad, ya que el IE saldrá con los gifs animados
	
			return false;
		}
	
		imgPreloader.src = loadingImage;
	}

	/*
	 * Inicio el wyLightBox
	 */
	function init_wyLightbox()
	{
		
		if (!document.getElementsByTagName){ return; }
		var anchors = document.getElementsByTagName("a");
	
		// Realizar un bucle a través de todas las etiquetas "a"
		for (var i=0; i<anchors.length; i++){
			var anchor = anchors[i];
	
			if (anchor.getAttribute("href") && (anchor.getAttribute("rel") == "wylightbox")){
				anchor.onclick = function () {showLightbox(this); return false;}
			}
		}
		
		var objBody = document.getElementsByTagName("body").item(0);
		
		// Crear superposición div
		var Overlay = document.createElement("div");
			Overlay.setAttribute('id','overlay');
			Overlay.onclick = function () {hideLightbox(); return false;}
			Overlay.style.backgroundColor = 'rgba(48,49,49,0.7)';
			Overlay.style.display = 'none';
			Overlay.style.position = 'absolute';
			Overlay.style.top = '0';
			Overlay.style.left = '0';
			Overlay.style.zIndex = '90';
			Overlay.style.width = '100%';
			objBody.insertBefore(Overlay, objBody.firstChild);
		
		var arrayPageSize = getPageSize();
		var arrayPageScroll = getPageScroll();
		
		if( wyLightbox.ImagenPreCarga != '' )
		{
			ImagenPrecarga( wyLightbox.ImagenPreCarga );
		}
	
		// Crear lightbox div
		var Lightbox = document.createElement("div");
			Lightbox.setAttribute('id','lightbox');
			Lightbox.style.backgroundColor = '#eee';
			Lightbox.style.padding = '10px';
			Lightbox.style.borderRadius = '5px';
			Lightbox.style.display = 'none';
			Lightbox.style.position = 'absolute';
			Lightbox.style.zIndex = '100';	
			objBody.insertBefore(Lightbox, Overlay.nextSibling);
			
		// Crear link x cerrar
		var xBoton = document.createElement("a");
			xBoton.setAttribute('href','#');
			xBoton.setAttribute('title','Cerrar');
			xBoton.onclick = function () {hideLightbox(); return false;}
			xBoton.innerHTML = '<span>x</span>';
			xBoton.style.position = 'absolute';
			xBoton.style.display = 'inline-block';
			xBoton.style.backgroundColor = '#000';
			xBoton.style.borderRadius = '50%';
			xBoton.style.padding = '5px 10px 5px 10px';
			xBoton.style.border = '2px solid #fff';
			xBoton.style.color = '#fff';
			xBoton.style.top = '-8px';
			xBoton.style.right = '-8px';
			xBoton.style.textDecoration = 'none';
			xBoton.style.textAlign = 'center';
			xBoton.style.verticalAlign = 'middle';
			xBoton.style.zIndex = '200';
			Lightbox.appendChild(xBoton);
		
		// Crear link imagen
		var LinkImagen = document.createElement("a");
			LinkImagen.setAttribute('href','#');
			LinkImagen.setAttribute('title','Click to close');
			LinkImagen.onclick = function () {hideLightbox(); return false;}
			Lightbox.appendChild(LinkImagen);
	
		/*/ Precarga y crear imagen de botón de cierre
		var imgPreloadCloseButton = new Image();
	
		// Si la imagen del botón cerrar se encontró, 
		imgPreloadCloseButton.onload=function(){
	
			var objCloseButton = document.createElement("img");
			objCloseButton.src = closeButton;
			objCloseButton.setAttribute('id','closeButton');
			objCloseButton.style.position = 'absolute';
			objCloseButton.style.zIndex = '200';
			xBoton.appendChild(objCloseButton);
	
			return false;
		}
	
		imgPreloadCloseButton.src = closeButton;*/
	
		// create image
		var objImage = document.createElement("img");
		objImage.setAttribute('id','lightboxImage');
		LinkImagen.appendChild(objImage);
		
		// create details div, a container for the caption and keyboard message
		var objLightboxDetails = document.createElement("div");
		objLightboxDetails.setAttribute('id','lightboxDetails');
		Lightbox.appendChild(objLightboxDetails);
	
		// create caption
		var objCaption = document.createElement("div");
		objCaption.setAttribute('id','lightboxCaption');
		objCaption.style.display = 'none';
		objLightboxDetails.appendChild(objCaption);
	
		// create keyboard message
		/*var objKeyboardMsg = document.createElement("div");
		objKeyboardMsg.setAttribute('id','keyboardMsg');
		objKeyboardMsg.innerHTML = 'press <a href="#" onclick="hideLightbox(); return false;"><kbd>x</kbd></a> to close';
		objLightboxDetails.appendChild(objKeyboardMsg);*/
	
	
	}



	function addLoadEvent(func)
	{	
		var oldonload = window.onload;
		if (typeof window.onload != 'function'){
			window.onload = func;
		} else {
			window.onload = function(){
				oldonload();
				func({msg:'mensaje de clase'});
			}
		}
	
	}



	addLoadEvent(init_wyLightbox);	