CREATE TABLE `ygefactura` (
  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `codigo_comercio` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_sucursal` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `num_doc` int(11) NOT NULL DEFAULT '0',
  `id_transaccion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_cliente` int(11) NOT NULL DEFAULT '0',
  `sn_pedido` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ss_cart` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fecha_pedido` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `monto_envio` decimal(6,2) NOT NULL DEFAULT '0.00',
  `estado_pago` enum('En proceso','Retenido','Pendiente','Cancelado','Reembolsado') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'En proceso',
  `id_dir_envio` int(11) NOT NULL DEFAULT '0',
  `id_opcion_envio` int(11) NOT NULL DEFAULT '0',
  `id_cli_m_pago` int(11) NOT NULL DEFAULT '0',
  `metodo_pago` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `reembolso` tinyint(1) NOT NULL DEFAULT '0',
  `anulado` tinyint(1) NOT NULL DEFAULT '0',
  `notas` longtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla para la tabla `ygefacturadetalle`
--

CREATE TABLE `ygefacturadetalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `id_factura` int(11) NOT NULL DEFAULT '0',
  `articuloid` int(11) NOT NULL DEFAULT '0',
  `producto` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `imagen` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` int(6) NOT NULL DEFAULT '0',
  `descuento` decimal(12,2) NOT NULL DEFAULT '0.00',
  `precio` decimal(12,2) NOT NULL DEFAULT '0.00',
  `divisa` varchar(6) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'USD',
  `estado_pedido` enum('En proceso','Aceptado','Enviado','Arrivó','Recibido','Anulado') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'En proceso',
  `fecha_aceptacion` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `fecha_max_entrega` date NOT NULL DEFAULT '1000-01-01',
  `fecha_recibido` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `fecha_max_devolucion` date NOT NULL DEFAULT '1000-01-01'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla para la tabla `ygemetodopago`
--

CREATE TABLE `ygemetodopago` (
  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `nombre` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icono` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `api_php` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `api_php_confirmacion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `api_php_ipn` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `divisa` varchar(6) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'USD',
  `seleccionado` tinyint(1) NOT NULL DEFAULT '0',
  `orden` int(11) NOT NULL DEFAULT '0',
  `publicado` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Estructura de tabla para la tabla `ygeempleados`
--

CREATE TABLE `ygeempleados` (
  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `id_empleado` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `num_doc` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `fecha_nacimiento` date NOT NULL DEFAULT '1000-01-01',
  `sexo` enum('Hombre','Mujer','Sin especificar') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Sin especificar',
  `nacionalidad` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PE',
  `foto` longblob NOT NULL,
  `sz_imagen` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1x1',
  `id_cargo` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `profesion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `telefono` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `registro` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `ciudad` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `zip` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pais` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PE',
  `ipusr` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  `estado` enum('Activo','Descanso','Vacaciones','Suspendido','Renuncia','Despido') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Activo',
  `observaciones` longtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
