<?php 
	
	/*
	 *
	 * 2003 - 2021 @ Yal Publicidad
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * Este archivo por si solo no hace nada, pero genera un entorno de sesiones login
	 * SessUsr.php
	 *
	 */
	
	defined('YMS') or die( 'No dispones de acceso' );

	if(!isset($_SESSION)) session_start();

	function str2linkTwy($cadena=NULL){
		if($cadena==NULL) return false;
		$arr	= array('http://','https://');
		$cadena	= str_replace($arr,'',$cadena);
		$l		= 'http://' . $cadena;
		$link	= '<a href="l.php?u=' . urlencode($l) . '">' . trim($cadena,'/') . '</a>';
		return $link;
	} 

	class SessUser{
		private static $dbTbl		= 'ygeclientes';
		private static $keyIniSess	= '_';
		
		private static $idUs2;
		private static $nomUs2;
		private static $keySessUs;
		
		/* arrSess() : establesco sesiones personalizadas del sistema*/
		public static function arrSess($datsSess=array()){
			foreach($datsSess as $c => $v){
				// -- creo el nombre clave de la sesion
				$nom_sess = self::$keyIniSess.$c;
				$_SESSION[$nom_sess] = $v;
			}
		}
		
		/* dbtabla() : establesco la tabla contenedora de los datos de usuario */
		public static function dbtabla($tabla=NULL){
			if(!empty($tabla)){
				self::$dbTbl = $tabla;
			}
			return false;
		}
		
		/* dbtabla() : establesco llave de sesion de login */
		public static function keyIniSess($key=NULL){
			if(!empty($key)){
				self::$keyIniSess = $key;
			}
			return false;
		}
		
		/* obtSess() : obtengo session almacena en array del sistema */
		public static function obtSess($datsSess = NULL){
			// -- creo el nombre clave de la sesion
			$nom_sess = self::$keyIniSess.$datsSess;
			// -- obtengo sesion almacenada
			$sesion = (isset($_SESSION[$nom_sess])) ? $_SESSION[$nom_sess] : false;
			return $sesion;
		}
		
		/* esSessUs() : retorna 'true' si la es válida */
		public static function esSessUs(){
			// -- creo el nombre clave de la sesion
			$nom_sess = self::$keyIniSess;
			// -- obtengo las sesiones de usuario
			$ipUs	= $_SERVER['REMOTE_ADDR'];
			$idUs	= (isset($_SESSION[$nom_sess.'idUs'])) ? $_SESSION[$nom_sess.'idUs'] : 0; // ID de susuario
			$eUs	= (isset($_SESSION[$nom_sess.'eUs'])) ? $_SESSION[$nom_sess.'eUs'] : 'null@null'; // email de usuario
			
			// -- obtengo token de sesion de usuario
			$keySessUsR	= _mysql_obtener_reg(self::$dbTbl, "id='$idUs' AND estado_cuenta=1", "passwordtoken");
			// -- obtengo nombre valor de sesion
			$keySessUs	= encriptar($eUs, $idUs);
			$keySessUs	= $_SESSION[$nom_sess.'sessUs'.$keySessUs];
			
			return ($keySessUs === $keySessUsR) ? true : false;
		}
		
		/* estalecerSessUs($nomUs) : establece el key de sesion 
		 * @param  str    $nomUs    nombre del usuario que se le generara el key de sesion 
		 */
		public static function estalecerSessUs($datsSess=array()){
			// -- creo el nombre clave de la sesion
			$nom_sess = self::$keyIniSess.$datsSess;
			
			$ipUs	= $_SERVER['REMOTE_ADDR'];
			$idUs	= $_SESSION[$nom_sess.'idUs'] = (isset($datsSess['id'])) ? $datsSess['id'] : 0;
			$eUs	= $_SESSION[$nom_sess.'eUs'] = (isset($datsSess['usuario'])) ? $datsSess['usuario'] : 'null@null';
			$nomUs	= $_SESSION[$nom_sess.'nomUs'] = (isset($datsSess['usuarionombre'])) ? $datsSess['usuarionombre'] : '@null';
			
			$keySessUs= encriptar($eUs, $idUs);
			$_SESSION[$nom_sess.'sessUs'.$keySessUs] = encriptar($eUs, $ipUs);
			// -- * Guardo el key
			_mysql_query("UPDATE " . self::$dbTbl . " SET passwordtoken='". $_SESSION[$nom_sess.'sessUs'.$keySessUs] ."', ultimo_acceso='" . date('Y-m-d H:i:s') . "', ip='$ipUs' WHERE id='$idUs'");
		}
		
		/* mailMsjTpl : plantilla de mensaje que se enviará por email */
		public static function mailMsjTpl($tpl, $bv = array(), $rv = array()){
			if(file_exists($tpl)){
				$cnt	= file_get_contents($tpl);
				$cnt	= str_replace($bv,$rv,$cnt);
				return $cnt;
			}
			return false;
		}
		
		/* 
		 * otbUs : obtiene el usuario activo
		 * @param  str    $porDefecto    Cadena por defecto que se mostrará en caso no otenga usuario activo
		 */
		public static function obtUs($porDefecto=NULL){
			// -- creo el nombre clave de la sesion
			$nom_sess = self::$keyIniSess.$datsSess;
			return ( isset($_SESSION[$nom_sess.'eUs']) ) ? $_SESSION[$nom_sess.'eUs'] : 'Invitado';
		}
		
		/* 
		 * otbIdUs() : obtiene el ID de usuario activo
		 */
		public static function obtIdUs(){
			// -- creo el nombre clave de la sesion
			$nom_sess = self::$keyIniSess.$datsSess;
			return ( isset($_SESSION[$nom_sess.'idUs']) ) ? $_SESSION[$nom_sess.'idUs'] : 0;
		}
		
		/* 
		 * otbNomUs : obtiene el nomre de usuario activo
		 * @param  str    $porDefecto    Cadena por defecto que se mostrará en caso no otenga usuario activo
		 */
		public static function obtNomUs($porDefecto=NULL){
			// -- creo el nombre clave de la sesion
			$nom_sess = self::$keyIniSess.$datsSess;
			return ( isset($_SESSION[$nom_sess.'nomUs']) ) ? $_SESSION[$nom_sess.'nomUs'] : 'Invitado';
		}
		
		/* obtSessUs : obtiene el key de sesion */
		public static function obtSessUs(){
			// -- creo el nombre clave de la sesion
			$nom_sess = self::$keyIniSess.$datsSess;
			return ( self::esSessUs() ) ? $_SESSION[$nom_sess.'sessUs'] : false;
		}
		
		/* linkPost() : obtiene la url actual de la pagina */
		public static function linkPost(){
			
			$isSecure = false;
			if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
				$isSecure = true;
			}elseif (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https' || !empty($_SERVER['HTTP_X_FORWARDED_SSL']) && $_SERVER['HTTP_X_FORWARDED_SSL'] == 'on') {
				$isSecure = true;
			}
			$http = $isSecure ? 'https:' : 'http:';
			
			$link = $http. '//' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\') . '/' . html_slug();
			return $link;
		}
	}
	
?>
