<?php
	/*
	 *
	 * 2003 - 2021 @ Yal Publicidad - yPanel
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 *
	 */
	
	/* Autorizo acceso */
		defined('YPANEL_INI') or die( 'No dispones de acceso' );

function crearBoton($idBtn,$atributos=NULL){
	return Boton::crear($idBtn,$atributos);
}

class Boton{
	private static $atributos = array("class"=>"nuevo");
	
	public static function crear($idBtn,$atributos=NULL){
		// obtengo atributos del boton
		$batributos			= (!empty($atributos)) ? $atributos() : array();
		// id de boton
		$batributos['id']	= (!empty($idBtn)) ? $idBtn : '';
		// texto del boton
		$texto				= '';
		// icono
		$icono				= (isset($batributos['icon'])) ? $batributos['icon'] : '';
		$batributos['icon']	= '';
		// 
		switch( $idBtn ){
			case 'nuevo':
				$icono = (!empty($icono)) ? $icono : '<i class="fa fa-plus"></i> ';
				$texto = (isset($batributos['text'])) ? $batributos['text'] : etiqueta( 'b_nuevo', 'Nuevo' );
				$batributos['type']	= 'button';
				$batributos['name']	= $idBtn;
				$batributos['onClick']	= ( isset($batributos['onClick'])) ? $batributos['onClick'] : 'efacc(\'nuevo\')';
				break;
						
			case 'editar':
				$icono = (!empty($icono)) ? $icono : '<i class="fas fa-pencil-alt"></i> ';
				$texto = (isset($batributos['text'])) ? $batributos['text'] :etiqueta( 'b_actualizar', 'Actualizar datos' );
				$batributos['type']	= 'button';
				$batributos['name']	= $idBtn;
				$batributos['onClick']	= 'efacc(\'editar\')';
				break;
						
			case 'guardar':
				$icono = (!empty($icono)) ? $icono : '<i class="fa fa-save"></i> ';
				$texto = (isset($batributos['text'])) ? $batributos['text'] : etiqueta( 'b_guardar', 'Guardar cambios' );
				$batributos['name']	= $idBtn;
				break;
					
			case 'cancelar':
				$icono = (!empty($icono)) ? $icono : '<i class="fad fa-times-circle"></i> ';
				$texto = (isset($batributos['text'])) ?  $batributos['text'] : etiqueta( 'b_cancelar', 'Cancelar' );
				$batributos['type']	= 'button';
				$batributos['name']	= $idBtn;
				$batributos['onClick']	= 'efacc(\'cancelar\')';
				break;
						
			case 'cerrar':
				$icono = (!empty($icono)) ? $icono : '<i class="fa fa-close"></i> ';
				$texto = (isset($batributos['text'])) ?  $batributos['text'] : etiqueta( 'b_cerrar', 'Cerrar' );
				$batributos['type']	= 'button';
				$batributos['name']	= $idBtn;
				$batributos['onClick']	= (isset($batributos['onClick'])) ? $batributos['onClick'] : 'efacc(\'cerrar\')';
				break;
						
			case 'salir':
				$icono = (!empty($icono)) ? $icono : '<i class="fad fa-times"></i> ';
				$texto = (isset($batributos['text'])) ?  $batributos['text'] : etiqueta( 'b_cerrar', 'Cerrar' );
				$batributos['type']	= 'button';
				$batributos['name']	= $idBtn;
				$batributos['onClick']	= (isset($batributos['onClick'])) ? $batributos['onClick'] : 'efacc(\'salir\')';
				break;
						
			default:
				$batributos['class'] = (isset($batributos['class'])) ?  'b-clasico '.$batributos['class'] : 'b-clasico';
				$texto	= (isset($batributos['text'])) ?  $batributos['text'] : '';
		}
		
		$boton			= '';
		$btn_atributos	= ' ';
		// si icono es diferente a nulo
		$icono			= ($icono!='nulo') ? $icono . ' ' : '';
		// leo atributos del boton
		foreach($batributos as $k => $v){
			$btn_atributos .= $k . '="' . $v .'" ';
		}
		// creo el boton
		$boton	= '<button' . $btn_atributos . '>' . $icono . $texto . '</button>';
		
		return $boton;
	}
}
	
?>