<?php
	
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * Plantilla original Weby+
	 *
	 */
	 
	 /* Autorizo acceso */
		defined('WY_INI_WEBY') or die( 'No dispones de acceso' );
		
		$_SESSION['cc_captcha'] = rand(10,999999);
		
?>

<!DOCTYPE HTML>
<html>
	<head>
		<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" />
		<?php 
			obt_head();
		?>
		<link rel="stylesheet" href="<?php echo obt_base(); ?>/css/main.css" />
		<noscript><link rel="stylesheet" href="<?php echo obt_base(); ?>/css/noscript.css" /></noscript>
		
		<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script></script>
		<script type="text/javascript">
			$(function() {
			  $('a[href*=#]:not([href=#])').click(function() {
				if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {
				  var target = $(this.hash);
				  target = target.length ? target : $('[name=' + this.hash.slice(1) +']');
				  if (target.length) {
					$('html,body').animate({
					  scrollTop: target.offset().top
					}, 1000);
					return false;
				  }
				}
			  });
			});
		</script>
		
		<script type="text/javascript">
			window.onscroll = function(){
				var scroll = document.documentElement.scrollTop || document.body.scrollTop;
				
				var $intro = document.querySelector('#intro');
				var $header= document.querySelector('.logo');
				
				if(scroll > 150){		
					$intro.style.opacity=0;
					$header.style.visibility='visible';
					$header.style.opacity=1;
				}else{
					$intro.style.opacity=1;
					$header.style.opacity=0;
					$header.style.visibility='hidden';
				}
			}
		</script>
	
	</head>
	
	<body class="">
		
		<!-- Wrapper -->
			<div id="wrapper" class="fade-in">

				<!-- Intro -->
					<div id="intro">
						<h1><?php echo obt_nombre_organizacion(); ?></h1>
						<p>Bienvenidos<br /><?php echo obt_email(); ?>.</p>
						<ul class="actions">
							<li><a href="<?php echo obt_slug() ?>#header" class="button icon solo fa-arrow-down scrolly">Continuar</a></li>
						</ul>
					</div>

				<!-- Header -->
					<header id="header">
						<a href="./" class="logo"><?php echo obt_nombre_organizacion(); ?></a>
					</header>

				<!-- Nav -->
					<nav id="nav">
						<?php echo obt_menu( '_top', 'class="links"' ); ?>
						<?php echo obt_menu_sociales('class="icons"'); ?>
					</nav>

				<!-- Main -->
					<div id="main">
						<!-- Posts -->
						<?php
							// Pagina por secciones
							if( es_seccion( 'buscar' ) ) :
									$wy->Importar( 'wy_buscar', 'plantilla/contenido' );
									//include_once('wy_buscar.php');
							else :
								$q = obt_contenido( NULL, NULL, 'id DESC LIMIT 0,1');
								$r = _mysql_fetch_array( $q );
						?>
						<!-- Featured Post -->
							<article class="post featured">
								<header class="major">
									<span class="date"><?php echo fecha( $r['fecha'], 'F j\\, Y' ); ?></span>
									
									<div class="share">
										<?php echo ( es_post() ) ? compartir_post( $r['id'], utf8_encode( $r['textocorto'] ) ) : ''; ?> 
									</div>
									
									<h2><?php echo ( es_post() ) ? utf8_encode( $r['titulo'] ) : '<a href="' . obt_slug($r['id'], 'Contenido' ) . '">' . utf8_encode( $r['titulo'] ) . '</a>'; ?></h2>
									<p><?php echo utf8_encode( $r['textocorto'] ) ?></p>
								</header>
								<?php 
									if( $r['imagenpost'] != NULL ) : 
										echo ( es_post() ) ? '<img src="' . $r['imagenpost'] . '" alt="">' : '<a class="image main" href="' . obt_slug($r['id'], 'Contenido' ) . '"><img src="' . $r['imagenpost'] . '" alt=""></a>'; 
									endif; 
									
									if( es_post() ) :
								?>
								<p><?php echo utf8_encode( $r['texto'] ) ?></p>
								<?php
									endif;
									
									if( !es_post() ) :
								?>
								<ul class="actions special">
									<li><a href="<?php echo obt_slug($r['id'], 'Contenido' ) ?>" class="button large">Leer más</a></li>
								</ul>
								<?php
									endif;
								?>
							</article>

						<!-- Posts -->
							<section class="posts">
							<?php
								$q1 = obt_contenido( NULL, NULL, 'id DESC LIMIT 1,9');
								while( $r1 = _mysql_fetch_array( $q1 ) ):
											$PadreId = $r1['id'];
											$titulo_entrada = utf8_encode( $r1['titulo'] );
											//$wy->obt_slug( $r['id'], 'Contenido' );
							?>
								<article>
									<header>
										<span class="date"><?php echo fecha( $r1['fecha'], 'F j\\, Y' ); ?></span>
										<h2><?php echo ( es_post() ) ? utf8_encode( $r1['titulo'] ) : '<a href="' . obt_slug($r1['id'], 'Contenido' ) . '">' . utf8_encode( $r1['titulo'] ) . '</a>'; ?></h2>
									</header>
									<?php 
										if( $r1['imagenpost'] != NULL ) : 
											echo ( es_post() ) ? '<img src="' . $r1['imagenpost'] . '" alt="">' : '<a class="image fit" href="' . obt_slug($r1['id'], 'Contenido' ) . '"><img src="' . $r1['imagenpost'] . '" alt=""></a>'; 
										endif; 
									?>
									<p><?php echo resumirTexto( utf8_encode( $r1['textocorto'] ), 150, true ) ?></p>
									<ul class="actions special">
										<li><a href="<?php echo obt_slug($r1['id'], 'Contenido' ) ?>" class="button">Leer más</a></li>
									</ul>
								</article>
							<?php				
								endwhile;
							endif;
							?>
							</section>

						<!-- Footer -->
							<!--footer>
								<div class="pagination">
									<!--<a href="#" class="previous">Prev</a>-->
									<!--a href="#" class="page active">1</a>
									<a href="#" class="page">2</a>
									<a href="#" class="page">3</a>
									<span class="extra">&hellip;</span>
									<a href="#" class="page">8</a>
									<a href="#" class="page">9</a>
									<a href="#" class="page">10</a>
									<a href="#" class="next">Next</a>
								</div>
							</footer-->
							
							<footer><?php echo obt_mapa(); ?></footer>

					</div>
				<!-- Footer -->
					<footer id="footer">
						<section>
							<script language="JavaScript" type="text/javascript">
									function eConsulta2( x ){
											
										if( x.name.value.length < 3 ){
											MsjBox.mostrar('Ingrese su nombre por favor.');
											x.name.focus();
											return false;
										} if( x.email.value.length < 10 ){
											MsjBox.mostrar('Ingrese su email.');
											x.email.focus();
											return false;
										} if( x.message.value.length < 7 ){
											MsjBox.mostrar('Ingrese su mensaje.');
											x.message.focus();
											return false;
										} 
										
										MsjBox.mostrar('Enviando consulta, espere...');
																	
										WebyPlus.ajax({
												url: '<?php echo obt_base(); ?>/wy-prcss.php',
												metodo: 'POST',
												data: 'ac=eConsulta&nombre=' + x.name.value + '&email=' + x.email.value + '&mensaje=' + x.message.value + '&key=<?php echo md5($_SESSION['cc_captcha']) . '-' . $_SESSION['cc_captcha'] . '-' . rand(11111,999999); ?>',
												contenidoTipo: 'application/x-www-form-urlencoded',
												suceso: function(respuesta){
																if( respuesta == 0 ){
																	MsjBox.mostrar('¡Error de envío!');
																} if( respuesta == 1 ){
																	MsjBox.mostrar('La consulta se envió con éxito.');
																	x.name.value='';
																	x.email.value='';
																	x.message.value='';
																} if( respuesta == 2 ){
																	MsjBox.mostrar('¡FALLÓ CONEXIÓN! La solicitud no pudo ser enviada.');
																}
																
														}
											});
										
										return false;
									}
										
							</script>
							<form method="post" action="#" onSubmit="eConsulta2(this);return false;">
								<div class="fields">
									<div class="field">
										<label for="name">Name</label>
										<input type="text" name="name" id="name" />
									</div>
									<div class="field">
										<label for="email">Email</label>
										<input type="text" name="email" id="email" />
									</div>
									<div class="field">
										<label for="message">Message</label>
										<textarea name="message" id="message" rows="3"></textarea>
									</div>
								</div>
								<ul class="actions">
									<li><input type="submit" value="Enviar Consulta" /></li>
								</ul>
							</form>
						</section>
						<section class="split contact">
							<section class="alt">
								<h3>Dirección</h3>
								<p><?php echo obt_direccion(); ?></p>
							</section>
							<section>
								<h3>Teléfono</h3>
								<p><?php echo obt_telefono(); ?></p>
							</section>
							<section>
								<h3>Email</h3>
								<p><?php echo obt_email(); ?></p>
							</section>
							<section>
								<h3>Social</h3>
								<?php echo obt_menu_sociales('class="icons alt"'); ?>
							</section>
						</section>
					</footer>

				<!-- Copyright -->
					<div id="copyright">
						<ul><li><?php obt_copyRight(); ?></li></ul>
					</div>

			</div>

	</body>
</html>