<?php
	/*
	 *
	 * yMS (c) 2003 - 2022 Yal Publicidad
	 * Sistema: Macrodígital Software - de Yal Publicidad
	 *
	 */
	 
	 /* Autorizo acceso */
		defined('YMS') or die( 'No dispones de acceso' );

	// saber si el login esta en sesion abierta
	function loginEnSesion(){
		return yMSISess::en_sesion();
	}
	// establecer sesion login 
	function loginEstablecerSesion($datsSess=array(),$recordarme=false){
		yMSISess::establecerSesion($datsSess,$recordarme);
	}
	// obtener el ID de usuario
	function loginIdUsuario(){
		return yMSISess::obtIdUs();
	}
	// definir si es multi login
	function loginMultiSesion($multisesion=false){
		yMSISess::multisess($multisesion);
	}
	// obtener el nombre de usuario
	function loginNomUsuario($porDefecto=NULL){
		return yMSISess::obtNomUsuario($porDefecto);
	}
	// obtener sesion almacenada
	function loginObtSesion($nomSess = NULL){
		return yMSISess::obtSesion($nomSess);
	}
	// obtener/definir tabla de login
	function loginTabla($tabla=NULL){
		return yMSISess::tabla($tabla);
	}
	// obtener el nombre de usuario
	function loginUsuario($porDefecto=NULL){
		return yMSISess::obtUs($porDefecto);
	}
	

	class yMSISess{
		private static $dbTbl		= 'ygeclientes';
		private static $multiSess	= false;
		
		private static $idUs2;
		private static $nomUs2;
		private static $keySessUs;
		
		/* arrSess() : almaceno sesiones personalizadas al momento de loguearse
		 * @param array    $datsSess    array de sesiones 
		 * ej. array(array1, array2, array3, array4,...)
		*/
		private static function arrSess($datsSess=array()){
			$salaSess = self::$dbTbl;
			foreach($datsSess as $c => $v){
						$_SESSION[$salaSess.$c] = $v;
			}
		}
		
		/* estSesion() : almaceno session personalizada 
		 * @param str    $nomSess    Nombre de la sesion a almacenar
		 * @param str    $valorSess  Valor de la sesion a almacenar
		 */
		public static function estSesion($nomSess, $valorSess = NULL){
			if(empty($nomSess)) return false;
			$sesion = $_SESSION[self::$dbTbl.$nomSess] = $valorSess;
			return $sesion;
		}
		
		/* obtSesion() : obtengo session almacena en el logueo 
		 * @param str    $nomSess    Nombre de la sesion a almacenar
		 */
		public static function obtSesion($nomSess = NULL){
			$sesion = (isset($_SESSION[self::$dbTbl.$nomSess])) ? $_SESSION[self::$dbTbl.$nomSess] : false;
			return $sesion;
		}
		
		/* esSessUs() : retorna 'true' si la sesion esta abierta */
		public static function en_sesion(){
			// verifico si el usuario marcó recordarme
			$recordarme= y_sesion(self::$dbTbl."rec0rdarm3");
			if($recordarme>0){
				//$datsSess = json_decode($_COOKIE[self::$dbTbl."datsSess"],true);
				$datsSess = json_decode(y_sesion(self::$dbTbl."datsSess"),true);
				if(is_array($datsSess)){
					foreach($datsSess as $c => $v){
						$_SESSION[self::$dbTbl.$c] = $v;
					}
				}
			}
			// -- obtengo las sesiones de usuario
			$idUs	= ( isset($_SESSION[self::$dbTbl.'id']) ) ? $_SESSION[self::$dbTbl.'id'] : 0;
			$eUs	= ( isset($_SESSION[self::$dbTbl.'usuario']) ) ? $_SESSION[self::$dbTbl.'usuario'] : false;
			// recupero el nombre de sesion de usuario
			$nomKeySessUs= encriptar(self::$dbTbl.$eUs, $idUs);
			// -- obtener sesion de usuario registrada
			$keySessUsR	= _mysql_obtener_reg(self::$dbTbl, "id='$idUs' AND estado_cuenta=1", "passwordtoken");
			// recupero key de sesion principal
			$keySessUsC	= $_SESSION[self::$dbTbl.$nomKeySessUs];
			
			// si se ha definido multi sesion, aplico el siguiente script
			if(self::$multiSess){
				if(!empty(y_sesion('multisess'.$keySessUsC))){
					$keySessUsR	= trim(y_sesion('multisess'.$keySessUsC));
				}
			} 
			// si es una sola sesion
			return ($keySessUsC === $keySessUsR) ? true : false;
		}
		
		/* estalecerSessUs($nomUs) : establece el key de sesion 
		 * @param  str    $nomUs    nombre del usuario que se le generara el key de sesion 
		 * ej. array('id'=>1,'usuario'=>'mail@mail.com','nomUsuario'=>'Jose Perez', array3, array4,...)
		 *
		 * Nota: los nombres obligatorios para que inicie sesion son id, usuario, usuarionombre
		 */
		public static function establecerSesion($datsSess=array(),$recordarme=false){
			// obtengo la IP remota
			$ipUs	= $_SERVER['REMOTE_ADDR'];
			// creo sesiones: ID, USUARIO, NOMBREUSUARIO
			$idUs	= $datsSess['id']		= (isset($datsSess['id'])) ? $datsSess['id'] : 0;
			$eUs	= $datsSess['usuario']	= (isset($datsSess['usuario'])) ? $datsSess['usuario'] : 'null@null';
			$datsSess['nomUsuario']			= (isset($datsSess['nomUsuario'])) ? $datsSess['nomUsuario'] : '@null';
			
			self::arrSess($datsSess);
			
			// sal de sesion
			$sessSal= (time() + ($idUs*60));
			// creo nombre key de sesion
			$nomKeySessUs= encriptar(self::$dbTbl.$eUs, $idUs);
			$valKeySessUs= $sessSal.md5(encriptar($eUs, $ipUs));
			$_SESSION[self::$dbTbl.$nomKeySessUs] = $valKeySessUs;
			// si se ha definido multi sesion, aplico el siguiente script
			if(self::$multiSess) y_sesion('multisess'.$valKeySessUs,$valKeySessUs,$recordarme);
			// -- * Guardo el key
			_mysql_query("UPDATE " . self::$dbTbl . " SET passwordtoken='". $valKeySessUs ."', ultimo_acceso='" . date('Y-m-d H:i:s') . "', ip='$ipUs' WHERE id='$idUs'");
			
			// creo recordarme
			//setcookie( self::$dbTbl."rec0rdarm3", $recordarme, time()+(60*60*24*30) ); // 30 dias
			y_sesion(self::$dbTbl."rec0rdarm3", $recordarme, true);
			if($recordarme){
				$datsSess[$nomKeySessUs] = $valKeySessUs; 
				y_sesion( self::$dbTbl."datsSess", json_encode($datsSess), true ); // 30 dias
				///setcookie( self::$dbTbl."datsSess", json_encode($datsSess), strtotime( '+30 days' ) );
			}
		}
		
		/* mailMsjTpl : plantilla de mensaje que se enviará por email */
		public static function mailMsjTpl($tpl, $bv = array(), $rv = array()){
			if(file_exists($tpl)){
				$cnt	= file_get_contents($tpl);
				$cnt	= str_replace($bv,$rv,$cnt);
				return $cnt;
			}
			return false;
		}
		/* 
		 * multisess() : si es true permite mas de una sesión por usuario 
		 *
		 * Nota: debe colarse al inicio del script
		 */
		public static function multisess($multisesion=false){
			self::$multiSess = $multisesion;
		}
		
		/* 
		 * otbUs : obtiene el usuario activo
		 * @param str    $porDefecto    Cadena por defecto que se mostrará en caso no otenga usuario activo
		 */
		public static function obtUs($porDefecto=NULL){
			return ( isset($_SESSION[self::$dbTbl.'usuario']) ) ? $_SESSION[self::$dbTbl.'usuario'] : false;
		}
		
		/* 
		 * otbIdUs() : obtiene el ID de usuario activo
		 */
		public static function obtIdUs(){
			return ( isset($_SESSION[self::$dbTbl.'id']) ) ? $_SESSION[self::$dbTbl.'id'] : 0;
		}
		
		/* 
		 * otbNomUs : obtiene el nomre de usuario activo
		 * @param str    $porDefecto    Cadena por defecto que se mostrará en caso no otenga usuario activo
		 */
		public static function obtNomUsuario($porDefecto=NULL){
			return ( isset($_SESSION[self::$dbTbl.'nomUsuario']) ) ? $_SESSION[self::$dbTbl.'nomUsuario'] : 'Invitado';
		}
		
		/* 
		 * tabla : obtiene/establece el nombre de tabla activa
		 * @param str    $tabla    Si es NULL obtiene el nombre de la tabla.
		 *                         Si es diferente a NULL establece el nombre de la tabla.
		 */
		public static function tabla($tabla=NULL){
			if(empty($tabla)) return self::$dbTbl;
			self::$dbTbl = $tabla;
		}
		
		
		/* linkPost() : obtiene la url actual de la pagina */
		private static function linkPost(){
			
			$isSecure = false;
			if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
				$isSecure = true;
			}elseif (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https' || !empty($_SERVER['HTTP_X_FORWARDED_SSL']) && $_SERVER['HTTP_X_FORWARDED_SSL'] == 'on') {
				$isSecure = true;
			}
			$http = $isSecure ? 'https:' : 'http:';
			
			$link = $http. '//' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\') . '/' . html_slug();
			return $link;
		}
	}
?>