<?php
	/*
	 *
	 * yMS (c) 2003 - 2021 Yal Publicidad
	 * Sistema: Macrodígital Software - de Yal Publicidad
	 *
	 */
	 
	 /* Autorizo acceso */
		defined('YMS') or die( 'No dispones de acceso' );
		
	if( !class_exists( 'yMSError' ) ) die( '<br><b>Error:</b> La librería @lib.y_error es necesaria para la ejecución de esta aplición.' );
	
	function archivo_ini( $camino_archivo, $matriz = array(), $acc = 'l', $multi_secciones = true, $modo = 'w' ){
		return yMSfunciones::archivo_ini( $camino_archivo, $matriz, $acc, $multi_secciones, $modo );
	}
	
	function bytes2Mb( $bytes = 0 ){
		return yMSfunciones::convertirBytes2Mb( $bytes );
	}

	function calcEdad($fNacimiento=NULL){
		if($fNacimiento==NULL) return 0;
		$nacimiento = new DateTime($fNacimiento);
		$ahora = new DateTime(date("Y-m-d"));
		$dif = $ahora->diff($nacimiento);
		return $dif->format("%y");
	}

	function comprimir( $ubicacion, $carpeta, $zip ){
		return yMSfunciones::comprimir( $ubicacion, $carpeta, $zip );
	}
	
	function encriptar( $cadena, $llave, $acc = 'encriptar', $cod = 'base64') {
		return yMSfunciones::encriptar( $cadena, $llave, $acc, $cod );
	}
	
	function extraerHref( $tag_a ){
		return yMSfunciones::extraerHref( $tag_a );
	}
	
	function extraerNum( $cadena ){
		return yMSfunciones::extraerNum( $cadena );
	}
	
	function extraerTitle( $url ){
		return yMSfunciones::extraerTitle( $url );	
	}
	
	function genCodigo( $longitud ) {
			$key = '';
			$pattern = '1234567890abcdefghijklmnopqrstuvwxyz';
			$max = strlen($pattern)-1;
			for($i=0;$i < $longitud;$i++) $key .= $pattern{mt_rand(0,$max)};
			return $key;
	}

	function guardar_archivo( $nombre, $contenido = '', $dir_salida = '' ){
		return yMSfunciones::guardar_archivo( $nombre, $contenido, $dir_salida );	
	}

	function http_construir_url(){
		return yMSfunciones::http_construir_url();
	}
	
	function linea2li( $cadena, $ol = false ){
		return yMSfunciones::linea2li( $cadena, $ol );
	}
	
	function obtener_contenido_remoto( $archivo ){
		// -- Si existe cUrl, obtengo los datos con cUrl
		if( function_exists('curl_init') ){
			return yMSfunciones::curl( $archivo );
		}
		// -- Si no existe cUrl, utilizo file_get_contents()
		if( function_exists( 'file_get_contents' ) ){
			return file_get_contents( $archivo );
		}
		return false;
	}
	
	function obt_curl( $url, $timeout = 10 ){
		return yMSfunciones::curl( $url, $timeout );
	}
	
	function obtIsp($ip=NULL) {
		if (empty($ip)) $ip = $_SERVER['REMOTE_ADDR'];
		$longisp = @gethostbyaddr($ip);
		$isp = explode('.', $longisp);
		$isp = array_reverse($isp);
		$tmp = $isp[1];
		if (preg_match("/\<(org?|com?|net)\>/i", $tmp)) {
			$myisp = $isp[2].'.'.$isp[1].'.'.$isp[0];
		} else {
			$myisp = $isp[1].'.'.$isp[0];
		}
		return preg_match("/[0-9]{1,3}\.[0-9]{1,3}/", $myisp) ? $ip : $myisp;
	}

	function obtWatchYouTube( $url_video ){
		return yMSfunciones::obtWatchYouTube( $url_video );
	}
	
	function OS(){
		return yMSfunciones::OS();	
	}
	
	function quitar_acentos( $cadena ){
		return yMSfunciones::quitar_acentos( $cadena );
	}
	
	function quitar_tags( $cadena_html ){
		return yMSfunciones::quitar_tags( $cadena_html );	
	}
	
	function resumirTexto( $cadena, $num_caracteres = 55, $sacarTags=false ){
		return yMSfunciones::resumirTexto( $cadena, $num_caracteres, $sacarTags );
	}
	
	function tamanoDir( $dir = ".", $subdirs = true ){
		return yMSfunciones::tamanoDir( $dir, $subdirs );
	}
	
	function texto2postfb( $string, $target='_blank' ){
		return yMSfunciones::texto2postfb( $string, $target );
	}

	function texto2twiiny( $string='', $target='_blank' ){
		return yMSfunciones::texto2twiiny( $string, $target );
	}
	
	function texto2tweet( $string, $target='_blank' ){
		return yMSfunciones::texto2tweet( $string, $target );
	}
	
	function url_codificar($cadena, $acc = 'codificar', $base64 = true){
		return yMSfunciones::url_codificar( $cadena, $acc, $base64 );
	}

	function url_encriptar($string=NULL,$llave='=@',$acc='E',$tcod='hex'){
		if (empty($string)) return false;
		$llave	= (empty($llave)) ? '=@/&--' : $llave; 
		$acc	= strtolower($acc);
		$acc	= ($acc=='d') ? 'desencriptar' : 'encriptar';
		return encriptar($string, $llave, $acc, $tcod);
	}
	
	// url_existe( string $url = NULL ) : bool
	function url_existe( $url = NULL ) {
		return yMSfunciones::url_existe( $url );	
	}
	
	/*function y_sesion( $clave, $valor = NULL ){
		return yMSfunciones::ySesion( $clave, $valor );
	}*/
	
	function y_sesion_destruir(){
		return yMSfunciones::ySesionDestruir();
	}
	
	/* --------------------------------- *\
		clase de modulo
	\* --------------------------------- */
	
	class yMSfunciones {
		
		public static $ySesion_uri;
		
		/**
		 * archivo_ini - Funcion para escribir o leer ficheros INI 
		 * archivo_ini( array( "matriz_1" => array(  ) ) );
		 * @param string    $camino_archivo    Ruta del fichero INI a leer o escribir
		 * @param array     $matriz            Array que se escribirá
		 * @param string    $acc               Acción a realizar, 'l'=leer, 'e'=escribir
		 * @param bool      $multi_secciones   true si se creará multi secciones
		 * @param string    $modo              Modo en que se abrirá el archivo. Por defecto 'w'		
		 */
		public static function archivo_ini( $camino_archivo, $matriz = array(), $acc = 'l', $multi_secciones = true, $modo = 'w' ) 
		{	
			$salida = '';
			
			if( strtolower( $acc ) == 'e' ){
				# saltos de línea (usar "\r\n" para Windows)
				define( 'SALTO', "\n" );
				
				if ( !is_array( current( $matriz ) ) ) {
					$tmp = $matriz;
					$matriz['tmp'] = $tmp; # no importa el nombre de la sección, no se usará
					unset($tmp);
				}
				
				foreach( $matriz as $clave => $matriz_interior ) {
					if ($multi_secciones) {
						$salida .= '['.$clave.']' . SALTO;
					}
		
					foreach($matriz_interior as $clave2 => $valor)
						$salida .= $clave2.' = "'.$valor.'"'.SALTO;
		
					if ($multi_secciones) {
						$salida .= SALTO;
					}
				}
		
				$puntero_archivo = fopen($archivo, $modo);
		
				if ($puntero_archivo !== false) {
					$escribo = fwrite($puntero_archivo, $salida);
		
					if ($escribo === false) {
						$devolver = -2;
					} else {
						$devolver = $escribo;
					}
		
					fclose($puntero_archivo);
				} else {
					$devolver = -1;
				}
		
				return $devolver;
			}else{
				
				if( !file_exists( $camino_archivo ) ) return false;
				
				$filepath = $camino_archivo;
				$ini = file( $filepath );
				if ( count( $ini ) == 0 ) { return array(); }
				$sections = array();
				$values = array();
				$globals = array();
				$i = 0;
				foreach( $ini as $line ){
					$line = trim( $line );
					// Comments
					if ( $line == '' || $line{0} == ';' ) { continue; }
					// Sections
					if ( $line{0} == '[' ) {
						$sections[] = substr( $line, 1, -1 );
						$i++;
						continue;
					}
					// Key-value pair
					list( $key, $value ) = explode( '=', $line, 2 );
					$key = trim( $key );
					$value = trim( $value );
					if ( $i == 0 ) {
						// Array values
						if ( substr( $line, -1, 2 ) == '[]' ) {
							$globals[ $key ][] = $value;
						} else {
							$globals[ $key ] = $value;
						}
					} else {
						// Array values
						if ( substr( $line, -1, 2 ) == '[]' ) {
							$values[ $i - 1 ][ $key ][] = $value;
						} else {
							$values[ $i - 1 ][ $key ] = $value;
						}
					}
				}
				for( $j=0; $j<$i; $j++ ) {
					$result[ $sections[ $j ] ] = $values[ $j ];
				}
				return $result + $globals;
			}
		}
		
		/**
		 * convertirBytes2Mb - Convertir bytes a MB
		 * @param int    $bytes     Numero de bytes a convertir en MB
		 */
		public static function convertirBytes2Mb( $bytes = 0 ){
			
			if( $bytes > 1023 && $bytes < 1048576 )
				return number_format( ( $bytes / 1024 ), 2 ) . ' kb';
				
			if( $bytes > 1048575 && $bytes < 1073741824 )
				return number_format( ( $bytes / 1048576 ), 2 ) . ' MB';
				
			if( $bytes > 1073741823 && $bytes < 1073741824000 )
				return number_format( ( $bytes / 1073741824 ), 2 ) . ' GB';
				
			if( $bytes > 1073741823999 )
				return number_format( ( $bytes / 1073741824000 ), 2 ) . ' TB';
				
			return $bytes . ' bytes';
			
		}
		
		/**
		 * comprimir - Comprimir archivos
		 * @param string    $ubicacion    Ubicación donde se guardará el archivo comprimido
		 * @param string    $carpeta      Nombre de la carpeta que se comprimirá
		 * @param object    $zip          Clase zip
		 */
		public static function comprimir( $ubicacion, $carpeta, $zip ){ 
			$dir = $ubicacion;
			//$zip->addDir($carpeta);
			$directorio = opendir($ubicacion); 
			while ($archivo = readdir($directorio)) {
				if(!is_dir("$dir/$archivo")){
					$zip->addFile($dir.'/'.$archivo, "$carpeta/$archivo"); 
				}else{
					if($archivo != "." && $archivo != ".." ){
						$nuevaUbicacion = $ubicacion . "/". $archivo."/";
						comprime($nuevaUbicacion, $carpeta.$archivo."/", $zip);
					} 
				} 
			}
			closedir($directorio);
			//return $zip;
		}
		
		/**
		 * curl - obtener contenido de archivos por cURl
		 * @param string    $url        valor URL
		 * @param int       $timeout    Tiempo de espera 
		 */
		public static function curl( $url, $timeout = 10 ) {
			$ch = curl_init();
			curl_setopt ($ch, CURLOPT_URL, $url);
			curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
			$file_contents = curl_exec($ch);
			curl_close($ch);
			return ( $file_contents ) ? $file_contents : false;
		}
		
		/**
		 * encriptar - Encriptar / Desencriptar cadena 
		 * @param string $string    Cadena que se encritará/desencriptará
		 * @param string $key       Llave de encriptación/desencriptación
		 * @param string $acc       Acción a realizar $acc='encriptar' / $acc='desencriptar' 
		 * ej. encriptar('mi_cadena', 'mi_llave', 'Encriptar');
		 * ej. encriptar('mi_cadena', 'mi_llave', 'Desencriptar');
		 */
		public static function encriptar($string, $key, $acc = 'encriptar', $cod = 'base64') {
			$result = '';
			$retorno = '/%?==';
			
			$acc = strtolower( $acc );
			
			if($acc=='encriptar'){
				for($i=0; $i<strlen($string); $i++) {
					$char = substr($string, $i, 1);
					$keychar = substr($key, ($i % strlen($key))-1, 1);
					$char = chr(ord($char)+ord($keychar));
					$result.=$char;
				}
				
				switch($cod){
					case 'hex':
						$retorno = self::yCrHex2(base64_encode($result));
						break;
					default:
						// codificacion base64
						$retorno = base64_encode($result);
				}
			}
			
			if($acc=='desencriptar'){
				switch($cod){
					case 'hex':
						$string = base64_decode(self::yCrHex2($string,'D'));
						break;
					default:
						// decodificacion base64
						$string = base64_decode($string);
				}
				for($i=0; $i<strlen($string); $i++) {
					$char = substr($string, $i, 1);
					$keychar = substr($key, ($i % strlen($key))-1, 1);
					$char = chr(ord($char)-ord($keychar));
					$result.=$char;
				}
				$retorno = $result;
			}
			
			return $retorno;
		}
		
		/**
		 * extraerHref - Extrae enlace de codigo HTML
		 * @param string    $tag_a    etiqueta donde se extraerá en enlace
		 */
		public static function extraerHref( $tag_a ){
			if( empty( $tag_a ) ) return false;
			
			$str = preg_match( "<a([^>]+)>|</a>", "", $tag_a ); 
			return $str;
		}
		
		/**
		 * extraerNum - Extrae numero de una cadena
		 * @param string    $cadena    Cadena donde se extraerá el número
		 */
		public static function extraerNum( $cadena ){
			//$Num = intval(preg_replace('/[^0-9]+/', '', $cadena), 10);
			$Num='';
			$cadena = str_replace('+','0',$cadena);
			for( $index = 0; $index < strlen($cadena); $index++ )
			{
				if( is_numeric($cadena[$index]) )
				{
					$Num .= $cadena[$index];
				}
			}  
			return $Num;
		}
		
		/**
		 *  extraerTitle - Extrae titulo de un sitio web 
		 * @param string    $url    URL de la pagina web donde se extraerá el titulo
		 */
		public static function extraerTitle( $url ){
			$str = file_get_contents( $url );
			if( strlen( $str ) > 0 ){
				preg_match( "@<title>(.*)</title>@", $str, $title );
				return $title[1];
			}
			return false;
		}
		
		/**
		 * guardar_archivo - Guardar Archivos de texto
		 * @param string $nombre        Nombre del archivo ej. sintitulo1.txt
		 * @param string $contenido     Contenido del archivo que se guardará ej. texto de prueba 1
		 * @param string $dir_salida    Ruta del directorio donde se guardará  ej. home/misitio/public_html
		 */
		public static function guardar_archivo( $nombre, &$contenido = '', $dir_salida = '' )
		{
			if ( !$contenido ) return false;
			if ( !is_dir( $dir_salida ) ) return false;
	
			try
			{
				$handle = fopen( $dir_salida . '/' . $nombre, 'w+' );
				fwrite( $handle, $contenido );
				fclose( $handle );
			}
			catch ( Exception $e )
			{
				var_dump($e->getMessage());
				return false;
			}
	
			return true;
		}
		
		/* http_construir_url() : obtiene la url actual del navegador */
		public static function http_construir_url(){
			
			$isSecure = false;
			if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
				$isSecure = true;
			}elseif (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https' || !empty($_SERVER['HTTP_X_FORWARDED_SSL']) && $_SERVER['HTTP_X_FORWARDED_SSL'] == 'on') {
				$isSecure = true;
			}
			$http = $isSecure ? 'https:' : 'http:';
			
			$link = $http. '//' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\') . '/' . html_slug();
			return $link;
		}
		
		/**
		 * texto2tweet - Convierte un texto simple a tweet  
		 */
		public static function texto2postfb( $string, $target='_blank' ){
			$string = trim($string);
			
			//$t= preg_replace('/(http:\/\/www.|https:\/\/www.)([^ ]+)/i', 'www.$1', $string);
			$http=array('http://www.','https://www.'); $string = str_replace($http,'www.',$string);
			$t= preg_replace('/(http|https)(:\/\/)([^ ]+)/i', '<a href="$1$2$3" target="'.$target.'">$1$2$3</a>', $string);
			//$t= preg_replace('/(http|https)(:\/\/)(www.)([^ ]+)/i', '<a href="$1$2$4" target="'.$target.'">$1$2$4</a>', $string);		
			
			$t=  preg_replace('/www.([^ :]+)/i', '<a href="http://www.$1" target="'.$target.'">www.$1</a>', $t);
	 
			$t=  preg_replace('/@([^ :]+)/i', '<a href="http://facebook.com/$1" target="'.$target.'">@$1</a>', $t);
			$t=  preg_replace('/#([^ :]+)/i', '<a href="http://facebook.com/hashtag/$1?src=hash" target="'.$target.'">#$1</a>', $t);
			return $t;
		}
		
		/**
		 * texto2tweet - Convierte un texto simple a tweet  
		 */
		public static function texto2twiiny( $string, $target='_blank' ){
			$string = trim($string);
			
			//$t= preg_replace('/(http:\/\/www.|https:\/\/www.)([^ ]+)/i', 'www.$1', $string);
			$http=array('http://www.','https://www.'); 
			$string = str_replace($http,'www.',$string);
			$t= preg_replace('/(http|https)(:\/\/)([^ ]+)/i', '<a href="$1$2$3" target="'.$target.'">$1$2$3</a>', $string);
			//$t= preg_replace('/(http|https)(:\/\/)(www.)([^ ]+)/i', '<a href="$1$2$4" target="'.$target.'">$1$2$4</a>', $string);		
			
			$t=  preg_replace('/www.([^ :]+)/i', '<a href="http://www.$1" target="'.$target.'">www.$1</a>', $t);
	 
			$t=  preg_replace('/@([^ :]+)/i', '<a href="http://twiiny.com/$1" target="'.$target.'">@$1</a>', $t);
			$t=  preg_replace('/#([^ :]+)/i', '<a href="http://twiiny.com/hashtag/$1?src=hash" target="'.$target.'">#$1</a>', $t);
			return $t;
		}
		
		/**
		 * texto2tweet - Convierte un texto simple a tweet  
		 */
		public static function texto2tweet( $string, $target='_blank' ){
			$string = trim($string);
			
			//$t= preg_replace('/(http:\/\/www.|https:\/\/www.)([^ ]+)/i', 'www.$1', $string);
			$http=array('http://www.','https://www.'); $string = str_replace($http,'www.',$string);
			$t= preg_replace('/(http|https)(:\/\/)([^ ]+)/i', '<a href="$1$2$3" target="'.$target.'">$1$2$3</a>', $string);
			//$t= preg_replace('/(http|https)(:\/\/)(www.)([^ ]+)/i', '<a href="$1$2$4" target="'.$target.'">$1$2$4</a>', $string);		
			
			$t=  preg_replace('/www.([^ :]+)/i', '<a href="http://www.$1" target="'.$target.'">www.$1</a>', $t);
	 
			$t=  preg_replace('/@([^ :]+)/i', '<a href="http://twitter.com/$1" target="'.$target.'">@$1</a>', $t);
			$t=  preg_replace('/#([^ :]+)/i', '<a href="http://twitter.com/hashtag/$1?src=hash" target="'.$target.'">#$1</a>', $t);
			return $t;
		}
		
		/**
		 * linea2li - Convierte saltos de linea a lista ordenada o simple
		 * @param string    $cadena    Cadena que se cnveritirá en 'ul' o 'ol' 
		 * @param bool      $ol        true si se convertirá en 'ol'
		 */
		public static function linea2li( $cadena, $ol = false )
		{
			$ol		= ( $ol == true ) ? 'ol':'ul'; 
			$linea	= explode( "\n", $cadena );
	
			$sHTML	= '<'.$ol.'>';
	
			for( $i = 0; $i < count( $linea ); $i++) {
				// A la variable $valorCombo le añadimos cada uno de los elementos del array
				$sHTML .= '<li>'.$SLineas[$i].'</li>';
			}
	
			$sHTML	.= '</'.$sTList	.'>';
	
			return $sHTML;
		}
		
		/**
		 * obtWatchYouTube - Obtiene código Watch de video YouTube 
		 * @param string    $url_video    URL de video de YouTube
		 */
		public static function obtWatchYouTube( $url_video )
		{
			$f = explode("/", $url_video);
			$arch=$f[count($f)-1];
						
			$sVideo=str_replace('watch?v=','',$arch);
			return $sVideo;
		}
		
		/**
		 * OS - Obtener el sistema operativo desde donde se ejecuta el software
		 * : string
		 */
		public static function OS(){
			if ( strtoupper(substr(PHP_OS, 0, 3)) === 'WIN' )
				return 'Windows';
				
			if ( strtoupper(substr(PHP_OS, 0, 3)) === 'LIN' )
				return 'Linux';
				
			return PHP_OS;
		}
		
		/**
		 * quitar_accentos - Quita acentos de cadena 
		 * @param string   $cadena    Cadena de donde se quitará acentos
		 */
		public static function quitar_acentos( $cadena ){
			//return strtr( $cadena, 'àáâãäçèéêëìíîïñòóôõöùúûüýÿÀÁÂÃÄÇÈÉÊËÌÍÎÏÑÒÓÔÕÖÙÚÛÜÝ', 		'aaaaaceeeeiiiinooooouuuuyyAAAAACEEEEIIIINOOOOOUUUUY' );
			$strB	= array('à', 'á', 'â', 'ã', 'ä', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'À', 'Á', 'Â', 'Ã', 'Ä', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ù', 'Ú', 'Û', 'Ü', 'Ý');
			$strR	= array('a', 'a', 'a', 'a', 'a', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'A', 'A', 'A', 'A', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'N', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y');
			$str	= str_replace($strB, $strR, $cadena);
			return $str;
		}
		
		/*
		 * Función que permite sacar tags 
		 * de cadena con formato html
		 */
		public static function quitar_tags( $cadena_html ){
			if( empty( $cadena_html ) ) return false;
			
			$str = preg_match( "<([^>]+)>", "", $str ); 
			return $str;
		}
		
		/**
		 * resumirTexto - Sacar un resumen de un texto 
		 * @param string    $cadena            Cadena donde se saracará el resumen
		 * @param int       $num_caracteres    Numero de caracteres que se mostrará como resumen
		 * @param bool      $sacarTags         true para limpiar la cadena de etiquetas html
		 */
		public static function resumirTexto( $cadena, $num_caracteres = 55, $sacarTags=false ){
			$puntos = '';
			if( strlen( $cadena ) >= $num_caracteres) {
					$puntos = '...';
			}
			if( $sacarTags ){
				$cadena = strip_tags( $cadena );
			}
			$cadena .= ' ';
			$cadena = substr( $cadena, 0,  $num_caracteres + 1 );
			$cadena = substr( $cadena, 0, strrpos( $cadena,' ') );
			return  $cadena.$puntos;
		}
		
		/*
		 * Guardar variables en array
		 */
		 public function setVar( $cadena, $llave )
		 {
			 if( $cadena != NULL )
			 {
				 $Vars[$llave] = $cadena;
			 }
		 }
		 
		/*
		 * Obtener variables en array
		 */
		 public function getVar( $llave, $default = '' )
		 {
			 if( $llave != NULL )
			 {
				 return $Vars[$llave];
			 }
			 return $default;
		 }
		
		/**
		 * tamanoDir - Retorna tamaño de un directorio
		 * @param string    $dir        directorio que se medirá el tamaño
		 * @param bool      $subdirs    true si se consideran sub-directorios en la medición
		 */
		public static function tamanoDir( $dir = ".", $subdirs = true ) 
		{ 
			/* Creamos un array con todos los nombres de directorios y 
			archivos contenidos dentro del directorio inicial */ 
			$arr = scandir($dir); 
	
			/* establecemos que la variable $sizedir es igual a cero */ 
			$sizedir = 0; 
	
			/* YA NO Recorremos el array saltando los directorios . y .. */ 
			for ($i=0; $i<count($arr); $i++)
				{
					/* Comprobamos que el archivo/directorio actual no sea "." ni ".." */
				  if ($arr[$i]!="." && $arr[$i]!="..")
				   {
					 /* Si es un directorio hacer..... */ 
					 if (is_dir($dir ."/". $arr[$i])) 
						 { 
							 /* Establecemos que la variable $sizedir es igual 
							 a ella misma m?s el valor devuelto por MeDir */ 
							 if ( $subdirs ) $sizedir += tamanoDir($dir . "/" . $arr[$i]); 
						 } 
					 /* Si es un archivo hacer ... */ 
					 else 
						 { 
							 /* Establecemos que la variable $sizedir es igual 
							 a ella misma m?s el tama?o del fichero $dir ."/". $arr[$i] */ 
							 $sizedir += filesize($dir ."/". $arr[$i]); 
						 } 
				   }
					ob_flush();
					flush();
				} 
			/* Devolvemos el valor total de $sizedir */ 
			return $sizedir; 
		}
		
		/**
		 * url_codificar - codifica la URL que se envía por POST o GET
		 * @param string    $url    URL a codificar
		 * @param string    $acc    Accion a realizar 'codificar' / 'decodificar'
		 */
		public static function url_codificar( $url, $acc = 'codificar', $base64 = true){
			$acc	= strtolower( $acc );
			if( $acc == 'codificar' )
				return ( $base64 ) ? urlencode( base64_encode( $url ) ) : urlencode( $url );
				
			if( $acc == 'decodificar' )
				return ( $base64 ) ? base64_decode( urldecode( $url ) ) : urldecode( $url );
		}
		
		/*
		 * url_existe - Retorna 'true' si existe la url
		 * @param string    $url    URL  = url_exists( "http://ejemplo.com/una-url-a-comprobar" );
		 */
		public static function url_existe( $url = NULL ) {
	 
			if( empty( $url ) ){
				return false;
			}
		 
			$options['http'] = array(
				'method' => "HEAD",
				'ignore_errors' => 1,
				'max_redirects' => 0
			);
			$body = @file_get_contents( $url, NULL, stream_context_create( $options ) );
			
			// Ver http://php.net/manual/es/reserved.variables.httpresponseheader.php
			if( isset( $http_response_header ) ) {
				sscanf( $http_response_header[0], 'HTTP/%*d.%*d %d', $httpcode );
		 
				//Aceptar solo respuesta 200 (Ok), 301 (redirección permanente) o 302 (redirección temporal)
				$accepted_response = array( 200, 301, 302 );
				if( in_array( $httpcode, $accepted_response ) ) {
					return true;
				} else {
					return false;
				}
			 } else {
				 return false;
			 }
		}
		
		/**
		 * ySesion - Crea sesión propia del sistema
		 */
		/*public static function ySesion( $clave, $valor = NULL ){
			$user_agent	= $_SERVER['HTTP_USER_AGENT'];
			$ip			= $_SERVER['REMOTE_ADDR'];
			//** ubicación donde se guardarán las sesiones
			$sess_uri	= self::$ySesion_uri . '.sess' . md5( $ip . $user_agent );
			if( !empty( $valor ) ){
				if( file_exists( $sess_uri ) ) {
					$json = file_get_contents( $sess_uri );
					$json = json_decode( $json, true );
				}
				
				$json[$clave]	= $valor;
				$json			= json_encode( $json );
				
				file_put_contents( $sess_uri, $json );
				return $valor;
			}
			
			if( file_exists( $sess_uri ) ) {
				$json = file_get_contents( $sess_uri );
				$json = json_decode( $json );
						
				return ( isset( $json->$clave ) ) ? $json->$clave : NULL;
			}
			
			return $sess_uri;
		}*/
		
		public static function yCrHex2($string, $acc = 'E') {
			$acc = strtolower( $acc );
			$hex = '';
			
			if($acc=='e'){
				for ($i=0; $i<strlen($string); $i++){
					$ord = ord($string[$i]);
					$hexCode = dechex($ord);
					$hex .= substr('0'.$hexCode, -2);
				}
				//return strToUpper($hex);
				return $hex;
			}

			if($acc=='d'){
				//$string='';
				for ($i=0; $i < strlen($string)-1; $i+=2){
					$hex .= chr(hexdec($string[$i].$string[$i+1]));
				}
				//return $string;
				return $hex;
			}
		}
		
		/**
		 * ySesionDestruir() : bool
		 * Elimina sesión propia del sistema
		 */
		public static function ySesionDestruir(){
			$user_agent	= $_SERVER['HTTP_USER_AGENT'];
			$ip			= $_SERVER['REMOTE_ADDR'];
			//** ubicación donde se guardarán las sesiones */
			$sess_uri	= self::$ySesion_uri . '.sess' . md5( $ip . $user_agent );
			
			if( file_exists( $sess_uri ) ) {
				return unlink( $sess_uri );
			}
			
			return false;
		}
		 
		 /* Recortar Texto */
		/*function recortar_texto($string, $longitud = 180) {
			//Comprobamos que sea necesario recortar la cadena de texto
			if((mb_strlen($string) > $longitud)) {
				$espacios = mb_strpos($string, ' ', $longitud) - 1;
				if($espacios > 0) {
					$char = count_chars(mb_substr($string, 0, ($espacios + 1)), 1);
					if ($char[ord('<')] > $char[ord('>')]) {
						$espacios = mb_strpos($string, ">", $espacios) - 1;
					}
					$string = mb_substr($string, 0, ($espacios + 1)).'...';
				}
				if(preg_match_all("|(<([\w]+)[^>]*>)|", $string, $buffer)) {
					if(!empty($buffer[1])) {
						preg_match_all("|</([a-zA-Z]+)>|", $string, $buffer2);
						if(count($buffer[2]) != count($buffer2[1])) {
							$tags = array_diff($buffer[2], $buffer2[1]);
							$tags = array_reverse($tags);
							foreach($tags as $tag) {
									$string .= '</'.$tag.'>';
							}
						}
					}
				}
			}
			return $string;
		}
		
		/* Complemento de función fecha_larga() */
		/*function cambiaf_a_mysql($fecha){ 
			preg_match( "([0-9]{1,2})/([0-9]{1,2})/([0-9]{2,4})", $fecha, $mifecha); 
			$lafecha=$mifecha[3]."-".$mifecha[2]."-".$mifecha[1]; 
			return $lafecha;
		}*/
		
		/*public function obt_url( $clave = 0 ){
			$url = ( isset($_SERVER['PATH_INFO']) ) ? $_SERVER['PATH_INFO'] : NULL;
			$url = preg_replace('/^(\/)/','',$url);
			$url = explode('/',$url);
			
			return $url[$clave];
		}*/
	
	}
	
	
	
	/*
	
	<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top">
<input type="hidden" name="cmd" value="_xclick-subscriptions">
<input type="hidden" name="business" value="soporte@yalpublicidad.com">
<input type="hidden" name="lc" value="US">
<input type="hidden" name="item_name" value="Hosting">
<input type="hidden" name="item_number" value="WH001">
<input type="hidden" name="no_note" value="1">
<input type="hidden" name="src" value="1">
<input type="hidden" name="a3" value="79.00">
<input type="hidden" name="p3" value="1">
<input type="hidden" name="t3" value="M">
<input type="hidden" name="currency_code" value="USD">
<input type="hidden" name="bn" value="PP-SubscriptionsBF:btn_subscribeCC_LG.gif:NonHostedGuest">
<input type="image" src="https://www.paypalobjects.com/es_XC/i/btn/btn_subscribeCC_LG.gif" border="0" name="submit" alt="PayPal, la forma más segura y rápida de pagar en línea.">
<img alt="" border="0" src="https://www.paypalobjects.com/es_XC/i/scr/pixel.gif" width="1" height="1">
</form>



<div id="paypal-button-container"></div>
<script src="https://www.paypal.com/sdk/js?client-id=sb&currency=USD" data-sdk-integration-source="button-factory"></script>
<script>
  paypal.Buttons({
      style: {
          shape: 'rect',
          color: 'gold',
          layout: 'vertical',
          label: 'paypal',
          
      },
      createOrder: function(data, actions) {
          return actions.order.create({
              purchase_units: [{
                  amount: {
                      value: '1'
                  }
              }]
          });
      },
      onApprove: function(data, actions) {
          return actions.order.capture().then(function(details) {
              alert('Transaction completed by ' + details.payer.name.given_name + '!');
          });
      }
  }).render('#paypal-button-container');
</script>
	
	
	*/
?>