<?php

	/*
	 *
	 * 2003 - 2016 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * @lib yp_sesiones.php
	 *
	 * Sesiones del sitio web Weby+
	 *
	 */
	 
	 /* Autorizo acceso */
		defined('WY_INI_WEBY') or die( 'No dispones de acceso' );
	
	
	
	function comprime($ubicacion, $carpeta, $zip){ 
		comprimir( $ubicacion, $carpeta, $zip );
	}
	
	
	function Ini_Escribe($matriz, $camino_archivo, $multi_secciones = true, $modo = 'w') {
		return archivo_ini( $camino_archivo, $matriz = array(), $acc = 'e' );
	}
	
	/*
	 * Leer archivos INI
	 */
	function Ini_Leer ( $filepath ) {
		return archivo_ini( $filepath );
	}
	
	/*
	 * Funcion para crear caja de mensaje
	 */
	function Msj( $mensaje, $tipo = 'Correcto', $prefijo = false ){
		
		$MsjClass = 'm-bien';
		
		switch($tipo){
			case 'Correcto':
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
			case 'Atento':
					$MsjClass	= 'm-atento';
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
			case 'Cuidado':
					$MsjClass	= 'm-cuidado';
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
			case 'Error':
					$MsjClass	= 'm-error';
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
		}
		
		return '<div class="' . $MsjClass . '">' . $prefijo . $mensaje . '</div>';
	}
	
	
	function obt_contenido_archivo($url, $timeout = 10) {
		return obt_curl( $url, $timeout );
	}
	
	/*
	 * Obtener Zona Horaria GMT
	 */
	function obt_GMT( $zona_horaria = -5 ){ 
		return zona_horaria( $zona_horaria );
	}
	
		
	class WYFUNC {
		
		public $Vars = array();
		public $Lista_ZonaHoraria = array(
												'-11'=>'UTC-11 Samoa',
												'-10'=>'UTC-10 Hawaii',
												'-9'=>'UTC-09 Anchorage, Juneau',
												'-8'=>'UTC-08 Seattle, San Francisco, Los Angeles',
												'-7'=>'UTC-07 Edmonton, Denver, Phoenix',
												//'-6'=>'UTC-06 Winnipeg, Chicago, Houston',
												'-6'=>'UTC-06 Mexico, Tegucigalpa, Managua, San Jose',
												//'-5'=>'UTC-05 New York, Miami, La Habana',
												//'-5'=>'UTC-05 Puerto Principe, Panama',
												'-5'=>'UTC-05 Bogota, Quito, Lima',
												//'-4'=>'UTC-04 Halifax, Santo Domingo',
												//'-4'=>'UTC-04 Caracas, Georgetown, Manaus',
												'-4'=>'UTC-04 La Paz, Asuncion, Santiago de Chile',
												//'-3'=>'UTC-03 Brasilia, Rio De Janeiro',
												'-3'=>'UTC-03 Montevideo, Buenos Aires',
												'-2'=>'UTC-02 Recife',
												'-1'=>'UTC-01 Azores',
												'0'=>'UTC+00 Londres, Dublín, Lisboa',
												'0'=>'UTC+00 Casablanca, Dakar, Accra',
												'1'=>'UTC+01 Paris, Madrid, Roma',
												//'1'=>'UTC+01 Berlín, Praga, Belgrado',
												//'1'=>'UTC+01 Varsovia, Estocolmo, Oslo',
												//'1'=>'UTC+01 Argel, Lagos, Brazzaville, Luanda',
												//'2'=>'UTC+02 Helsinki, Minks, Bucarest',
												//'2'=>'UTC+02 Estambul, Atenas, Beirut',
												'2'=>'UTC+02 Cairo, Tripoli, Harare, Ciudad del Cabo',
												'3'=>'UTC+03 San Petersburgo, Moscow, Bagdad',
												//'3'=>'UTC+03 Riad, Addis Abeba',
												//'3'=>'UTC+03 Kampala, Nairobi, Mogadisco',
												'4'=>'UTC+04 Samara, Baku, Tbilisi, Dubai',
												'5'=>'UTC+05 Sheliabinsk, Karachi, Islamabad',
												'6'=>'UTC+06 Omsk, Tashkent, Dacca',
												'7'=>'UTC+07 Novosibirsk, Bangkok, Hanoi, Yakarta',
												//'8'=>'UTC+08 Irkutsk, Lhasa, Beijing',
												'8'=>'UTC+08 Hong Kong, Kuala Lumpur, Singapur, Manila, Perth',
												'9'=>'UTC+09 Tokyo, Seul',
												'10'=>'UTC+10 Vladivostok, Sydney, Melbourne',
												'11'=>'UTC+11 Noumea, Magaban',
												'12'=>'UTC+12 Wellington (Nueva Zelanda)'
												
											 );
		
		
		public function encriptar($string, $key, $acc = 'Encriptar') {
			return encriptar( $string, $key, $acc );
		}
		
		public function ExtraerNum($cadena){
			return extraerNum( $cadena );
		}
		
		public function resumirTexto( $cadena, $num_caracteres = 55, $sacarTags=false ){
			return resumirTexto( $cadena, $num_caracteres, $sacarTags );
		}
		
		public function quitar_accentos($string){
			return quitar_accentos( $string );
		}
		
		/* Formato de Fechas */
		public function formato_fecha($fecha1, $formato_final='') 
		{
			/* obtengo las fechas como datos */
			if (preg_match("/[0-9]{1,2}\/[0-9]{1,2}\/([0-9][0-9]){1,2}/",$fecha1))
					  list($dia1,$mes1,$año1)=split("/",$fecha1);
			if (preg_match("/[0-9]{1,2}-[0-9]{1,2}-([0-9][0-9]){1,2}/",$fecha1))
					  list($dia1,$mes1,$año1)=split("-",$fecha1);
					  
			$fecha = $año1.'-'.$mes1.'-'.$dia1;
			
			if ($formato_final == '') 
			{  
				return $fecha1;
			} else { 
				return date($formato_final, strtotime($fecha));
			}
			
			//Thu, October 10, 2014 - 18:12 -> formato_fecha('10-10-2014','D, F d, Y')
		}
		
		public function fecha( $fecha = NULL, $formato = NULL, $lang = 'es_ES', $gmt = NULL ){
			return fecha( $fecha, $formato, $lang, $gmt );
		}
		
		
		public function cambiaf_a_mysql($fecha){ 
			preg_match( "([0-9]{1,2})/([0-9]{1,2})/([0-9]{2,4})", $fecha, $mifecha); 
			$lafecha=$mifecha[3]."-".$mifecha[2]."-".$mifecha[1]; 
			return $lafecha;
		}
		
		public function convertir_slinea_li($sCadena,$sOL=false)
		{
			return linea2li( $cadena, $sOL );
		}
		
		public function sacarTags( $str ){
			return quitar_tags( $str );
		}
		 
		public function sacarHref( $str ){
			return extraerHref( $str );
		}
		
		/* Estraer codigo de video YouTube */
		public function isVideo($sVideo)
		{
			return obtWatchYouTube( $sVideo );
		}
		
		/* Extraer enlace de string */
		public function formatearlink($string,$target='_blank'){
			return texto2tweet( $string, $target );
		}
		
		/* Extraer titulo de web */
		public function getTitle($Url){
			return extraerTitle( $Url );
		}
		
		public function obt_url( $clave = 0 ){
			$url = ( isset($_SERVER['PATH_INFO']) ) ? $_SERVER['PATH_INFO'] : NULL;
			$url = preg_replace('/^(\/)/','',$url);
			$url = explode('/',$url);
			
			return $url[$clave];
		}
	
	}
	
	$wy_func = new WYFUNC();
	
	/*
	 * Agregar metatag en el head
	 */
	function wyp_agregar_meta( $meta ){
		if( !empty( $meta ) )
			return '<meta charset="' . $charset . '">' . "\n";
		
		return false;
	}
	
	/*
	 * Mostrar etiqueta
	 */
	function wyp_etiqueta( $etiqueta, $por_defecto = '' ){
		if( isset( $_SESSION['wyp_us'] ) ) return ( isset( wyp_json( 'datos/lng/' . wyp_us_lng( $_SESSION['wyp_us'] ) . '.lng' )->$etiqueta ) ) ? wyp_json( 'datos/lng/' . wyp_us_lng( $_SESSION['wyp_us'] ) . '.lng' )->$etiqueta : $por_defecto;
		return false;
	}
	
	/*
	 * Conecto todas las extensiones registradas
	 */
	function conectar_extensiones(){
		$q = obt_query( "extensiones", "WHERE publicado = '1'" );
		$ext = '';
		while( $r = query_array( $q ) ){
			$ext .= '<li>' . WYHTML::link( post_link( 'plugin_extension' ) . '&extension=' . $r['extension'], ' &nbsp; ' . $r['extension'], 'class="fa fa-plug"' ) . '</li>';
		}
		return $ext;
	}
	
	/*
	 * Head yPanel
	 */
	function wyp_head_yPanel( $WyP_Titulo = 'Panel' ){
		$charset	= ( WYCFG_WYCHARSET != NULL ) ? WYCFG_WYCHARSET : 'utf-8';
		$autor		= WYCFG_Soporte;
		
		$Head = '<meta charset="' . $charset . '">' . "\n";
		$Head .= "\t" . '<meta name="author" content="' . $autor . '" />' . "\n";
		$Head .= "\t" . '<title>' . $WyP_Titulo . ' - yPanel</title>' . "\n";
		$Head .= "\t" . '<link rel="icon" href="favicons/favicon.png" type="image/x-icon">' . "\n" .
				 "\t" . '<link rel="shortcut icon" href="images/favicons/favicon.png" type="image/x-icon"/>' . "\n";
		
		return $Head;
	}
	
	/*
	 * Funcion para leer json
	 */
	function wyp_json( $url_json, $asociativo = false ){
		$url_json = YPATH . YDS . 'ypanel' . YDS . '.ypanel' . YDS . $url_json;
		$f = '';
		if( file_exists( $url_json ) ){
			$data	= file_get_contents( $url_json );
			$data	= json_decode( $data, $asociativo );
			return $data;
		}else{
			 return false;
		}
	}
	
	/*
	 * Funcion para escribir json
	 */
	function wyp_json_escribir( $url_json, $json ){
		//$str = file_get_contents('data.json');//get contents of your json file and store it in a string,bro small suggestion never keep any JSON data in ur html file its not safe.always keep json data in external file.
        //$arr = json_decode($str, true);//decode it
		
		$url_json = YPATH . YDS . 'ypanel' . YDS . '.ypanel' . YDS . $url_json;
		
		if ( !empty( $json ) )
		{
			$file = fopen( $url_json , 'w' );
			fwrite($file, $json);
			fclose($file);
			return $json;
		}
		return false;
	}
	
	/*
	 * Funcion para crear caja de mensaje
	 */
	function wyp_mensaje( $mensaje, $tipo = 'Correcto', $prefijo = false ){
		
		$MsjClass = 'm-bien';
		
		switch($tipo){
			case 'Correcto':
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
			case 'Atento':
					$MsjClass	= 'm-atento';
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
			case 'Cuidado':
					$MsjClass	= 'm-cuidado';
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
			case 'Error':
					$MsjClass	= 'm-error';
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
		}
		
		return '<div class="' . $MsjClass . '">' . $prefijo . $mensaje . '</div>';
	}
	
	/*
	 * Obtener privilegios de nivel del usuario
	 */
	function wyp_n_privilegios_usr( $t_nivel = NULL, $item = NULL, $item1 = NULL ){
		$nivel = wyp_nivel_usr( $_SESSION['wyp_us'] );
		
		if( $item != NULL ){
			return ( isset( wyp_json( 'niveles.conf' )->$nivel->$t_nivel->$item ) ) ? wyp_json( 'niveles.conf' )->$nivel->$t_nivel->$item : false;
		}elseif( $item1 != NULL ){
			return ( isset( wyp_json( 'niveles.conf' )->$nivel->$t_nivel->$item->$item1 ) ) ? wyp_json( 'niveles.conf' )->$nivel->$t_nivel->$item->$item1 : false;
		}else{
			return ( isset( wyp_json( 'niveles.conf' )->$nivel->$t_nivel ) ) ? wyp_json( 'niveles.conf' )->$nivel->$t_nivel : false;
		}
	}
	
	/*
	 * Obtener nivel de usuario
	 */
	function wyp_nivel_usr( $usuario ){
		if( empty( $usuario ) ) return false;
		$nivel = ( isset( wyp_json( 'cuentas_usuarios' )->$usuario->nivel ) ) ? wyp_json( 'cuentas_usuarios' )->$usuario->nivel : 'no_nivel';
		
		if( $nivel != 'no_nivel' ){
			$nivel_id = ( isset( wyp_json( 'niveles' )->$nivel ) ) ? wyp_json( 'niveles' )->$nivel : false;
			return $nivel_id;
		}else{
			return false;
		}
	}
	
	/*
	 * No Cache
	 */
	function wyp_no_cache(){
		header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
		header("Cache-Control: post-check=0, pre-check=0", false);
		header("Pragma: no-cache");
	}
	
	/*
	 *  Funcion saludo de bienvenida
	 */
	function wyp_saludo_bienvenida( $cadena = NULL ){
		//$hoy = getdate(); 
		//$hora=$hoy["hours"];
		$hora = gmdate( 'H', obt_GMT( GMT ) ); 
		if ($hora<6) { 
			echo( wyp_etiqueta( 'e_madrugado', 'Hoy has madrugado mucho' ) . " " . $cadena ); 
		}elseif($hora<12){ 
			echo( wyp_etiqueta( 'e_buenos_dias', 'Buenos días' ) . " " . $cadena ); 
		}elseif($hora<=18){ 
			echo( wyp_etiqueta( 'e_buenas_tardes', 'Buenas Tardes' ) . " " . $cadena ); 
		}else{ echo( wyp_etiqueta( 'e_buenas_noches', 'Buenas Noches' ) . " " . $cadena ); } 
	}
	
	/*
	 * Funcion para obtener URL de sitio weby+
	 */
	function wyp_sitio_weby(){
		$Protocolo = strtolower( substr($_SERVER['SERVER_PROTOCOL'], 0, 4) ) . '://';
		return '//' . $_SERVER['HTTP_HOST'] .  Base_SitioWeby();
	}
	
	/*
	 * Obtener lenguaje definido por el usuario
	 */
	function wyp_us_lng( $usuario ){
		return ( isset( wyp_json( 'cuentas_usuarios' )->$usuario->lenguaje ) ) ? wyp_json( 'cuentas_usuarios' )->$usuario->lenguaje : 'Es-es';
	}
	
	/*
	 * Obtener usuario de sesión
	 */
	function wyp_us_sess(){
		return $_SESSION['wyp_us'];	
	}
	
	function post_categoria( $seccion = 0 ){
		if( WYSQL::existe( "secciones", "id", "id='$seccion'" ) )
			return WYSQL::_Obt1Reg( "secciones", "id='$seccion'", "nombre" );
			
		return 'Sin categor&iacute;a';
	}
	
	function post_fecha_publicacion( $fecha = NULL ){
		global $wy_func;
		
		if( !empty( $fecha ) )
			return $wy_func->fecha( $fecha, 'd/m/Y h:i:s a' );
			
		return 'Sin fecha de publicaci&oacute;n';
	}
	
	function post_publicado( $publicado = 0, $icono = true ){
		if( $publicado == 1 )
			return ( $icono ) ? 'wyp-ico-publicado-16x16' : 'Acceso P&uacute;blico';
		
		return ( $icono ) ? 'wyp-ico-no-publicado-16x16' : 'S&oacute;lo yo';
	}
	
	
	
	/*
	 * Funcion para redireccionar 
	 */
	function redireccionar( $url = NULL ){
		if( isset( $_POST['r'] ) && $_POST['r'] != NULL )
			return '<script> location.href = "' . $_POST['r'] . '"; </script>';
			
		if( $url != NULL )
			return '<script> location.href = "' . $url . '"; </script>';
			
		return '';
	}
	
?>