<?php
	/*
	 *
	 * yMS (c) 2003 - 2020 Yal Publicidad
	 * Sistema: Macrodígital Software - de Yal Publicidad
	 *
	 */
	
	/* Autorizo acceso */
		defined('YMS') or die( '<h2>No dispones de acceso<h2>' );
		
	/* compruebo si se han cargado modulos reqeridos  */
		if( !class_exists( 'yMSfunciones' ) ) die( '<br><b>Notificación @lib.mysql dice</b>: No se encontró \'@lib.funciones\' requerido para el arranque de ésta librería.' );
		
	define( 'BASEDATOS',	'DATABASE');
	define( 'TABLA',		'TABLE');
	define( 'YP_CHARSET',	'utf-8' );
	
	/*
	 * conectar con MySQL
	 * ej.
	 * _mysql_conectar( 'localhost', 'root', '1234' );
	 */
	function _mysql_conectar( $hostName, $userName, $password, $db = NULL, $port = 3306 ){
		return ySQL::conectar( $hostName, $userName, $password, $db, $port );
	}
	
	/*
	 * contar registros
	 * ej.
	 * _mysql_contar( 'mitabla', 'id', 'publicado=1' );
	 */
	 function _mysql_contar_reg( $tabla, $campoId, $where ){
		 return ySQL::contarReg( $tabla, $campoId, $where );
	 }
		
	/*
	 * Crear Base de Datos MySQL
	 */
	function _mysql_crear_db( $nombre_db ){
		return ySQL::crear( $nombre_db );
	}
	
	/*
	 * Crear Base de Datos MySQL
	 */
	function _mysql_crear_tbl( $nombre_tbl ){
		return ySQL::crear( $nombre_tbl, TABLA );
	}
	
	/*
	 * Elininar Base de Datos de MySQL
	 */
	function _mysql_eliminar_db( $nombre_db ){
		return ySQL::eliminar( $nombre_db );
	}
	
	/*
	 * Elininar Tabla de MySQL
	 */
	function _mysql_eliminar_tbl( $nombre_tbl ){
		return ySQL::eliminar( $nombre_tbl, TABLA );
	}
	
	/*
	 * Elininar registro
	 */
	function _mysql_eliminar_reg( $tabla, $id_reg ){
		return ySQL::eliminar_registro( $tabla, $id_reg );
	}
	
	/*
	 * Mostrar error de MySQL
	 */
	function _mysql_error(){
		return mysqli_error( ySQL::$SQLConn );
	}
	
	/**/
	function _mysql_existe( $tabla, $campoId, $where ){
		return ySQL::existe( $tabla, $campoId, $where );
	}
	
	/* comprobar si existe campo de tabla mysql */
	function _mysql_existe_columna( $tabla, $nombre_columna = NULL ){
		$result = _mysql_query("SHOW COLUMNS FROM $tabla WHERE Field = '$nombre_columna'");
		
		if( _mysql_num_rows( $result ) === 0 ){
			return true;
		}
		return false;
		/*if ($result->num_rows === 0) {
			// Si no encontramos la columna, la agregamos
			$mysqli->query("ALTER TABLE productos ADD `$columnName` tinyint(1) unsigned NOT NULL");
		}*/
	}
	
	/* 
	* funcion para generar backup de base de datos o tablas MySQL 
	* ej.
	* para generar backup de base de datos actual
	* _mysql_generar_backup( '*', '/home/midominio/public_html/' );
	*
	* para generar backup de una o mas tablas
	* _mysql_generar_backup( 'tabla1, tabla2', '/home/midominio/public_html/' );
	*
	*/
	function _mysql_generar_backup( $tablas = '*', $dir_salida = '' ){
			return ySQL::backupMySQL( $tablas, $dir_salida );
	}
	
	function _mysql_importar( $nombre_del_archivo, $prefijo ){
		return ySQL::importar( $nombre_del_archivo, $prefijo );
	}
	
	/*
	 * Mostrar ID de ultimo registro MySQL
	 * ej. 
	 * $id = _mysql_insert_id();
	 * echo $id; //imprime 1
	 */
	function _mysql_insert_id(){
		return mysqli_insert_id( ySQL::$SQLConn );	
	}
	
	/**
	 * _mysql_insert_reg - Inserta registros en tabla
	 */
	function _mysql_insertar_reg( $tabla, $campos, $valores ){
		return ySQL::insertar_registro( $tabla, $campos, $valores );
	}
	
	/**
	 * _mysql_insert_reg - Inserta registros en tabla
	 */
	function _mysql_insert_reg( $tabla, $campos, $valores ){
		return ySQL::insertar_registro( $tabla, $campos, $valores );
	}
	
	/*
	 * Realizar consulta mysqli_fetch_array, num_rows con MySQL
	 */
	function _mysql_fetch_array( $resultado, $resultado_tipo = NULL ){
		if( ! empty( $resultado ) )
		{
			return ( $resultado_tipo != NULL ) ? mysqli_fetch_array( $resultado, $resultado_tipo ) : mysqli_fetch_array( $resultado );				
		}
		
		return false;
	}
	
	/* resultado de consulta mysqli_fetch_row MySQL */
	function _mysql_fetch_row( $resultado ){
		if( ! empty( $resultado ) ){	
			return mysqli_fetch_row( $resultado );
		}
		
		return false;
	}
	
	/* listar base de datos MySQL*/
	function _mysql_list_dbs(){
			return _mysql_query("SHOW DATABASES");
	}
		
	/* listar tablas de base de datos MySQL */
	function _mysql_list_tables( $db ){
		if( ! empty( $db ) ){	
			return _mysql_query( "SHOW TABLES FROM $db" );
		}
		
		return false;
	}
	
	/*  */
	function _mysql_modificar_reg( $tabla, $idbuscar, $campomodificar ){
		return ySQL::modificar_registro( $tabla, $idbuscar, $campomodificar );	
	}
	
	/* consultar mysqli_num_fields */
	function _mysql_num_fields( $resultado ){
		if( ! empty( $resultado ) ){
			return mysqli_num_fields( $resultado );
		}
		
		return false;
	}
	
	/* consultar mysqli_num_rows */
	function _mysql_num_rows( $resultado ){
		if( ! empty( $resultado ) ) {
			return mysqli_num_rows( $resultado );
		}
		
		return false;
	}
	
	/*  */
	function _mysql_obtener_reg( $tabla, $buscar_consulta, $mostrar_consulta ){
		return ySQL::obt1Reg( $tabla, $buscar_consulta, $mostrar_consulta );
	}
	
	/*  */
	function _mysql_real_escape_string( $cadena_de_escape ){
		if( empty( $cadena_de_escape ) ) return false;
		return mysqli_real_escape_string( ySQL::$SQLConn, $cadena_de_escape );
	}
	
	function _mysql_select_db( $nombre_db ){
		if( ! empty( $nombre_db ) ){
			if(!mysqli_select_db( ySQL::$SQLConn, $nombre_db ))
			{
				return false;
			}
					
			if (! mysqli_set_charset ( ySQL::$SQLConn, YP_CHARSET ))
			{
				_mysql_query( 'SET NAMES ' . YP_CHARSET);
			}
					
			return true;
		}
		
		return false;
	}
	
	/* complemento de Mysql_list_tables( $nombre_db ) para extraer nombre de tabla */
	function _mysql_tablename( $resultado, $i ){
		if( ! empty( $resultado ) ){	
			$tabla = array();
			//print_r($resultado);
			while( $r = _mysql_fetch_array( $resultado ) ){ 
				$tabla[] = $r[0]; 
			}
			return isset( $tabla[$i] ) ? $tabla[$i] : NULL;
		}
		
		return false;
	}
	
	/* Realizar consultas query con MySQL */
	function _mysql_query( $consulta ){
		if( ! empty( $consulta ) ){
				return ( ySQL::$SQLConn ) ?  mysqli_query( ySQL::$SQLConn, $consulta ) : false;
		}	
		return false;
	}
	
	
	
	class ySQL {
		
		public static $SQLConn;
		
		private static $dbname;
		
		/**
		 * backupMySQL - Generar copia de seguridad de tabla o base de datos
		 * 
		 * @param string    $tables        Utilice '*' para toda la base de datos o 'table1, table2, table3 ...'
		 * @param string    $dir_salida    ruta del directorio donde se guardará
		 */
		public static function backupMySQL( $tables = '*', $dir_salida = '' )
		{
			$retorno = '';
			
			try
			{
				/** Tablas para exportar */
				if($tables == '*')
				{
					$tables = array();
					$result = _mysql_query('SHOW TABLES');
					while($row = _mysql_fetch_row($result))
					{
						$tables[] = $row[0];
					}
				} else {
					$tables = is_array($tables) ? $tables : explode( ',', $tables );
				}
	
				$sql = "-- yMySQL - Yal Publicidad
-- version " . MSiData::obtener( 'version_nucleo' ) . "
-- http://hosting.yalpublicidad.com
--

# +===================================================================
# |
# | Generado el " . date("d-m-Y") . " a las " . date("h:m:s A") . " 
# | Servidor: {$_SERVER['HTTP_HOST']}
# | Version de MySQL: " . mysqli_get_client_version() . "
# | Version de PHP: " . phpversion() . "
# | Base de datos: '" . self::obt_db() . "'
# |
# +-------------------------------------------------------------------
\n\n";
				$sql .= 'CREATE DATABASE IF NOT EXISTS ' . self::obt_db() . ";\n\n";
				$sql .= 'USE ' . self::obt_db() .";\n\n";
	
				/** Tablas de iteración */
				foreach($tables as $table)
				{
					$retorno .= "Backing up " . $table . " table...";
	
					$result = _mysql_query( 'SELECT * FROM ' . $table );
					$numFields = _mysql_num_fields( $result );
					
					$sql .= "-- --------------------------------------------------------\n\n";
					$sql .= "-- \n-- Estructura de tabla para la tabla `$table` \n--\n\n";
					$sql .= 'DROP TABLE IF EXISTS ' . $table . ';';
					// ** Obtener crear tabla
					$crear_tabla = _mysql_fetch_row( query( 'SHOW CREATE TABLE ' . $table ) );
					$sql .= "\n\n" . $crear_tabla[1] . ";\n\n";
					// ** Obtener columnas de tabla
					$columna = '';
					$col_num = 0;
					$col_tabla = _mysql_query( 'SHOW COLUMNS FROM ' . $table );
						foreach( $col_tabla as $col ){
								$columna .= '`' . $col['Field'] . '`';
								
								if ( $col_num < ( $numFields - 1 ) )
								{
									$columna .= ', ';
								}
								
								$col_num++;
						}
					
					// ** Volco resultados de registros en tabla
					$campo = '';
					$campo_num = 0;
					for ($i = 0; $i < $numFields; $i++) 
					{
						while( $row = _mysql_fetch_row( $result ) )
						{
							$campo .= '(';
							for( $j = 0; $j < $numFields; $j++ ) 
							{
								$row[$j] = addslashes( $row[$j] );
								$row[$j] = str_replace( "\n", "\\n", $row[$j] );
								if ( isset( $row[$j] ) )
								{
									$campo .= "'" . $row[$j] . "'" ;
								}
								else
								{
									$campo .= "''";
								}
	
								if ( $j < ( $numFields - 1 ) )
								{
									$campo .= ', ';
								}
							}
							
							if ( $campo_num < ( $numFields - 1 ) )
							{
								$campo.= "),\n";
							}
							$campo_num++;
						}
					}
					
					$campo = trim( trim( $campo ), ',' );
					if( $campo_num > 0 ) {
						$sql .= "-- \n-- Volcado de datos para la tabla `$table` \n--\n\n";
						$sql .= "INSERT INTO `$table` ($columna) VALUES\n$campo;";
						$sql.="\n\n\n";
					}
	
					$retorno .= " OK" . "<br>";
				}
			}
			catch ( Exception $e )
			{
				var_dump( $e->getMessage() );
				return false;
			}
			
			$nom_sql = self::obt_db() . '-' . date("d-m-Y", time()).'.sql';
			return guardar_archivo( $nom_sql, $sql, $dir_salida );
		}
	
		/*
		 * conectar - conectar con MySQL
		 * @param string    $hostName    Nombre del servidor, normalmente 'localhost'
		 * @param string    $userName    Usuario de base de datos
		 * @param string    $password    Contraseña de base de datos
		 * @param string    $db          Nombre de la base de datos
		 * @paran int       $port        Puerto de servidor
		 */
		public static function conectar( $hostName, $userName, $password, $db = NULL, $port = 3306 )
		{
				
				// verifico datos de conexion a MySQL
				try{
					self::$dbname	= $db;
					/* Selecciono modo de conexion MySQL o MySQLi */
						self::$SQLConn = mysqli_connect( $hostName, $userName, $password ) or die( msg_error( mysqli_connect_error(), NULL, 'alert alert-danger text-center' ) );
						
						if( $db != NULL ){
							if(!mysqli_select_db( self::$SQLConn, $db ))
							{
								if( !self::crear( $db, BASEDATOS ) ) { 
									msg_error( mysqli_error( self::$SQLConn ), NULL, 'alert alert-danger text-center' );
									return false; 
								}
								mysqli_select_db( self::$SQLConn, $db );
							}
							
							if (! mysqli_set_charset( self::$SQLConn, 'utf-8' ))
							{
								_mysql_query( 'SET NAMES ' . 'utf-8' );
							}
						}
						
						return self::$SQLConn;
				}catch( Throwable $t ){
						msg_error( $t->getMessage() . PHP_EOL, NULL, 'alert alert-danger text-center' );
						restore_error_handler();
				}
				
				return false;
		}
		
		
		
		/*
		 * Contar registros
		 */
		public static function contarReg( $tabla, $campoId = 'id', $where = NULL )
		{
			$where = ( $where != NULL ) ? " WHERE $where" : "";
			$q1	= _mysql_query("SELECT $campoId FROM $tabla $where" );
			
			if($q1){
					$TotalReg = mysqli_num_rows( $q1 );
					return $TotalReg;
					mysqli_free_result($q1);
			}
			
			return 0;
		}
		
		/*
		 * Funcion para crear DB, Tablas MySql
		 */
		public static function crear( $nombre_db_tbl = '', $tipo = BASEDATOS )
		{
			
			$CHARSET = " DEFAULT CHARACTER SET utf8mb4";
			if( _mysql_query('CREATE ' . $tipo . ' IF NOT EXISTS ' . $nombre_db_tbl ) )
				{			
					return true;
				}else{
					return false;
				}
			
		}
		
		/*
		 * Funcion para eliminar DB, Tablas MySql
		 */
		public static function eliminar( $nombre_db_tbl = '', $tipo = BASEDATOS )
		{
			if( _mysql_query('DROP ' . $tipo . ' ' . $nombre_db_tbl ) )
				{			
					return true;
				}else{
					return false;
				}
			
		}
		
		/*
		 * Comprobar si un Registro Existe 
		 */
		public static function existe( $tabla, $campoId = '*', $where = NULL )
		{
			$cExist	= _mysql_query( "SELECT $campoId FROM $tabla WHERE $where" );
			$exist	= _mysql_num_rows( $cExist );
						
			if($exist > 0){
				return true;
			}else{
				return false;
			}
		}
		
		/*
		 * Eliminar registro por id
		 */
		public static function eliminar_registro( $tabla, $campo_id ){
			$sql = _mysql_query("DELETE FROM $tabla WHERE id='$campo_id'");
			if($sql)
			{
				return true;
			}else{
				return false;
			}
		}
		
		/* 
		 * Insertar registros 
		 */
		public static function insertar_registro( $tabla, $campos, $valores)
		{
			$sql = _mysql_query("INSERT INTO $tabla($campos) VALUES($valores)");
			if($sql)
			{
				return true;
			}else{
				return false;
			}
		}
		
		/* 
		 * Modificar un registros 
		 */
		
		public static function modificar_registro( $tabla, $idbuscar, $campomodificar)
		{
			if( _mysql_query("UPDATE $tabla SET $campomodificar WHERE $idbuscar") )
			{
				return true;
			}else{
				return false;
			}
		}
		
		
		/**
		 * obt_db() : string
		 */
		public static function obt_db(){
			return self::$dbname;
		}
		 
		/*
		 * Obtener un registros 
		 */
		public static function obt1Reg( $tabla, $buscar_consulta, $mostrar_consulta )
		{
			$Sql	= _mysql_query( "SELECT * FROM $tabla WHERE $buscar_consulta" );
			$row	= _mysql_fetch_array( $Sql );
			
			return ( isset( $row[$mostrar_consulta] ) ) ? $row[$mostrar_consulta] : false;
		}
		
		
		
		/* Tamaño de DB */
		public static function size_db( $db ) {
 
			$tables = _mysql_list_tables( $db );
			
			$units = array(' B', ' KB', ' MB', ' GB', ' TB');
			$status = -1;
			
			if (!$tables) 
			{ 
				$status = -1; 
			}
			else
			{
				$tbcount = _mysql_num_rows( $tables );
				$size = 0;
				
				/* almaceno todas las tablas existentes */
				$tabla = array();
				while($r = _mysql_fetch_array( $tables )){ $tabla[] = $r[0]; }
				
				for ( $i=0; $i < $tbcount; $i++ ) {
					$tbname = $tabla[$i];
					$result = _mysql_query("SHOW TABLE STATUS FROM ". $db ." LIKE '".$tbname."'");
					$data = _mysql_fetch_array( $result );
					$size += ($data['Index_length'] + $data['Data_length']);
				};
				
				for ($i = 0; $size > 1024; $i++) {
					$size /= 1024;
				}
				
				$status = round($size, 2).$units[$i];
				
			}
			
			return $status;
		}
		
		/*
		 * importar - Importar ficheros .sql
		 */
		public static function importar( $nombre_del_archivo, $prefijo = NULL ){
			if ( !file_exists( $nombre_del_archivo ) ) return false;
			
			// Variable temporal, utilizada para almacenar la consulta actual
			$templinea = '';
			// Leer en archivo completo
			$lineas = file( $nombre_del_archivo );
			// Bucle a través de cada línea
			foreach ($lineas as $linea)
			{
				$linea	= trim( $linea );
				// Omitirlo si es un comentario
				if (substr($linea, 0, 2) == '--' || $linea == '')
					continue;
				
				// Añadir esta línea al segmento actual
				$templinea .= ( $prefijo != NULL ) ? str_replace( '<TBLPREFIJO>', $prefijo, $linea ) : $linea;
				// Si tiene un punto y coma al final, es el final de la consulta
				if (substr(trim($linea), -1, 1) == ';')
				{
					// Realizar la consulta
					// /query($templinea) or print('Error al relizar la consulta \'<strong>' . $templinea . '\': ' . query_error() . '<br /><br />');				
					_mysql_query( $templinea ) or die( _mysql_error() );
					// Restablecer variable temporal a vacío
					$templinea = '';
				}
			}
			//echo "Tablas importadas con éxito";
			return true;
		}
		
	}
	
	
	/*
	
mysql_client_encoding() 
mysql_list_dbs() (use SHOW DATABASES query)
mysql_db_name() 
mysql_list_fields()
mysql_db_query() 
mysql_list_processes() (use SHOWPROCESSLIST query)
mysql_dbname() 
mysql_list_tables() (use SHOWTABLES query)
mysql_field_flags() 
mysql_listdbs() (use SHOW DATABASES query)
mysql_field_len() 
mysql_listfields()
mysql_field_name() 
mysql_listtables() (use SHOWTABLES query)
mysql_field_table() 
mysql_numfields()
mysql_field_type() 
mysql_numrows() (use mysqli_num_rows() instead)
mysql_fieldflags() 
mysql_pconnect() (append p: to thehostname passed to mysqli_connect())
mysql_fieldlen() 
mysql_result()
mysql_fieldname() 
mysql_selectdb() (use mysqli_select_db() instead)
mysql_fieldtable() 
mysql_table_name()
mysql_fieldtype() 
mysql_tablename()
mysql_freeresult() (use mysqli_free_result() instead)
mysql_field_name() 
mysql_listtables() (use SHOWTABLES query)
mysql_field_table() 
mysql_numfields()
mysql_field_type() 
mysql_numrows() (usemysqli_num_rows() instead)
mysql_fieldflags() 
mysql_pconnect() (append p: to thehostname passed to mysqli_connect())
mysql_fieldlen() 
mysql_result()
mysql_fieldname() 
mysql_selectdb() (usemysqli_select_db() instead)
mysql_fieldtable() 
mysql_table_name()
mysql_fieldtype() 
mysql_tablename()
mysql_freeresult() (usemysqli_free_result() instead)
mysql_unbuffered_query()
	
	*/

?>