<?php
	/*
	 *
	 * yPanel (c) 2003 - 2019 Yal Publicidad
	 * Sistema yPanel - yWHA
	 *
	 */
	
	/* Autorizo acceso */
		defined('YMS') or die( '<h2>No dispones de acceso<h2>' );
		
	function html_base(){
		return yHTML::base();	
	}
	
	function html_charset( $charset = 'utf-8' ){
		return yHTML::charset( $charset );
	}
	
	function html_enlace( $href, $texto, $atributos = NULL, $target = NULL ){
		return yHTML::enlace( $href, $texto, $atributos, $target );
	}
	
	function html_importar( $camino_archivo ){
		return yHTML::importar( $camino_archivo );
	}
	
	function html_incluir_tpl( $tpl_uri ){
		yHTML::incluir_tpl( $tpl_uri );
	}
	
	function html_meta( $atributos = NULL ){
		return yHTML::meta( $atributos );
	}
	
	function html_obtImportacion(){
		return yHTML::obtImportacion();
	}
	
	function html_obtMeta(){
		return yHTML::obtMeta();	
	}
	
	function html_obtTitle(){
		return yHTML::obtTitle();	
	}
	
	function html_slug(){
		return yHTML::slug();	
	}
	
	function html_title( $title ){
		return yHTML::title( $title );	
	}
		
	class yHTML {
		
		public static $importar	= array();
		public static $meta		= array();
		public static $title;
		
		/**
		 * Guardar variables en array
		 */
		 public function setVar( $cadena, $llave )
		 {
			 if( $cadena != NULL )
			 {
				 $Vars[$llave] = $cadena;
			 }
		 }
		 
		/*
		 * Obtener variables en array
		 */
		 public function getVar( $llave, $default = '' )
		 {
			 if( $llave != NULL )
			 {
				 return $Vars[$llave];
			 }
			 return $default;
		 }
		
		/**
		 * Obtener Base html
		 * base() : string
		 */
		public static function base(){
			$base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\'); //$_SERVER['HTTP_HOST'] dirname($_SERVER['PHP_SELF'])
			$base = $base . '/';
			return $base;
		}
		
		/** 
		 * charset - Define el atributo Charset del 'head'
		 * @param string    $charset    Conjunto de caracteres usar.
		 */
		public static function charset( $charset = 'utf-8' ){
			$HTML = '<meta charset="' . $charset . '">' . "\n";
			return $HTML;
		}
		
		/**
		 * enlace - Crear links dinamicos
		 */
		public static function enlace( $href, $texto, $atributos = NULL, $target = NULL )
		{
			if ( is_array( $atributos ) ) {
				$atributos = explode( '\n', $atributos );
			}

			$target = ( $target != NULL ) ? ' target="' . $target . '" ' : '';

			return '<a href="' . $href . '" ' . $atributos . $target . '>' . $texto . '</a>';

		}
		
		/**
		 * importar - Importar ficheros JS, CSS
		 * @param string    $camino_archivo    Ruta de ficheros que se importarán  
		 */
		static public function importar( $camino_archivo ){
			
			$tipo_archivo	= strtolower( $tipo_archivo );
			$clave			= str_replace( '/', '', $camino_archivo  );
			if( !empty( $camino_archivo ) ){
				self::$importar[$clave] = $camino_archivo;
			}
			return false;
		}
		
		/**
		 * incluir_tpl - Incluir platillas html
		 * @param string    $tpl_uri    Ruta de platilla
		 */
		public static function incluir_tpl( $tpl_uri )
		{
			if( file_exists( $tpl_uri ) ){
				$tpl = file_get_contents( $tpl_uri );
				return $tpl;
			}
			return false;
		}
		
		/**
		 * meta - Describe metadata de HTML 
		 * @param string    $name    
		 */
		public static function meta( $atributos = NULL ){
			$atributos	= explode( '|', $atributos );
			$i=0;
			if( is_array( $atributos ) ){
				for( $i; $i < count( $atributos ); $i++ ){
					self::$meta[] = trim( $atributos[$i] );
				}
				return;
			}
			//self::$meta[] = "\t" . '<meta ' . trim( $atributos ) . ' />' . "\n";
		}
		
		/**
		 * Obtener las importaciones CSS y JS almacenadas
		 * obtImportacion() : string
		 */
		public static function obtImportacion(){
			$archivos_importar = '';
			foreach( self::$importar as $c => $v ){
				$ext	= explode( '.', $v );
				
				if( $ext == 'js' ){
					$archivos_importar .= "\t\n" . '<script src="' . self::$importar[ $v ] . '"></script>' . "\n";
				}elseif( $ext == 'css' ){
					$archivos_importar .= "\t\n" . '<link rel="stylesheet" href="' . self::$importar[ $v ] . '">' . "\n";
				}
			}
			
			return $archivos_importar;
		}
		
		/**
		 * Obtiene el array de metas HTML
		 * obtMeta() : string
		 */
		public static function obtMeta(){
			$meta = '';
			foreach( self::$meta as $c => $v ){
				$meta .= ( !empty( self::$meta[ $c ] ) ) ? "\t" . '<meta ' . self::$meta[ $c ] . ' />' . "\n" : '';
			}
			
			return $meta;
		}
		
		/**
		 * Obtiene el título de la pagina web
		 * obtTitle() : string
		 */
		public static function obtTitle(){
			return self::$title;
		}
		
		/**
		 * Extrae el slug del sitio
		 * slug() : string
		 * ej.	www.misitioweby.com/zapatos/mujer/botas
		 *		Retorna: zapatos/mujer/botas
		 */
		public static function slug(){
			$base		= preg_replace('/^(\/)/','', self::base() );
			$base_slug	= preg_replace('/^(\/)/','',$_SERVER['REQUEST_URI']);
			$slug		= str_replace( $base, '', $base_slug );

			if( !empty($slug) ) return $slug;
			
			return false;
		}
		
		/** 
		 * title - Establece el titulo de pagina
		 * @param string    $title    Titulo de la pagina web
		 */
		public static function title( $title = 'Sin Título' ) {
			self::$title = "\t" . '<title>' . $title . '</title>' . "\n";
		}
	}
	
?>