<?php
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - yPanel
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 *
	 */
	
	/* Autorizo acceso */
		defined('YPANEL_INI') or die( 'No dispones de acceso' );
	
	class extension{
		
		public static function base(){
			$modulo		= ( isset( $_GET['panel'] ) ) ? $_GET['panel'] : 'ninguno';
			$modulo_dir	= ( isset( self::modulo( $modulo )->dir ) ) ? 'wy_incluye/wy_ext/' . self::modulo( $modulo )->dir : '';
			return base_sitioWeby() . $modulo_dir;
		}
		
		/*
		 * función para crear botones
		 */
		function boton( $tipo_boton = 'guardar', $texto = NULL, $enviar_form = false ){
			return com_boton( $tipo_boton, $texto, $enviar_form );
		}
		
		/**
		 * 
		 */
		public static function boton_toggle( $id, $value, $checked, $disabled = false, $on = '' ){
			return 	com::boton_toggle( $id, $value, $checked, $disabled, $on );
		}
		
		/**
		 * carga complementos propios de yPanel
		 */
		public static function cargar( $modulo = NULL ){
			//** verifico si el modulo existe
			if( !isset( self::dat2( $modulo )->nombre ) ) return '<h2>Acceso No Disponible.</h2><p>Error 404: La extensión solicitada, no se encontró.</p>';
			//** si el módulo existe cargo variables */
			$exthtml		= '';
			//** cargo nombre base de modulo
			$panel		= $modulo;
			//** cargo array de datos
			$modulo		= self::dat2( $modulo );
			//** obtengo nombre de modulo
			$nombre		= $modulo->nombre;
			//** obtengo descripcion de modulo
			$descrip	= $modulo->descripcion;
			//** obtengo ubicacion de directorio de modulo
			$mod_uri	= YPATH . 'wy_incluye' . YDS . 'wy_ext' . YDS . $modulo->dir;
			$mod_app	= $mod_uri . $panel . '.php';
			//** obtengo ubicacion de formulario
			$mod_frm	= $mod_uri . 'frm.php';
			//** coloco title de modulo en el head
			yPanel::title_html( etiqueta( 'h_' . $panel, $nombre ) );
			
			//** Imprimimo HTML */
			//** si el usuario posee privilegios muestro contenido de modulo
			if( yPanel::privilegio( $panel, $modulo->nivel ) )
			{
				//** creo el encabezado del modulo
				$exthtml	.= '<div class="row">
					<div class="col-lg-12">
						<div class="card">
							<div class="card-body">
									<h4 class="m-b-15">' . etiqueta( 'h_' . $panel, $nombre ) . '</h4>
									<p class="fs-small">' . etiqueta( 'p_' . $panel, $descrip ) . '</p>';
				$cModApp= '';
				$cModFrm= '';
				//** si php principal de modulo existe, lo cargo en variable
				if( file_exists( $mod_app ) ){
					ob_start(); # apertura de bufer
					include_once( $mod_app );
					$cModApp = ob_get_contents();
					ob_end_clean(); # cierre de bufer
					
					//** si existe acciones: $_getAcc del modulo cargo php 'frm' en variable
					if( file_exists( $mod_frm ) ){
						ob_start(); # apertura de bufer
						include_once( $mod_frm );
						$cModFrm = ob_get_contents();
						ob_end_clean(); # cierre de bufer
					}
					
					if( isset( $_GET['acc'] ) ){
						$exthtml .= (empty($cModFrm)) ? $cModApp:$cModFrm;
					}else{
						$exthtml .= $cModApp;
					}
				}
				
				
				$exthtml	.= '</div>
						</div>
					</div>
				</div>';
					
			}else{
				return '<h2>No dispones de privilegios para acceder.</h2><p>Ponte en contacto con tu administrador de servicio, para solicitar privilegios.</p>';
			}
			
			
			return $exthtml;
			
		}
		
		/**
		 * dat2 - obtiene datos de la extensión que se carga
		 * @param $modulo	string	nombre de la extensión que se obtendrá los datos 
		 */
		public static function dat2( $modulo = NULL ){
			$extensiones	= yPanel::$__DIR__ . '.ypanel/extensiones.y';
			//-- si no existe lib de extenciones, creo lib (para versiones antiguas)
			if( !file_exists( $extensiones ) ) { file_put_contents($extensiones, '{}'); }
			//-- Compruebo existencia de extensiones
			if( file_exists( $extensiones ) ) { 
				$data	= file_get_contents( $paneles ); 
				$data	= json_decode( $data );
				return ( isset( $data->$modulo ) ) ? $data->$modulo : false;
			}
			return false;
		}
		
		public static function etiqueta( $etiqueta, $por_defecto = '' ){
			return com::etiqueta( $etiqueta, $por_defecto );
		}
		
		/**
		 *
		 */
		public static function importar( $archivo ){
			if( empty( $archivo ) ) return false;
			
			$cImportado	= '';
			
			if( file_exists( $archivo ) ){
					ob_start(); # apertura de bufer
					include_once( $archivo );
					$cImportado .= ob_get_contents();
					ob_end_clean(); # cierre de bufer
			}
			return $cImportado;
		}
		
		//** Obtener datos POST */
		function com_obtReg( $campo, $valor_defecto = '' ){
			$tabla	= ( isset( $_GET['extension'] ) ) ? yPanel::paneles( $_GET['extension'] )->tabla : NULL;
			$tabla	= ( isset( $_GET['panel'] ) ) ? yPanel::paneles( $_GET['panel'] )->tabla : $tabla;
			if( isset( $_GET['post'] ) ) return utf8_encode( wy_mysql_obt1Reg( $tabla, "id='" . $_GET['post'] . "'", $campo ) );
			return $valor_defecto;
		}
		
		
	}
	
	
?>