<?php 
	/*
	 *
	 * 2003 - 2021 @ Yal Publicidad - yLib
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * @ypanel.ylib
	 *
	 */
	
	/* Autorizo acceso */
	defined('YPANEL_INI') or die( 'No dispones de acceso' );
	
	//* defino acceso al sistema WebyPlus
	define( "WY_INI_WEBY", true );
	define("PATH", dirname(__FILE__));
	//* defino camino al sistema ej. WebyPlus
	define("YPATH",dirname(dirname(__FILE__)));
	define("YDS",DIRECTORY_SEPARATOR);
	
	function captcha($obtener=false){
		return ylib::captcha($obtener);
	}

	function valCaptcha($vCaptcha=NULL){
		return ylib::validar_captcha($vCaptcha);
	}

	function importar($ruta=NULL, $ext=NULL){
		ylib::importar($ruta,$ext);
	}

	function paquete($rPaquete=NULL){
		ylib::paquete($rPaquete);
	}

	class ylib
	{
		private static $rutaPaquete = YPATH . YDS;	// ruta del paquete del sistema
		private static $rutaPanel	= PATH  . YDS;	// ruta del panel
		private static $clCaptcha	= array();
		
		/* captcha() : Creo codigo captcha
		 * @param  bool  $obtener    true si desea obtener el valor captcha almacenado
		*/
		public static function captcha($obtener=false){
			if(!isset($_SESSION)) session_start();
			$claveSession	= (isset($_SESSION['cCaptcha'])) ? $_SESSION['cCaptcha'] : date('YmdHis') . rand(10,999);
			if($obtener==true){
				return (isset($_SESSION[$claveSession])) ? $_SESSION[$claveSession] : date('YmdHis') . rand(10,999);
			}
			
			return $_SESSION[$claveSession] = md5(rand(10000,999999));
		}
		
		/* validar_captcha() : Valida el captcha almacenado 
		 * @param  str  $vCaptcha    valor captcha que se va a comparar
		*/
		public static function validar_captcha($vCaptcha=NULL){
			if(!isset($_SESSION)) session_start();
			$claveSession	= (isset($_SESSION['cCaptcha'])) ? $_SESSION['cCaptcha'] : date('YmdHis') . rand(10,999);
			return (isset($_SESSION[$claveSession]) && $_SESSION[$claveSession]==$vCaptcha) ? true : false;
		}
		
		/* paquete() : Cargo ruta del paquete ej. Webyplus 
		 * @param  str  $rPaquete    ruta del paquete
		*/
		public static function paquete($rPaquete=NULL){
			if(empty($rPaquete)) return false;
			self::$rutaPaquete = $rPaquete;
		}
		
		/* importar() : importa ficheros al sistema 
		 * @param  str  $rPaquete    ruta del paquete
		*/
		public static function importar($ruta=NULL, $ext=NULL){
			if(empty($ruta)) return false;
			// determino extension
			$ext	= (empty($ext)) ? '.php' : '.' . $ext;
			// creo ruta
			$ruta	= explode(".", $ruta);
			$rutax	= '';
			for($i=0;$i<count($ruta);$i++){
				// si encuentro 'sisx' en el index 0 reempazo por ruta del paquete del sistema ej. Webyplus
				if($ruta[0]=='sisx') {
					$ruta[0] = self::$rutaPaquete;
				}elseif($ruta[0]=='ypanelx') { // parametro adicional para incluir desde yPanel
					$ruta[0] = self::$rutaPanel . $ruta[0];
				}else{
					$ruta[0] = self::$rutaPanel . $ruta[0];
				}
				
				$rutax .= $ruta[$i] . '/';
			}
			$rutax	= trim($rutax,'/');
			$path	= $rutax . $ext;
			// cargo fichero / leo ruta de archivo
			if(is_file($path)){
				include_once($path);
			}
			return;
		}
		
		
	}
	
	
?>