<?php

	/*
	 *
	 * 2003 - 2016 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * @lib funciones
	 *
	 * Sesiones del sitio web Weby+
	 *
	 */
	 
	 /* Autorizo acceso */
		defined('WY_Ini_Weby') or die( 'No dispones de acceso' );
	
	/*
	 * Agregar metatag en el head
	 */
	function wyp_agregar_meta( $meta ){
		if( !empty( $meta ) )
			return '<meta charset="' . $charset . '">' . "\n";
		
		return false;
	}
	
	/*
	 * Obtener la base del sitio Weby+
	 */
	function Base_SitioWeby(){
			$base = rtrim(dirname(dirname($_SERVER['SCRIPT_NAME'])), '/\\');
			$base = $base . '/';
			return $base;
	}
	
	/*
	 * Mostrar etiqueta
	 */
	function wyp_etiqueta( $etiqueta, $por_defecto = '' ){
		if( isset( $_SESSION['wyp_us'] ) ) return ( isset( wyp_json( 'datos/lng/' . wyp_us_lng( $_SESSION['wyp_us'] ) . '.lng' )->$etiqueta ) ) ? wyp_json( 'datos/lng/' . wyp_us_lng( $_SESSION['wyp_us'] ) . '.lng' )->$etiqueta : $por_defecto;
		return false;
	}
	
	/*
	 * Conecto todas las extensiones registradas
	 */
	function conectar_extensiones(){
		$q = obt_query( "extensiones", "WHERE publicado = '1'" );
		$ext = '';
		while( $r = query_array( $q ) ){
			$ext .= '<li>' . WYHTML::link( post_link( 'plugin_extension' ) . '&extension=' . $r['extension'], ' &nbsp; ' . $r['extension'], 'class="fa fa-plug"' ) . '</li>';
		}
		return $ext;
	}
	
	/*
	 * Head yPanel
	 */
	function wyp_head_yPanel( $WyP_Titulo = 'Panel' ){
		$charset	= ( WYCFG_WYCHARSET != NULL ) ? WYCFG_WYCHARSET : 'utf-8';
		$autor		= WYCFG_Soporte;
		
		$Head = '<meta charset="' . $charset . '">' . "\n";
		$Head .= "\t" . '<meta name="author" content="' . $autor . '" />' . "\n";
		$Head .= "\t" . '<title>' . $WyP_Titulo . ' - yPanel</title>' . "\n";
		$Head .= "\t" . '<link rel="icon" href="favicons/favicon.png" type="image/x-icon">' . "\n" .
				 "\t" . '<link rel="shortcut icon" href="images/favicons/favicon.png" type="image/x-icon"/>' . "\n";
		
		return $Head;
	}
	
	/*
	 * Funcion para leer json
	 */
	function wyp_json( $url_json, $asociativo = false ){
		$url_json = YPATH . YDS . 'ypanel' . YDS . '.ypanel' . YDS . $url_json;
		$f = '';
		if( file_exists( $url_json ) ){
			$data	= file_get_contents( $url_json );
			$data	= json_decode( $data, $asociativo );
			return $data;
		}else{
			 return false;
		}
	}
	
	/*
	 * Funcion para escribir json
	 */
	function wyp_json_escribir( $url_json, $json ){
		//$str = file_get_contents('data.json');//get contents of your json file and store it in a string,bro small suggestion never keep any JSON data in ur html file its not safe.always keep json data in external file.
        //$arr = json_decode($str, true);//decode it
		
		$url_json = YPATH . YDS . 'ypanel' . YDS . '.ypanel' . YDS . $url_json;
		
		if ( !empty( $json ) )
		{
			$file = fopen( $url_json , 'w' );
			fwrite($file, $json);
			fclose($file);
			return $json;
		}
		return false;
	}
	
	/*
	 * Funcion para crear caja de mensaje
	 */
	function wyp_mensaje( $mensaje, $tipo = 'Correcto', $prefijo = false ){
		
		$MsjClass = 'm-bien';
		
		switch($tipo){
			case 'Correcto':
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
			case 'Atento':
					$MsjClass	= 'm-atento';
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
			case 'Cuidado':
					$MsjClass	= 'm-cuidado';
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
			case 'Error':
					$MsjClass	= 'm-error';
					$prefijo	= ($prefijo != false) ? '<strong>&iexcl;' . $tipo . '!</strong> &nbsp; ':'';
				break;
		}
		
		return '<div class="' . $MsjClass . '">' . $prefijo . $mensaje . '</div>';
	}
	
	/*
	 * Obtener privilegios de nivel del usuario
	 */
	function wyp_n_privilegios_usr( $t_nivel = NULL, $item = NULL, $item1 = NULL ){
		$nivel = wyp_nivel_usr( $_SESSION['wyp_us'] );
		
		if( $item != NULL ){
			return ( isset( wyp_json( 'niveles.conf' )->$nivel->$t_nivel->$item ) ) ? wyp_json( 'niveles.conf' )->$nivel->$t_nivel->$item : false;
		}elseif( $item1 != NULL ){
			return ( isset( wyp_json( 'niveles.conf' )->$nivel->$t_nivel->$item->$item1 ) ) ? wyp_json( 'niveles.conf' )->$nivel->$t_nivel->$item->$item1 : false;
		}else{
			return ( isset( wyp_json( 'niveles.conf' )->$nivel->$t_nivel ) ) ? wyp_json( 'niveles.conf' )->$nivel->$t_nivel : false;
		}
	}
	
	/*
	 * Obtener nivel de usuario
	 */
	function wyp_nivel_usr( $usuario ){
		if( empty( $usuario ) ) return false;
		$nivel = ( isset( wyp_json( 'cuentas_usuarios' )->$usuario->nivel ) ) ? wyp_json( 'cuentas_usuarios' )->$usuario->nivel : 'no_nivel';
		
		if( $nivel != 'no_nivel' ){
			$nivel_id = ( isset( wyp_json( 'niveles' )->$nivel ) ) ? wyp_json( 'niveles' )->$nivel : false;
			return $nivel_id;
		}else{
			return false;
		}
	}
	
	/*
	 * No Cache
	 */
	function wyp_no_cache(){
		header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
		header("Cache-Control: post-check=0, pre-check=0", false);
		header("Pragma: no-cache");
	}
	
	/*
	 *  Funcion saludo de bienvenida
	 */
	function wyp_saludo_bienvenida( $cadena = NULL ){
		//$hoy = getdate(); 
		//$hora=$hoy["hours"];
		$hora = gmdate( 'H', obt_GMT( GMT ) ); 
		if ($hora<6) { 
			echo( wyp_etiqueta( 'e_madrugado', 'Hoy has madrugado mucho' ) . " " . $cadena ); 
		}elseif($hora<12){ 
			echo( wyp_etiqueta( 'e_buenos_dias', 'Buenos días' ) . " " . $cadena ); 
		}elseif($hora<=18){ 
			echo( wyp_etiqueta( 'e_buenas_tardes', 'Buenas Tardes' ) . " " . $cadena ); 
		}else{ echo( wyp_etiqueta( 'e_buenas_noches', 'Buenas Noches' ) . " " . $cadena ); } 
	}
	
	/*
	 * Funcion para obtener URL de sitio weby+
	 */
	function wyp_sitio_weby(){
		$Protocolo = strtolower( substr($_SERVER['SERVER_PROTOCOL'], 0, 4) ) . '://';
		return '//' . $_SERVER['HTTP_HOST'] .  Base_SitioWeby();
	}
	
	/*
	 * Obtener lenguaje definido por el usuario
	 */
	function wyp_us_lng( $usuario ){
		return ( isset( wyp_json( 'cuentas_usuarios' )->$usuario->lenguaje ) ) ? wyp_json( 'cuentas_usuarios' )->$usuario->lenguaje : 'Es-es';
	}
	
	/*
	 * Obtener usuario de sesión
	 */
	function wyp_us_sess(){
		return $_SESSION['wyp_us'];	
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	function post_categoria( $seccion = 0 ){
		if( WYSQL::existe( "secciones", "id", "id='$seccion'" ) )
			return WYSQL::_Obt1Reg( "secciones", "id='$seccion'", "nombre" );
			
		return 'Sin categor&iacute;a';
	}
	
	function post_fecha_publicacion( $fecha = NULL ){
		global $wy_func;
		
		if( !empty( $fecha ) )
			return $wy_func->fecha( $fecha, 'd/m/Y h:i:s a' );
			
		return 'Sin fecha de publicaci&oacute;n';
	}
	
	function post_link( $seccPost = 'entradas', $idPost = NULL, $accPost = NULL ){
		
		if( $accPost != NULL ) $accPost = '&acc=' . $accPost;
		if( $idPost != NULL ) $idPost = '&post=' . $idPost;
		
		return $_SERVER['PHP_SELF'] . '?secc=' . $seccPost . $idPost . $accPost;
	}
	
	function post_publicado( $publicado = 0, $icono = true ){
		if( $publicado == 1 )
			return ( $icono ) ? 'wyp-ico-publicado-16x16' : 'Acceso P&uacute;blico';
		
		return ( $icono ) ? 'wyp-ico-no-publicado-16x16' : 'S&oacute;lo yo';
	}
	
	
	
	/*
	 * Funcion para redireccionar 
	 */
	function redireccionar( $url = NULL ){
		if( isset( $_POST['r'] ) && $_POST['r'] != NULL )
			return '<script> location.href = "' . $_POST['r'] . '"; </script>';
			
		if( $url != NULL )
			return '<script> location.href = "' . $url . '"; </script>';
			
		return '';
	}
	
	
	
	
	 
	
	
?>