<?php 
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - Yal Analizador de MS Sistema
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 */
	 
class MSAcSis{
	public static $path;
	
	public static function depurar( $fichero ){
		if( self::eje_analisis( $fichero ) ){
			unlink( $fichero );
		}
	}
	
	public static function eje_analisis( $fichero ){
		$path = realpath( self::$path );
		if( file_exists( $fichero ) ){
			
				$ini = file( $fichero );
				
				if ( count( $ini ) == 0 ) { return array(); }
				
				$i = 0;
				foreach( $ini as $line ){
					$line = trim( $line );
					// Comments
					if ( $line == '' || $line{0} == ';' || $line{0} == '#' ) { continue; }
					
					$comando = explode( ' ', $line );
					
					switch( strtolower( $comando[0] ) ){
						case 'importarsql':
							_mysql_importar( $path . '/' . $comando[1], WY_DBPREFIJO );
							break;
						case 'del':
							if( file_exists( $path . '/' . $comando[1] ) ){
								if( is_dir( $path . '/' . $comando[1] ) ){
									eliminarDir( $path . '/' . $comando[1] );
								}else{
									unlink( $path . '/' . $comando[1] );
								}
							}
							break;
						case 'move':
							if( file_exists( $path . '/' . $comando[1] ) ){
								rename( $path . '/' . $comando[1], $path . '/' . $comando[2] );
							}
							break; 
						default:
							//
					}
				}
				
				return true;
		}
		return false;
	}
	
	//** funcion para abrir directorio */
	private static function abrirdir( $dir ){
		return ( is_dir( $dir ) ) ? opendir( $dir ) : false;
	}
	
	/*
	 * Funcion para eliminar directorio
	 */
	private static function eliminarDir( $dir ) { 
			$files = array_diff( scandir($dir), array('.','..') ); 
			foreach ($files as $file) {
				( is_dir( "$dir/$file" ) ) ? self::eliminarDir( "$dir/$file" ) : unlink( "$dir/$file" ); 
			}
			return rmdir( $dir );
	}

		
	/* Funcion para obtener diferencia de días
	 * entre dos fechas 
	 */
	function comparar_fechas($fecha_comparacion, $fecha_actual)
		{
			$primera = date('Y-m-d',strtotime($fecha_comparacion) );
			$segunda = date('Y-m-d',strtotime($fecha_actual) );
			
			$primera = date( "d/m/Y", strtotime( $primera ) );
			$segunda = date( "d/m/Y", strtotime( $segunda ) );
			
			$valoresPrimera = explode ("/", $primera); 
			$valoresSegunda = explode ("/", $segunda); 
			
			$diaPrimera    = $valoresPrimera[0]; 
			$mesPrimera  = $valoresPrimera[1]; 
			$anyoPrimera   = $valoresPrimera[2];
			
			$diaSegunda   = $valoresSegunda[0];
			$mesSegunda = $valoresSegunda[1]; 
			$anyoSegunda  = $valoresSegunda[2];
			
			$diasPrimeraJuliano = gregoriantojd($mesPrimera, $diaPrimera, $anyoPrimera);  
			$diasSegundaJuliano = gregoriantojd($mesSegunda, $diaSegunda, $anyoSegunda); 
			
			if(!checkdate($mesPrimera, $diaPrimera, $anyoPrimera)){
				// "La fecha ".$primera." no es v&aacute;lida";
				return 0;
			}elseif(!checkdate($mesSegunda, $diaSegunda, $anyoSegunda)){
				// "La fecha ".$segunda." no es v&aacute;lida";
				return 0;
			}else{
				return  $diasPrimeraJuliano - $diasSegundaJuliano;
			}
	}
	
	/* 
		funcion para comprimir archivos:
		$nombre_zip	= "ruta-y-nombre-del-nuevo.zip";
		$zip		= new ZipArchive();
		
		$zip->open( $nombre_zip, ZIPARCHIVE::CREATE);
		comprimir( "directorio/a/comprimir", "", $zip );
		$zip->close();
	*/
	function comprimir_dir( $ubicacion, $carpeta, $zip ){ 
		$dir = realpath( YEPATH . YEDS . $ubicacion );
		//$zip->addDir($carpeta);
		$directorio = opendir( $dir ); 
		while ( $archivo = readdir( $directorio ) ) {
			if( !is_dir( "$dir/$archivo" ) ){
				$zip->addFile( $dir . '/' . $archivo, "$carpeta/$archivo" ); 
            }else{
				if( $archivo != "." && $archivo != ".." ){
					$nuevaUbicacion = $ubicacion . "/". $archivo."/";
					comprimir_dir($nuevaUbicacion, $carpeta.$archivo."/", $zip);
				} 
			} 
		}
		closedir($directorio);
		//return $zip;
	}
	
	/* funcion para crear ID de Archivo */
		function idarchivo( $nombre ){
			 $caracteres_nulos = array( ' ', ',', '.', '-', '@', "á", "é", "í", "ó", "ú" );
			 return ( !empty( $nombre ) ) ? str_replace( $caracteres_nulos, '', $nombre ) : false;
		}
		 
	//Crear nuevos directorios completos
		function rcopiar( $source, $target ) {
			if ( is_dir( $source ) ) {
				@mkdir( $target );
				$d = dir( $source );
				while ( FALSE !== ( $entry = $d->read() ) ) {
					if ( $entry == '.' || $entry == '..' ) {
						continue;
					}
					$Entry = $source . '/' . $entry; 
					if ( is_dir( $Entry ) ) {
						full_copy( $Entry, $target . '/' . $entry );
						continue;
					}
					copy( $Entry, $target . '/' . $entry );
				}
				
				$d->close();
				
				return true;
			}else {
				return copy( $source, $target );
			}
		}
		
	
}
	
?>