<?php
	/*
	 *
	 * yMS (c) 2003 - 2020 Yal Publicidad
	 * Sistema: Macrodígital Software - de Yal Publicidad
	 *
	 */
	
	define( "YMS", true );
	
	//* Procesador de errores
	include_once( 'y_error.php' );
	
	//Definimos el tratamiento de errores no controlados
	/*set_error_handler( function()
	{
		throw new Exception( "<b>Error de conexión:</b> " );
	});*/
	
	class Y{
		
		public static $ruta_paquete;
		public static $bibliotecas	= array( "@lib" => "lib" );
		
		public static function importar( string $path ){
			if( empty( $path ) ) return false;
			
			$camino			= '';
			$ruta_paquete	= ( self::$ruta_paquete != NULL ) ? self::$ruta_paquete : dirname( dirname(__FILE__) );
			
			$path	= explode( '.', $path );
			
			if( is_array( $path ) ){
				for( $i = 0; $i < count( $path); $i++ ){
					$camino .= '/' . $path[$i];
				}
				include_once( $camino . '.php' );
			}
			
			include_once( $path[0] . '.php' );
		}
	}
	
	/* ----------------------------------- *\
			Clase iData
	\* ----------------------------------- */
	class MSiData {
		
		public $terminos			= '';
		public static $camino_ydata = '';
		public static $camino_tyc	= '';
		
		/*
		 * funcion para cargar yData.y
		 * {"version_nucleo":"1.9.15","version_php":"5.6.0","version_mysql":"50000","app_nombre":"WebyPlus","idioma":"en"}
		 */
		public static function obtener( $dato ){
			if( file_exists( self::$camino_ydata . '/iData.y' ) ){
				$iData	= file_get_contents( self::$camino_ydata . '/iData.y' );
				$iData = json_decode( $iData );
				return isset( $iData->$dato ) ? $iData->$dato : false;
			}else{
				die( '<b>Alerta!</b> MsiData archivo de sistema, no existe.' );
			}
		}
		
		public static function tyc(){
			if( file_exists( self::$camino_ydata . 'tyc/tyc.' . LNG::$idioma ) ){
				$iData	= file_get_contents( self::$camino_ydata . 'tyc/tyc.' . LNG::$idioma );
				return ( strlen( $iData ) > 55 ) ? $iData : false;
			}else{
				die( '<b>Alerta!</b> MsiData archivo de sistema, no existe.' );
			}
		}
	}
	
	//** funciones de sistema */
	require_once( 'y_funciones.php' );
	//** funciones MySQLi */
	require_once( 'y_mysql.php' );
	//** funciones html globales */
	require_once( 'y_html.php' );
	//** funciones de idioma */
	require_once( 'y_lng.php' );
	//** funciones de actualizacion */
	require_once( 'y_actualizador.php' );
	//** analizador de sistema
	require_once( 'y_anaMSsis.php' );
	//** cargo conversor de divisas
	include_once( 'y_tblconversiondivisa.php' );
	//** cargo funciones de correo
	include_once( 'y_correo.php' );
	

?>