<?php

	/*
	 *
	 * 2003 - 2016 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * @lib yp_sesiones.php
	 *
	 * Sesiones del sitio web Weby+
	 *
	 */
	 
	 /* Autorizo acceso */
		defined('YMS') or die( 'No dispones de acceso' );
		
	/*
	 * Funcion para enviar correo electrónico
	 */
	function enviar_correo( $tipo = 'Normal', $para = WYCFG_MAILUSER, $asunto = WYCFG_MAILASUNTO, $nombre = NULL, $desde = NULL, $Contenido = '', $reply = NULL, $replyName = NULL ){
		
		$tipo = strtolower( $tipo );
		
		if( $tipo == 'normal' )
			return Mail1( $para, $asunto, $desde, $Contenido );
		
		if( $tipo == 'normal-desuscripcion' )
			return Mail2( $para, $asunto, $nombre, $desde, $Contenido, $reply );
		
		if( $tipo == 'smtp' )
			return MailSMTP( WYCFG_MAILHOST, WYCFG_MAILUSER, WYCFG_MAILPASS, $desde, $nombre, $para, $asunto, $Contenido, WYCFG_MAILPORT, WYCFG_MAILSSL, $reply, $replyName );
			
		return false;
	}
	
	
	/* 
	 * Enviar @Mail Normal 
	 */
	function Mail1($para, $asunto,$desde,$Contenido){
			// Generamos los headers del mensaje 
			$headers = "From: $desde\r\n" .
			"MIME-Version: 1.0\r\n" .
			"Content-type: text/html; charset=iso-8859-1\r\n";
			//Enviamos el mensaje
			if (@mail($para, utf8_decode( $asunto ), $Contenido, $headers)){
				return 1; //envio
			}else{
				return 0; //no envio
			}
		}
		
		
	/* 
	 * Enviar @Mail con desuscripción 
	 */
	function Mail2($para,$asunto,$nombre,$desde,$Contenido,$nombre_para=NULL,$reply=NULL, $prioridad = NULL){
			if($reply==NULL){ $reply=$desde; }
			if( $nombre_para == NULL ){ $nombre_para = $para; }
			if( $prioridad > 0 ) $prioridad = "X-Priority: $prioridad\n";
			
			$nombre = utf8_decode( $nombre );
			
			//'Content-Type: multipart/alternative; boundary="'.md5(date('hmi')).'"' . "\r\n" .
			$headers = "From: " . utf8_decode( $nombre ) . " <$desde>\n" .
			"To: <$para>\n" .
			"Subject: " . utf8_decode( $asunto ) . "\n" .
			"Reply-To: $reply\n" .
			"MIME-Version: 1.0\n" .
			"List-Unsubscribe: <mailto:$desde>\n" .
			"Return-Path: $desde\n" .
			$prioridad .
			"Content-type: text/html; charset=iso-8859-1";
	
			//now sending message
			if (mail($para, utf8_decode( $asunto ), $Contenido, $headers)){
				return true; //envio
			}else{
				return false; //no envio
			}
		}
	
	/* 
	 * Enviar @Mail SMTP 
	 */
	 
	 //include_once('PHPMailer.php');
	//include_once( YPATH_LIBRERIAS . '/class.phpmailer.php' );
	include_once( 'PHPMailer.php' );
	
	function MailSMTP($host,$usuario,$password,$desde,$nombre,$para,$asunto,$Contenido,$port='25',$ssl=false,$reply=NULL,$replyName=NULL){
		
		$reply		= ($reply==NULL) ? $desde : $reply;
		$replyName	= ($replyName==NULL) ? $nombre : $replyName;
		
			$headers = "Reply-To: $reply\n" .
			"List-Unsubscribe: <mailto:$desde>\n" .
			"Return-Path: $desde\n" .
			"X-Priority: 1\n";

		$mail = new PHPMailer (); # Crea una instancia
		$mail -> isSMTP();
		$mail -> Host 		= $host;
		$mail -> Username	= $usuario;
		$mail -> Password	= $password;
		$mail -> Port		= $port;
		$mail -> SMTPAuth 	= $ssl;
		
		//$mail->setFrom( $desde, utf8_decode( $nombre ) );
		$mail -> From 			= $desde;
		$mail -> FromName 		= utf8_decode( $nombre ); # BuayaCorp Puede obtenerse del formulario, por facilidad se hace de esta manera
		//$mail -> addReplyTo($reply, $replyName);
		
		$mail -> AddCustomHeader( $headers );
		
		$mail -> AddAddress ($para);
		$mail -> Subject 		= utf8_decode( $asunto );		
		$mail -> Body 			= $Contenido;
		$mail -> IsHTML (true);
		
		//Ahora enviamos mensaje
		if ($mail -> Send ()){
			return true; //envio
		}else{
			return false; //no envio
		}
		
		
		
		
		/*//Tell PHPMailer to use SMTP
		$mail->isSMTP();
		//Enable SMTP debugging
		// 0 = off (for production use)
		// 1 = client messages
		// 2 = client and server messages
		$mail->SMTPDebug = 2;
		//Ask for HTML-friendly debug output
		$mail->Debugoutput = 'html';
		//Set the hostname of the mail server
		$mail->Host = "mail.example.com";
		//Set the SMTP port number - likely to be 25, 465 or 587
		$mail->Port = 25;
		//Whether to use SMTP authentication
		$mail->SMTPAuth = true;
		//Username to use for SMTP authentication
		$mail->Username = "yourname@example.com";
		//Password to use for SMTP authentication
		$mail->Password = "yourpassword";
		//Set who the message is to be sent from
		$mail->setFrom('from@example.com', 'First Last');
		//Set an alternative reply-to address
		$mail->addReplyTo('replyto@example.com', 'First Last');
		//Set who the message is to be sent to
		$mail->addAddress('whoto@example.com', 'John Doe');
		//Set the subject line
		$mail->Subject = 'PHPMailer SMTP test';
		//Read an HTML message body from an external file, convert referenced images to embedded,
		//convert HTML into a basic plain-text alternative body
		$mail->msgHTML(file_get_contents('contents.html'), dirname(__FILE__));
		//Replace the plain text body with one created manually
		$mail->AltBody = 'This is a plain-text message body';
		//Attach an image file
		$mail->addAttachment('images/phpmailer_mini.png');
		
		//send the message, check for errors
		if (!$mail->send()) {
			echo "Mailer Error: " . $mail->ErrorInfo;
		} else {
			echo "Message sent!";
		}*/
		
		
		
		
	}
		
?>