<?php
	
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * Modulo principal con funciones de desarrollador WebyPlus
	 *
	 */
	 
	 /* Autorizo acceso */
		defined('WY_INI_WEBY') or die( 'No dispones de acceso' );
	
	function enlace($url, $texto = '', $atributos = NULL){
		global $wy;
		return $wy->enlace($url, $texto, $atributos);
	}
	
	function es_inicio(){
		global $wy;
		return $wy->es_inicio();
	}
	
	function es_post(){
		global $wy;
		return $wy->Es_Post();
	}
	
	function es_seccion( $seccion = NULL, $nivel = 1 ){
		global $wy;
		return $wy->Es_Seccion( $seccion, $nivel );
	}
	
	function obt_base(){
		global $wy;
		return $wy->obt_base();
	}
	
	function obt_contenido( $where = NULL ){
		global $wy;
		return $wy->obt_contenido($where);
	}
	
	function obt_copyRight(){
		global $wy;
		return $wy->obt_copyRight();
	}
	
	function obt_direccion( $direccion = '' ){
		global $wy;
		return $wy->obt_direccion($direccion);
	}
	
	function obt_email( $emails = '', $br = false ){
		global $wy;
		return $wy->obt_email( $emails, $br );
	}
	
	function obt_head(){
		global $wy;
		return $wy->obt_head();
	}
	
	function obt_nombre_organizacion( $organizacion = '' ){
		global $wy;
		return $wy->obt_nombre_organizacion( $organizacion );
	}
	
	function obt_mapa(){
		global $wy;
		return $wy->obt_mapa( 'wide' );
	}
	
	function obt_mi_link_post(){
		global $wy;
		return $wy->obt_mi_link_post();
	}
	
	function obt_menu( $objetivo = '_top', $class = NULL, $limite = 5, $padre = 0, $id = 1 ){
		global $wy;
		return $wy->obt_menu( $objetivo, $class, $limite, $padre, $id );
	}
	
	function obt_menu_sociales( $ul_atributos = NULL, $li_atributos = NULL, $num_items = 5 ){
		global $wy;
		return $wy->obt_menu_sociales( $ul_atributos, $li_atributos, $num_items );
	}
	
	function obt_lista_entradas( $ul_atributos = NULL, $li_atributos = NULL ){
		global $wy;
		return $wy->obt_lista_entradas( $ul_atributos, $li_atributos );
	}
	
	function obt_slug( $id = 0, $tipo = NULL ){
		global $wy;
		return $wy->obt_slug( $id, $tipo );
	}

	function obt_telefono( $telfs = '', $br = false){
		global $wy;
		return $wy->obt_telefono( $telfs, $br );
	}
	
	function obt_titulo_principal( $solo_titulo = '' ){
		global $wy;
		return $wy->obt_solo_titulo( $solo_titulo );
	}
	
	function obt_titulo_seccion( $nombre_por_defecto = NULL ){
		global $wy;
		return $wy->obt_titulo_seccion( $nombre_por_defecto );
	}
	
	function title_bar( $title = NULL ){
		global $wy;
		return $wy->title( $title );
	}
	
	class WebyPlus {
		public $tmp_path;
		
		private $title;
		
		/**
		 * Inicia conexión y levanta el sistema WebyPlus
		 * : boll
		 */
		public function __construct( $hostName, $userName, $password, $db = NULL, $port = 3306 ){
			_mysql_conectar( $hostName, $userName, $password, $db, $port );
		}
		
		/*
		 * Importar ficheros - FUNCION OBSELETA
		 */
		public function Importar( $filePath, $base = NULL ){
			global $wy;
			static $paths;

			if (!isset($paths)) {
				$paths = array();
			}
	
			$keyPath = ( $base != NULL ) ? $base . $filePath : $filePath;
	
			if (!isset($paths[$keyPath]))
			{
				if ( ! $base ) {
					$base =  YPATH;
				}
				
				if( $base == 'plantilla/contenido' ){
					$base = EntornoWeby::temaPath();
				}
				
				if( $base == 'plantilla/extension/home' ){
					$base = YPATH_EXTENSION;
					$filePath = $filePath . '.wy_ext_home';
				}
	
				//$partes = explode( '.', $filePath );
	
				$path  = str_replace( '.', YDS, $filePath );
	
				$rs   = include($base.YDS.$path.'.php');
	
				$paths[$keyPath] = $rs;
			}
	
			return $paths[$keyPath];
		}
		 
		/**
		 * Devuelve true si no encuentra slug, false si encuentra slug
		 * es_inicio() : Bool
		 */
		public function es_inicio()
		{
			$slug_partes[0] = NULL;
			$slug = html_slug();
			if( !empty($slug) ) $slug_partes= explode('/',$slug);
			
			if( !empty($slug_partes[0]) ){
				if( wy_mysql_existe( "secciones", "slug", "slug='" . $slug_partes[0] . "'" ) ){
					return false;
				}
			}
			return true;	
		}
		
		/**
		 * Devuelve true si encuentra una entrada, false si no encuentra una entrada
		 * es_post() : Bool
		 */
		public function es_post(){				
			/* Leo slug */
				$slug		= html_slug();
				if( !empty($slug) ) $slug_partes = explode('/',$slug);
					
				if( !empty( $slug_partes ) ){						
						// Obtengo el ultimo slug
						$slug = end( $slug_partes );
						if( wy_mysql_existe( "contenido", "slug", "slug='$slug'" ) ) return true;
				}
				
			/* Compruebo si se usa slug o variables */
				if( isset( $_GET['id'] ) ) {
						if( wy_mysql_existe( "contenido", "id", "id='" . $_GET['id'] . "'" ) ) return true;
				}
				
			return false;
		}
		
		/**
		 * Devuelve true si encuentra una seccion, false si no encuentra una seccion
		 * es_seccion( $seccion, $nivel ) : Bool
		 * @param string    $seccion    Nombre de la seccion a evaluar
		 * @param int       $nivel      Nivel de slug que se va a comparar
		 */
		public function Es_Seccion( $seccion = NULL, $nivel = 1 )
		{
			$nivel = ( $nivel - 1 );
			
			// Leo slug
				$slug_partes= array();
				$slug		= html_slug();
				if( !empty($slug) ) $slug_partes= explode('/',$slug);
					
			// Si no busco seccion especifica
				if( $seccion == NULL ){
					if( !empty( $slug_partes ) ){						
						// Obtengo el ultimo slug
						$slug = end( $slug_partes );
						if( _mysql_existe( WY_DBPREFIJO . "secciones", "slug", "slug='$slug'" ) ) return true;
					}
				}else{						
					if( !empty($slug_partes[$nivel]) ){
						// comparo si el slug es igual al nombre de la seccion
						if( $slug_partes[$nivel] == $seccion ){
							return true;
						}
					}
				}
				
			return false;
		}
		
		/*public function Es_Seccion( $seccion = NULL, $nivel = 1 )
		{ 
			// Si no busco seccion especifica
			if( $seccion == NULL ){
				//* Leo slug
					$slug_partes= array();
					$slug		= html_slug();
					if( !empty($slug) ) $slug_partes= explode('/',$slug);
						
					if( !empty( $slug_partes ) ){						
							// Obtengo el ultimo slug
							$slug = end( $slug_partes );
							if( wy_mysql_existe( "secciones", "slug", "slug='$slug'" ) ) return true;
					}
					
			// Si busco seccion especifica
			}else{
				$nivel = ( $nivel - 1 );
				$Slug_partes[$nivel] = NULL;
				$Slug = html_slug();
				if( !empty($Slug) ) $Slug_partes= explode('/',$Slug);
				
				if( !empty($Slug_partes[$nivel]) ){
					if( $Slug_partes[$nivel] == $seccion ){
						return true;
					}
				}
			}
			return false;
		}
		
		/**
		 * enlace - crear enlace html
		 * @param string    $url          Url del enlace
		 * @param string    $texto        Texto del enlace
		 * @param string    $atributos    Atributos del enlace
		 */
		public function enlace($url, $texto = '', $atributos = NULL)
		{
			if( $texto != '' || $texto != NULL )
				return html_enlace( $url, $texto, $atributos );
				
			return '';	
		}
		
		/**
		 * head_html - Obtener head html del sitio WebyPlus
		 * @param string   $charset    Conjunto de caracteres usar. 
		 */
		public function head_html( $charset = NULL ){

			$head	= html_charset( $charset );
			$head	.= "\t" . '<base href="' . html_base() .'">' . "\n";
			$title	= trim( strip_tags( $this->obt_title() ) );
			$head	.= "\t" . '<title>' . $title . '</title>' . "\n";
			$head	.= html_obtMeta();

			$head .= "\n\t" . '<link rel="stylesheet" href="css/styles.css">' . "\n" .
					 "\t" . '<script type="text/javascript" src="js/jsy-scriptv2.js"></script>' . "\n" .
					 "\t" . '<script type="text/javascript" src="js/jsy-script.js"></script>' . "\n" .
					 "\t" . '<meta name="generator" content="' . App_Organizacion . '" />' . "\n" .
					 "\t" . '<link rel="icon" href="images/favicon.png" type="image/x-icon">' . "\n" .
					 "\t" . '<link rel="shortcut icon" href="images/favicon.png" type="image/x-icon"/>' . "\n";		  
			return $head;
		}
		
		/**
		 * obt_base - retorna la ubicación base del sitio web
		 * obt_base() : string
		 * 
		 */
		 public function obt_base(){
			 return str_replace( '\\', '/', html_base() . EntornoWeby::temaPath( true ) );
		 }
		
		/**
		 * obt_contenido() - Obtengo el contenido de las entradas
		 * @param string    $where    Parametros de consulta
		 */
		public function obt_contenido( $where = NULL ){
				
				if( $where != NULL ) return _mysql_query( "SELECT * FROM " . WY_DBPREFIJO . "contenido " . $where );
				
				
				if( $orden != NULL ) $orden = " ORDER BY " . $orden;
				 
				$parametros = '';
				
				/* Leo slug */
					$Slug		= html_slug();
					if( !empty($Slug) ) $Slug_partes= explode('/',$Slug);
					
					if( !empty( $Slug_partes ) ){						
						// Obtengo el ultimo slug
						$Slug = end( $Slug_partes );
					}else{ $Slug = NULL; }
					
				/* Muestro contenido de Entradas */
					//Si existe slug como entrada muestro el contenido de la entrada
						if( _mysql_existe( WY_DBPREFIJO  . "contenido", "slug", "slug='$Slug' AND publicado='1'" ) )
							$parametros = "id='" . _mysql_obtener_reg( WY_DBPREFIJO  . "contenido", "slug='$Slug'", "id" ) . "' AND";
							
					// Si existe slug como seccion muestro las entradas anidadas a la seccion
						if( _mysql_existe( "secciones", "slug", "slug='$Slug' AND publicado='1'" ) ) 
							$parametros = "seccionid='" . _mysql_obtener_reg( WY_DBPREFIJO  . "secciones", "slug='$Slug'", "id" ) . "' AND padreid='0' AND";
							
				
				/* Compruebo si se usa slug o variables */
					if( isset( $_GET['id'] ) ) $parametros = "WHERE id='" . $_GET['id'] . "'";
						
				
				return _mysql_query( "SELECT * FROM " . WY_DBPREFIJO . "contenido WHERE $parametros publicado='1' " . $orden );
		}
		
		/**
		 * Obtiene copyright de la organización
		 * obt_copyRight() : string
		 * 
		 */
		public function obt_copyRight(){
			$organizacion	= ( WY_ORGANIZACION != NULL ) ? WY_ORGANIZACION : NULL;
			$html =   '		<div class="copy">' . "\n" .
					  '					<span>&copy;&nbsp;</span>' . "\n" .
					  '					<span id="copyright-year">' . date('Y') . '</span><span>&nbsp;' . $Organizacion . '.&nbsp;</span>' . "\n" .
					  '					<span>Todos los derechos reservados.</span>' . "\n" .

					  '                 <span>&nbsp;&bull;&nbsp;</span>' . "\n" .

					  '                 <span>Designed by <a class="wm" href="' . App_Organizacion_web . '" target="_blank">' . App_Organizacion . '</a>, with technology <a class="wmt" href="' . App_web . '" target="_blank">' . App_NombreOriginal . '</a></span>

					  		</div>';

							

			print $html;
		}
		
		/**
		 * obt_direccion - Obtiene email de contactos almacenado en configuración
		 * @param string    $direccion    Valor por defecto que se mostrará si no se encuentran direcciones
		 */
		public function obt_direccion( $direccion = '' )
		{
			if( WY_DIRECCION != NULL ){
				$direccion = WY_DIRECCION;
			}
			return $direccion;
		}
		
		/**
		 * obt_email - Obtiene emails de contactos almacenado en configuración
		 * @param string    $emails    Valor por defecto que se mostrará si no encuentran emails
		 * @param bool      $br        true si se desea obtener un email por linea
		 */
		public function obt_email( $emails = '', $br = false )
		{
			$br	= ( $br ) ? '<br>' : ' ';
			if( WY_EMAILS != NULL ){
				$email = explode(',', WY_EMAILS);
				
				for($i=0; $i < count($email); $i++){
					$emails .= '<a href="mailto:' . $email[$i] . '">' . $email[$i] . '</a>' . $br;
				}
			}
			return $emails;
		}
		 
		/**
		 * Obtener atributos 'head' del sitio WebyPlus 
		 * obt_head() : string
		 */
		public function obt_head(){
			$q	= self::obt_contenido();
			$r	= _mysql_fetch_array($q);
			
			//* Cargo titulo
				self::title();
			//* creo metas			
				$tags		= ( html_slug() ) ? $r['tags'] : WY_KEYWORDS;
				html_meta( 'name="robots" content="index, follow" | name="description" content="' . WY_DESCRIPTION . '" | name="keywords" content="' . $tags . '" | name="rating" content="General" | name="DC.Language" content="Spanish"' );
				html_meta( 'name="author" content="' . App_Organizacion . '"' );
				$_head		= self::head_html( WY_CHARSET );
			
			
			if( html_slug() ) {
				$image	= ( $r['imagenpost'] != NULL ) ? 'http://' . $_SERVER['HTTP_HOST'] . rtrim( dirname( $_SERVER['SCRIPT_NAME'] ), '/\\' ) . '/' . $r['imagenpost'] : NULL;
				
				$_head .= "\n" . '	<meta property="og:title" content="' . $title . '"/>' .
						  "\n" . '	<meta property="og:url" content="' . $this->obt_mi_link_post() . '"/>' .
						  "\n" . '	<meta property="og:site_name" content="' . $_SERVER['HTTP_HOST'] . '"/> ' . 
						  "\n" . '	<meta property="og:image" content="' . $image . '"/>' .
						  "\n" . '	<meta property="og:description" content="' . WY_DESCRIPTION . '"/>' .
						  "\n" . '	<meta property="og:type" content="article"/>' .
						  "\n" . '	<meta name="twitter:card" content="summary_large_image"/>' .
						  "\n" . '	<meta name="twitter:title" content="' . $title . '"/>' .
						  "\n" . '	<meta property="twitter:description" content="' . WY_DESCRIPTION . '"/>' .
						  "\n" . '	<meta name="twitter:image" content="' . $image . '"/>' .
						  "\n" . '	<meta property="article:tag" content="' . $tags . '"/>';
			}
			
			print $_head;
		}
		
		/**
		 * obt_nombre_organizacion - Obtener nombre de la organización administradora 
		 *                           del sitio WebyPlus.
		 * @param string    $organizacion    Valor por defecto que se mostrará 
		 *                                   si no encuentra el nombre de organizacion.
		 */
		public function obt_nombre_organizacion( $organizacion = '' )
		{
			if( WY_ORGANIZACION != NULL ){
				return WY_ORGANIZACION;
			}
			return $organizacion;
		}
		
		/**
		 * obt_mapa - Obtengo mapa del sitio WebyPlus
		 * @param string    $tipo    Valor por defecto que se mostrará, si no se obtiene mapa 
		 */
		 public function obt_mapa( $tipo = 'wide' )
		 {
			 $mapa = '';
			 if( WY_MAPA != NULL )
			 {
			 	$mapa = WY_MAPA;
			 }
			 
			 return $mapa;
		 }
		
		/**
		 * obt_mi_link_post() : string
		 * Obtengo el link de la entrada o seccion actual 
		 */
		public function obt_mi_link_post(){
			$http	= ( isset( $_SERVER['HTTPS'] ) ) ? 'https://' : 'http://';
			$link	= $http . $_SERVER['HTTP_HOST'] . rtrim( dirname( $_SERVER['SCRIPT_NAME'] ), '/\\' ) . '/' . self::obt_slug();
			return $link;
		}
		
		
		
		/**
		 * obt_menu - Obtiene el menu de navegacion del sitio WebyPlus
		 * @param string    $objetivo
		 * @param string    $class
		 * @param int       $limite
		 * @param int       $padre
		 * @param int       $id
		 * 
		 */
		public function obt_menu( $objetivo = '_top', $class = NULL, $limite = 5, $padre = 0, $id = 1 ){
			
			// Defino objetivo
				if( $objetivo != NULL ) $objetivo = "posicion='$objetivo' and";

			/* Leo slug */
				$slug		= html_slug();
				if( !empty($slug) ) $slug_partes= explode('/',$slug);

				if( !empty( $slug_partes ) ){
					/* Busco coinciencias */
					$slug = $slug_partes[0];						
				}else{
					$slug = 1;
				}

			$limite		= ( $limite != 0 ) ? "LIMIT 0,$limite" : "";
			$_menu	= '<ul ' . $class . '>' . "\n";

			$Q = _mysql_query( "SELECT * FROM " . WY_DBPREFIJO . "menu WHERE $objetivo padre = '$padre' ORDER BY orden ASC $limite" );
			while( $row = _mysql_fetch_array( $Q ) ){
				if( $row['tipo'] == 'contenido' && $row['publicado'] == 1 ){

					$_menu .= '<li><a href="';

					if($row['slug']!=NULL){
						$_menu .= $row['slug'];
					}else{						
						if($row['link']!=NULL)
							$_menu .= $row['link'];
						else
							$_menu .= './';
					}		

					$_menu .= '" class="';			

					if( $row['id'] == $slug || $row['slug'] == $slug || $row['link'] == $slug ) $_menu .= 'activo';

					$_menu .= '">' . utf8_encode($row['nombre']) . '</a>';
					
					/* Creo sub menu si existe */
						if( wy_mysql_existe( "menu", "padre", "padre='" . $row['id'] . "'" ) ) $_menu .= $this->obt_menu( 0, NULL, '', 0, $row['id'] );

					/* *** */
					$_menu .= '</li>' . "\n";
				}
			}	

			$_menu .= '</ul>' . "\n";

				print $_menu;
		}
		
		/**
		 * obt_menu_sociales - Obtiene las redes sociales del sitio WebyPlus
		 * @param string    $ul_atributos
		 * @param string    $li_atributos
		 * @param int       $num_items
		 */
		public function obt_menu_sociales( $ul_atributos = NULL, $li_atributos = NULL, $num_items = 5 ){
			
			$sql = _mysql_query( "SELECT * FROM " . WY_DBPREFIJO . "menu WHERE tipo='redes_sociales' AND publicado='1' LIMIT 0,$num_items" );
			
			$_mnu = '<ul ' . $ul_atributos . '>' . "\n";
			
			while( $row = _mysql_fetch_array( $sql ) ){
				$_mnu_texto = ( $row['icono'] != NULL ) ? '<img src="' . $row['icono'] . '" alt="">' : $row['nombre'];
				
				$_mnu .= "\t" . '<li ' . $li_atributos . '>' . html_enlace( $row['link'], $_mnu_texto, $row['atributos'], $row['target'] ) . '</li>' . "\n";
			}
			
			$_mnu .= '</ul>' . "\n";
			
			return $_mnu;
		}
		
		/**
		 * obt_lista_entradas - Obtiene la lsta de entradas de la seccion actual
		 * @param string    $ul_atributos
		 * @param string    $li_atributos
		 */
		public function obt_lista_entradas( $ul_atributos = NULL, $li_atributos = NULL ){
			
			$q = _mysql_query("SELECT * FROM " . WY_DBPREFIJO . "secciones WHERE publicado='1'");
			$_list = '<ul ' . $ul_atributos . '>' . "\n";
			while( $row = _mysql_fetch_array( $q ) ){
				
				$_id_s		= $row['id'];
				$_slug_s	= $row['slug'];
				$_slugSec	= ( $_slug_s != NULL ) ? $_slug_s : 'index.php?iSec=' . $_id_s;
				
				$_list .= "\t<li " . $li_atributos . '>' .
						  html_enlace( self::slug_seccion( $row['id'] ), 
										   utf8_encode( $row['nombre'] ) );
										  
					$q1 = _mysql_query("SELECT * FROM " . WY_DBPREFIJO . "contenido WHERE seccionid='$_id_s' AND publicado='1'");
					$q1_num = wy_mysql_contar_reg( "contenido", "seccionid", "seccionid='$_id_s'" );
					
					if( $q1_num ) $_list .= "\n\t\t<ul>\n";
					while( $r = _mysql_fetch_array( $q1 ) ){
						
						$_id_c		= $r['id'];
						$_slug_s	= ( $_slug_s != NULL ) ? $_slug_s : $_id_s;
						$_slugCont	= ( $r['slug'] != NULL ) ? $_slug_s . '/' . $r['slug'] : 'index.php?iSec=' . $_id_s . '&id=' . $_id_c;
						
						$_list .= "\t\t\t<li>" .
								  html_enlace( self::slug_contenido( $r['id'] ),
												   utf8_encode( $r['titulo'] ) ) .
								  "</li>\n";
					}
					if( $q1_num ) $_list .= "\t\t</ul>";
				
				$_list .= "</li>\n";
			}
			$_list .= "</ul>\n";
			
			echo $_list;
		}
		
		/*
		 * funcion obsoleta - pronto a eliminar
		 */
		public function obt_query( $tabla = '', $arg = '' )
		{
			if( !empty( $tabla ) ){
				return wy_mysql_query( $tabla, $arg );
			}
			 
			 return false;
		}
		 
		/**
		 * obt_slug - obtiene el slug de actual / entrada / sección
		 * @param int       $id
		 * @param string    $tipo
		 */
		public function obt_slug( $id = 0, $tipo = NULL ){
			 $tipo	= strtolower( $tipo );
			 switch( $tipo ){
				 case 'contenido':
				 		return self::slug_contenido( $id );
				 	break;
				 case 'seccion':
				 		return self::slug_seccion( $id );
				 	break;
				default:
					return html_slug();
			 }
			 return '';
		}
		
		 
		/**
		 * obt_solo_titulo - Obtiene titulo de sitio WebyPlus
		 * @param string    $solo_titulo
		 */
		public function obt_solo_titulo( $solo_titulo = '' )
		{
			if( WY_TITLE != NULL ){
				return WY_TITLE;
			}
			return $solo_titulo;
		}
		
		/**
		 * obt_telefono - Obtiene telefono de contactos almacenado en configuraciones
		 * @param string    $tefs
		 * @param bool      $br
		 */
		public function obt_telefono( $telfs = '', $br = false)
		{
			$br	= ( $br ) ? '<br>':' ';
			
			if( $telfs == '' && WY_TELEFONOS != NULL ){
				$telefono = explode(',', WY_TELEFONOS);
				
				for($i=0; $i < count($telefono); $i++){
					$telfs .= '<a class="o-telefono" href="tel:' . extraerNum($telefono[$i]) . '">' . $telefono[$i] . '</a>' . $br;
				}
			}
			return $telfs;
		}
		
		/**
		 * obt_title() : string
		 * Obtiene el titulo del sitio WebyPlus
		 */
		public function obt_title(){
			return $this->title;
		}
		
		/**
		 * obt_titulo_seccion - Obtener titulo de seccion sitio WebyPlus
		 * @param string     $nombre_por_defecto
		 */
		public function obt_titulo_seccion( $nombre_por_defecto = NULL )
		{
			$slug_partes	= array();
			//$nombre_seccion	= $nombre_por_defecto;
			$slug = html_slug();
			if( !empty($slug) ) $slug_partes= explode('/',$slug);
			
			if( !empty( $slug_partes ) ){
				$slug = end( $slug_partes );
				
				if( wy_mysql_existe( "contenido", "slug", "slug='$slug' AND publicado='1'" ) ) {
					$idSec	= wy_mysql_obt1Reg( "contenido", "slug='" . $slug . "'", "seccionid" );
					return utf8_encode( wy_mysql_obt1Reg( "secciones", "id='" . $idSec . "'", "nombre" ) );
				}
				
				return utf8_encode( wy_mysql_obt1Reg( "secciones", "slug='" . $slug . "'", "nombre" ) );
				
			}
			
			
			return $nombre_por_defecto;
		}
		
		/**
		 * slug_contenido - Obtiene slug de entrada
		 * @param int    $id
		 */
		private function slug_contenido( $id )
		{
			$q = wy_mysql_query( "contenido", "WHERE id=$id" );
			$r = _mysql_fetch_array( $q );
			 
			 $slug_seccion	= ( $r['seccionid'] > 0 ) ? self::slug_seccion( $r['seccionid'] ) . '/' : NULL;
			 $slug_por_id	= ( $id > 0 ) ? 'index.php?id=' . $id : NULL;
			 $slug			= ( $r['slug'] != NULL ) ? $slug_seccion . $r['slug'] : $slug_por_id;
			 
			 return $slug;
		}
		
		/**
		 * slug_seccion - Obtiene slug de seccion
		 * @param int    $idSec
		 */
		private function slug_seccion( $idSec )
		{
			$q = wy_mysql_query( "secciones", "WHERE id='$idSec'" );
			$r = _mysql_fetch_array( $q );
			 
			 $slug_padre	= ( $r['padre'] > 0 ) ? $this->slug_Seccion( $r['padre'] ) . '/' : NULL;
			 $slug			= ( $r['slug'] != NULL ) ? $slug_padre . $r['slug'] : NULL;
			 
			 return $slug;
		}
		
		/**
		 * title - almacena titulo que se mostrará en sitio WebyPlus
		 * @param string    $title
		 */
		public function title( $title = NULL )
		{	
			// title personalizado
			if( !empty( $title ) ){
				$this->title = $title;
				return;
			}
			
			/* Leo slug */
					$slug		= html_slug(); 
					if( !empty($slug) ) $slug_partes = explode('/',$slug);

					if( !empty( $slug_partes ) ){
						/* Busco coinciencias */
						$slug		= end( $slug_partes );
						$slugContent= wy_mysql_existe( "contenido", "slug", "slug='$slug'" );
						$slugSec	= wy_mysql_existe( "secciones", "slug", "slug='$slug'" );

						if( !empty( $slugContent ) && $slugContent ) {
							$title	= utf8_encode( wy_mysql_Obt1Reg( "contenido", "slug='$slug'", "titulo" ) );
							$this->title = $title;
							return;
						}

						if( !empty($slugSec) && $slugSec ) {
							$title	= utf8_encode( wy_mysql_Obt1Reg( "secciones", "slug='$slug'", "nombre" ) );
							$this->title = $title;
							return;
						}
					}

			/* Compruebo si se usa slug o variables */
				///if( isset( $_GET['id'] ) ) return utf8_encode( self::Title( WYSQL::Obt1Reg( 'contenido', 'id=' . $_GET['id'], 'titulo' ) ) );
				///if( isset( $_GET['iSec'] ) ) return utf8_encode( self::Title( WYSQL::Obt1Reg( 'secciones', 'id=' . $_GET['iSec'], 'nombre' ) ) );
				$title	= ( WY_TITLE != '' ) ? WY_TITLE : App_Nombre;
				$this->title = $title;
				return;
		}
		
	} //
	
	$wy = new WebyPlus( WY_DBHOST, WY_DBUSER, WY_DBPASS, WY_DBNAME );	

?>