<?php
	/*
	 *
	 * 2003 - 2021 @ Yal Publicidad - yPanel
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 *
	 */
	
	/* Autorizo acceso */
		defined('YPANEL_INI') or die( 'No dispones de acceso' );

	function paqueteExt($rutaExtension=NULL){
		extension::paqueteExt($rutaExtension);
	}
	
	function instalar_ext( $tmp_name = NULL ){
		return extension::instalar_ext($tmp_name);
	}

	function extBase(){
		return extension::base();
	}

	class extension{
		
		private static $rutaInstExt	= YPATH . YDS . 'res' . YDS . 'extension' . YDS;
		const RefExtension	= 'res/extension/';
		const Tabla			= WY_DBPREFIJO."extensiones";
		
		public static function base(){
			$modulo			= ( isset( $_GET['extension'] ) ) ? $_GET['extension'] : 'ninguno';
			$extension_dir	= _mysql_obtener_reg(self::Tabla, "miapp='$modulo'", "dir");
			$base_dir		= self::RefExtension . $extension_dir . '/';
			return base_sitioWeby() . $base_dir;
		}
		
		
		/*
		 * función para crear botones
		 */
		function boton( $tipo_boton = 'guardar', $texto = NULL, $enviar_form = false ){
			return com_boton( $tipo_boton, $texto, $enviar_form );
		}
		
		/**
		 * 
		 */
		public static function boton_toggle( $id, $value, $checked, $disabled = false, $on = '' ){
			return 	com::boton_toggle( $id, $value, $checked, $disabled, $on );
		}
		
		/**
		 * carga complementos propios de yPanel
		 */
		public static function cargar( $modulo = NULL ){
			$tabla	= self::Tabla;
			if(_mysql_existe($tabla, "*", "miapp='$modulo'")){
				$q = _mysql_query("SELECT * FROM `$tabla` WHERE miapp='$modulo'");
				$r = _mysql_fetch_array($q);
				//** si el módulo existe cargo variables */
				$exthtml	= '';
				//** cargo nombre base de modulo
				$panel		= $r['miapp'];
				//** obtengo nombre de modulo
				$nombre		= utf8_encode($r['nombre']);
				//** obtengo descripcion de modulo
				$descrip	= utf8_encode($r['descripcion']);
				//** obtengo ubicacion de directorio de modulo
				$mod_uri	= self::$rutaInstExt . $r['dir'];
				$index_app	= $mod_uri . YDS . $panel . '.php';
				//** coloco title de modulo en el head
				yPanel::title_html( etiqueta( 'h_' . $panel, $nombre ) );
				
				//** Imprimimo HTML */
				//** si el usuario posee privilegios muestro contenido de modulo
				if( yPanel::privilegio( $panel, $r['nivel'] ) )
				{
					//** creo el encabezado del modulo
					$exthtml	.= '<div class="row">
						<div class="col-lg-12">
							<div class="card">
								<div class="card-body">
										<h4 class="m-b-15">' . etiqueta( 'h_' . $panel, $nombre ) . '</h4>
										<p class="fs-small">' . etiqueta( 'p_' . $panel, $descrip ) . '</p>';
					$cModApp= '';
					$cModFrm= '';
					//** si php principal de modulo existe, lo cargo en variable
					if( file_exists( $index_app ) ){
						ob_start(); # apertura de bufer
						include_once( $index_app );
						$cModApp = ob_get_contents();
						ob_end_clean(); # cierre de bufer
						
						$exthtml .= $cModApp;
					}


					$exthtml	.= '</div>
							</div>
						</div>
					</div>';

				}else{
					return '<h2>No dispones de privilegios para acceder.</h2><p>Ponte en contacto con tu administrador de servicio, para solicitar privilegios.</p>';
				}
				
			}else{
				return '<h2>Acceso No Disponible.</h2><p>Error 404: La extensión solicitada, no se encontró.</p>';
			}
			
			return $exthtml;
			
		}
		
		
		/**
		 * dat2 - obtiene datos de la extensión que se carga
		 * @param $modulo	string	nombre de la extensión que se obtendrá los datos 
		 */
		public static function dat2( $modulo = NULL ){
			$extensiones	= yPanel::$__DIR__ . '.ypanel/extensiones.y';
			//-- si no existe lib de extenciones, creo lib (para versiones antiguas)
			if( !file_exists( $extensiones ) ) { file_put_contents($extensiones, '{}'); }
			//-- Compruebo existencia de extensiones
			if( file_exists( $extensiones ) ) { 
				$data	= file_get_contents( $paneles ); 
				$data	= json_decode( $data );
				return ( isset( $data->$modulo ) ) ? $data->$modulo : false;
			}
			return false;
		}
		
		public static function etiqueta( $etiqueta, $por_defecto = '' ){
			return com::etiqueta( $etiqueta, $por_defecto );
		}
		
		/**
		 *
		 */
		public static function importar( $archivo ){
			if( empty( $archivo ) ) return false;
			
			$cImportado	= '';
			
			if( file_exists( $archivo ) ){
					ob_start(); # apertura de bufer
					include_once( $archivo );
					$cImportado .= ob_get_contents();
					ob_end_clean(); # cierre de bufer
			}
			return $cImportado;
		}
		
		//** Funcion para instalar tema Weby+ 
		public static function instalar_ext( $tmp_name = NULL ){
			if( empty( $tmp_name ) ) return false;
			
			// ruta del directorio donde se instalara la extension
			$tmp_path	= self::$rutaInstExt;
			// existe archivo infoDat.inf
			$existeInfoDat = false;
			// existen ficheros .sql
			$instalar_sql = false;
			$tmp_sql = array();
			// -- si se ha subido un fichero zip lo proceso
			if( is_uploaded_file($tmp_name) ){
				// cargo clase Zip
				$zip = new ZipArchive;
				// si se abre el archivo zip temporal lo procesamos
				if ($zip->open($tmp_name) === TRUE) {
					$sql = 1;
					for($i = 0; $i < $zip->numFiles; $i++) {
						// recorro los archivos del zip
						$filename		= $zip->getNameIndex($i);
						// Leo sólo el nombre del archivo ej. carpeta/documento.txt retorna documento.txt
						$nombreArchivo	= basename( $filename );
						// extraer partes de informacion
						$partes			= pathinfo($nombreArchivo);
						// obtengo solo la extension del archivo
						$extension		= ( isset( $partes["extension"] ) ) ? $partes["extension"] : NULL;
						// -- verifico si el archivo necesario para la instalación existe
						if( basename($filename) == 'infoDat.inf' ){ $existeInfoDat = true; $rutaInfoDat = $filename; }
						// -- Si existe archivos con extension .sql se instala
						if( strtolower($extension) == 'sql') { $instalar_sql = true; $tmp_sql[$sql] = $filename; $sql++; }
					}
					
					// -- si existe infoDat se instala la extension
					if( $existeInfoDat ){
						// se extrae archivos del zip
						$zip->extractTo( $tmp_path );
						// Obtengo la ruta local del archivo infoDat.inf
						$rutaInfoDat = $tmp_path . $rutaInfoDat;
						// leo archivo infoDat.inf
						$INFO = Ini_Leer( $rutaInfoDat );
						// Comprobar si se instala .sql bd
						if( $instalar_sql == true ){
							for( $j=1; $j <= count($tmp_sql); $j++ ){
								if( file_exists( $tmp_path . $tmp_sql[$j] ) ) 
									_mysql_importar( $tmp_path . $tmp_sql[$j] );
							}
						}
						
						// inicio instalacion de extension
						$appMiApp		= $INFO['Instalacion']['App'];
						$appNombre		= utf8_decode( $INFO['Instalacion']['Nombre'] );
						$appDescripcion	= utf8_decode( $INFO['Instalacion']['Descripcion'] );
						$appUrlExtension= $INFO['Instalacion']['UrlExtension'];
						$appVersion		= $INFO['Instalacion']['Version'];
						$appAutor		= utf8_decode( $INFO['Instalacion']['Autor'] );
						$appTabla		= $INFO['Instalacion']['Tabla'];
						$appDir			= $INFO['Instalacion']['Directorio'];
						$appMnuTexto	= utf8_decode( $INFO['Instalacion']['MenuTexto'] );
						$appMnuTextoLng	= $INFO['Instalacion']['MenuTextoIdLng'];
						$appNivel		= $INFO['Instalacion']['Nivel'];
						if(_mysql_existe("yse_extensiones", "*", "miapp='$appMiApp'")){
							// actualizo extension
							if(_mysql_query("UPDATE `" . WY_DBPREFIJO . "extensiones` SET `nombre`='$appNombre',`descripcion`='$appDescripcion', `url_extension`='$appUrlExtension', `version`='$appVersion', `autor`='$appAutor', `tabla`='$appTabla', `dir`='$appDir', `mnu_texto`='$appMnuTexto', `mnu_texto_cod_lng`='$appMnuTextoLng', `nivel`='$appNivel' WHERE miapp='$appMiApp'")){
								return 'EXTACTOK';
							}else{
								return 'EXTACTNO';
							}		
						}else{
							if(_mysql_query("INSERT INTO `" . WY_DBPREFIJO . "extensiones`(`miapp`, `nombre`, `descripcion`, `url_extension`, `version`, `autor`, `tabla`, `dir`, `mnu_texto`, `mnu_texto_cod_lng`, `nivel`) VALUES ('$appMiApp', '$appNombre', '$appDescripcion', '$appUrlExtension', '$appVersion', '$appAutor', '$appTabla', '$appDir', '$appMnuTexto', '$appMnuTextoLng', '$appNivel')") or die(_mysql_error())){
								return 'EXTINSTOK';
							}else{
								return 'EXTINSTNO';
							}
										
						}
					}else{
						return 'INFDATNO';
					}							

					$zip->close();

				} else {
					return 'NOZIP';
				}
			}else{
				return 'NOUPL';
			}
		}
		
		public static function paqueteExt($rutaExtension=NULL){
			if(!empty($rutaExtension)) self::$rutaInstExt = $rutaExtension;
			return self::$rutaInstExt;
		}
		
		//** Obtener datos POST */
		function com_obtReg( $campo, $valor_defecto = '' ){
			$tabla	= ( isset( $_GET['extension'] ) ) ? yPanel::paneles( $_GET['extension'] )->tabla : NULL;
			$tabla	= ( isset( $_GET['panel'] ) ) ? yPanel::paneles( $_GET['panel'] )->tabla : $tabla;
			if( isset( $_GET['post'] ) ) return utf8_encode( wy_mysql_obt1Reg( $tabla, "id='" . $_GET['post'] . "'", $campo ) );
			return $valor_defecto;
		}
		
		
	}
	
	
?>