<?php
	
	/*
	 *
	 * 2003 - 2016 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 */
	
	/* Autorizo acceso */
		defined('WY_Ini_Weby') or die( 'No dispones de acceso' );
		
		
		// funcion para crear documento .htaccess
		function htaccess( $base ){
			return '########## COMIENZA WEBY+' . "\n" .
				   '# * 2003 - ' . date('Y') . ' @ Yal Publicidad - Weby+' . "\n" .
				   '# * www.yalpublicidad.com' . "\n" .
				   '# * online@yalpublicidad.com' . "\n" . "\n" .
				   '# Establecer DirectoryIndex' .
				   '	DirectoryIndex index.php' . "\n" . "\n" .
				   '# Impedir listar el directorio' . "\n" .
				   '	Options -Indexes'  . "\n" .
				   '	order deny,allow' . "\n" . "\n" .
				   '# Ocultando htaccess|htpasswd' . "\n" .
				   '<Files ~ "^\.(htaccess|htpasswd)$">' . "\n" .
				   '	deny from all' . "\n" .
				   '</Files>' . "\n" . "\n" .
				   '<FilesMatch "^.*(error_log|wy_.*|php.ini|\.[hH][tT][aApP].*)$">' . "\n" .
				   '	Order deny,allow' . "\n" .
				   '	Deny from all' . "\n" .
				   '</FilesMatch>' . "\n" . "\n" .
				   '<IfModule mod_rewrite.c>' . "\n" .
				   '	RewriteEngine On' . "\n" .
				   '	RewriteBase ' . $base . "\n" .
				   '	RewriteRule ^index\.php$ - [L]' . "\n" .
				   '	RewriteCond %{REQUEST_FILENAME} !-f' . "\n" .
				   '	RewriteCond %{REQUEST_FILENAME} !-d' . "\n" .
				   '	RewriteRule . ' . $base . 'index.php [L]' . "\n" .
				   '</IfModule>' . "\n" . "\n" .
				   '# Reescribir ErrorDocument'. "\n" .
				   '	ErrorDocument 403 /error/HTTP_ErrorDocument.php?var=403' . "\n" .
				   '	ErrorDocument 404 /error/HTTP_ErrorDocument.php?var=404' . "\n" .
				   '	ErrorDocument 500 /error/HTTP_ErrorDocument.php?var=500' . "\n" .
				   '########## FINALIZA WEBY';
		}
		
		/* funcion para crear documento de configuracion */
		function dConfiguracion( $dbHost = 'localhost', 
								 $dbUsuario = 'root', 
								 $dbPass = '', 
								 $dbNombre = 'yanel', 
								 $dbPrefijo = 'wy_', 
								 $smtpHost = '', 
								 $smtpUsuario = '', 
								 $smtpPass = '', 
								 $smtpPort = 25, 
								 $smtpSSL = 'false', 
								 $smtpNombre = '', 
								 $smtpEmail = '', 
								 $smtpAsunto = '',
								 $webyCharset = 'utf-8', 
								 $webyTitulo = '', 
								 $webyDescription = '', 
								 $webyKeywords = '', 
								 $contactoOrganizacion = '', 
								 $contactoDireccion = '', 
								 $contactoTelefonos = '', 
								 $contactoEmails = '', 
								 $contactoMapa = '', 
								 $idWeby = '', 
								 $codActivacion = '', 
								 $estado = 1, 
								 $gmt = -5 ){
			
			if( $dbUsuario == NULL && $dbPass = NULL ) return false;
			
			$smtpPort = ( $smtpPort == NULL ) ? 25 : $smtpPort;
			$smtpSSL = ( $smtpSSL == NULL ) ? 'false' : $smtpSSL;
			
			$dCfg = '<?php
	/**
	 *
	 * 2003 - ' . date('Y') . ' @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * Base de configuracion para Weby+
	 *
	 * Este archivo contiene las siguientes configuraciones:
	 *
	 * * SERVIDOR Sesiones
	 * * MySQL Sesiones
	 * * SMTP Sesiones
	 * * Datos de Configuracion sitio Weby+
	 * * Clave ID Secreta y Clave de Activación de Producto
	 * * Estado de Sitio Weby+
	 * * GMT Sesion
	 *
	 * @link https://codex.webyplus.com/Editing_wy_configuracion.php
	 *
	 * @paquete Weby+
	 */
	
	/* SERVIDOR Sesiones */
		$Cfg[\'Server\'][\'host\']		= \'localhost\';			/* Normalmente es localhost */
		$Cfg[\'Server\'][\'user\']		= \'\';					/* Usuario de hosting */
		$Cfg[\'Server\'][\'password\']	= \'\';					/* Contraseña de hosting */
		$Cfg[\'Server\'][\'path\']		= dirname(__FILE__);	/* Directorio publico, normalmente /home/usuariohost/public_html/ */
		
	/* MySQL Sesiones */
		$Cfg[\'DB\'][\'host\']		= \'' . $dbHost . '\';		/* Normalmente es localhost */
		$Cfg[\'DB\'][\'user\']		= \'' . $dbUsuario . '\';		/* MySQL usuario */
		$Cfg[\'DB\'][\'password\']	= \'' . $dbPass . '\';		/* MySQL Contraseña */
		$Cfg[\'DB\'][\'name\']		= \'' . $dbNombre . '\';			/* MySQL nombre base de datos */
		$Cfg[\'DB\'][\'prefijo\']	= \'' . $dbPrefijo .'\';			/* MySQL Prefijo de tablas */
	
	/* SMTP Sesiones */
		$Cfg[\'Mail\'][\'host\']		= \'' . $smtpHost . '\';		/* SMTP host, normalmente mail.midominio.com */
		$Cfg[\'Mail\'][\'user\']		= \'' . $smtpUsuario . '\';		/* SMTP usuario ej. webmaster@midominio.com */
		$Cfg[\'Mail\'][\'password\']	= \'' . $smtpPass . '\';		/* SMTP contraseña */
		$Cfg[\'Mail\'][\'port\']		= ' . $smtpPort . ';		/* SMTP puerto, normalmente 25 */
		$Cfg[\'Mail\'][\'ssl\']			= ' . $smtpSSL . ';	/* SMTP SSL autenticación */
		$Cfg[\'Mail\'][\'nombre\']		= \'' . $smtpNombre . '\';		/* SMTP nombre ej. Juan Perez */
		$Cfg[\'Mail\'][\'email\']		= \'' . $smtpEmail . '\';		/* SMTP email ej. juanperez@midominio.com */
		$Cfg[\'Mail\'][\'asunto\']		= \'' . $smtpAsunto . '\';		/* SMTP asunto ej. consulta sobre servicio */
	
	/* Datos de Configuracion sitio Weby+ */
		$Cfg[\'Weby\'][\'charset\']		= \'' . $webyCharset . '\';
		$Cfg[\'Weby\'][\'titulo\']		= \'' . $webyTitulo . '\';
		$Cfg[\'Weby\'][\'description\']	= \'' . $webyDescription . '\';
		$Cfg[\'Weby\'][\'keywords\']	= \'' . $webyKeywords . '\';
		
		$Cfg[\'Contacto\'][\'organizacion\']= \'' . $contactoOrganizacion . '\';
		$Cfg[\'Contacto\'][\'direccion\']	= \'' . $contactoDireccion . '\';
		$Cfg[\'Contacto\'][\'telefonos\']	= \'' . $contactoTelefonos . '\';
		$Cfg[\'Contacto\'][\'emails\']		= \'' . $contactoEmails . '\';
		$Cfg[\'Contacto\'][\'mapa\']		= \'' . $contactoMapa . '\';
		
	/* Clave ID Secreta y Clave de Activación de Producto  */
		define(\'WEBYPLUS_ID\', \'' . $idWeby . '\');
		define(\'WEBYPLUS_ID_ACTIVACION\', \'' . $codActivacion . '\');
	
	/* 
	 * Estado de Sitio Weby+ 
	 * 1 = Activo
	 * 2 = Mantenimiento
	 * 3 = En Construccion
	 */
		define( \'YP_ESTADO_WEBY\', ' . $estado . ' );
		
	/* GMT Sesion */
		define( \'GMT\', ' . $gmt .' );
?>';
	 	return $dCfg;
		}
		
?>