<?php
	/*
	 *
	 * yMS (c) 2003 - 2020 Yal Publicidad
	 * Sistema: Macrodígital Software - de Yal Publicidad
	 *
	 */
	
	/* Autorizo acceso */
		defined('YMS') or die( 'No dispones de acceso' );

	if( !class_exists( 'ySQL' ) ) die( '<br><b>Error:</b> La librería @lib.y_mysql es necesaria para la ejecución de esta librería.' );
	
	// sesion_caducidad() : Leer/estalecer la caducidad de la sesion
	function sesion_caducidad($minutos=0){
		return yMSESS::caducidad($minutos);
	}

	// Destruye una o todas las sesiones creadas
	function sesion_destruir($nomSess=NULL){
		return yMSESS::destruir($nomSess);
	}
	
	// leer/crear sesion o cookie
	function y_sesion($nombre=NULL, $valor=NULL, $cookie=false, $expiracion=0){
		return yMSESS::sesion($nombre,$valor,$cookie,$expiracion);
	}
	
	class yMSESS {
		private static $tabla		= "ysesiones";
		private static $sessTiempo	= 3600;
		
		/* caducidad() : Lee/estalece el tiempo de expiracion de la sesion
		 * @param integer    $minutos    minutos que durara la sesion
		*/
		public static function caducidad($minutos=0){
			if($minutos==0){
				return self::$sessTiempo;
			}
			self::$sessTiempo = ($minutos*60);
			return self::$sessTiempo;
		}
		
		/* destruir() : Destruyo todas las sesiones creadas
		 * @param string    $nomSess    nombre opcional de la sesion a destruir
		*/
		public static function destruir($nomSess=NULL){
			$tabla	= self::$tabla;
			$cod_sess= md5(php_uname('a'));
				
			if(empty($nomSess)){
				$q = _mysql_query("SELECT * FROM $tabla WHERE id_sess='$cod_sess'");
				while($r = _mysql_fetch_array($q)){
					_mysql_eliminar_reg($tabla, $r['id']);
				}
				return(true);
			}
			$nomSess= $cod_sess.$nomSess;
			return _mysql_eliminar_reg($tabla, "id_sess='$cod_sess' AND nombre='$nomSess'");
		}
		
		/* refrescar_cache() : Destruyo las sesiones caducadas
		 */
		private static function refrescar_cache(){
			$tabla	= self::$tabla;
			$fecha	= date('Y-m-d H:i:s');
			$etabla	= _mysql_query("SHOW TABLES LIKE '$tabla'");
			//if($etabla){
				$q = _mysql_query("SELECT * FROM $tabla WHERE vence<'$fecha'");
				while($r = _mysql_fetch_array($q)){
					_mysql_eliminar_reg($tabla, $r['id']);
				}
				return true;
			//}
			//return false;
		}
		
		/* sesion() : Creo/leo sesion interna
		 * @param string    $nombre      nombre de la sesion que se creara/leera
		 * @param string    $valor       valor que almacenara la sesion
		 * @param boolean   $cookie      true si la sesion se usará como cookie
		 * @param integer   $expiracion  tiempo en segundos en que caducará la cookie
		 */
		public static function sesion($nombre=NULL, $valor=NULL, $cookie=false, $expiracion=0){
			if(empty($nombre)) return false;
			// verifico si existe tabla
			$tabla	= self::$tabla;
			$etabla	= _mysql_query("SHOW TABLES LIKE '$tabla'");
			// creo id code de sesion x usuario
			$browser	= $_SERVER['HTTP_USER_AGENT'];
			$cod_sess	= md5($browser.php_uname('a'));
			///$nombre	= $cod_sess.$nombre;
			$e		= $cod_sess.$nombre;
			// encripto el valor que se guardará
			$valore	= encriptar($valor,$e);
			// tiempo de expiracion
			$tExpiracion= time()+self::$sessTiempo;
			// si es cookie
			if($cookie){
				$tExpiracion= ($expiracion>0) ? $expiracion : (time()+(60*60*24*30));
			}
			// creo tabla si no existe ALTER TABLE `mt_videos`  ADD `prueba` INT(11) NOT NULL AUTO_INCREMENT  AFTER `publicado`,  ADD   PRIMARY KEY  (`prueba`);
			if($etabla==false){
				_mysql_query("CREATE TABLE IF NOT EXISTS `$tabla` (`id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY, `id_sess` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '', `nombre` varchar(355) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '', `valor` LONGTEXT COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '', `fecha` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00', `vence` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00' ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;") or die(_mysql_error());
			}
			
			// voy eliminando las sesiones caducadas
			self::refrescar_cache();
			
			// si valor es diferente a null guardo sesion
			if(!empty($valor)){
				// verifico si la sesion existe
				if(_mysql_existe($tabla,"*","id_sess='$cod_sess' AND nombre='$nombre'")){
					// si existe, modifico dato de sesion
					if(_mysql_modificar_reg($tabla, "id_sess='$cod_sess' AND nombre='$nombre'", "id_sess='$cod_sess', valor='$valore', vence='" . date('Y-m-d H:i:s', $tExpiracion) . "'")){
						return $valor;
					}
				}else{
					// si no existe, inserto dato de sesion
					if(_mysql_insertar_reg($tabla, "id_sess, nombre, valor, fecha, vence", "'$cod_sess', '$nombre', '$valore', '" . date('Y-m-d H:i:s') . "', '" . date('Y-m-d H:i:s', $tExpiracion) . "'")){
						return $valor;
					} 
				}
				return false;
			}
			// leo sesion
			$valore	= _mysql_obtener_reg($tabla, "id_sess='$cod_sess' AND nombre='$nombre'", "valor");
			$valor	= encriptar($valore,$e, 'desencriptar');
			return $valor;
		}
		
	}
	
?>