<?php
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - yPanel
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 *
	 */
	
	/* Autorizo acceso */
		defined('YPANEL_INI') or die( 'No dispones de acceso' );
	
	// -- obtiene base html de componente yPanel
	function com_base(){
		//global $com;
		//return base_sitioWeby() . 'ypanel/paneles/' . $com->nombre . '/';
		$modulo		= ( isset( $_GET['panel'] ) ) ? $_GET['panel'] : 'ninguno';
		$modulo_dir	= ( isset( yPanel::paneles( $modulo )->dir ) ) ? 'ypanel/' . yPanel::paneles( $modulo )->dir : 'ypanel/paneles/';
		return base_sitioWeby() . $modulo_dir;
	}
	
	// -- crea boton de componente yPanel
	function com_boton( $tipo_boton = 'guardar', $texto = NULL, $enviar_form = false ){
		//global $com;
		
		//$js = ( function_exists( $funcion ) ) ? $funcion( $id ) : $funcion;
		
		/*if( $funcion != NULL ){
			$boton_nom = 'btn_' . $id;
			$com->JS_funcion[$id] = 'var ' . $boton_nom . ' = document.querySelector("#' . $id . '"); ' . "\n" .
									$boton_nom . '.onclick = function(){ ' . $js . ' }; ';
		}*/
		
		//$onClick = ( function_exists( $funcion ) ) ? $funcion( $id ) : $funcion;
		switch( $tipo_boton ){
					case 'nuevo':
						$texto	= ( $texto != NULL ) ? $texto : etiqueta( 'b_nuevo', 'Nuevo' );
						$ic 	= '<i class="fa fa-plus"></i> ';
					 	break;
						
					case 'editar':
						$texto	= ( $texto != NULL ) ? $texto : etiqueta( 'b_actualizar', 'Actualizar datos' );
						$ic 	= '<i class="fa fa-check-circle"></i> ';		 	
						break;
						
					case 'guardar':
						$texto	= ( $texto != NULL ) ? $texto : etiqueta( 'b_guardar', 'Guardar cambios' );
						$ic 	= '<i class="fa fa-save"></i> ';
						break;
					
					case 'cancelar':
						$texto	= ( $texto != NULL ) ? $texto : etiqueta( 'b_cancelar', 'Cancelar' );
						$ic 	= '';
						break;
						
					case 'cerrar':
						$texto	= ( $texto != NULL ) ? $texto : etiqueta( 'b_cerrar', 'Cerrar' );
						$ic 	= '<i class="fa fa-close"></i> ';
						break;
						
					case 'salir':
						$texto	= ( $texto != NULL ) ? $texto : etiqueta( 'b_salir', 'Salir' );
						$ic 	= '<i class="fa fa-close"></i> ';
						break;
						
					default:
						$texto		= $texto;
						$ic 		= '';
			}
			$eFrm	= ( $enviar_form === true ) ? ' onClick="eform( this.form )"' : NULL;
			return '<button type="button" id="' . $tipo_boton . '" name="' . $tipo_boton . '"' . $eFrm . '>' . $ic . $texto . '</button>';
	}
	
	// --
	function com_btnToggle( $id, $value, $checked, $disabled = false, $on = NULL ){
		return 	com::boton_toggle( $id, $value, $checked, $disabled, $on );
	}
	
	//** Mostrar etiqueta por idioma */
	function com_etiqueta( $etiqueta, $por_defecto = '' ){
		return com::etiqueta( $etiqueta, $por_defecto );
	}
	
	//** Obtener datos POST */
	function com_obtReg( $campo, $valor_defecto = '' ){
		$tabla	= ( isset( $_GET['extension'] ) ) ? yPanel::paneles( $_GET['extension'] )->tabla : NULL;
		$tabla	= ( isset( $_GET['panel'] ) ) ? yPanel::paneles( $_GET['panel'] )->tabla : $tabla;
		if( isset( $_GET['post'] ) ) return utf8_encode( wy_mysql_obt1Reg( $tabla, "id='" . $_GET['post'] . "'", $campo ) );
		return $valor_defecto;
	}
	
	//** Comprobar si estoy en una accion */
	function es_accion( $accion = NULL ){
		if( $accion == NULL || empty( $accion ) ) return (isset( $_GET['acc'] )) ? true : false;
		
		if( isset( $_GET['acc'] ) ){
			return ( $_GET['acc'] == $accion ) ? true : false; 
		}
	}
	
	class com{
		
		private static $pantallainicio	= NULL;
		
		public $archivo_conf		= false;
		public $gestor_idioma		= false;
		public $nombre;
		public $titulo;
		public $descripcion;
		
		public $a_tabla			= array();
		public $consulta_tabla	= "ORDER BY id DESC";
		
		public $JS_funcion	= array();
		public $JS_b_nuevo	= false;
		public $JS_b_salir	= false;
		
		
		/**
		 * 
		 */
		public static function boton_toggle( $id, $value, $checked, $disabled = false, $on = '' ){
			if( empty( $id ) || empty( $value ) ) return NULL; if( empty( $checked ) ) $checked=false;
			
			$disabled = ( $disabled === true ) ? ' disabled ' : '';
			$ckd = ( $checked == true || $checked != 0 || $checked != '0' ) ? ' checked ' : '';
			$bToggle = '<input type="checkbox" class="tgl tgl-light" id="' . $id . '" name="' . $id . '" value="' . $value . '" ' . $on . $ckd . $disabled . ' /><label class="tgl-btn" for="' . $id . '"></label>';
			
			return $bToggle;
		}
		
		public static function etiqueta( $etiqueta, $por_defecto = '' ){
			if( empty( $etiqueta ) ) return $por_defecto;
			
			$lng 		= yPanel::cuenta_usuario( 'lenguaje' );
			
			$url		= ( isset( $_GET['extension'] ) ) ? YPATH . YDS . 'wy_incluye/wy_ext/' . $_GET['extension'] . '/lng/' . $lng . '.lng' : 'null';
			//$url		= ( isset( $_GET['panel'] ) ) ? yPanel::$__DIR__ . 'paneles/' . $_GET['panel'] . '/lng/' . $lng . '.lng' : $url;
			$url		= ( isset( $_GET['panel'] ) ) ? yPanel::$__DIR__ . yPanel::paneles( $_GET['panel'] )->dir . '/lng/' . $lng . '.lng' : $url;
			
			//$url_json = yPanel::$__DIR__ . 'ypanel/paneles/' . $nom_ext . '/lng/' . $lng . '.lng';
			$url_json	= $url;
			if( file_exists( $url_json ) ){
				$data	= file_get_contents( $url_json );
				$data	= json_decode( $data );
				
				return ( isset( $data->$etiqueta ) ) ?  $data->$etiqueta : $por_defecto;
			}
			return $por_defecto;
		}
	
		/**
		 *
		 */
		public static function importar( $archivo ){
			if( empty( $archivo ) ) return false;
			
			$cImportado	= '';
			
			if( file_exists( $archivo ) ){
					ob_start(); # apertura de bufer
					include_once( $archivo );
					$cImportado .= ob_get_contents();
					ob_end_clean(); # cierre de bufer
			}
			return $cImportado;
		}
		
		public static function obt_pantalla_inicio(){
			if( !empty( self::$pantallainicio ) ) return self::$pantallainicio;
			
			return false;
		}
		
		
		public static function pantalla_inicio( $pantallainicio = NULL ){
			self::$pantallainicio = $pantallainicio;
			return;
		}
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		/*
		 * función para cargar componente al sistema
		 */
		function cargar(){
			// ** Compruebo si el componente dispone de acceso
			if( wyp_n_privilegios_usr( 'mnu_usr', 'usuario' ) != 1 ) { 
				echo wyp_mensaje( "Acceso Restringido: No tiene acceso a esta área.", "Error" );
				return false;
			}
			
			echo '<div class="com-caja-encabezado">';
			echo $this->obtener_titulo_seccion();
			echo $this->obtener_descripcion();
			echo '<hr></div><div class="com-caja-cuerpo">';
			if( $this->archivo_conf ){
				if( file_exists( YPATH . YDS . 'ypanel/wy_com/' . $this->nombre . '/wy_' . $this->nombre . '.php' ) ){
					include_once( YPATH . YDS . 'ypanel/wy_com/' . $this->nombre . '/wy_' . $this->nombre . '.php' );
				}
			}
			echo '</div>';
			
			echo '<script type="text/javascript">';
				if( $this->JS_b_nuevo ) echo 'var bNuevo = document.querySelector("button[name=b_nuevo]"); bNuevo.onclick = function(){ Ir_a(\'' . com_ir_a( 'this', 'agregar' ) . '\'); }; ';
				if( $this->JS_b_salir ) echo 'var bCerrar = document.querySelector("button[name=b_cerrar]"); bCerrar.onclick = function(){ Ir_a(\'' . ( isset( $_GET['acc'] ) ? com_ir_a( 'this' ) : './' ) . '\'); }; ';
				
				
				
			echo '</script>';
		}
		
		/*
		 * Leo configuración del componente
		 */
		public function leer_conf(){
			global $ypanel;
			
			// ** Prefijo de titulo
				$a = array('agregar'=>wyp_etiqueta( 'e_com_form_agregar', 'Modificar ' ), 'editar'=>wyp_etiqueta( 'e_com_form_editar', 'Editar ' ), 'modificar'=>wyp_etiqueta( 'e_com_form_modificar', 'Modificar ' ), 'nulo'=>'');
				$prefijo_t = ( isset( $_GET['acc'] ) ) ? $_GET['acc'] : 'nulo';
		
			// ** creo la ruta de configuración del componente
				$url_json = YPATH . YDS . 'ypanel/wy_com/' . $this->nombre . '/com.conf';
				
			// ** Verifico si existe el archivo de configuración
				if( file_exists( $url_json ) ){
					// ** leo la configuración en JSON
					$data	= file_get_contents( $url_json );
					$conf	= json_decode( $data );
					
					// ** evaluo si se usará gestor de idiomas o no
					$this->gestor_idioma	= ( isset( $conf->gestor_idioma ) && $conf->gestor_idioma == 1 ) ? true : false;
					$this->titulo			= ( isset( $conf->nombre ) ) ? $conf->nombre : $this->nombre;
					$this->descripcion		= ( isset( $conf->descripcion ) ) ? $conf->descripcion : '';
					
					if( $this->gestor_idioma ){ // ** ejecuto gestor de idiomas
						$this->titulo = ( strlen( $this->titulo ) > 3 ) ? explode( '|', $this->titulo ) : $this->titulo;
						$this->descripcion = ( strlen( $this->descripcion ) > 3 ) ? explode( '|', $this->descripcion ) : $this->descripcion;
						// Creo el nombre de la barra de titulo
						$ypanel->titulo_barra_titulo = ( is_array( $this->titulo ) ) ? ( ( isset($a[$prefijo_t] ) )? $a[$prefijo_t]: '' ) . com_lng( $this->titulo[0], $this->titulo[1] ) : $this->titulo;
						$this->descripcion = ( is_array( $this->descripcion ) ) ? com_lng( $this->descripcion[0], $this->descripcion[1] ) : $this->descripcion;
					}else{ // ** No ejecuto gestor de idiomas
						$ypanel->titulo_barra_titulo = $this->titulo;
					}
					
					// ** confirmo existencia de archivo de configuración
					$this->archivo_conf = true;
					
					return true;
				}
				
				return false;
			
		}
		
		public function obtener_js(){
			foreach( $this->JS_funcion as $jsk => $jsv ){
					echo "\n\n" . $this->JS_funcion[ $jsk ] . "\n\n";
			}
		}
		
		/*
		 * Obtengo el titulo
		 * de la sección del 
		 * componente
		 */
		public function obtener_titulo_seccion(){
			global $ypanel;
			return '<div class="titulo">' . $ypanel->obtener_titulo() . '</div>';
		}
		
		/*
		 * Obtengo la descripcion
		 * del componente
		 */
		public function obtener_descripcion(){
			if( !empty( $this->descripcion ) ) return '<div class="descripcion">' . $this->descripcion . '</div>';
			return false;
		}
		
		
	}
	
	/*
	 * ***************************************************************
	 * FUNCIONES OBSOLETAS
	 * ***************************************************************
	 */
	 
	$com = new com();
	
	/*
	 * Nombre del Componente
	 */
	$com->nombre = ( isset( $_GET['panel'] ) ) ? $_GET['panel'] : 'ninguno';
	
	function com_captcha( $id_captcha = 'com_captcha', $longitud = 8 ){
		$captcha = '';
		$pattern = '1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWYZ';
		$max = strlen( $pattern ) - 1;
		for( $i = 0; $i < $longitud; $i++ ) $captcha .= $pattern{ mt_rand( 0, $max ) };
		return $_SESSION[ $id_captcha ] = $captcha;
	}
	
	/*
	 * Funcion para crear hipervinculos
	 */
	function com_enlace( $href, $cadena, $atributos = NULL ){
		global $_WY_HTML;
		return $_WY_HTML::link( $href, $cadena, $atributos );
	}
	
	/*
	 * Funcion para abrir seccion
	 */
	function com_ir_a( $secc, $accPost = NULL, $idPost = 0 ){
		if( !empty( $secc ) ){
			$seccPost	= ( $secc == 'this' ) ? 'secc=' . $_GET['secc'] : 'secc=' . $secc;
			$accPost	= ( $accPost != NULL ) ? '&acc=' . $accPost : NULL;
			$idPost		= ( $idPost > 0 ) ? '&post=' . $idPost : NULL;
			
			return $_SERVER['PHP_SELF'] . '?' . $seccPost . $idPost . $accPost;
		}
		return false;
	}
	
	/*
	 * funcion para agregar funciones JS
	 */
	function com_js( $funcion_nombre, $funcion_js ){
		global $com;
		if( !empty( $funcion_js ) ){
			$js_nombre = 'jsy_' . $funcion_nombre . '()';
			$funcion_javascript = ( $funcion_nombre == 'linea' ) ? $funcion_js : 'function ' . $js_nombre . ' { ' . $funcion_js . ' }';
			$funcion_nombre		= ( $funcion_nombre == 'linea' ) ? $funcion_nombre . rand(10,999) : $funcion_nombre;
			$com->JS_funcion[ $funcion_nombre ] = $funcion_javascript;
			return $js_nombre;
		}
		return false;
	}
	
	/*
	 * Mostrar etiqueta por idioma
	 */
	function com_lng( $etiqueta, $por_defecto = '', $asociativo = false ){
		global $com;
		
		if( empty( $etiqueta ) ) return $por_defecto;
		
		$lng = ( isset( $_SESSION['wyp_us'] ) ) ? wyp_us_lng( $_SESSION['wyp_us'] ) : 'es';
		
		$url_json = YPATH . YDS . 'ypanel' . YDS . 'wy_com' . YDS . $com->nombre . '/lng/' . $lng . '.lng';
		if( file_exists( $url_json ) ){
			$data	= file_get_contents( $url_json );
			$data	= json_decode( $data, $asociativo );
			if( $asociativo == false ){
				$etiqueta = ( isset( $data->$etiqueta ) ) ?  $data->$etiqueta : $por_defecto;
			}else{
				$etiqueta = ( isset( $data[$etiqueta] ) ) ?  $data[$etiqueta] : $por_defecto;
			}
			
			return $etiqueta;
		}
		return $por_defecto;
	}
	
	
	/*
	 * Obtener datos POST
	 */
	function com_obt_post( $tabla, $campo, $valor_defecto = '' ){
		if( isset( $_GET['post'] ) ) return utf8_encode( wy_mysql_obt1Reg( $tabla, "id='" . $_GET['post'] . "'", $campo ) );
		return $valor_defecto;
	}
	
	
	/*
	 * Registrar datos POST
	 */
	function com_reg_post( $tabla, $campo, $valor = '', $idPost = 0, $valor_defecto = NULL ){
		$valor = ( $valor == '' ) ? $valor_defecto :  $valor;
		if( $idPost > 0 ) { 
			$valor_reg = WYSQL::obt1Reg( $tabla, "id='" . $idPost . "'", "$campo" );
			if( $valor != $valor_reg ) return WYSQL::modificar_reg( $tabla, "id='" . $idPost . "'", "$campo='$valor'");
			return true;
		}else{
			if( $valor != '' ) return WYSQL::insertar_reg( $tabla, $campo, "'$valor'");
		}		
		return false;
	}
		
	
	
	/*
	 * Funcion para mostrar resultados
	 * de campos de una tabla
	 */	
	function tabla_iniciar( $nombre_tabla ){
		global $com;
		if( !empty( $nombre_tabla ) ){
			$com->a_tabla[$nombre_tabla] = array();
			return $nombre_tabla;
		}
		$nombre_tabla = rand(10,99999);
		return $com->a_tabla[$nombre_tabla] = array();
	}
	
	function tabla_campo( $nombre_tabla, $nombre_campo, $etiqueta_campo, $func_valor_campo = NULL ){
		global $com;
		if( !empty( $nombre_tabla ) ){
			$com->a_tabla[$nombre_tabla]['campo'][$nombre_campo] = $nombre_campo;
			$com->a_tabla[$nombre_tabla]['campo_valor'][$nombre_campo] = $func_valor_campo;
			$com->a_tabla[$nombre_tabla]['etiqueta'][$etiqueta_campo] = $etiqueta_campo;
		}
	}
	
	function tabla_consulta( $consulta ){
		global $com;
		if( !empty( $consulta ) ) {
			$com->consulta_tabla = $consulta;
		}
		return false;
	}
	
	function tabla_ejecutar( $nombre_tabla ){
		global $com;
		if( !empty( $nombre_tabla ) ){
			//print_r( $com->a_tabla[$nombre_tabla] );
			$tabla = '<table class="" cellspacing="0"><thead><tr>';				
				foreach( $com->a_tabla[$nombre_tabla]['etiqueta'] as $k => $v){
					$tabla .= '<th class="">' . $com->a_tabla[$nombre_tabla]['etiqueta'][$k] . '</th>';
				}
			$tabla .= '</tr></thead><tbody>';
		
			$tr_COLOR		= array("tr-bg-f5","");
			$tr_CONTADOR		= 0;
		
			$q = query( "SELECT * FROM " . WYCFG_DBPREFIJO . $nombre_tabla . " " . $com->consulta_tabla );						  
			while($r = query_array($q)){
				$tr_CONTADOR++;
												
				$tabla .= '<tr id="' . $nombre_tabla . '-' . $r['id'] . '" class="' . $tr_COLOR[$tr_CONTADOR % 2] . '">'; //<td class="usuario-id">' . $r['id'] . '</td>';
					foreach( $com->a_tabla[$nombre_tabla]['campo'] as $kc => $vc ){
						//$tabla .= '<td class="">' . $r[ $com->a_tabla[$nombre_tabla]['campo'][$kc] ] . '</td>';
						$tabla .= '<td class="">';
							if( $com->a_tabla[$nombre_tabla]['campo_valor'][$kc] != NULL ) 
								$tabla .= $com->a_tabla[$nombre_tabla]['campo_valor'][$kc]( utf8_encode( $r[ $com->a_tabla[$nombre_tabla]['campo'][$kc] ] ),$r['id'] );
							else
								$tabla .= utf8_encode( $r[ $com->a_tabla[$nombre_tabla]['campo'][$kc] ] );
						$tabla .= '</td>';
					}
				$tabla .= '</tr>';
			}
			$tabla .= '</tbody></table>';
			
			echo $tabla;
		}
	}
	
	
	/*
	 * verifico si existe configuración
	 * del componentes. Si existe cargo
	 * el componente al sistema
	 */
	//$com->leer_conf();
	
?>