<?php 
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - yexplorador
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 *
	 */
	
	include_once( 'lib/mod.func.php' );
	
	if( YE::veriSess() == false ) { echo '<h1>error 404</h1>'; exit; }
	
	//** creo sesion */
	
	//** Variables globales */
	//$y_title		= ( !isset( $_GET['title'] ) ) ? 'Explorar Imagenes' : $_GET['title'];
	//$y_dirbase		= ( !isset( $_GET['dir_base'] ) ) ? '/images/' : $_GET['dir_base'];
	//$y_vista		= ( !isset( $_GET['vista'] ) ) ? 'iconos' : $_GET['vista'];
	//$y_locationdir	= ( !isset( $_GET['locationdir'] ) ) ? '../../../images' : $_GET['locationdir'];
	
	$funcjs			= ( isset( $_GET['func_js'] ) ) ? '&func_js=' . $_GET['func_js'] : '';
	$selector		= ( isset( $_GET['selector'] ) ) ? '&selector=' . $_GET['selector'] : '';
	//$y_insImg		= ( isset( $_GET['insImg'] ) && $_GET['insImg'] == 1 ) ? 'si' . $funcjs . $selector : 'no';
	 
	 /*
	  * Directorio Real donde se trabajarán
	  * las exploración de ficheros alojados
	  * en el sitio web
	  *
	  * NOTA: Este dato debe ser proporcionado por el administrador
	  * ej. localhost windows: define( 'WYE_BASE_DIRECTORIO', 'C:\ypanel\home\mi_sitio_weby\' )
	  * ej. localhost linux: define( 'WYE_BASE_DIRECTORIO', '/home/usuario/public_html/' )
	  *
	  */
	 define( 'YE_TITLE', ( ( !isset( $_GET['title'] ) ) ? 'Explorar Imagenes' : $_GET['title'] ) . ' - Yal Publicidad' );
	 define( 'YE_BASE_DIRECTORIO', ( ( !isset( $_GET['dir_base'] ) ) ? '/images/' : $_GET['dir_base'] ) );
	 //define( 'YE_LOCATION_DIR', $y_locationdir );	// ej. ../../../imagenes
	 define( 'YE_VISTA', ( ( !isset( $_GET['vista'] ) ) ? 'iconos' : $_GET['vista'] ) );
	 define( 'YE_INSIMG', ( ( isset( $_GET['insImg'] ) && $_GET['insImg'] == 1 ) ? 'si' . $funcjs . $selector : 'no' ) );
	 define( 'YE_FUNCJS', ( ( isset( $_GET['func_js'] ) ) ? $_GET['func_js'] : '' ) );
	 //include_once('lib/ye.php');
	 
?>
<html>
<head>
	<title><?php echo YE_TITLE ?></title>
	<link rel="stylesheet" href="css/style.css" type="text/css">
	<link rel="stylesheet" href="fonts/font-awesome-4.7.0/css/font-awesome.min.css">
</head>
<body>
	<div id="ygestorarchivos">
		
		<header class="yga-nav">
			<div class="contenedor">
				<!-- Barra de opciones -->
				<div class="row">
					<div id="topnav" class="clear">
						<ul>
							<li id="action-newfile" onclick="return actionHandler('newfile');">
								<a href="javascript:void(0)" title="Agregar nuevo archivo" class="btn btn-link">
									<span class="fa fa-plus"></span>
									Archivo
								</a>
							</li>
							<li id="action-newfolder" onclick="return actionHandler('newfolder');">
								<a href="javascript:void(0)" title="Agregar nueva carpeta" class="btn btn-link">
									<span class="fa fa-plus"></span>
									Carpeta
								</a>
							</li>
							<li id="action-copy" onclick="return actionHandler('copy');">
								<a href="javascript:void(0)" title="Copiar" id="actionCopy" class="btn btn-link">
									<i class="fa fa-copy"></i>
									Copiar
								</a>
							</li>
							<li id="action-move" onclick="return actionHandler('move');">
								<a href="javascript:void(0)" title="Mover archivo" id="actionMove" class="btn btn-link">
									<span class="fa fa-exchange"></span>
									Mover
								</a>
							</li>
							<li id="action-upload" onclick="return actionHandler('upload');">
								<a href="javascript:void(0)" title="Cargar" class="btn btn-link">
									<i class="fa fa-upload"></i>
									Cargar
								</a>
							</li>
							<li id="action-download" onclick="return actionHandler('download');">
								<a href="javascript:void(0)" title="Descargar" class="btn btn-link">
									<i class="fa fa-download"></i>
									Descargar
								</a>
							</li>
							<li class="divider" id="action-delete" onclick="return actionHandler('delete');">
								<a href="javascript:void(0)" title="Eliminar" class="btn btn-link">
									<span class="fa fa-remove"></span>
									Eliminar
								</a>
							</li>
							<li id="action-rename" onclick="return actionHandler('rename');">
								<a href="javascript:void(0)" title="Cambiar el nombre" class="btn btn-link">
									<i class="fa fa-file"></i>
									Renombrar
								</a>
							</li>
						</ul>
					</div>
				</div>
				<!-- /Barra de opciones -->
			</div>
		</header>
		
		<section class="cpaneles">
				<!-- Panel de Navegacion -->
				<div class="palnav">
						<!-- barra de navegacion -->
						 <div class="path">
							<div class="input-group">
								  <span class="input-group-addon">
									  <span id="imgHome" class="fa fa-home"></span>/
								  </span>
								  <input id="location" type="text" class="form-control">
								  <span class="input-group-btn">
									<button id="btnGo" class="btn btn-default" type="button" onclick="yGestorArchivos.dirnav();">Ir</button>
								  </span>
							</div>
						</div>
						<!-- /barra de navegacion -->
						
						<!-- listar panel de navegacion -->
						<div id="panelNav">
						</div>
						<!-- /listar panel de navegacion -->
		
				</div>
				<!-- /Panel de Navegacion -->
					
				<!-- Panel Principal -->
				<div class="palexplorador">
					<div id="palexplorador">
					</div>
				</div>
				<!-- /Panel Principal -->
				
		</section>
	
	</div>
	
	<script type="text/javascript" src="js/jsy-script.js"></script>
	<script type="text/javascript">				
			/* Directorio principal */
			var homedir = "";
			var dir = "<?php echo YE_BASE_DIRECTORIO ?>";
			var vista = "<?php echo YE_VISTA ?>";
			var locationdir = "";
			var insimg = "<?php echo YE_INSIMG ?>";
			yGestorArchivos.cargar();
			
			/* Formulario para crear carpetas */
			actionHandler = function( $acc ){
				if( typeof $acc != 'undefined' ){
					
					
					// frm copiar archivo
					if( $acc == 'copy' ){
						$arraydir = '';
						for( i = 0; i < document.getElementsByName('chka').length; i++ ){
								$dir = '#chka_' + i;
								if( $_($dir).checked ) $arraydir += $_($dir).value + '<br>';
						}
						
						return ygaModal.abrir('<form id="actionHandler" method="post">' +
											  '<h4 class="color-rojo-p">Copiar Archivo</h4>' +
											  '<div class="lbl">Se copiarán los siguientes archivos:</div>' +
											  '<div class="lbl"><strong>' + $arraydir + '</strong></div>' +	
											  '<div class="lbl">Copiar archivo en: <i class="fa fa-home"></i></div>' +
											  '<div class="lbl"><input type="text" id="path" value="' + $barra.value + '" name="path" placeholder="Ruta donde se creará el archivo:"></div>' +
											  '<div class="ft"><button type="button" class="btn btn-primario" onClick="copiararchivo(this.form.path.value); ">Copiar archivo(s)</button></div></form>');
					}
					
					// frm eliminar archivo
					if( $acc == 'delete' ){
						$arraydir = '';
						for( i = 0; i < document.getElementsByName('chka').length; i++ ){
								$dir = '#chka_' + i;
								if( $_($dir).checked ) $arraydir += $_($dir).value + '<br>';
						}
						
						return ygaModal.abrir('<form id="actionHandler" method="post">' +
											  '<h4 class="color-rojo-p">Eliminar Archivo</h4>' +
											  '<div class="lbl">Se eliminarán los siguientes archivos:</div>' +
											  '<div class="lbl"><strong>' + $arraydir + '</strong></div>' +
											  '<div class="ft"><button type="button" class="btn btn-primario" onClick="eliminararchivo(); ">Eliminar archivo(s)</button></div></form>');
					}
					
					// descargar archivo
					if( $acc == 'download' ){
						$arraydir = '';
						$dl = false;
						for( i = 0; i < document.getElementsByName('chka').length; i++ ){
								$dir = '#chka_' + i;
								if( $_($dir).checked ){ $arraydir += $_($dir).value + ';'; $dl = true; }
						}
						
						if( $dl ) location.href = 'dl.php?arraydir=' + $arraydir + '&basedir=' + dir;
						
						return false;
					}
					
					
					
					// frm para crear nuevo fichero
					if( $acc == 'newfile' ){
						return ygaModal.abrir('<form id="actionHandler" method="post">' +
											  '<h4>Crear Nuevo Archivo</h4>' +
											  '<div class="lbl">Nuevo nombre del archivo:</div>' +
											  '<div class="lbl"><input type="text" id="name" name="name" placeholder="Nuevo nombre del archivo:" autocomplete="off"></div>' +
											  '<div class="lbl">Crear archivo en: <i class="fa fa-home"></i></div>' +
											  '<div class="lbl"><input type="text" id="path" value="' + $barra.value + '" name="path" placeholder="Ruta donde se creará el archivo:"></div>' +
											  '<div class="ft"><button type="button" class="btn btn-primario" onClick="nuevoarchivo( this.form.name.value, this.form.path.value ); ">Crear nuevo archivo</button></div></form>');
					}
					
					// frm para crear nueva carpeta
					if( $acc == 'newfolder' ){
						return ygaModal.abrir('<form id="actionHandler" method="post">' +
											  '<h4 class="color-rojo-p">Nueva Carpeta</h4>' +
											  '<div class="lbl">Nuevo nombre de carpeta:</div>' +
											  '<div class="lbl"><input type="text" id="name" name="name" placeholder="Nuevo nombre de carpeta:" autocomplete="off"></div>' +
											  '<div class="lbl">Crear carpeta en: <i class="fa fa-home"></i></div>' +
											  '<div class="lbl"><input type="text" id="path" value="' + $barra.value + '" name="path" placeholder="Crear carpeta en:"></div>' +
											  '<div class="ft"><button type="button" class="btn btn-primario" onClick="nuevacarpeta( this.form.name.value, this.form.path.value ); ">Crear carpeta</button></div></form>');
					}
					
					// frm mover archivo
					if( $acc == 'move' ){
						$arraydir = '';
						for( i = 0; i < document.getElementsByName('chka').length; i++ ){
								$dir = '#chka_' + i;
								if( $_($dir).checked ) $arraydir += $_($dir).value + '<br>';
						}
						
						return ygaModal.abrir('<form id="actionHandler" method="post">' +
											  '<h4 class="color-rojo-p">Mover Archivo</h4>' +
											  '<div class="lbl">Se moverán los siguientes archivos:</div>' +
											  '<div class="lbl"><strong>' + $arraydir + '</strong></div>' +	
											  '<div class="lbl">Ruta de la carpeta donde se moverá el archivo: <i class="fa fa-home"></i></div>' +
											  '<div class="lbl"><input type="text" id="path" value="' + $barra.value + '" name="path" placeholder="ej. public_html"></div>' +
											  '<div class="ft"><button type="button" class="btn btn-primario" onClick="moverarchivo(this.form.path.value); ">Mover archivo(s)</button></div></form>');
					}
					
					// frm para renombrar archivo
					if( $acc == 'rename' ){
						$arraydir = '';
						for( i = 0; i < document.getElementsByName('chka').length; i++ ){
								$dir = '#chka_' + i;
								if( $_($dir).checked ) $arraydir = $_($dir).value;
						}
						
						return ygaModal.abrir('<form id="actionHandler" method="post">' +
											  '<h4 class="color-rojo-p">Renombrar Archivo</h4>' +
											  '<div class="lbl">Se cambiará el nombre del siguiente archivo:</div>' +
											  '<div class="lbl"><strong>' + $arraydir + '</strong></div>' +	
											  '<div class="lbl">Nuevo nombre del archivo:</div>' +
											  '<div class="lbl"><input type="text" id="path" value="' + basename( $arraydir ) + '" name="path" placeholder="ej. public_html"></div>' +

											  '<div class="lbl"><button type="button" class="btn btn-primario" onClick="renombrararchivo( this.form.path.value, \'' + $arraydir + '\' ); ">Renombrar Archivo</button></div></form>');
					}
					
					// frm para cargar archivo
					if( $acc == 'upload' ){
						localdir = ( $barra.value != '' ) ?  $barra.value : '';
						window.open("ul.php?dir=" + encodeURIComponent( homedir + dir + localdir ) , "ypUpload");
					}
				}
				
				return false;
			}
			
			/* funcion para copiar archivos */
			copiararchivo = function( $locationdir ){
					// creo lista de archivos que se copiaran
					$arraydir = '';
					for( i = 0; i < document.getElementsByName('chka').length; i++ ){
								$dir = '#chka_' + i;
								if( $_($dir).checked ) $arraydir += $_($dir).value + ';';
					}
					
					// envio solicitud al YGA
					$ajax({
							metodo: 'GET',
							data: 'a=copiar&arraydir=' + $arraydir + '&ldir=' + $locationdir + '&homedir=' + homedir + '&basedir=' + dir + '&vista=' + vista,
							url: 'lib/ye.php',
							suceso: function(respuesta){
													
													if( respuesta == 0 ){
														alert( 'El archivo no se pudo copiar.' + $arraydir );
													} if( respuesta == 1 ){
														ygaModal.cerrar();
														yGestorArchivos.explorar_archivo( '', $locationdir );
													} if( respuesta == 2 ){
														alert( 'La ruta de destino no existe.' );
													}
							}
						});
					return false;
			}
			
			/* funcion para eliminar archivos */
			eliminararchivo = function(){
					$arraydir = '';
					for( i = 0; i < document.getElementsByName('chka').length; i++ ){
								$dir = '#chka_' + i;
								if( $_($dir).checked ) $arraydir += $_($dir).value + ';';
					}
					
					$ajax({
							metodo: 'GET',
							data: 'a=eliminar_archivo&arraydir=' + $arraydir + '&homedir=' + homedir + '&basedir=' + dir + '&vista=' + vista,
							url: 'lib/ye.php',
							suceso: function(respuesta){
													
													if( respuesta == 0 ){
														alert( 'El archivo no se pudo eliminar.' + $arraydir );
													} if( respuesta == 1 ){
														ygaModal.cerrar();
														yGestorArchivos.explorar_archivo( '', $barra.value );
													} 
							}
						});
					return false;
			}
			
			/* funcion para crear nuevo archivo */
			nuevoarchivo = function( $nombre, $locationdir  ){
				if( $nombre == '' ) { alert( 'Ingrese un nombre de archivo válido.' ); return false; }
				$ajax({
							metodo: 'GET',
							data: 'a=crear_archivo&nombre=' + $nombre + '&ldir=' + $locationdir + '&homedir=' + homedir + '&basedir=' + dir + '&vista=' + vista,
							url: 'lib/ye.php',
							suceso: function(respuesta){
													
													if( respuesta == 0 ){
														alert( 'El archivo no se pudo crear.' );
													} if( respuesta == 1 ){
														ygaModal.cerrar();
														yGestorArchivos.explorar_archivo( '', $locationdir );
													} if( respuesta == 2 ){
														alert( 'El archivo ya existe.' );
													}
							}
						});
				return false;
			}
			
			/* funcion para crear nueva carpeta */
			nuevacarpeta = function( $nombre, $locationdir  ){
				if( $nombre == '' ) { alert( 'Ingrese un nombre de carpeta.' ); return false; }
				$ajax({
							metodo: 'GET',
							data: 'a=crear_carpeta&nomdir=' + $nombre + '&ldir=' + $locationdir + '&basedir=' + dir + '&vista=' + vista,
							url: 'lib/ye.php',
							suceso: function(respuesta){
													
													if( respuesta == 0 ){
														alert( 'No se creó la carpeta.' );
													} if( respuesta == 1 ){
														ygaModal.cerrar();
														yGestorArchivos.explorar_archivo( '', $locationdir );
													} if( respuesta == 2 ){
														alert( 'La carpeta ya existe.' );
													}
							}
						});
				return false;
			}
			
			/* funcion para mover archivos */
			moverarchivo = function( $locationdir ){
					// creo lista de archivos que se copiaran
					$arraydir = '';
					for( i = 0; i < document.getElementsByName('chka').length; i++ ){
								$dir = '#chka_' + i;
								if( $_($dir).checked ) $arraydir += $_($dir).value + ';';
					}
					
					// envio solicitud al YGA
					$ajax({
							metodo: 'GET',
							data: 'a=mover&arraydir=' + $arraydir + '&ldir=' + $locationdir + '&homedir=' + homedir + '&basedir=' + dir + '&vista=' + vista,
							url: 'lib/ye.php',
							suceso: function(respuesta){
													
													if( respuesta == 0 ){
														alert( 'El archivo ' + $arraydir + ' no se pudo mover.' );
													} if( respuesta == 1 ){
														ygaModal.cerrar();
														yGestorArchivos.explorar_archivo( '', $locationdir );
													} if( respuesta == 2 ){
														alert( 'La ruta de destino no existe.' );
													}
							}
						});
					return false;
			}
			
			/* funcion para renombrar archivos */
			renombrararchivo = function( $nNombre, $locationdir ){
					// envio solicitud al YGA
					$ajax({
							metodo: 'GET',
							data: 'a=renombrar&nNombre=' + $nNombre + '&ldir=' + $locationdir + '&homedir=' + homedir + '&basedir=' + dir + '&vista=' + vista,
							url: 'lib/ye.php',
							suceso: function(respuesta){
													
													if( respuesta == 0 ){
														alert( 'El archivo ' + $arraydir + ' no se pudo renombrar.' );
													} if( respuesta == 1 ){
														ygaModal.cerrar();
														yGestorArchivos.explorar_archivo( '', $barra.value );
													} if( respuesta == 2 ){
														alert( 'La ruta de destino no existe.' );
													}
							}
						});
					return false;
			}
			
			
			function basename(path) {
				   return path.split('/').reverse()[0];
			}

			function habilitar_acc(){
							//$copiar = document.querySelector('#action-copy');
							
							var $habilitar = false;
							//var $azip = 'compress';
							for( i = 0; i < document.getElementsByName('chka').length; i++ ){
								$dir = 'chka_' + i;
								if( document.getElementById($dir).checked ){
									$habilitar = true;
									//$azip = document.getElementById($dir).value;
								}
							}
							
							// compruebo si es un archivo comprimido
							/*if( $habilitar ){
									if( oExtension( $azip ) == 'zip' || oExtension( $azip ) == 'gz' || oExtension( $azip ) == 'rar' ){
										$_('#action-extract').className = '';
									}else{
										$_('#action-extract').className = 'disabled';
									}
							}*/
								
							if( $habilitar ){
								$_('#action-copy').className = '';
								$_('#action-move').className = '';
								$_('#action-download').className = '';
								$_('#action-delete').className = 'divider';
								$_('#action-rename').className = '';
								//$_('#action-edit').className = 'divider';
								//$_('#action-extract').className = '';
								//$_('#action-compress').className = '';
							}else{
								$_('#action-copy').className = 'disabled';
								$_('#action-move').className = 'disabled';
								$_('#action-download').className = 'disabled';
								$_('#action-delete').className = 'divider disabled';
								$_('#action-rename').className = 'disabled';
								//$_('#action-edit').className = 'divider disabled';
								//$_('#action-extract').className = 'disabled';
								//$_('#action-compress').className = 'disabled';
							}
							
			}
			//habilitar_acc();
			//setTimeout( "habilitar_acc()", 500 );
			
			/*	funcion para obtener 
				extesion de archivo
				ej. 
				var a = archivo.pe.txt
				oExtension( a ); // return "txt"
			*/
			function oExtension( archivo ) {
			  return archivo.slice( ( archivo.lastIndexOf(".") - 1 >>> 0 ) + 2 );
			}
			
			
			
function formatBytes(bytes, decimals) {
    if (bytes === 0) return '0 Bytes';

    const k = 1024;
    const dm = decimals < 0 ? 0 : decimals;
    const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];

    const i = Math.floor(Math.log(bytes) / Math.log(k));

    return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
} 
	</script>
		
</body></html>