<?php
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * Carga el entorno del sitio Weby+
	 *
	 */
	
	/* Autorizo acceso */
		defined('WY_INI_WEBY') or die( 'No dispones de acceso' );
	
	/* Compruebo si el archivo de configuracion del sistema existe */
		if ( !file_exists( YPATH . YDS . 'wy_configuracion.php' ) || ( filesize( YPATH . YDS . 'wy_configuracion.php' ) < 10 ) ) {			
			if( file_exists( YPATH . YDS . 'instalar' . YDS . 'index.php' ) ) {
				header( 'Location: instalar/index.php' );
				exit();
			} else {
				echo '<center><strong>Error 1:</strong> La configuraci&oacute;n e instalaci&oacute;n del sistema no pueden ser cargado.</center>';
				exit();
			}		
		}
	
	//* Denegamos el acceso a plantilla en caso no existiera o esté en estado de mantenimiento */
		require_once( YPATH . YDS . 'error/include/HTTP_ErrorDocument.php' );
		HTTPErrorDocument::estado();
	
	//* Cargo la configuración del sistema */
		require_once( YPATH . YDS . 'wy_lib' . YDS . 'wy_cargar.php' );
		
	
	//* Verifico version de PHP Y MySQL
		if( !$PHP_VERSION || !$MySQL_VERSION ){
			// Si no cumple con requerimientos imprimo mensaje
			echo wy_error();
			exit();
		}
		
/* ---------------------------------------- *\
	Despues de verificar requimientos
	Inicio sistema WebyPlus(R)
\* ---------------------------------------- */
	
	//* Verifico que la licencia WebyPlus esté activa
		if( !IdWebyPlus( WEBYPLUS_ID, 'C' ) )
		{
			HTTPErrorDocument::tlpError( 8003 );
			exit;
		}
	
	/* Incluyo modulo de funciones personalizadas */
		if( file_exists( EntornoWeby::temaPath() . YDS . 'wy_mod_sitioweby.php' ) )
		{
				require_once( EntornoWeby::temaPath() . YDS . 'wy_mod_sitioweby.php' );
		}
		
	/* Cargo pagina del sitio web */
		EntornoWeby::index();
	 
?>