<?php
	
	/*
	 *
	 * 2003 - 2020 @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * @bin.wy_cfg
	 *
	 * Modulo de constantes de configuración WebyPlus.
	 *
	 */
	
	/* Autorizo acceso */
		defined('WY_INI_WEBY') or die( 'No dispones de acceso' );
	
	
	define( 'WY_SERVERHOST',	$Cfg['Server']['host'] );
	define( 'WY_SERVERUSER',	$Cfg['Server']['user'] );
	define( 'WY_SERVERPASS',	$Cfg['Server']['password'] );
	define( 'WY_SERVERPATH',	$Cfg['Server']['path'] );
	
	define( 'WY_DBHOST',		$Cfg['DB']['host'] );
	define( 'WY_DBPORT',		( isset( $Cfg['DB']['host'] ) ? $Cfg['DB']['port'] : 3306 ) );
	define( 'WY_DBUSER',		$Cfg['DB']['user'] );
	define( 'WY_DBPASS',		$Cfg['DB']['password'] );
	define( 'WY_DBNAME',		$Cfg['DB']['name'] );
	define( 'WY_DBPREFIJO',		$Cfg['DB']['prefijo'] );
	
	define( 'WY_MAILHOST',		$Cfg['Mail']['host'] );
	define( 'WY_MAILUSER',		$Cfg['Mail']['user'] );
	define( 'WY_MAILPASS',		$Cfg['Mail']['password'] );
	define( 'WY_MAILPORT',		$Cfg['Mail']['port'] );
	define( 'WY_MAILSSL',		$Cfg['Mail']['ssl'] );
	define( 'WY_MAILNOMBRE',	$Cfg['Mail']['nombre'] );
	define( 'WY_MAILEMAIL',		$Cfg['Mail']['email'] );
	define( 'WY_MAILASUNTO',	$Cfg['Mail']['asunto'] );
	
	define( 'WY_CHARSET',		$Cfg['Weby']['charset'] );
	define( 'WY_TITLE',			$Cfg['Weby']['titulo'] );
	define( 'WY_DESCRIPTION',	$Cfg['Weby']['description'] );
	define( 'WY_KEYWORDS',		$Cfg['Weby']['keywords'] );
	
	define( 'WY_ORGANIZACION',	$Cfg['Contacto']['organizacion'] );
	define( 'WY_DIRECCION',		$Cfg['Contacto']['direccion'] );
	define( 'WY_TELEFONOS',		$Cfg['Contacto']['telefonos'] );
	define( 'WY_EMAILS',		$Cfg['Contacto']['emails'] );
	define( 'WY_MAPA',			$Cfg['Contacto']['mapa'] );
	
	/* Datos APP sistema Weby+ */
		define( "App_Version",			MSiData::obtener( 'version_nucleo' ) );
		define( 'App_CopyRight',		MSiData::obtener( 'copyright' ) );
		define( "App_Idioma",			MSiData::obtener( 'idioma' ) );
		define( "App_ActualizadorXML",	MSiData::obtener( 'api_actualizacion' ) );
		define( "App_Nombre",			MSiData::obtener( 'app_nombre' ) );
		define( "App_Descripcion",		MSiData::obtener( 'app_descripcion' ) );
		define( 'App_Tipo',				MSiData::obtener( 'app_tipo' ) );
		define( 'App_Modificacion',		MSiData::obtener( 'app_modificacion' ) );
		define( 'App_MarcasComerciales',MSiData::obtener( 'marcas_comerciales' ) );
		define( 'App_NombreOriginal',	MSiData::obtener( 'nombre_original' ) );
		define( 'App_web',				MSiData::obtener( 'app_web' ) );
		define( 'App_Email',			MSiData::obtener( 'app_email_soporte' ) );
		define( 'App_Organizacion',		MSiData::obtener( 'organizacion' ) );
		define( 'App_Organizacion_web',	MSiData::obtener( 'organizacion_web' ) );
		define( 'App_Organizacion_email',MSiData::obtener( 'organizacion_email' ) );
		
		/*$AppInfo = Ini_Leer( YPATH . YDS . 'ypanel/wy_info.wyd' );
		
	
	/* funcion de configuracion */
		function dConfiguracion( $dbHost = 'localhost', 
								 $dbUsuario = 'root', 
								 $dbPass = '', 
								 $dbNombre = 'yanel', 
								 $dbPrefijo = 'wy_', 
								 $smtpHost = '', 
								 $smtpUsuario = '', 
								 $smtpPass = '', 
								 $smtpPort = 25, 
								 $smtpSSL = false, 
								 $smtpNombre = '', 
								 $smtpEmail = '', 
								 $smtpAsunto = '',
								 $webyCharset = 'utf-8', 
								 $webyTitulo = '', 
								 $webyDescription = '', 
								 $webyKeywords = '', 
								 $contactoOrganizacion = '', 
								 $contactoDireccion = '', 
								 $contactoTelefonos = '', 
								 $contactoEmails = '', 
								 $contactoMapa = '', 
								 $idWeby = '', 
								 $codActivacion = '', 
								 $estado = 1, 
								 $gmt = -5 ){
			
			if( $dbUsuario == NULL && $dbPass = NULL ) return false;
			
			$dCfg = '<?php
	/**
	 *
	 * 2003 - ' . date('Y') . ' @ Yal Publicidad - Weby+
	 * www.yalpublicidad.com
	 * online@yalpublicidad.com
	 *
	 * Base de configuracion para Weby+
	 *
	 * Este archivo contiene las siguientes configuraciones:
	 *
	 * * SERVIDOR Sesiones
	 * * MySQL Sesiones
	 * * SMTP Sesiones
	 * * Datos de Configuracion sitio Weby+
	 * * Clave ID Secreta y Clave de Activación de Producto
	 * * Estado de Sitio Weby+
	 * * GMT Sesion
	 *
	 * @link https://codex.webyplus.com/Editing_wy_configuracion.php
	 *
	 * @paquete Weby+
	 */
	
	/* SERVIDOR Sesiones */
		$Cfg[\'Server\'][\'host\']		= \'localhost\';			/* Normalmente es localhost */
		$Cfg[\'Server\'][\'user\']		= \'\';					/* Usuario de hosting */
		$Cfg[\'Server\'][\'password\']	= \'\';					/* Contraseña de hosting */
		$Cfg[\'Server\'][\'path\']		= dirname(__FILE__);	/* Directorio publico, normalmente /home/usuariohost/public_html/ */
		
	/* MySQL Sesiones */
		$Cfg[\'DB\'][\'host\']		= \'' . $dbHost . '\';		/* Normalmente es localhost */
		$Cfg[\'DB\'][\'user\']		= \'' . $dbUsuario . '\';		/* MySQL usuario */
		$Cfg[\'DB\'][\'password\']	= \'' . $dbPass . '\';		/* MySQL Contraseña */
		$Cfg[\'DB\'][\'name\']		= \'' . $dbNombre . '\';			/* MySQL nombre base de datos */
		$Cfg[\'DB\'][\'prefijo\']	= \'' . $dbPrefijo .'\';			/* MySQL Prefijo de tablas */
	
	/* SMTP Sesiones */
		$Cfg[\'Mail\'][\'host\']		= \'' . $smtpHost . '\';		/* SMTP host, normalmente mail.midominio.com */
		$Cfg[\'Mail\'][\'user\']		= \'' . $smtpUsuario . '\';		/* SMTP usuario ej. webmaster@midominio.com */
		$Cfg[\'Mail\'][\'password\']	= \'' . $smtpPass . '\';		/* SMTP contraseña */
		$Cfg[\'Mail\'][\'port\']		= ' . $smtpPort . ';		/* SMTP puerto, normalmente 25 */
		$Cfg[\'Mail\'][\'ssl\']			= ' . $smtpSSL . ';	/* SMTP SSL autenticación */
		$Cfg[\'Mail\'][\'nombre\']		= \'' . $smtpNombre . '\';		/* SMTP nombre ej. Juan Perez */
		$Cfg[\'Mail\'][\'email\']		= \'' . $smtpEmail . '\';		/* SMTP email ej. juanperez@midominio.com */
		$Cfg[\'Mail\'][\'asunto\']		= \'' . $smtpAsunto . '\';		/* SMTP asunto ej. consulta sobre servicio */
	
	/* Datos de Configuracion sitio Weby+ */
		$Cfg[\'Weby\'][\'charset\']		= \'' . $webyCharset . '\';
		$Cfg[\'Weby\'][\'titulo\']		= \'' . $webyTitulo . '\';
		$Cfg[\'Weby\'][\'description\']	= \'' . $webyDescription . '\';
		$Cfg[\'Weby\'][\'keywords\']	= \'' . $webyKeywords . '\';
		
		$Cfg[\'Contacto\'][\'organizacion\']= \'' . $contactoOrganizacion . '\';
		$Cfg[\'Contacto\'][\'direccion\']	= \'' . $contactoDireccion . '\';
		$Cfg[\'Contacto\'][\'telefonos\']	= \'' . $contactoTelefonos . '\';
		$Cfg[\'Contacto\'][\'emails\']		= \'' . $contactoEmails . '\';
		$Cfg[\'Contacto\'][\'mapa\']		= \'' . $contactoMapa . '\';
		
	/* Clave ID Secreta y Clave de Activación de Producto  */
		define(\'WEBYPLUS_ID\', \'' . $idWeby . '\');
		define(\'WEBYPLUS_ID_ACTIVACION\', \'' . $codActivacion . '\');
	
	/* 
	 * Estado de Sitio Weby+ 
	 * 1 = Activo
	 * 2 = Mantenimiento
	 * 3 = En Construccion
	 */
		define( \'YP_ESTADO_WEBY\', ' . $estado . ' );
		
	/* GMT Sesion */
		define( \'GMT\', ' . $gmt .' );
?>';
	 	return $dCfg;
		}
	 
?>