<?php

	/*
	 *
	 * yMS (c) 2003 - 2020 Yal Publicidad
	 * Sistema: Macrodígital Software - de Yal Publicidad
	 *
	 */
	 
	 /* Autorizo acceso */
		defined('YMS') or die( 'No dispones de acceso' );
		
	
	class yDivisa{
		/*
		 * funcion para convertir divisa
		 * $ 100 USD
		 * ej yDivisa::convertir( '100', 'usd', 'pen' );
		 * retorna 350 -> PEN
		 */
		public static function convertir( $monto = 0, $de = 'usd', $a = 'pe' ){
			$de	 	= strtoupper( $de );
			$a 		= strtoupper( $a );
			
			$json	= json_decode( self::tipo_cambio( $de, $a ) );
			$tasa	= (isset( $json->tasa ) && is_numeric($json->tasa)) ? $json->tasa : 1;
			
			$monto	= ( $monto * $tasa );
			
			return $monto;
		}
		
		/*
		 * funcion para obtener el inverso de divisa 
		 * ej yDivisa::obt( 'PEN' );
		 * retorna 0.30303
		 */
		public static function obt( $moneda = 'pen', $divisa = 'usd' ){
			$short	 	= strtoupper( $moneda );
			$divisa 	= strtoupper( $divisa );
			
			$json		= json_decode( self::obtTabla( $short ) );
			$inverso	= isset( $json->$divisa ) ? $json->$divisa : 0.30303;
			
			return $inverso;
		}
		
		public static function obtTabla( $divisa = 'pen', $assoc = false ){
			$divisa = strtolower( $divisa );
			
			// evitar problemas de codificación
				//header('Content-Type: text/html; charset=utf-8');   
			// url
				$urlCT		= "https://es.fxexchangerate.com/$divisa/";
			// cURL
				$ch	= curl_init($urlCT);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				$cl	= curl_exec($ch);
			// Los elementos Dom de la página que vas a reccorrer
				$dom		= new DOMDocument();
				@$dom->loadHTML($cl);
			// La ruta del elemento
				$xpath		= new DOMXpath($dom);
				$resultado	= array();
			// Listo resultados
				$trs = $dom->getElementsByTagName("tr");
				foreach ( $trs as $tr )
				{
						// Cada TD
						$nombre = ( isset( $tr->getElementsByTagName("td")->item(0)->nodeValue ) ) ? $tr->getElementsByTagName("td")->item(0)->nodeValue : '';
						$divisa = ( isset( $tr->getElementsByTagName("td")->item(1)->nodeValue ) ) ? $tr->getElementsByTagName("td")->item(1)->nodeValue : '';
						$valor = ( isset( $tr->getElementsByTagName("td")->item(2)->nodeValue ) ) ? $tr->getElementsByTagName("td")->item(2)->nodeValue : '';
				 
						//echo $title . "\t" . $value."<br>";
						$resultado[$divisa] = $valor;
				}
				
			return ( $assoc ) ? $resultado : json_encode($resultado);
			
		}
		
		/*
		 * funcion para obtener el inverso de divisa 
		 * ej yDivisa::obtInverso( 'PEN', 'USD' );
		 * retorna 1.52
		 */
		public static function obtInverso( $moneda = 'pen', $divisa = 'usd' ){
			$short	 	= strtoupper( $moneda );
			$divisa 	= strtoupper( $divisa );
			
			$json		= json_decode( self::obtTabla( $short ) );
			
			$inverso	= isset( $json->$divisa ) ? $json->$divisa : 0.30303;
			$inverso	= ( 1 / $inverso );
			
			return $inverso;
		}
		
		public static function tipo_cambio( $de = 'pen', $a = 'usd' ){
			$de = strtoupper($de);
			$a	= strtoupper($a);
			
			// evitar problemas de codificación
				//header('Content-Type: text/html; charset=utf-8');   
			// url
				//$urlCT		= "https://es.fxexchangerate.com/" . $de . "/" . $a . ".html";
				$urlCT = 'https://es.exchange-rates.org/converter/'.$de.'/'.$a.'/1';
			// cURL
				$ch	= curl_init($urlCT);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				$cl	= curl_exec($ch); //return $cl;
			// Los elementos Dom de la página que vas a reccorrer
				$dom		= new DOMDocument();
				@$dom->loadHTML($cl);
			// La ruta del elemento
				$xpath		= new DOMXpath($dom);
				$resultado	= array();
			// Listo resultados
				$trs = $dom->getElementsByTagName("small");
				foreach ( $trs as $tr )
				{
					//echo ( isset( $tr->getElementsByTagName("span")->item(0)->nodeValue ) ) ? $tr->getElementsByTagName("span")->item(0)->nodeValue . '<br>' : '-';
					$dat2[] = ( isset( $tr->getElementsByTagName("span")->item(0)->nodeValue ) ) ? $tr->getElementsByTagName("span")->item(0)->nodeValue : '';
				}
			// -- obtengo resultados del primer array
			$tasa	= (isset($dat2[0])) ? explode('=',$dat2[0]) : false;
			// solo dejo el valor numerico
			$tasa	= (isset($tasa[1])) ? trim( str_replace(strtoupper($a),'',$tasa[1]) ) : 0;
			// cambio como por punto
			$tasa	= str_replace(',','.',$tasa);
			// creo el inverso ej. 3.73
			$inverso= (1/$tasa);
			// creo JSON con datos
			$rspta = '{"de":"' . strtoupper($de) . '","tasa":"' . $tasa . '","inverso":"' . $inverso . '","a":"' . strtoupper($a) . '","tasa_str":"1 ' . $de . '","inverso_str":"' . number_format($inverso,5) . ' ' . $a . '"}';
			return $rspta;
			
		}
		
	}
	
		
		/*$x = 0;
		$convDivisa = $xpath->query( '//div[1]/div[4]/div[1]/div/div[6]/table/tbody/tr[1]/td[3]' );
		$convDivisa2 = $xpath->query( '//div[1]/div[4]/div[1]/div/div[6]/table/tbody/tr[1]/td[4]/a' );
		$tabla = $xpath->query( '//div[1]/div[4]/div[1]/div/div[6]/table/tbody' );
		$divisa = $convDivisa->item($x)->nodeValue;
		$iso = $convDivisa2->item($x)->nodeValue;
		echo $divisa . ' - ' . $iso;*/
		
	
?>