<?php
	/*
	 *
	 * yMS (c) 2003 - 2022 Yal Publicidad
	 * Sistema: Macrodígital Software - de Yal Publicidad
	 *
	 */
	 
	 /* Autorizo acceso */
		defined('YMS') or die( 'No dispones de acceso' );

	function calcular_edad( $edad ){
		$fecha_nacimiento = new DateTime($edad);
		$hoy	= new DateTime();
		$edad	= $hoy->diff($fecha_nacimiento);
		return $edad->y;
	}

	/* Funcion para obtener diferencia de días
	 * entre dos fechas 
	 * $fecha_actual = '2021-01-30';
	 * ej. diffDias($fecha_actual, '2021-01-20');
	 * retorna: 10
	 */
	function diffDias($fecha, $fecha_comparacion = NULL)
	{
		// -- cargo fecha de comparacion
		$primera = date('Y-m-d', strtotime($fecha) );
		$segunda = ($fecha_comparacion!=NULL) ? date('Y-m-d',strtotime($fecha_comparacion) ) : date('Y-m-d');
		// -- extraigo valores de fechas
		$valoresPrimera = explode ("-", $primera); 
		$valoresSegunda = explode ("-", $segunda); 
		
		$diaPrimera    = $valoresPrimera[2]; 
		$mesPrimera  = $valoresPrimera[1]; 
		$anyoPrimera   = $valoresPrimera[0];
		
		$diaSegunda   = $valoresSegunda[2];
		$mesSegunda = $valoresSegunda[1]; 
		$anyoSegunda  = $valoresSegunda[0];
		// -- convierto a juliano
		$diasPrimeraJuliano = gregoriantojd($mesPrimera, $diaPrimera, $anyoPrimera);  
		$diasSegundaJuliano = gregoriantojd($mesSegunda, $diaSegunda, $anyoSegunda); 
		
		if(!checkdate($mesPrimera, $diaPrimera, $anyoPrimera)){
			// "La fecha ".$primera." no es v&aacute;lida";
			return 0;
		}elseif(!checkdate($mesSegunda, $diaSegunda, $anyoSegunda)){
			// "La fecha ".$segunda." no es v&aacute;lida";
			return 0;
		}else{
			return  $diasPrimeraJuliano - $diasSegundaJuliano;
		}
	}
	
	function fecha( $fecha = NULL, $formato = NULL, $lang = 'es_ES', $gmt = NULL ){
		return yMSfecha::fecha( $fecha, $formato, $lang, $gmt );
	}

	function fecha_publicacion( $fecha = NULL, $lang = 'es_ES', $gmt = 0, $incluir_hora = false ){
		return yMSfecha::fecha_publicacion($fecha, $lang, $gmt, $incluir_hora);
	}
	
	/* Obtengo GMT del seridor */
	function gmtServ(){
		return yMSfecha::gmtServ();
	}

	/* Obtengo diferencia de horas entre servidor / cliente */
	function difHCliServ($gmtCliente=-5){
		return yMSfecha::difHServCli($gmtCliente);
	}

	/* Convertir tiempo actual a tiempo local del servidor */
	function ctimestampServ($fecha, $gmtCliente=-5){
		if(empty($fecha)) return false;
		return yMSfecha::ctimestampServ($fecha, $gmtCliente);
	}

	function tiempo_acual( $tipo, $gmt = false ){
		return yMSfecha::tiempo_acual( $tipo, $gmt );
	}

	function timestamp( $zona_horaria = -5 ){
		// imprimo el tiempo actual del servidor
		$timestamp		= time()+date("Z");
		// evaluo si la zona horaria es mayor/menor -+12
		if ($zona_horaria > -12.1 and $zona_horaria < 12.1)
		{
			$timestamp = time() + ($zona_horaria * 3600);
		}
		return $timestamp;
	}
	
	function zona_horaria( $zona_horaria = -5 ){
		return yMSfecha::zona_horaria( $zona_horaria );
	}
	
	/* --------------------------------- *\
		clase de modulo
	\* --------------------------------- */
	
	class yMSfecha {
		
		/**
		 * formato_fecha - Formato de Fecha */
		function formato_fecha( $tipo, $fecha, $gmt = false ) 
		{
			$fecha = empty( $fecha ) ? time() : $fecha;
			
			if ( 'timestamp' === $tipo || 'U' === $tipo ) {
				return $gmt ? time() : gmdate( $fecha, time() + ( $gmt * 3600 ) );
			}
		
			if ( 'mysql' === $tipo ) {
				$tipo = 'Y-m-d H:i:s';
			}
			
			$timezone = $gmt ? new DateTimeZone( 'UTC' ) : strtotime($fecha) + ( $gmt * 3600 );
			$datetime = new DateTime( 'now', $timezone );
		
			return $datetime->format( $tipo );
			
			//Thu, October 10, 2014 - 18:12 -> formato_fecha( 'D, F d, Y H:i', '10-10-2014')
		}
		
		/* 
		 * Función para asignar formato de fecha:
		 * Fecha corta: 	fecha();
		 * 		Imprime 	07/06/2016
		 * Fecha pesonalizada:	fecha( 'Y/m/d h:i:s a' )
		 *		Imprime			07/06/2016 11:50:35 am
		 * 
		 * Fecha larga: 	fecha('2009-06-07 12:45:05', 'D j \\d\e F \\d\e\l Y \a \\l\a\s G:i');
		 * 		Imprime		Mar 07 de Junio del 2016 a las 12:45
		 * 
		 * Fecha larga 2:	fecha(date(), 'D j \\d\e F ');
		 * 
		 * La cadena de formato, se crea combinando con simbolos, letras, numeros y caracteres de formato: a - am/pm 
			A - AM/PM 
			B - Hora swatch de internet 
			d - Dia del mes 01 a 31 
			D - Una representación textual de un día, tres letras, Mon hasta Sun
			F - Una representación textual completa de un mes, como January o March	January hasta December
			g - Hora de 1 a 12 
			G - Hora de 0 a 23 
			h - Hora de 01 a 12 
			H - Hora de 00 a 23 
			i - Minutos 00 a 59 
			j - Dia del mes de 1 a 31 
			l ('L' minúscula)	Una representación textual completa del día de la semana, Sunday hasta Saturday
			m - Numero de mes de 01 a 12 
			n - Numero de mes de 1 a 12 
			N	Representación numérica ISO-8601 del día de la semana, 1 (para lunes) hasta 7 (para domingo)
			s - Segundos de 00 a 59 
			S - Sufijo ordinal inglés para el día del mes, 2 caracteres	st, nd, rd o th. Funciona bien con j
			t - Dias del mes de 28 a 31 
			U - Fecha Unix 
			w - Dia de la semana de 0 a 6 empezando por Domingo 
			W - Semana del año ej: 42 
			y - Año ej: 99 
			Y - Año ej: 1999 
			z - Dia del año de 0 a 366
		 */
		public static function fecha( $fecha = NULL, $formato = NULL, $lang = NULL, $gmt = 13 ){ 
			setlocale( LC_ALL, ( ( $lang == NULL ) ? 'es_ES' : $lang ) );
			
			$timestamp	= ( $fecha != NULL ) ? strtotime($fecha) : time()+date("Z"); // hora local por defecto
			$fecha		= ( $fecha != NULL ) ? $fecha : date('Y-m-d H:i:s');
			$formato	= ( $formato != NULL ) ? $formato : 'Y-m-d H:i:s';
			
			$En	= array('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sun','Mon','Tue','Wed','Thu','Fri','Sat','Jan','Feb','Mar','Apr','Jun','Jul','Aug','Sep','Oct','Nov','Dec','Eneuary','January','February','March','April','May','June','July','Agoust','September','October','November','December','Dicember');
			$Es	= array('Domingo','Lunes','Martes','Mi&eacute;rcoles','Jueves','Viernes','S&aacute;bado','Dom','Lun','Mar','Mie','Jue','Vie','Sab','Ene','Feb','Mar','Abr','Jun','Jul','Ago','Set','Oct','Nov','Dic','Enero','Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Setiembre','Octubre','Noviembre','Diciembre','Diciembre');
			
			// Zona horaria
			//$hora_local = 'Error con zona horaria';
			//$timestamp = time()+date("Z"); // hora local por defecto
			if( $gmt != 13 ){
				if ( $gmt > -12.1 and $gmt < 12.1 )
				{
					$timestamp = strtotime($fecha) + ( $gmt * 3600 ); // hora local GMT
				}
			}
			//
			return ( $formato != 'Y-m-d H:i:s' ) ? str_replace( $En, $Es, gmdate( $formato, $timestamp ) ) : gmdate( $formato, $timestamp );
			
			
			//$fechaRSS = $this->cambiaf_a_mysql($fecha);
			/*if ($fecha == NULL) {
				//return gmdate( 'd/m/Y', time() + ( $gmt * 3600 ) );
				$formato = ( $formato == NULL ) ? 'Y-m-d H:i:s' : $formato;
				return gmdate( $formato, $timestamp );
			} else{
				$formato = ( $formato == NULL ) ? $fecha : $formato;
				//return str_replace($En,$Es,date($formato, strtotime($fecha)));
				return str_replace( $En, $Es, gmdate( $formato, $timestamp ) );
			}*/
		}
		
		/* 
		 * fecha_publicacion - funcion para obtener el tiempo de publicacion 
		 * @param String $fecha    dato que se convertira a fecha larga
		 * ej. fecha_publicacion( '2022-02-07 12:13:23', 'es_ES', -5);
		 * -> Hoy 12:13
		 */
		public static function fecha_publicacion( $fecha, $lang = NULL, $gmt = 0 ){
			setlocale( LC_ALL, ( ( $lang == NULL ) ? 'es_ES' : $lang ) );
			// si la fecha es vacia, retorno falso
			if( empty($fecha) ) return false;
			// obtengo zona horaria ej. -5
			$zona_horaria	= ($gmt > 0) ? $gmt : -5;
			// imprimo el tiempo actual del servidor
			$timestamp		= time()+date("Z");
			// evaluo si la zona horaria es mayor/menor -+12
			if ($zona_horaria > -12.1 and $zona_horaria < 12.1)
			{
				$timestamp = time() + ($zona_horaria * 3600);
			}

			//ceil((strtotime($fecha1) - strtotime($fecha2) / 60);*/

			// obtengo la fecha y hora local
			$date	= gmdate( 'Y-m-d H:i:s', $timestamp );
			// obtengo la fecha y hora local registrada
			$date_r	= gmdate( $fecha, $timestamp );
			// creo nuevo tiempo 
			$date1	= new DateTime( $date );
			$date2 = new DateTime( $fecha );
			$diff = $date1->diff($date2);
			// calculo diferencia de días
			$difDias = diffDias($date, $date_r);
			// calculo si el registro si hizo hoy o días atrás
			if($difDias == 0){
				// Se registró Hoy
				if( $diff->h < 1 ){
					if( $diff->i < 1 )
						return 'Hace un momento';
					else
						return 'Hace ' . $diff->i . ' minutos';
				}elseif( $diff->h == 1 ){
						return 'Hace ' . $diff->h . ' hora';
				}else{
						return fecha( $fecha, '\\H\o\y H:i', 'es_ES', $zona_horaria );
				}
			}elseif($difDias > 0 && $difDias < 2){
				return fecha( $fecha, '\\A\y\e\r H:i', 'es_ES', $zona_horaria );
			}elseif($difDias > 1 && $difDias < 30){
				return fecha( $fecha, 'D j \\d\e F', 'es_ES', $zona_horaria );
			}elseif($difDias > 28 && $difDias < 60){
				return fecha( $fecha, 'D d/m', 'es_ES', $zona_horaria );
			}else{
				return fecha( $fecha, 'd/m/Y', 'es_ES', $zona_horaria );
			}
		}
		
		/* gmtServ() : Obtengo GMT del seridor */
		public static function gmtServ(){
			$timezone = new DateTimeZone( 'UTC' );
			$datetime = new DateTime( 'now', $timezone );
			// obtengo hora del servidor
			$hora1 = date('H');
			$hora2 = gmdate( 'H', $datetime->getTimestamp() );
			$gmServ= ($hora1-$hora2);
			return $gmServ;
		}

		/* difHServCli([str $gmtCliente]) : Obtengo diferencia de horas entre servidor / cliente 
		 * @param str    $gmtCliente    GTM del cliente
		 * ej. difHServCli(-5) -> 5
		 */
		public static function difHServCli($gmtCliente=-5){
			$hora1 = date('Y-m-d H:i:s');
			$hora2 = gmdate( 'Y-m-d H:i:s', (time()+( $gmtCliente * 3600 ) ) );
			$gmServ= date_diff(date_create($hora1),date_create($hora2));
			return $gmServ->h;
		}

		/* ctimestampServ(str $fecha [, str $gmtCliente]) : Convertir tiempo actual a tiempo local del servidor 
		 * @param str    $fecha         fecha del cliente
		 * @param str    $gmtCliente    GMT del cliente
		 */
		public static function ctimestampServ($fecha, $gmtCliente=-5){
			if(empty($fecha)) return false;
			return ( strtotime($fecha)+( self::difHServCli($gmtCliente) * 3600 ) );
		}
		
		/* 
		 * formato_fecha - Formato de Fecha */
		public static function tiempo_acual( $tipo, $gmt = false ) 
		{
			if ( 'timestamp' === $tipo || 'U' === $tipo ) {
				return $gmt ? time() : time() + (int) ( date_offset_get(new DateTime) * 3600 );
			}
		
			if ( 'mysql' === $tipo ) {
				$tipo = 'Y-m-d H:i:s';
			}
			
			$timezone = $gmt ? new DateTimeZone( 'UTC' ) : strtotime( date( $tipo ) ) + ( $gmt * 3600 );
			$datetime = new DateTime( 'now', $timezone );
		
			return $datetime->format( $tipo );
		}
	
		/**
		 * zona_horaria - Obtener Zona Horaria GMT
		 * @param int    $zona_horaria    Zona Horaria UTC a calcular
		 * ej. date('d/m/Y H:i:s',zona_horaria(-5));
		 */
		public static function zona_horaria( $zona_horaria = 0 ){
			if ($zona_horaria > -12.1 and $zona_horaria < 12.1)
			{
				$hora_local = time() + ($zona_horaria * 3600);
				return $hora_local;
			}
			return false;
		}
		 
		 
		
		/* Complemento de función fecha_larga() */
		/*function cambiaf_a_mysql($fecha){ 
			preg_match( "([0-9]{1,2})/([0-9]{1,2})/([0-9]{2,4})", $fecha, $mifecha); 
			$lafecha=$mifecha[3]."-".$mifecha[2]."-".$mifecha[1]; 
			return $lafecha;
		}*/
	
	}
?>